/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.req.ContractTemplateAddReqDto;
import cn.kinyun.scrm.contract.dto.req.ContractTemplateBaseReqDto;
import cn.kinyun.scrm.contract.dto.req.ContractTemplateListReqDto;
import cn.kinyun.scrm.contract.dto.resp.ContractTemplateRespDto;
import cn.kinyun.scrm.contract.dto.resp.GetOnlineEditUrlRespDto;
import cn.kinyun.scrm.contract.enums.ContractTemplateTypeEnum;
import cn.kinyun.scrm.contract.service.ContractTemplateService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contract.dto.ContractTemplateQuery;
import com.kuaike.scrm.dal.contract.entity.ContractCorpVerifyInfo;
import com.kuaike.scrm.dal.contract.entity.ContractTemplate;
import com.kuaike.scrm.dal.contract.mapper.ContractCorpVerifyInfoMapper;
import com.kuaike.scrm.dal.contract.mapper.ContractTemplateMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContractTemplateServiceImpl
implements ContractTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ContractTemplateServiceImpl.class);
    @Resource
    private BjyPartnerService bjyPartnerService;
    @Resource
    private ContractTemplateMapper contractTemplateMapper;
    @Resource
    private ContractCorpVerifyInfoMapper corpVerifyInfoMapper;
    @Value(value="${app.contract.uploadTemplateUrl}")
    private String uploadTemplateUrl;
    @Value(value="${app.contract.onlineEditUrl}")
    private String onlineEditUrl;

    @Override
    public List<ContractTemplateRespDto> list(ContractTemplateListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("contract list, reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        ContractTemplateQuery templateQuery = reqDto.convert2TemplateQuery(userInfo);
        List templates = this.contractTemplateMapper.selectListByParams(templateQuery);
        if (CollectionUtils.isEmpty((Collection)templates)) {
            return Collections.emptyList();
        }
        int count = this.contractTemplateMapper.selectCountByParams(templateQuery);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        List templateRespDtos = BeanUtil.convertToList((Collection)templates, ContractTemplateRespDto.class, (String[])new String[0]);
        templateRespDtos.forEach(templateRespDto -> {
            ContractTemplateTypeEnum contractTemplateTypeEnum = ContractTemplateTypeEnum.get(templateRespDto.getTemplateType());
            templateRespDto.setTemplateTypeDesc(contractTemplateTypeEnum.getDesc());
        });
        return templateRespDtos;
    }

    @Override
    public void add(ContractTemplateAddReqDto reqDto) {
        ContractTemplate abandonTemplate;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("add contract template, reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        if (ContractTemplateTypeEnum.ABANDON.getValue() == reqDto.getTemplateType().intValue() && Objects.nonNull(abandonTemplate = this.contractTemplateMapper.selectAbandonTemplateByBizId(userInfo.getBizId())) && Objects.nonNull(abandonTemplate.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5546\u6237\u4e0b\u5df2\u5b58\u5728\u5e9f\u9664\u5408\u540c\u6a21\u677f,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        PartnerInfo partnerInfo = this.bjyPartnerService.getPartner(userInfo.getBizId());
        if (Objects.isNull(partnerInfo)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5546\u6237\u672a\u5f00\u901a\u767e\u5bb6\u4e91\u5e10\u53f7");
        }
        ContractCorpVerifyInfo verifyInfo = this.corpVerifyInfoMapper.selectByBizId(userInfo.getBizId());
        if (Objects.isNull(verifyInfo)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5546\u6237\u8fd8\u672a\u505a\u5b9e\u540d\u8ba4\u8bc1\uff0c\u8bf7\u5148\u5b8c\u6210\u5b9e\u540d\u8ba4\u8bc1");
        }
        Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
        String templateId = this.uploadTemplate2Fdd(reqDto.getTemplateName(), reqDto.getDocUrl(), verifyInfo.getCustomerId(), partnerInfo, headerParams);
        if (StringUtils.isBlank((CharSequence)templateId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6dfb\u52a0\u5408\u540c\u6a21\u677f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        ContractTemplate contractTemplate = new ContractTemplate();
        contractTemplate.setBizId(userInfo.getBizId());
        contractTemplate.setCorpId(userInfo.getCorpId());
        contractTemplate.setTemplateId(templateId);
        contractTemplate.setTemplateName(reqDto.getTemplateName());
        contractTemplate.setDocUrl(reqDto.getDocUrl());
        contractTemplate.setTemplateType(reqDto.getTemplateType());
        contractTemplate.setCreateBy(userInfo.getId());
        contractTemplate.setUpdateBy(userInfo.getId());
        Date curDate = new Date();
        contractTemplate.setCreateTime(curDate);
        contractTemplate.setUpdateTime(curDate);
        contractTemplate.setIsDeleted(NumberUtils.INTEGER_ZERO);
        this.contractTemplateMapper.insert((Object)contractTemplate);
    }

    @Override
    public ContractTemplateRespDto detail(ContractTemplateBaseReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("contract detail, reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        ContractTemplate contractTemplate = this.contractTemplateMapper.selectByBizIdAndTemplateId(userInfo.getBizId(), reqDto.getTemplateId());
        ContractTemplateRespDto contractTemplateRespDto = new ContractTemplateRespDto();
        if (Objects.nonNull(contractTemplate)) {
            BeanUtils.copyProperties((Object)contractTemplate, (Object)contractTemplateRespDto);
            contractTemplateRespDto.setTemplateTypeDesc(ContractTemplateTypeEnum.get(contractTemplate.getTemplateType()).getDesc());
        }
        return contractTemplateRespDto;
    }

    @Override
    public GetOnlineEditUrlRespDto getOnlineEditUrl(ContractTemplateBaseReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("getOnlineEditUrl, reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        ContractTemplate contractTemplate = this.contractTemplateMapper.selectByBizIdAndTemplateId(userInfo.getBizId(), reqDto.getTemplateId());
        if (Objects.isNull(contractTemplate)) {
            log.warn("\u6839\u636ebizId:{}, templateId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)userInfo.getBizId(), (Object)reqDto.getTemplateId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        PartnerInfo partnerInfo = this.bjyPartnerService.getPartner(userInfo.getBizId());
        Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
        String onlineEditUrl = this.getContractTemplateEditUrl(contractTemplate.getTemplateId(), partnerInfo, headerParams);
        GetOnlineEditUrlRespDto getOnlineEditUrlRespDto = new GetOnlineEditUrlRespDto();
        getOnlineEditUrlRespDto.setOnlineEditUrl(onlineEditUrl);
        return getOnlineEditUrlRespDto;
    }

    @Override
    public void del(ContractTemplateBaseReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("del, reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        ContractTemplate contractTemplate = this.contractTemplateMapper.selectByBizIdAndTemplateId(userInfo.getBizId(), reqDto.getTemplateId());
        Preconditions.checkArgument((boolean)Objects.nonNull(contractTemplate), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        if (ContractTemplateTypeEnum.ABANDON.getValue() != contractTemplate.getTemplateType().intValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53ea\u80fd\u5220\u9664\u6a21\u677f\u7c7b\u578b\u4e3a\u5e9f\u9664\u6a21\u677f\u7684\u6a21\u677f");
        }
        contractTemplate.setIsDeleted(NumberUtils.INTEGER_ONE);
        contractTemplate.setUpdateTime(new Date());
        contractTemplate.setUpdateBy(userInfo.getId());
        this.contractTemplateMapper.updateByPrimaryKey((Object)contractTemplate);
    }

    private String uploadTemplate2Fdd(String templateName, String docUrl, String customerId, PartnerInfo partnerInfo, Map<String, String> headerParams) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("customer_id", customerId);
        queryParams.put("template_name", templateName);
        queryParams.put("doc_url", docUrl);
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.uploadTemplateUrl, queryParams, headerParams);
            log.info("uploadTemplate2Fdd result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u4e0a\u4f20\u5408\u540c\u6a21\u677f\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u4e0a\u4f20\u5408\u540c\u6a21\u677f\u63a5\u53e3\u5931\u8d25");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u4e0a\u4f20\u5408\u540c\u6a21\u677f\u63a5\u53e3\u5931\u8d25");
        }
        return jsonObject.getJSONObject("data").getString("template_id");
    }

    private String getContractTemplateEditUrl(String templateId, PartnerInfo partnerInfo, Map<String, String> headerParams) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("template_id", templateId);
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.onlineEditUrl, queryParams, headerParams);
            log.info("getContractTemplateEditUrl result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u5728\u7ebf\u7f16\u8f91\u5408\u540c\u6a21\u677f\u5730\u5740\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5728\u7ebf\u7f16\u8f91\u5408\u540c\u6a21\u677f\u5730\u5740\u5931\u8d25");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5728\u7ebf\u7f16\u8f91\u5408\u540c\u6a21\u677f\u5730\u5740\u5931\u8d25");
        }
        return jsonObject.getJSONObject("data").getString("url");
    }
}

