/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.entity.chat.msg.Emotion;
import cn.kinyun.wework.sdk.entity.chat.msg.File;
import cn.kinyun.wework.sdk.entity.chat.msg.Image;
import cn.kinyun.wework.sdk.entity.chat.msg.MeetingVoiceCall;
import cn.kinyun.wework.sdk.entity.chat.msg.Video;
import cn.kinyun.wework.sdk.entity.chat.msg.Voice;
import cn.kinyun.wework.sdk.enums.ChatMsgType;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.chat.dto.ResolvedAmrBasicInfoDto;
import com.kuaike.scrm.chat.dto.SdkFieldToUrlReq;
import com.kuaike.scrm.chat.service.FileService;
import com.kuaike.scrm.chat.service.PullChatMsgService;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.FileStatus;
import com.kuaike.scrm.common.enums.IsDelete;
import com.kuaike.scrm.common.service.MessageCommonService;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.SHA1Utils;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.chat.entity.WeworkFile;
import com.kuaike.scrm.dal.chat.entity.WeworkMixedFile;
import com.kuaike.scrm.dal.chat.entity.WeworkUniqueFile;
import com.kuaike.scrm.dal.chat.mapper.WeworkFileMapper;
import com.kuaike.scrm.dal.chat.mapper.WeworkMixedFileMapper;
import com.kuaike.scrm.dal.chat.mapper.WeworkUniqueFileMapper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    private static final String FILE_TYPE_AMR = "amr";
    private static final String FILE_TYPE_MP3_SUFFIX = ".mp3";
    private static final Cache<String, Object> FILE_CONVERT_RECORDER = CacheBuilder.newBuilder().expireAfterWrite(40L, TimeUnit.SECONDS).initialCapacity(1000).build();
    private static final Set<String> FILE_TYPES = Sets.newHashSet((Object[])new String[]{ChatMsgType.FILE.getValue(), ChatMsgType.IMAGE.getValue(), ChatMsgType.VOICE.getValue(), ChatMsgType.VIDEO.getValue(), ChatMsgType.EMOTION.getValue(), ChatMsgType.MEETING_VOICE_CALL.getValue()});
    public static final String OSS_LOCK = "OSS_LOCK";
    public static final String ES_LOCK = "ES_LOCK";
    public static final String AMR_LOCK = "AMR_LOCK";
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private WeworkFileMapper weworkFileMapper;
    @Autowired
    private WeworkUniqueFileMapper weworkUniqueFileMapper;
    @Autowired
    private WeworkMixedFileMapper weworkMixedFileMapper;
    @Autowired
    private PullChatMsgService pullChatMsgService;
    @Autowired
    private MessageCommonService messageCommonService;
    @Autowired
    private ThreadPoolMonitorUtils threadPoolMonitorUtils;
    @Autowired
    private AliyunOss aliyunOss;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private final ThreadPoolExecutor syncToOssExecutorService = new ThreadPoolExecutor(6, 6, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(6), (ThreadFactory)new NamedThreadFactory("SyncToOssThread"), new ThreadPoolExecutor.DiscardPolicy());
    @Value(value="${silk-v3-decoder.path:}")
    private String basePath;
    private static final Semaphore syncToOssSemaphore = new Semaphore(6);

    @PostConstruct
    public void init() {
        this.threadPoolMonitorUtils.addToMonitor2((ExecutorService)this.syncToOssExecutorService);
    }

    public boolean locked(String key, long sec) {
        String lockKey = this.redisKeyPrefix + ":" + key;
        try {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"", sec, TimeUnit.SECONDS);
            log.debug("locked={}, key={}", (Object)locked, (Object)lockKey);
            if (locked == null) {
                return false;
            }
            return locked;
        }
        catch (Exception e) {
            log.error("Failed lock msgKey={}", (Object)key, (Object)e);
            return false;
        }
    }

    public void relock(String key, long sec) {
        String lockKey = this.redisKeyPrefix + ":" + key;
        try {
            this.redisTemplate.opsForValue().set((Object)lockKey, (Object)"", sec, TimeUnit.SECONDS);
            log.debug("relock key={}", (Object)lockKey);
        }
        catch (Exception e) {
            log.error("Failed lock msgKey={}", (Object)key, (Object)e);
        }
    }

    public void unlock(String key) {
        String lockKey = this.redisKeyPrefix + ':' + key;
        try {
            this.redisTemplate.delete((Object)lockKey);
            log.debug("unlock key={}", (Object)lockKey);
        }
        catch (Exception e) {
            log.error("Failed unlock msgKey={}", (Object)key, (Object)e);
        }
    }

    @Override
    public void handleNeedSyncToEsFile() {
        log.info("handleNeedSyncToEsFile begin");
        ArrayList fileList = Lists.newArrayList();
        List otherFileList = this.weworkFileMapper.selectByStatus(FileStatus.ALREADY_TO_OSS.getStatus());
        List voiceList = this.weworkFileMapper.selectByTypeAndStatus(FileStatus.HAVE_CONVERT_TO_MP3.getStatus(), (Collection)Sets.newHashSet((Object[])new String[]{ChatMsgType.VOICE.getValue(), ChatMsgType.MEETING_VOICE_CALL.getValue()}));
        fileList.addAll(otherFileList);
        fileList.addAll(voiceList);
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return;
        }
        if (!this.locked(ES_LOCK, 30L)) {
            log.info("handleNeedSyncToEsFile locked");
            return;
        }
        for (List files : Lists.partition((List)fileList, (int)20)) {
            try {
                Set existsChatMsgSet = this.messageCommonService.existsChatMsg(files);
                ArrayList updateList = Lists.newArrayList();
                Map chatMsgMap = existsChatMsgSet.stream().collect(Collectors.toMap(ChatMsg::getMsgId, Function.identity()));
                for (WeworkFile weworkFile : files) {
                    ChatMsg chatMsg = (ChatMsg)chatMsgMap.get(weworkFile.getMsgId());
                    if (!Objects.nonNull(chatMsg)) continue;
                    weworkFile.setCreateTime(new Date(chatMsg.getMsgTime()));
                    weworkFile.setStatus(Integer.valueOf(FileStatus.ALREAD_SYNC_ES.getStatus()));
                    updateList.add(weworkFile);
                }
                if (CollectionUtils.isEmpty((Collection)updateList)) {
                    log.info("updateList is empty");
                    continue;
                }
                this.messageCommonService.updateFile2Es((List)updateList);
                log.info("handleNeedSyncToEsFile updateList size:{}, ids:{}", (Object)updateList.size(), updateList.stream().map(WeworkFile::getId).collect(Collectors.toList()));
                this.weworkFileMapper.batchUpdateFile((List)updateList);
            }
            catch (Exception e) {
                log.error("handleNeedSyncToEsFile error", (Throwable)e);
            }
        }
        this.unlock(ES_LOCK);
        log.info("handleNeedSyncToEsFile end");
    }

    @Override
    public void handleNeedToOssFile() {
        log.info("handleNeedToOssFile begin");
        List fileList = this.weworkFileMapper.selectAllByStatus(FileStatus.INIT.getStatus());
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return;
        }
        if (!this.locked(OSS_LOCK, 30L)) {
            log.info("handleNeedToOssFile locked");
            return;
        }
        List partitions = Lists.partition((List)fileList, (int)50);
        for (List partition : partitions) {
            boolean acquire = false;
            try {
                acquire = syncToOssSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                log.error("syncToOssSemaphore acquire failed", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (!acquire) {
                log.error("not acquire syncToOssSemaphore, try later");
                break;
            }
            this.syncToOssExecutorService.submit(() -> {
                long startTime = System.currentTimeMillis();
                try {
                    ArrayList updateList = Lists.newArrayList();
                    for (WeworkFile weworkFile : partition) {
                        StopWatchDto timer = new StopWatchDto("singleSyncToOss", true, log);
                        if (StringUtils.isNotBlank((CharSequence)weworkFile.getMd5())) {
                            timer.start("selectExistsFileUrlByBizIdAndMd5");
                            String fileUrl = this.weworkFileMapper.selectExistsFileUrlByBizIdAndMd5(weworkFile.getBizId(), weworkFile.getMd5());
                            timer.stop();
                            if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
                                this.updateWeworkFileSuccess(weworkFile, updateList, timer, null, fileUrl);
                                continue;
                            }
                        }
                        timer.start("fetchFile");
                        Optional<java.io.File> optionalFile = this.pullChatMsgService.fetchFile(weworkFile.getCorpId(), weworkFile.getBizId(), weworkFile.getMediaData(), weworkFile.getMsgId(), weworkFile.getFileName());
                        timer.stop();
                        if (!optionalFile.isPresent()) {
                            weworkFile.setStatus(Integer.valueOf(FileStatus.FAIL.getStatus()));
                            timer.start("updateFail");
                            this.weworkFileMapper.updateByPrimaryKeySelective((Object)weworkFile);
                            timer.stop();
                            timer.print();
                            continue;
                        }
                        try {
                            this.syncToOss(optionalFile, weworkFile, updateList, timer);
                        }
                        catch (Exception e) {
                            log.error("syncToOss error:{}", (Object)JSON.toJSONString((Object)weworkFile), (Object)e);
                        }
                        timer.print();
                    }
                    if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                        List sortedList = updateList.stream().sorted(Comparator.comparing(WeworkFile::getId)).collect(Collectors.toList());
                        this.weworkFileMapper.batchUpdateFile(sortedList);
                        log.info("handleNeedToOssFile updateList :{}, {}", (Object)updateList.size(), updateList.stream().map(WeworkFile::getMsgId).collect(Collectors.toList()));
                    }
                }
                catch (Exception e) {
                    log.error("dealNeedToOssFile error", (Throwable)e);
                }
                finally {
                    syncToOssSemaphore.release();
                    log.info("syncToOss this batch wasteTime={}", (Object)(System.currentTimeMillis() - startTime));
                }
            });
        }
        this.unlock(OSS_LOCK);
        log.info("handleNeedToOssFile end");
    }

    private void syncToOss(Optional<java.io.File> optionalFile, WeworkFile weworkFile, List<WeworkFile> updateList, StopWatchDto timer) {
        if (!optionalFile.isPresent()) {
            this.updateWeworkFileFail(weworkFile, updateList);
            return;
        }
        java.io.File file = optionalFile.get();
        timer.start("fileSha1");
        String fileSha1 = SHA1Utils.getSha1((java.io.File)file);
        timer.stop();
        if (StringUtils.isBlank((CharSequence)fileSha1)) {
            this.updateWeworkFileFail(weworkFile, updateList);
            return;
        }
        timer.start("selectUniqueFile");
        WeworkUniqueFile weworkUniqueFile = this.selectUniqueFile(fileSha1);
        timer.stop();
        String url = "";
        if (Objects.nonNull(weworkUniqueFile)) {
            url = weworkUniqueFile.getUrl();
        } else {
            timer.start("uploadFile");
            url = this.aliyunOss.uploadFile(weworkFile.getCorpId(), file, file.getName());
            timer.stop();
            log.info("uploadFile success, url:{}", (Object)url);
            timer.start("insertUniqueFile");
            WeworkUniqueFile uniqueFile = this.buildUniqueFile(weworkFile, url, fileSha1, null);
            try {
                this.weworkUniqueFileMapper.insertSelective((Object)uniqueFile);
                log.info("insert unqiue file success sha1:{}", (Object)fileSha1);
            }
            catch (Exception e) {
                log.error("insert unique file fail, fileId:{}", (Object)weworkFile.getId(), (Object)e);
            }
            timer.stop();
        }
        this.updateWeworkFileSuccess(weworkFile, updateList, timer, file, url);
        log.info("syncToOss success");
    }

    private void updateWeworkFileFail(WeworkFile weworkFile, List<WeworkFile> updateList) {
        WeworkFile updateFile = new WeworkFile();
        updateFile.setId(weworkFile.getId());
        updateFile.setStatus(Integer.valueOf(FileStatus.FAIL.getStatus()));
        updateFile.setUpdateTime(new Date());
        updateList.add(updateFile);
    }

    private void updateWeworkFileSuccess(WeworkFile weworkFile, List<WeworkFile> updateList, StopWatchDto timer, java.io.File file, String url) {
        WeworkFile updateFile = new WeworkFile();
        updateFile.setId(weworkFile.getId());
        updateFile.setFileUrl(url);
        updateFile.setStatus(Integer.valueOf(FileStatus.ALREADY_TO_OSS.getStatus()));
        updateFile.setUpdateTime(new Date());
        updateList.add(updateFile);
        timer.start("deleteFail");
        FileUtils.deleteQuietly((java.io.File)file);
        timer.stop();
    }

    private WeworkUniqueFile buildUniqueFile(WeworkFile weworkFile, String url, String fileSha1, String suffix) {
        WeworkUniqueFile uniqueFile = new WeworkUniqueFile();
        uniqueFile.setSha1Str(fileSha1);
        if (Objects.nonNull(weworkFile.getFileSize())) {
            uniqueFile.setFileSize(Integer.valueOf(weworkFile.getFileSize().intValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            uniqueFile.setFileFormat(suffix);
        } else {
            uniqueFile.setFileFormat(weworkFile.getFileExt());
        }
        if (Objects.nonNull(weworkFile.getDuration())) {
            uniqueFile.setDuration(Long.valueOf(weworkFile.getDuration().longValue()));
        }
        uniqueFile.setUrl(url);
        uniqueFile.setUrlMd5(MD5Utils.MD5((String)url));
        return uniqueFile;
    }

    public WeworkUniqueFile selectUniqueFile(String fileKey) {
        if (StringUtils.isBlank((CharSequence)fileKey)) {
            return null;
        }
        WeworkUniqueFile selectSha1 = new WeworkUniqueFile();
        selectSha1.setSha1Str(fileKey);
        return (WeworkUniqueFile)this.weworkUniqueFileMapper.selectOne((Object)selectSha1);
    }

    public WeworkMixedFile selectMinedFile(String md5sum) {
        WeworkMixedFile item = new WeworkMixedFile();
        item.setMd5Sum(md5sum);
        return (WeworkMixedFile)this.weworkMixedFileMapper.selectOne((Object)item);
    }

    @Override
    public void handleMsgFile(ChatMsg chatMsg) {
        if (!"send".equals(chatMsg.getAction())) {
            return;
        }
        if (!FILE_TYPES.contains(chatMsg.getMsgType())) {
            return;
        }
        WeworkFile select = new WeworkFile();
        select.setMsgId(chatMsg.getMsgId());
        WeworkFile selectOne = (WeworkFile)this.weworkFileMapper.selectOne((Object)select);
        if (Objects.nonNull(selectOne)) {
            log.warn("exist file:{}", (Object)chatMsg.getMsgId());
            return;
        }
        WeworkFile weworkFile = new WeworkFile();
        this.toFile(weworkFile, chatMsg, chatMsg.getBizId());
        if (chatMsg.getMsgType().equals(ChatMsgType.IMAGE.getValue())) {
            Image image = chatMsg.getImage();
            if (Objects.isNull(image)) {
                log.warn("illegal image message msgId:{}", (Object)chatMsg.getMsgId());
                return;
            }
            weworkFile.setMediaData(image.getSdkfileid());
            weworkFile.setMd5(image.getMd5sum());
            weworkFile.setFileSize(image.getFileSize());
        }
        if (chatMsg.getMsgType().equals(ChatMsgType.FILE.getValue())) {
            File file = chatMsg.getFile();
            if (Objects.isNull(file)) {
                log.warn("illegal file message msgId:{}", (Object)chatMsg.getMsgId());
                return;
            }
            weworkFile.setMediaData(file.getSdkfileid());
            weworkFile.setMd5(file.getMd5sum());
            weworkFile.setFileSize(Long.valueOf(file.getFileSize().longValue()));
            weworkFile.setFileName(file.getFilename());
            weworkFile.setFileExt(file.getFileext());
        }
        if (chatMsg.getMsgType().equals(ChatMsgType.VOICE.getValue())) {
            Voice voice = chatMsg.getVoice();
            if (Objects.isNull(voice)) {
                log.warn("illegal voice message msgId:{}", (Object)chatMsg.getMsgId());
                return;
            }
            weworkFile.setMediaData(voice.getSdkfileid());
            weworkFile.setMd5(voice.getMd5sum());
            weworkFile.setDuration(voice.getPlayLength());
            weworkFile.setFileSize(Long.valueOf(voice.getVoiceSize().longValue()));
            weworkFile.setFileExt(FILE_TYPE_AMR);
        }
        if (chatMsg.getMsgType().equals(ChatMsgType.VIDEO.getValue())) {
            Video video = chatMsg.getVideo();
            if (Objects.isNull(video)) {
                log.warn("illegal video message msgId:{}", (Object)chatMsg.getMsgId());
                return;
            }
            weworkFile.setMediaData(video.getSdkfileid());
            weworkFile.setMd5(video.getMd5sum());
            weworkFile.setDuration(video.getPlayLength());
            weworkFile.setFileSize(Long.valueOf(video.getFileSize().longValue()));
            weworkFile.setFileExt("mp4");
        }
        if (chatMsg.getMsgType().equals(ChatMsgType.EMOTION.getValue())) {
            Emotion emotion = chatMsg.getEmotion();
            if (Objects.isNull(emotion)) {
                log.warn("illegal emotion message msgId:{}", (Object)chatMsg.getMsgId());
                return;
            }
            weworkFile.setMediaData(emotion.getSdkfileid());
            weworkFile.setMd5(emotion.getMd5sum());
            weworkFile.setFileSize(Long.valueOf(emotion.getImageSize().longValue()));
            weworkFile.setFileExt(emotion.getType() == 1 ? "gif" : "png");
        }
        if (chatMsg.getMsgType().equals(ChatMsgType.MEETING_VOICE_CALL.getValue())) {
            MeetingVoiceCall meetingVoiceCall = chatMsg.getMeetingVoiceCall();
            if (Objects.isNull(meetingVoiceCall)) {
                log.warn("illegal meetingVoiceCall message msgId:{}", (Object)chatMsg.getMsgId());
                return;
            }
            weworkFile.setMediaData(meetingVoiceCall.getSdkfileid());
            weworkFile.setMd5(chatMsg.getMsgId());
            weworkFile.setFileExt(FILE_TYPE_AMR);
        }
        try {
            this.weworkFileMapper.insertSelective((Object)weworkFile);
        }
        catch (Exception e) {
            log.error("fileType={},weworkFile={}", (Object)chatMsg.getMsgType(), (Object)weworkFile);
            throw e;
        }
    }

    private void toFile(WeworkFile weworkFile, ChatMsg chatMsg, Long bizId) {
        weworkFile.setMsgId(chatMsg.getMsgId());
        weworkFile.setBizId(bizId);
        weworkFile.setCorpId(chatMsg.getCorpId());
        weworkFile.setCreateTime(new Date());
        weworkFile.setIsDeleted(Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()));
        weworkFile.setUpdateTime(new Date());
        weworkFile.setType(chatMsg.getMsgType());
        weworkFile.setStatus(Integer.valueOf(FileStatus.INIT.getStatus()));
        weworkFile.setMsgTime(new Date(chatMsg.getMsgTime()));
    }

    @Override
    public void convertAmr2MP3() {
        log.info("convertAmr2MP3 begin");
        long startTime = System.currentTimeMillis();
        List fileList = this.weworkFileMapper.selectByTypeAndStatus(FileStatus.ALREADY_TO_OSS.getStatus(), (Collection)Sets.newHashSet((Object[])new String[]{ChatMsgType.VOICE.getValue(), ChatMsgType.MEETING_VOICE_CALL.getValue()}));
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return;
        }
        if (!this.locked(AMR_LOCK, 300L)) {
            log.info("convertAmr2MP3 locked");
            return;
        }
        for (List files : Lists.partition((List)fileList, (int)20)) {
            ArrayList updateList = Lists.newArrayList();
            for (WeworkFile weworkFile : files) {
                if (StringUtils.isNotBlank((CharSequence)weworkFile.getTranscodeFileUrl())) {
                    weworkFile.setStatus(Integer.valueOf(FileStatus.HAVE_CONVERT_TO_MP3.getStatus()));
                    updateList.add(weworkFile);
                    continue;
                }
                ResolvedAmrBasicInfoDto resolvedAmrBasicInfoDto = this.downloadAmrFileAndUploadMp3File(weworkFile.getFileUrl(), weworkFile);
                this.relock(AMR_LOCK, 300L);
                if (!Objects.nonNull(resolvedAmrBasicInfoDto)) continue;
                if (Objects.isNull(resolvedAmrBasicInfoDto.getResolvedPath())) {
                    weworkFile.setStatus(Integer.valueOf(FileStatus.CONVERT_TO_MP3_FAIL.getStatus()));
                } else {
                    weworkFile.setStatus(Integer.valueOf(FileStatus.HAVE_CONVERT_TO_MP3.getStatus()));
                    weworkFile.setTranscodeFileUrl(resolvedAmrBasicInfoDto.getResolvedPath());
                }
                updateList.add(weworkFile);
            }
            if (CollectionUtils.isEmpty((Collection)updateList)) {
                log.info("updateList is empty");
                continue;
            }
            log.info("handleNeedSyncToEsFile updateList size:{}, ids:{}", (Object)updateList.size(), updateList.stream().map(WeworkFile::getId).collect(Collectors.toList()));
            this.weworkFileMapper.batchUpdateFile((List)updateList);
        }
        this.unlock(AMR_LOCK);
        log.info("convertAmr2MP3 end, wasteTime={}", (Object)(System.currentTimeMillis() - startTime));
    }

    @Override
    public String manualConvertAmr2Mp3(String msgId, Integer update) {
        log.info("manualConvertAmr2Mp3 with msgId={},update={}", (Object)msgId, (Object)update);
        WeworkFile weworkFile = this.weworkFileMapper.queryByMsgId(msgId);
        if (weworkFile == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)weworkFile.getTranscodeFileUrl())) {
            return weworkFile.getTranscodeFileUrl();
        }
        ResolvedAmrBasicInfoDto resolvedAmrBasicInfoDto = this.downloadAmrFileAndUploadMp3File(weworkFile.getFileUrl(), weworkFile);
        if (Objects.isNull(resolvedAmrBasicInfoDto)) {
            return "\u6b63\u5728\u5904\u7406";
        }
        if (Objects.isNull(resolvedAmrBasicInfoDto.getResolvedPath())) {
            weworkFile.setStatus(Integer.valueOf(FileStatus.CONVERT_TO_MP3_FAIL.getStatus()));
            return "\u8f6c\u7801\u5931\u8d25";
        }
        weworkFile.setStatus(Integer.valueOf(FileStatus.HAVE_CONVERT_TO_MP3.getStatus()));
        weworkFile.setTranscodeFileUrl(resolvedAmrBasicInfoDto.getResolvedPath());
        if (update != null && update == 1) {
            this.weworkFileMapper.updateByPrimaryKeySelective((Object)weworkFile);
        }
        return resolvedAmrBasicInfoDto.getResolvedPath();
    }

    public ResolvedAmrBasicInfoDto downloadAmrFileAndUploadMp3File(String amrPath, @NonNull WeworkFile weworkFile) {
        if (weworkFile == null) {
            throw new NullPointerException("weworkFile is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)amrPath), (Object)"amrPath is not blank");
        log.info("downloadAmrFileAndUploadMp3File amrPath:{}", (Object)amrPath);
        String extName = FilenameUtils.getExtension((String)amrPath);
        String fileName = FilenameUtils.getBaseName((String)amrPath);
        String fileKey = FileServiceImpl.getFileKey(amrPath);
        log.info("basePath:{}, extName: {}, fileName:{}, fileKey:{}", new Object[]{this.basePath, extName, fileName, fileKey});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fileKey), (Object)"fileKey is not null; amrPath is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.basePath), (Object)"basePath is not null");
        Object presentObject = FILE_CONVERT_RECORDER.getIfPresent((Object)amrPath);
        if (Objects.nonNull(presentObject)) {
            log.warn("request is already processed, amrPath={}", (Object)amrPath);
            return null;
        }
        FILE_CONVERT_RECORDER.put((Object)amrPath, new Object());
        ResolvedAmrBasicInfoDto resolvedAmrBasicInfoDto = new ResolvedAmrBasicInfoDto();
        String aliYunUrl = null;
        boolean errorFlag = false;
        StopWatchDto watch = new StopWatchDto("downloadAmrFileAndUploadMp3File", true, log);
        watch.start("\u4e0b\u8f7d\u6587\u4ef6");
        byte[] bytes = new byte[]{};
        try {
            bytes = HttpClientUtils.download((String)amrPath);
        }
        catch (Exception e) {
            errorFlag = true;
            log.error("downloadAmrFileAndUploadMp3File download error; amrPath:{}, e", (Object)amrPath, (Object)e);
        }
        watch.stop();
        log.info("amrPath:{}", (Object)amrPath);
        if (errorFlag) {
            return resolvedAmrBasicInfoDto;
        }
        watch.start("\u5199\u5165arm\u6587\u4ef6");
        String localPath = FilenameUtils.getName((String)amrPath);
        java.io.File source = new java.io.File(localPath);
        try {
            IOUtils.write((byte[])bytes, (OutputStream)new FileOutputStream(source));
        }
        catch (IOException e) {
            errorFlag = true;
            log.error("downloadAmrFile and UploadMp3File write error; amrPath:{}", (Object)amrPath, (Object)e);
        }
        watch.stop();
        log.info("\u5199\u5165arm\u6587\u4ef6,fileName:{}", (Object)fileName);
        if (errorFlag) {
            return resolvedAmrBasicInfoDto;
        }
        watch.start("arm\u8f6c\u7801mp3");
        java.io.File target = this.convert(this.basePath, source.getAbsolutePath());
        watch.stop();
        log.info("amr\u8f6c\u7801mp3\u6587\u4ef6, fileName:{}", (Object)fileKey);
        watch.start("\u4e0a\u4f20mp3\u6587\u4ef6");
        if (target.exists()) {
            String fileSha1 = SHA1Utils.getSha1((java.io.File)target);
            WeworkUniqueFile weworkUniqueFile = this.selectUniqueFile(fileSha1);
            if (Objects.nonNull(weworkUniqueFile)) {
                aliYunUrl = weworkUniqueFile.getUrl();
            } else {
                try {
                    aliYunUrl = this.aliyunOss.uploadFile(weworkFile.getCorpId(), target, fileKey);
                }
                catch (Exception e) {
                    log.error("uploadFile amrPath:{}", (Object)amrPath, (Object)e);
                }
                log.info("uploadFile success, url:{}", (Object)aliYunUrl);
                WeworkUniqueFile uniqueFile = this.buildUniqueFile(weworkFile, aliYunUrl, fileSha1, FILE_TYPE_AMR);
                try {
                    this.weworkUniqueFileMapper.insertSelective((Object)uniqueFile);
                    log.info("insert unqiue file success sha1:{}", (Object)fileSha1);
                }
                catch (Exception e) {
                    log.error("insert unique file fail, fileId:{}", (Object)weworkFile.getId(), (Object)e);
                }
            }
            resolvedAmrBasicInfoDto.setResolvedPath(aliYunUrl);
        }
        watch.stop();
        log.info("\u4e0a\u4f20mp3\u6587\u4ef6,fileName:{}", (Object)fileName);
        FileUtils.deleteQuietly((java.io.File)source);
        FileUtils.deleteQuietly((java.io.File)target);
        watch.print();
        FILE_CONVERT_RECORDER.invalidate((Object)amrPath);
        return resolvedAmrBasicInfoDto;
    }

    private static String getFileKey(String armPath) {
        String[] split = armPath.split("/");
        if (split.length > 2) {
            return split[split.length - 1] + FILE_TYPE_MP3_SUFFIX;
        }
        return null;
    }

    private java.io.File convert(String basePath, String fileName) {
        log.info("convert basePath:{}, fileName:{}", (Object)basePath, (Object)fileName);
        String[] command = new String[]{basePath + "converter.sh", fileName, "mp3"};
        try {
            Process ps = Runtime.getRuntime().exec(command);
            int exitValue = ps.waitFor();
            if (0 != exitValue) {
                log.error("call shell failed. error code is :" + exitValue);
            }
        }
        catch (Exception e) {
            log.error("convert error fileName:{}", (Object)fileName, (Object)e);
            Thread.currentThread().interrupt();
        }
        String mp3LocalPath = FilenameUtils.removeExtension((String)fileName) + FILE_TYPE_MP3_SUFFIX;
        log.info("convert mp3LocalPath:{}", (Object)mp3LocalPath);
        return new java.io.File(mp3LocalPath);
    }

    @Override
    public String convertToUrlFromSdkField(SdkFieldToUrlReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("convertToUrlFromSdkField with userId={},bizId={},corpId={},req={}", new Object[]{currentUserInfo.getId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId(), req});
        req.validate();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        WeworkMixedFile mixedFile = new WeworkMixedFile();
        this.fillWeworkMixed(req, mixedFile);
        WeworkMixedFile weworkMixedFile = this.selectMinedFile(mixedFile.getMd5Sum());
        if (Objects.nonNull(weworkMixedFile)) {
            return weworkMixedFile.getOssUrl();
        }
        Optional<java.io.File> fileOptional = this.pullChatMsgService.fetchFile(corpId, bizId, mixedFile.getSdkFileId(), req.getMsgId(), mixedFile.getFileName());
        if (!fileOptional.isPresent()) {
            return null;
        }
        return this.syncToOssAndInsertMinedFile(corpId, fileOptional, mixedFile);
    }

    private String syncToOssAndInsertMinedFile(String corpId, Optional<java.io.File> optionalFile, WeworkMixedFile weworkMixedFile) {
        if (!optionalFile.isPresent()) {
            return null;
        }
        java.io.File file = optionalFile.get();
        String fileSha1 = SHA1Utils.getSha1((java.io.File)file);
        String url = "";
        url = this.aliyunOss.uploadFile(corpId, file, null);
        log.info("uploadFile success, url:{}", (Object)url);
        WeworkMixedFile mixedFile = new WeworkMixedFile();
        BeanUtils.copyProperties((Object)weworkMixedFile, (Object)mixedFile);
        mixedFile.setSha1Str(fileSha1);
        mixedFile.setOssUrl(url);
        mixedFile.setUrlMd5(MD5Utils.MD5((String)url));
        mixedFile.setUpdateBy(Long.valueOf(-1L));
        mixedFile.setCreateBy(Long.valueOf(-1L));
        Date date = new Date();
        mixedFile.setUpdateTime(date);
        mixedFile.setCreateTime(date);
        try {
            this.weworkMixedFileMapper.insertSelective((Object)mixedFile);
            log.info("insert unique file success sha1:{}", (Object)fileSha1);
        }
        catch (Exception e) {
            log.error("insert unique file fail, md5sum={}", (Object)mixedFile.getMd5Sum(), (Object)e);
        }
        FileUtils.deleteQuietly((java.io.File)file);
        log.info("syncToOssAndInsertMinedFile success");
        return url;
    }

    private void fillWeworkMixed(SdkFieldToUrlReq req, WeworkMixedFile weworkMixedFile) {
        String msgType = req.getType();
        weworkMixedFile.setType(msgType);
        weworkMixedFile.setMsgId(req.getMsgId());
        weworkMixedFile.setStatus(Integer.valueOf(0));
        weworkMixedFile.setFileUrl("");
        if (msgType.equals(ChatMsgType.IMAGE.getValue())) {
            try {
                Image image = (Image)JacksonUtils.getInstance().readValue(req.getContent(), Image.class);
                weworkMixedFile.setSdkFileId(image.getSdkfileid());
                weworkMixedFile.setMd5Sum(image.getMd5sum());
                weworkMixedFile.setFileSize(Integer.valueOf(image.getFileSize().intValue()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("content json \u89e3\u6790\u5f02\u5e38");
            }
        }
        if (msgType.equals(ChatMsgType.FILE.getValue())) {
            try {
                File file = (File)JacksonUtils.getInstance().readValue(req.getContent(), File.class);
                weworkMixedFile.setSdkFileId(file.getSdkfileid());
                weworkMixedFile.setMd5Sum(file.getMd5sum());
                weworkMixedFile.setFileSize(file.getFileSize());
                weworkMixedFile.setFileExt(file.getFileext());
                weworkMixedFile.setFileName(file.getFilename());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("content json \u89e3\u6790\u5f02\u5e38");
            }
        }
        if (msgType.equals(ChatMsgType.VOICE.getValue())) {
            try {
                Voice voice = (Voice)JacksonUtils.getInstance().readValue(req.getContent(), Voice.class);
                weworkMixedFile.setSdkFileId(voice.getSdkfileid());
                weworkMixedFile.setMd5Sum(voice.getMd5sum());
                weworkMixedFile.setDuration(voice.getPlayLength());
                weworkMixedFile.setFileSize(voice.getVoiceSize());
                weworkMixedFile.setFileExt(FILE_TYPE_AMR);
                weworkMixedFile.setStatus(Integer.valueOf(1));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("content json \u89e3\u6790\u5f02\u5e38");
            }
        }
        if (msgType.equals(ChatMsgType.VIDEO.getValue())) {
            try {
                Video video = (Video)JacksonUtils.getInstance().readValue(req.getContent(), Video.class);
                weworkMixedFile.setSdkFileId(video.getSdkfileid());
                weworkMixedFile.setMd5Sum(video.getMd5sum());
                weworkMixedFile.setDuration(video.getPlayLength());
                weworkMixedFile.setFileSize(video.getFileSize());
                weworkMixedFile.setFileExt("mp4");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("content json \u89e3\u6790\u5f02\u5e38");
            }
        }
        if (msgType.equals(ChatMsgType.EMOTION.getValue())) {
            try {
                Emotion emotion = (Emotion)JacksonUtils.getInstance().readValue(req.getContent(), Emotion.class);
                weworkMixedFile.setSdkFileId(emotion.getSdkfileid());
                weworkMixedFile.setMd5Sum(emotion.getMd5sum());
                weworkMixedFile.setFileSize(emotion.getImageSize());
                weworkMixedFile.setFileExt(emotion.getType() == 1 ? "gif" : "png");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("content json \u89e3\u6790\u5f02\u5e38");
            }
        }
        if (msgType.equals(ChatMsgType.MEETING_VOICE_CALL.getValue())) {
            try {
                MeetingVoiceCall meetingVoiceCall = (MeetingVoiceCall)JacksonUtils.getInstance().readValue(req.getContent(), MeetingVoiceCall.class);
                weworkMixedFile.setSdkFileId(meetingVoiceCall.getSdkfileid());
                weworkMixedFile.setMd5Sum(req.getMsgId());
                weworkMixedFile.setFileExt(FILE_TYPE_AMR);
                weworkMixedFile.setStatus(Integer.valueOf(1));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("content json \u89e3\u6790\u5f02\u5e38");
            }
        }
    }
}

