/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import com.kuaike.scrm.chat.service.CacheService;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class CacheServiceImpl
implements CacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheServiceImpl.class);
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;

    @Override
    @Cacheable(value={"corpId2BizId"}, key="#corpId")
    public Long queryBizId(String corpId) {
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
        return corp != null ? corp.getBizId() : 0L;
    }

    @Override
    public Set<Integer> queryUserNode(String corpId, String weworkUserId) {
        List exists = this.weworkDepartmentUserMapper.selectExistDepartmentUser(corpId, weworkUserId);
        return exists.stream().map(a -> a.getDepartmentId()).collect(Collectors.toSet());
    }

    @Override
    public Set<Integer> queryAllDepartment(String corpId, Set<Integer> departmentIds) {
        return this.departmentService.getAllFlatDepartment(corpId, departmentIds, true);
    }

    @Override
    @Cacheable(value={"corpIdUserId2UserId"}, key="#corpId + #weworkUserId")
    public String queryUserNum(String corpId, String weworkUserId) {
        return this.weworkUserMapper.queryWeworkUserNumById(corpId, weworkUserId);
    }
}

