/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.callback.corp.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelFollowUser;
import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.enums.ChatMsgType;
import cn.kinyun.wework.sdk.enums.TalkerType;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.chat.check.CorpWordTree;
import com.kuaike.scrm.chat.check.MatchedResult;
import com.kuaike.scrm.chat.check.MatchedType;
import com.kuaike.scrm.chat.check.MatchedWord;
import com.kuaike.scrm.chat.service.CacheService;
import com.kuaike.scrm.chat.service.ChatMsgRedisDelayQueueManager;
import com.kuaike.scrm.chat.service.QualityCheckEsService;
import com.kuaike.scrm.common.dto.CorpSensitiveWordBehaviorDto;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.common.enums.QualityCheckType;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkContactIdMapper;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkUserIdMapper;
import com.kuaike.scrm.dal.chat.entity.WeworkConversation;
import com.kuaike.scrm.dal.chat.mapper.WeworkConversationMapper;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckBehaviorSetting;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckLogEs;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckNotification;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckTriggerLogEs;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckWordEs;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckNotificationMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckNotificationScopeMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckWordGroupMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkNumPair;
import com.kuaike.scrm.dal.wework.dto.WeworkContactRelationDto;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUserStatisticsRecord;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserStatisticsRecordMapper;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.wework.insight.service.WeworkInsightService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class QualityCheckEsServiceImpl
implements QualityCheckEsService {
    private static final Logger log = LoggerFactory.getLogger(QualityCheckEsServiceImpl.class);
    @Value(value="${scrm.elasticsearch.qualityCheckLogIndex}")
    private String index;
    @Value(value="${scrm.elasticsearch.qualityCheckTriggerLogIndex}")
    private String triggerIndex;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private CorpWordTree corpWordTree;
    @Autowired
    private CacheService cacheService;
    @Resource
    private WeworkInsightService weworkInsightService;
    @Autowired
    private ChatMsgRedisDelayQueueManager delayQueueManager;
    @Autowired
    private IdGen idGen;
    @Autowired
    private RemindService remindService;
    @Autowired
    private NodeService nodeService;
    @Resource
    private QualityCheckNotificationMapper notificationMapper;
    @Resource
    private QualityCheckNotificationScopeMapper notificationScopeMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private QualityCheckBehaviorSettingMapper behaviorSettingMapper;
    @Resource
    private QualityCheckWordGroupMapper wordGroupMapper;
    @Resource
    private WeworkConversationMapper weworkConversationMapper;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Resource
    private AgentDecryptWeworkUserIdMapper agentDecryptWeworkUserIdMapper;
    @Resource
    private AgentDecryptWeworkContactIdMapper agentDecryptWeworkContactIdMapper;
    @Resource
    private WeworkUserStatisticsRecordMapper weworkUserStatisticsRecordMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String scrmManagerHost;
    private static final Set<String> SENSITIVE_TYPES = Sets.newHashSet((Object[])new String[]{ChatMsgType.TEXT.getValue(), ChatMsgType.CARD.getValue(), ChatMsgType.REDPACKET.getValue(), ChatMsgType.EXTERNAL_REDPACKET.getValue()});
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final String REMIND_STR = "\u3010\u5ba2\u6237\u6d41\u5931\u63d0\u9192\u3011\n [%s]\u5220\u9664\u4e86\u4f60\u7684\u4f01\u4e1a\u5fae\u4fe1\uff0c\u8bf7\u5173\u6ce8\u5e76\u53ca\u65f6\u8ddf\u8fdb\uff0c\u907f\u514d\u5ba2\u6237\u6d41\u5931\n\n>><a href=\"%s/clientSide?corpId=%s&contactId=%s\">\u67e5\u770b\u5ba2\u6237\u8be6\u60c5</a>";
    private static final String NOTIFICATION_FORMAT = "\u3010\u8fdd\u89c4\u901a\u77e5\u3011\n \u5458\u5de5[%s] %s [%s] %s\uff01\n\n ";
    private static final String CONTEXT_FORMAT = ">><a href=\"%s/sessionContext?corpId=%s&weworkUserId=%s&conversationId=%s&msgId=%s\">\u67e5\u770b\u4e0a\u4e0b\u6587</a>";
    private static final String CONTACT_FORMAT = "   >><a href=\"%s/clientSide?corpId=%s&contactId=%s\">\u67e5\u770b\u5ba2\u6237\u8be6\u60c5</a>";
    private static final String BATCH_NOTIFY_TEMPLATE = "\u5458\u5de5 [%s] %s [%s] %s \n";
    private static final String BATCH_NOTIFY_DETAILS = "\u5171%s\u6761\u8fdd\u89c4\u8bb0\u5f55\uff0c >><a href=\"%s/viloationNotice?corpId=%s&batchNo=%s\">\u67e5\u770b\u8be6\u60c5</a>";

    @Override
    public void handleMessage(ChatMsg chatMsg) {
        if (chatMsg == null) {
            return;
        }
        if (chatMsg.getAction().equals("recall")) {
            this.delayQueueManager.dealRecallMsg(chatMsg);
            return;
        }
        if (!chatMsg.getAction().equals("send") || !SENSITIVE_TYPES.contains(chatMsg.getMsgType())) {
            log.info("\u4e0d\u662f\u5173\u6ce8\u7684\u6d88\u606f\u7c7b\u578b,msgId={}", (Object)chatMsg.getMsgId());
            return;
        }
        int useAgent = this.queryNewDKF(chatMsg.getBizId());
        String corpId = chatMsg.getCorpId();
        String weworkUserId = chatMsg.getFrom();
        String contactId = (String)chatMsg.getTolist().get(0);
        if (useAgent == 1) {
            WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(chatMsg.getBizId());
            if (weworkCorp == null) {
                log.warn("weworkCorp is null corpId: {}", (Object)corpId);
                return;
            }
            corpId = weworkCorp.getCorpId();
            weworkUserId = this.agentDecryptWeworkUserIdMapper.queryByDecryptUserId(chatMsg.getBizId(), weworkUserId);
            contactId = this.agentDecryptWeworkContactIdMapper.queryByDecryptContactId(chatMsg.getBizId(), contactId);
        }
        chatMsg.setEncryptCorpId(corpId);
        chatMsg.setEncryptFormId(weworkUserId);
        chatMsg.setEncryptToId(contactId);
        String weworkUserNum = this.cacheService.queryUserNum(corpId, weworkUserId);
        switch (ChatMsgType.getType((String)chatMsg.getMsgType())) {
            case TEXT: {
                Set<Integer> departmentIds = this.cacheService.queryUserNode(corpId, weworkUserId);
                if (CollectionUtils.isEmpty(departmentIds)) {
                    log.info("\u672a\u627e\u5230\u53d1\u9001\u4eba\u6240\u5c5e\u90e8\u95e8,msgId={},from={}", (Object)chatMsg.getMsgId(), (Object)chatMsg.getFrom());
                    return;
                }
                if (!this.matchSensitiveWord(chatMsg, departmentIds, weworkUserNum)) break;
                return;
            }
            case CARD: {
                Integer cardBehavior = QualityBehaviorType.CARD.getType();
                CorpSensitiveWordBehaviorDto behaviorDto = this.corpWordTree.getBehaviorDto(chatMsg.getBizId());
                if (Objects.isNull(behaviorDto) || !behaviorDto.isSendCardCheck()) {
                    log.info("\u672a\u5f00\u542f\u540d\u7247\u68c0\u6d4b\u5f00\u5173,msgId={},from={}", (Object)chatMsg.getMsgId(), (Object)chatMsg.getFrom());
                    return;
                }
                if (!this.buildBehaviorLog(chatMsg, weworkUserNum, cardBehavior, chatMsg.getCard(), QualityBehaviorType.CARD.getDesc())) break;
                return;
            }
            case EXTERNAL_REDPACKET: 
            case REDPACKET: {
                this.weworkInsightService.handleRedPacketMsg(chatMsg);
                CorpSensitiveWordBehaviorDto behaviorDto2 = this.corpWordTree.getBehaviorDto(chatMsg.getBizId());
                if (Objects.isNull(behaviorDto2) || !behaviorDto2.isSendHongbaoCheck()) {
                    log.info("\u672a\u5f00\u542f\u7ea2\u5305\u68c0\u6d4b\u5f00\u5173,msgId={},from={}", (Object)chatMsg.getMsgId(), (Object)chatMsg.getFrom());
                    return;
                }
                Integer redPacketBehavior = QualityBehaviorType.RED_PACKAGE.getType();
                if (!this.buildBehaviorLog(chatMsg, weworkUserNum, redPacketBehavior, chatMsg.getRedPacket(), QualityBehaviorType.RED_PACKAGE.getDesc())) break;
                return;
            }
        }
        log.info("qualityCheck find msgId={}", (Object)chatMsg.getMsgId());
    }

    private boolean matchSensitiveWord(ChatMsg chatMsg, Set<Integer> departmentIds, String weworkUserNum) {
        MatchedResult result = this.corpWordTree.matchSensitiveWord(chatMsg.getBizId(), chatMsg.getText().getContent());
        if (result == null) {
            log.info("\u672a\u5339\u914d\u5230\u654f\u611f\u8bcd, msgId={}", (Object)chatMsg.getMsgId());
            return true;
        }
        QualityCheckLogEs dto = this.buildLog(chatMsg, weworkUserNum);
        if (dto == null) {
            return true;
        }
        ArrayList matchList = Lists.newArrayList();
        for (MatchedWord matchedWord : result.getMatchedWordList()) {
            for (MatchedType item : matchedWord.getTypes()) {
                Set<Integer> nodeIds = this.corpWordTree.getNodeIdsByGroupId(chatMsg.getBizId(), item.getGroupId());
                Set<Integer> allDepartmentIds = this.cacheService.queryAllDepartment(chatMsg.getEncryptCorpId(), nodeIds);
                if (!CollectionUtils.containsAny(departmentIds, allDepartmentIds)) continue;
                QualityCheckWordEs word = new QualityCheckWordEs();
                word.setTriggerGroupId(item.getGroupId());
                word.setTriggerWord(matchedWord.getWord());
                matchList.add(word);
            }
        }
        if (CollectionUtils.isEmpty((Collection)matchList)) {
            log.info("\u5339\u914d\u5230\u654f\u611f\u8bcd,\u4f46\u6ca1\u6709\u548c\u76d1\u542c\u90e8\u95e8\u6ca1\u6709\u4ea4\u96c6,corpId={},words={}", (Object)result.getCorpId(), result.getMatchedWordList());
            return true;
        }
        dto.setWords((List)matchList);
        log.info("matchSensitiveWord insert trigger");
        this.handleWeworkContactTriggerReplyMsg(chatMsg.getBizId(), new Date(chatMsg.getMsgTime()), chatMsg.getEncryptFormId(), QualityCheckType.WORD.getType());
        this.save(dto);
        String contactId = null;
        if (TalkerType.CONTACT.getValue() == chatMsg.getTalkerType().intValue()) {
            contactId = chatMsg.getEncryptToId();
        }
        Set wordGroupIds = matchList.stream().map(QualityCheckWordEs::getTriggerGroupId).collect(Collectors.toSet());
        List wordNums = this.wordGroupMapper.queryGroupNumByIds(chatMsg.getEncryptCorpId(), wordGroupIds);
        this.notification(dto, wordNums, null, null, contactId);
        return false;
    }

    private boolean buildBehaviorLog(ChatMsg chatMsg, String weworkUserNum, Integer behavior, Object content, String behaviorType) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return true;
        }
        QualityCheckLogEs dto = new QualityCheckLogEs();
        dto.setId(chatMsg.getMsgId());
        dto.setBizId(chatMsg.getBizId());
        dto.setCorpId(chatMsg.getEncryptCorpId());
        dto.setContent(JSON.toJSONString((Object)content));
        dto.setExternalType(Integer.valueOf(chatMsg.getExternalContact() != false ? 1 : 0));
        dto.setIsRevoke(Integer.valueOf(chatMsg.getIsRevoked() != null && chatMsg.getIsRevoked() != false ? 1 : 0));
        dto.setRevokeTime(new Date(chatMsg.getMsgTime()));
        dto.setTriggerBehavior(behavior);
        dto.setCreateTime(new Date());
        dto.setMsgId(chatMsg.getMsgId());
        dto.setMsgTime(new Date(chatMsg.getMsgTime()));
        dto.setMsgType(chatMsg.getMsgType());
        dto.setSendWeworkUserId(chatMsg.getEncryptFormId());
        dto.setTargetType(chatMsg.getTalkerType());
        String contactId = null;
        if (TalkerType.CONTACT.getValue() == chatMsg.getTalkerType().intValue()) {
            dto.setReceiveTargetId(chatMsg.getEncryptToId());
            contactId = chatMsg.getEncryptToId();
        } else if (TalkerType.CHATROOM.getValue() == chatMsg.getTalkerType().intValue()) {
            dto.setReceiveTargetId(chatMsg.getRoomId());
        } else {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)dto.getReceiveTargetId())) {
            return true;
        }
        dto.setType(QualityCheckType.BEHAVIOR.getType());
        dto.setSendWeworkUserNum(weworkUserNum);
        dto.setUpdateTime(new Date());
        dto.setConversationId(chatMsg.getConversationId());
        this.save(dto);
        if (this.checkBehaviorOpen(chatMsg.getBizId(), behaviorType)) {
            log.info("send card or redPacket insert trigger");
            this.handleWeworkContactTriggerReplyMsg(chatMsg.getBizId(), new Date(chatMsg.getMsgTime()), chatMsg.getEncryptFormId(), QualityCheckType.BEHAVIOR.getType());
        }
        String behaviorNum = this.behaviorSettingMapper.queryBehaviorNum(chatMsg.getEncryptCorpId(), behavior);
        this.notification(dto, null, behaviorNum, null, contactId);
        return false;
    }

    private QualityCheckLogEs buildLog(ChatMsg chatMsg, String weworkUserNum) {
        QualityCheckLogEs dto = new QualityCheckLogEs();
        dto.setId(chatMsg.getMsgId());
        dto.setBizId(chatMsg.getBizId());
        dto.setCorpId(chatMsg.getEncryptCorpId());
        dto.setContent(chatMsg.getText().getContent());
        dto.setExternalType(Integer.valueOf(chatMsg.getExternalContact() != false ? 1 : 0));
        dto.setIsRevoke(Integer.valueOf(chatMsg.getIsRevoked() != null && chatMsg.getIsRevoked() != false ? 1 : 0));
        dto.setRevokeTime(new Date(chatMsg.getMsgTime()));
        dto.setWords((List)Lists.newArrayList());
        dto.setTriggerBehavior(QualityBehaviorType.NONE.getType());
        dto.setCreateTime(new Date());
        dto.setMsgId(chatMsg.getMsgId());
        dto.setMsgTime(new Date(chatMsg.getMsgTime()));
        dto.setMsgType(chatMsg.getMsgType());
        dto.setSendWeworkUserId(chatMsg.getEncryptFormId());
        dto.setTargetType(chatMsg.getTalkerType());
        if (TalkerType.CONTACT.getValue() == chatMsg.getTalkerType().intValue()) {
            dto.setReceiveTargetId(chatMsg.getEncryptToId());
        } else if (TalkerType.CHATROOM.getValue() == chatMsg.getTalkerType().intValue()) {
            dto.setReceiveTargetId(chatMsg.getRoomId());
        } else {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)dto.getReceiveTargetId())) {
            log.info("receiveTargetId is empty, dto: {}", (Object)dto);
            return null;
        }
        dto.setType(QualityCheckType.WORD.getType());
        dto.setSendWeworkUserNum(weworkUserNum);
        dto.setUpdateTime(new Date());
        dto.setConversationId(chatMsg.getConversationId());
        return dto;
    }

    @Override
    public void handleDelContact(DelExternalContact event) {
        log.info("handleDelContact with event={}", (Object)event);
        this.executorService.submit(() -> {
            try {
                this.delContactTask(event);
            }
            catch (Exception e) {
                log.error("delContactTask with error", (Throwable)e);
            }
        });
    }

    private void delContactTask(DelExternalContact event) {
        String corpId = event.getToUserName();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByCorpId(corpId);
        if (weworkCorp == null) {
            log.warn("not find weworkCorp, corpId: {}", (Object)corpId);
            return;
        }
        Long bizId = this.weworkCorpMapper.getByCorpId(corpId).getBizId();
        CorpSensitiveWordBehaviorDto behaviorDto = this.corpWordTree.getBehaviorDto(bizId);
        if (behaviorDto == null || !behaviorDto.isDelContactCheck()) {
            log.info("corpId={}\u672a\u5f00\u542f\u5220\u9664\u597d\u53cb\u654f\u611f\u884c\u4e3a\u76d1\u63a7", (Object)corpId);
            return;
        }
        String weworkUserId = event.getUserId();
        String contactId = event.getExternalUserId();
        int useAgent = this.queryNewDKF(bizId);
        if (useAgent == 1) {
            weworkUserId = this.agentDecryptWeworkUserIdMapper.queryByEncryptUserId(bizId, weworkUserId);
            contactId = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactId(bizId, contactId);
        }
        WeworkConversation conversation = this.weworkConversationMapper.queryConversion(corpId, weworkUserId, contactId);
        QualityCheckLogEs dto = new QualityCheckLogEs();
        String id = this.idGen.getNum();
        dto.setId(id);
        dto.setBizId(this.cacheService.queryBizId(corpId));
        dto.setCorpId(event.getToUserName());
        dto.setExternalType(Integer.valueOf(1));
        dto.setIsRevoke(Integer.valueOf(0));
        dto.setTriggerBehavior(QualityBehaviorType.DEL_CONTACT.getType());
        dto.setContent("");
        dto.setMsgId(id);
        dto.setMsgTime(new Date(event.getCreateTime() * 1000L));
        dto.setMsgType(event.getMsgType());
        dto.setSendWeworkUserId(event.getUserId());
        dto.setTargetType(Integer.valueOf(TalkerType.CONTACT.getValue()));
        dto.setReceiveTargetId(event.getExternalUserId());
        dto.setType(QualityCheckType.BEHAVIOR.getType());
        dto.setSendWeworkUserNum(this.cacheService.queryUserNum(dto.getCorpId(), dto.getSendWeworkUserId()));
        dto.setCreateTime(new Date());
        dto.setUpdateTime(new Date());
        if (conversation != null) {
            dto.setConversationId(ChatMsg.getConversationId(null, (String)conversation.getWeworkUserId(), (String)conversation.getTalkerId()));
            dto.setMsgId(conversation.getMsgId());
        }
        if (this.checkBehaviorOpen(this.cacheService.queryBizId(corpId), QualityBehaviorType.DEL_CONTACT.getDesc())) {
            log.info("del contact insert trigger");
            this.handleWeworkContactTriggerReplyMsg(this.cacheService.queryBizId(corpId), new Date(event.getCreateTime()), event.getUserId(), QualityCheckType.BEHAVIOR.getType());
        }
        this.save(dto);
        String behaviorNum = this.behaviorSettingMapper.queryBehaviorNum(corpId, QualityBehaviorType.DEL_CONTACT.getType());
        this.notification(dto, null, behaviorNum, null, event.getExternalUserId());
        log.info("delContact weworkUserId={},contactId={}", (Object)dto.getSendWeworkUserId(), (Object)dto.getReceiveTargetId());
    }

    @Override
    public void handleDelByContact(DelFollowUser event) {
        log.info("handleDelByContact with event={}", (Object)event);
        this.executorService.submit(() -> {
            try {
                String name;
                WeworkContact contact;
                QualityCheckLogEs checkLog = this.delByContactTask(event);
                String corpId = event.getToUserName();
                String weworkUserId = event.getUserId();
                String contactId = event.getExternalUserId();
                Long bizId = this.cacheService.queryBizId(corpId);
                if (this.checkBehaviorOpen(bizId, QualityBehaviorType.DEL_BY_CONTACT.getDesc())) {
                    log.info("del by contact insert trigger");
                    this.handleWeworkContactTriggerReplyMsg(bizId, new Date(event.getCreateTime()), weworkUserId, QualityCheckType.BEHAVIOR.getType());
                }
                if ((contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId)) == null) {
                    log.warn("contact not exist, corpId={}, contactId={}, weworkUserId={}", new Object[]{corpId, contactId, weworkUserId});
                    name = "\u5df2\u5220\u9664";
                } else {
                    name = contact.getName();
                }
                WeworkContactRelation relation = this.weworkContactRelationMapper.get(corpId, weworkUserId, contactId);
                if (relation == null) {
                    log.warn("\u8054\u7cfb\u4eba\u5df2\u5220\u9664, corpId={}, contactId={}, weworkUserId={}", new Object[]{corpId, contactId, weworkUserId});
                } else if (StringUtils.isNotBlank((CharSequence)relation.getRemark())) {
                    name = relation.getRemark();
                }
                String content = String.format(REMIND_STR, name, this.scrmManagerHost, corpId, contactId);
                log.info("ready to send qyremind with corpId={}, weworkUserId={}, content={}", new Object[]{corpId, weworkUserId, content});
                this.remindService.sendMsg(corpId, weworkUserId, content);
                String behaviorNum = this.behaviorSettingMapper.queryBehaviorNum(corpId, QualityBehaviorType.DEL_BY_CONTACT.getType());
                if (checkLog != null) {
                    this.notification(checkLog, null, behaviorNum, null, contactId);
                }
            }
            catch (Exception e) {
                log.error("delByContactTask with error", (Throwable)e);
            }
        });
    }

    @Override
    public void notification(QualityCheckLogEs checkLog, List<String> wordNums, String behaviorNum, Integer isNotifyTimeout, String contactId) {
        WeworkUser innerUser;
        List notifications;
        log.info("notification checkLog: {}, wordNums: {}, behaviorNum: {}, isNotifyTimeout: {}, contactId: {}", new Object[]{checkLog, wordNums, behaviorNum, isNotifyTimeout, contactId});
        String corpId = checkLog.getCorpId();
        Long bizId = checkLog.getBizId();
        ArrayList behaviorNums = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)behaviorNum)) {
            behaviorNums.add(behaviorNum);
        }
        if (CollectionUtils.isEmpty((Collection)(notifications = this.notificationMapper.queryMatchNotification(corpId, wordNums, (Collection)behaviorNums, isNotifyTimeout)))) {
            log.info("not find match notification corpId: {}", (Object)corpId);
            return;
        }
        Set<Integer> departmentIds = this.cacheService.queryUserNode(corpId, checkLog.getSendWeworkUserId());
        List weworkUserOfOrgIds = this.organizationMapper.queryOrgIdByDepartmentIds(bizId, departmentIds);
        QualityCheckNotification matchNotification = this.matchNotification(notifications, checkLog.getSendWeworkUserNum(), weworkUserOfOrgIds);
        if (matchNotification == null) {
            log.info("not find notification, corpId: {}", (Object)corpId);
            return;
        }
        log.info("match notification num:{}", (Object)matchNotification.getNum());
        if (matchNotification.getNotifyType() == 2) {
            checkLog.setBatchNotify(Integer.valueOf(1));
            checkLog.setNotificationId(matchNotification.getId());
            log.info("update checkLog id: {}", (Object)checkLog.getId());
            this.updateNotificationId(checkLog);
            return;
        }
        String weworkUserName = (String)this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, (Collection)Lists.newArrayList((Object[])new String[]{checkLog.getSendWeworkUserNum()})).get(checkLog.getSendWeworkUserNum());
        WeworkContactRelation relation = this.weworkContactRelationMapper.get(corpId, checkLog.getSendWeworkUserId(), checkLog.getReceiveTargetId());
        String contactName = "";
        if (relation != null) {
            contactName = relation.getRemark();
        }
        if (checkLog.getExternalType() == 0 && checkLog.getTargetType() == 1 && (innerUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, checkLog.getReceiveTargetId())) != null) {
            contactName = innerUser.getName();
        }
        WeworkChatRoom weworkChatRoom = this.weworkChatRoomMapper.getWeworkChatRoom(corpId, checkLog.getReceiveTargetId());
        String chatRoomName = "";
        if (weworkChatRoom != null) {
            chatRoomName = weworkChatRoom.getName();
        }
        String action = "";
        if (checkLog.getType() == 0) {
            if (CollectionUtils.isNotEmpty((Collection)checkLog.getWords())) {
                String words = checkLog.getWords().stream().map(QualityCheckWordEs::getTriggerWord).collect(Collectors.joining(","));
                action = "\u804a\u5929\u6d88\u606f\u8fdd\u89c4 [" + words + "]";
            } else {
                action = "\u804a\u5929\u6d88\u606f\u8fdd\u89c4";
            }
        } else if (checkLog.getType() == 1) {
            action = QualityBehaviorType.getByType((int)checkLog.getTriggerBehavior()).getDesc();
        }
        StringBuilder sb = new StringBuilder();
        if (checkLog.getTargetType() == 1) {
            sb.append(String.format(NOTIFICATION_FORMAT, weworkUserName, "\u5bf9\u597d\u53cb", contactName, action));
        } else if (checkLog.getTargetType() == 2) {
            sb.append(String.format(NOTIFICATION_FORMAT, weworkUserName, "\u5728\u7fa4\u91cc", chatRoomName, action));
        }
        if (StringUtils.isNotBlank((CharSequence)checkLog.getConversationId())) {
            sb.append(String.format(CONTEXT_FORMAT, this.scrmManagerHost, corpId, checkLog.getSendWeworkUserNum(), checkLog.getConversationId(), checkLog.getMsgId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)contactId)) {
            sb.append(String.format(CONTACT_FORMAT, this.scrmManagerHost, corpId, contactId));
        }
        String notificationMsg = sb.toString();
        List chargeNums = Splitter.on((String)",").splitToList((CharSequence)matchNotification.getChargeNum());
        List chargeIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)chargeNums);
        if (CollectionUtils.isNotEmpty((Collection)chargeIds)) {
            for (String chargeId : chargeIds) {
                this.remindService.asyncSendMsg(corpId, chargeId, notificationMsg);
            }
        }
        String departMasterNum = matchNotification.getDepartMasterNum();
        List departMasterNums = Lists.newArrayList();
        List departMasterIds = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)departMasterNum)) {
            departMasterNums = Splitter.on((String)",").splitToList((CharSequence)departMasterNum);
            departMasterIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)departMasterNums);
            for (String departMasterId : departMasterIds) {
                if (chargeIds.contains(departMasterId)) continue;
                this.remindService.asyncSendMsg(corpId, departMasterId, notificationMsg);
            }
        }
        if (matchNotification.getIsNotify() == 1 && !chargeIds.contains(checkLog.getSendWeworkUserId()) && !departMasterIds.contains(checkLog.getSendWeworkUserId())) {
            this.remindService.asyncSendMsg(corpId, checkLog.getSendWeworkUserId(), notificationMsg);
        }
    }

    private QualityCheckNotification matchNotification(List<QualityCheckNotification> notifications, String weworkUserNum, List<Long> weworkUserOfOrgIds) {
        QualityCheckNotification result = null;
        for (QualityCheckNotification notification : notifications) {
            if (notification.getScope() == 0) {
                result = notification;
                break;
            }
            if (notification.getScope() != 1) continue;
            int count = this.notificationScopeMapper.matchWeworkUserList(notification.getCorpId(), notification.getNum(), weworkUserNum);
            if (count > 0) {
                result = notification;
                break;
            }
            List orgNums = (List)this.notificationScopeMapper.queryNotificationOrgMap(notification.getCorpId(), (Collection)Lists.newArrayList((Object[])new String[]{notification.getNum()})).get(notification.getNum());
            if (CollectionUtils.isEmpty((Collection)orgNums)) break;
            Collection orgIds = this.nodeService.getIdByNums(notification.getBizId(), (Collection)orgNums).values();
            Set managerOrgIds = this.nodeService.getPosterityIds(orgIds, notification.getBizId());
            Collection intersection = CollectionUtils.intersection((Iterable)managerOrgIds, weworkUserOfOrgIds);
            if (!CollectionUtils.isNotEmpty((Collection)intersection)) continue;
            result = notification;
            break;
        }
        return result;
    }

    private QualityCheckLogEs delByContactTask(DelFollowUser event) {
        String corpId = event.getToUserName();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByCorpId(corpId);
        if (weworkCorp == null) {
            log.warn("weworkCorp is null corpId: {}", (Object)corpId);
            return null;
        }
        Long bizId = weworkCorp.getBizId();
        CorpSensitiveWordBehaviorDto behaviorDto = this.corpWordTree.getBehaviorDto(bizId);
        if (behaviorDto == null || !behaviorDto.isDelByContactCheck()) {
            log.info("corpId={}\u672a\u5f00\u542f\u88ab\u597d\u53cb\u5220\u9664\u654f\u611f\u884c\u4e3a\u76d1\u63a7", (Object)corpId);
            return null;
        }
        String weworkUserId = event.getUserId();
        String contactId = event.getExternalUserId();
        int useAgent = this.queryNewDKF(bizId);
        if (useAgent == 1) {
            weworkUserId = this.agentDecryptWeworkUserIdMapper.queryByEncryptUserId(bizId, weworkUserId);
            contactId = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactId(bizId, contactId);
        }
        WeworkConversation conversation = this.weworkConversationMapper.queryConversion(corpId, weworkUserId, contactId);
        QualityCheckLogEs dto = new QualityCheckLogEs();
        String id = this.idGen.getNum();
        dto.setId(id);
        dto.setBizId(this.cacheService.queryBizId(corpId));
        dto.setCorpId(event.getToUserName());
        dto.setExternalType(Integer.valueOf(1));
        dto.setIsRevoke(Integer.valueOf(0));
        dto.setTriggerBehavior(QualityBehaviorType.DEL_BY_CONTACT.getType());
        dto.setContent("");
        dto.setMsgId(id);
        dto.setMsgType(event.getMsgType());
        dto.setMsgTime(new Date(event.getCreateTime() * 1000L));
        dto.setSendWeworkUserId(event.getUserId());
        dto.setTargetType(Integer.valueOf(TalkerType.CONTACT.getValue()));
        dto.setReceiveTargetId(event.getExternalUserId());
        dto.setType(QualityCheckType.BEHAVIOR.getType());
        dto.setSendWeworkUserNum(this.cacheService.queryUserNum(dto.getCorpId(), dto.getSendWeworkUserId()));
        dto.setCreateTime(new Date());
        dto.setUpdateTime(new Date());
        if (conversation != null) {
            dto.setConversationId(ChatMsg.getConversationId(null, (String)conversation.getWeworkUserId(), (String)conversation.getTalkerId()));
            dto.setMsgId(conversation.getMsgId());
        }
        this.save(dto);
        log.info("delByContact weworkUserId={},contactId={}", (Object)dto.getSendWeworkUserId(), (Object)dto.getReceiveTargetId());
        return dto;
    }

    private Integer queryNewDKF(Long bizId) {
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        return Objects.equals(weworkCorp.getIsNewDkf(), 1) ? 1 : 0;
    }

    private void handleWeworkContactTriggerReplyMsg(Long bizId, Date msgTime, String weworkUserId, Integer type) {
        log.info("handleWeworkContactTriggerReplyMsg bizId: {}, weworkUserId: {}, type: {}", new Object[]{bizId, weworkUserId, type});
        Calendar calendar = Calendar.getInstance();
        if (msgTime != null) {
            calendar.setTime(msgTime);
        } else {
            calendar.setTime(new Date());
        }
        WeworkUserStatisticsRecord statisticsRecord = new WeworkUserStatisticsRecord();
        statisticsRecord.setBizId(bizId);
        statisticsRecord.setNum(this.idGen.getNum());
        statisticsRecord.setYear(Integer.valueOf(calendar.get(1)));
        statisticsRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
        statisticsRecord.setWeek(Integer.valueOf(calendar.get(3)));
        statisticsRecord.setStatisticTime(msgTime);
        statisticsRecord.setCreateTime(new Date());
        statisticsRecord.setUpdateTime(new Date());
        statisticsRecord.setWeworkUserId(weworkUserId);
        if (type.equals(QualityCheckType.BEHAVIOR.getType())) {
            this.weworkUserStatisticsRecordMapper.insertOrUpdateTriggerBehaviorData(statisticsRecord);
        }
        if (type.equals(QualityCheckType.WORD.getType())) {
            this.weworkUserStatisticsRecordMapper.insertOrUpdateTriggerWordData(statisticsRecord);
        }
    }

    private boolean checkBehaviorOpen(Long bizId, String behaviorType) {
        log.info("Qualitycheck Behavior bizId: {}, behaviorType: {}", (Object)bizId, (Object)behaviorType);
        List settingList = this.behaviorSettingMapper.queryBehaviorListByBizId(bizId);
        if (CollectionUtils.isEmpty((Collection)settingList)) {
            log.info("Qualitycheck Behavior  get settingList is null");
            return false;
        }
        List settings = settingList.stream().filter(a -> a.getCheckDesc().equals(behaviorType)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(settings)) {
            log.info("Qualitycheck Behavior setting is null");
            return false;
        }
        QualityCheckBehaviorSetting setting = (QualityCheckBehaviorSetting)settings.get(0);
        log.info("checkBehaviorOpen bizId: {}, behaviorType: {}, status: {}", new Object[]{bizId, behaviorType, setting.getCheckStatus()});
        return setting.getCheckStatus() == 1;
    }

    @Override
    public void batchNotification() {
        List qualityCheckLogs = this.queryBatchNotify();
        if (CollectionUtils.isEmpty(qualityCheckLogs)) {
            log.info("wait batch notify is empty");
            return;
        }
        qualityCheckLogs = Lists.reverse(qualityCheckLogs);
        HashMap notifyGroupMap = Maps.newHashMap();
        for (QualityCheckLogEs log : qualityCheckLogs) {
            List list = notifyGroupMap.getOrDefault(log.getNotificationId(), Lists.newArrayList());
            list.add(log);
            notifyGroupMap.put(log.getNotificationId(), list);
        }
        Set notificationIds = notifyGroupMap.keySet();
        List notifications = this.notificationMapper.queryByIds(notificationIds);
        HashMap notificationMap = Maps.newHashMap();
        for (QualityCheckNotification notification : notifications) {
            notificationMap.put(notification.getId(), notification);
        }
        for (Long notificationId : notifyGroupMap.keySet()) {
            QualityCheckNotification notification = (QualityCheckNotification)notificationMap.get(notificationId);
            List checkList = (List)notifyGroupMap.get(notificationId);
            if (!this.batchNotify(notification)) continue;
            this.doBatchNotification(notification, checkList);
        }
    }

    private boolean batchNotify(QualityCheckNotification notification) {
        String key = this.redisKeyPrefix + "notificationNum:" + notification.getNum();
        String lastBatchNotifyTime = (String)this.redisTemplate.opsForValue().get((Object)key);
        long lastNotifyTime = notification.getUpdateTime().getTime();
        if (StringUtils.isNotEmpty((CharSequence)lastBatchNotifyTime)) {
            lastNotifyTime = Long.parseLong(lastBatchNotifyTime);
        }
        long curTime = System.currentTimeMillis();
        long waitTime = 0L;
        if (notification.getWaitTime() != null) {
            waitTime = notification.getWaitTime() * 60 * 1000;
        }
        return curTime - lastNotifyTime >= waitTime;
    }

    private void doBatchNotification(QualityCheckNotification notification, List<QualityCheckLogEs> checkList) {
        String corpId = notification.getCorpId();
        String batchNotifyNo = this.idGen.getNum();
        String notifyContent = this.buildBatchNotificationTemplate(corpId, batchNotifyNo, checkList);
        Long curTime = System.currentTimeMillis();
        List chargeNums = Splitter.on((String)",").splitToList((CharSequence)notification.getChargeNum());
        List chargeIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)chargeNums);
        if (CollectionUtils.isNotEmpty((Collection)chargeIds)) {
            for (String chargeId : chargeIds) {
                this.remindService.asyncSendMsg(corpId, chargeId, notifyContent);
            }
        }
        String departMasterNum = notification.getDepartMasterNum();
        List departMasterNums = Lists.newArrayList();
        List departMasterIds = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)departMasterNum)) {
            departMasterNums = Splitter.on((String)",").splitToList((CharSequence)departMasterNum);
            departMasterIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)departMasterNums);
            for (Object departMasterId : departMasterIds) {
                if (chargeIds.contains(departMasterId)) continue;
                this.remindService.asyncSendMsg(corpId, (String)departMasterId, notifyContent);
            }
        }
        HashSet touchUserIds = Sets.newHashSet();
        if (notification.getIsNotify() == 1) {
            for (QualityCheckLogEs checkLog : checkList) {
                if (chargeIds.contains(checkLog.getSendWeworkUserId()) || departMasterIds.contains(checkLog.getSendWeworkUserId()) || touchUserIds.contains(checkLog.getSendWeworkUserId())) continue;
                this.remindService.asyncSendMsg(corpId, checkLog.getSendWeworkUserId(), notifyContent);
                touchUserIds.add(checkLog.getSendWeworkUserId());
            }
        }
        Set<String> ids = checkList.stream().map(QualityCheckLogEs::getId).collect(Collectors.toSet());
        this.updateBatchNotifyNo(ids, batchNotifyNo);
        String key = this.redisKeyPrefix + "notificationNum:" + notification.getNum();
        this.redisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(curTime));
    }

    private String buildBatchNotificationTemplate(String corpId, String batchNotifyNo, List<QualityCheckLogEs> checkList) {
        HashSet weworkUserNums = Sets.newHashSet();
        HashSet chatRoomIds = Sets.newHashSet();
        HashSet innerUserIds = Sets.newHashSet();
        HashSet contactWeworkPairs = Sets.newHashSet();
        for (QualityCheckLogEs checkLog : checkList) {
            weworkUserNums.add(checkLog.getSendWeworkUserNum());
            if (checkLog.getTargetType() == 1) {
                if (checkLog.getExternalType() == 0) {
                    innerUserIds.add(checkLog.getReceiveTargetId());
                    continue;
                }
                ContactWeworkNumPair pair = new ContactWeworkNumPair(checkLog.getSendWeworkUserNum(), checkLog.getReceiveTargetId());
                contactWeworkPairs.add(pair);
                continue;
            }
            if (checkLog.getTargetType() != 2) continue;
            chatRoomIds.add(checkLog.getReceiveTargetId());
        }
        Map weworkUserNameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, (Collection)weworkUserNums);
        HashMap contactRemarkNameMap = Maps.newHashMap();
        List pairList = this.weworkContactRelationMapper.queryContactRelationByPair(corpId, (Collection)contactWeworkPairs);
        for (WeworkContactRelationDto pair : pairList) {
            contactRemarkNameMap.put(pair.getContactId(), pair.getRemark());
        }
        Map chatRoomNameMap = this.weworkChatRoomMapper.queryNameMap(corpId, (Collection)chatRoomIds);
        Map innerUserNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)innerUserIds)) {
            innerUserNameMap = this.weworkUserMapper.queryWeworkUserNameMap(corpId, (Collection)innerUserIds);
        }
        StringBuilder str = new StringBuilder("\u3010\u8fdd\u89c4\u901a\u77e5\u3011 \n");
        int count = checkList.size();
        for (int i = 0; i < count && i < 5; ++i) {
            QualityCheckLogEs checkLog = checkList.get(i);
            String weworkUserName = (String)weworkUserNameMap.get(checkLog.getSendWeworkUserNum());
            String contactName = (String)contactRemarkNameMap.get(checkLog.getReceiveTargetId());
            if (checkLog.getExternalType() == 0) {
                contactName = (String)innerUserNameMap.get(checkLog.getReceiveTargetId());
            }
            String chatRoomName = (String)chatRoomNameMap.get(checkLog.getReceiveTargetId());
            String action = "";
            if (checkLog.getType() == 0) {
                if (CollectionUtils.isNotEmpty((Collection)checkLog.getWords())) {
                    String words = checkLog.getWords().stream().map(QualityCheckWordEs::getTriggerWord).collect(Collectors.joining(","));
                    action = "\u804a\u5929\u6d88\u606f\u8fdd\u89c4 [" + words + "]";
                } else {
                    action = "\u804a\u5929\u6d88\u606f\u8fdd\u89c4";
                }
            } else if (checkLog.getType() == 1) {
                action = QualityBehaviorType.getByType((int)checkLog.getTriggerBehavior()).getDesc();
            }
            if (checkLog.getTargetType() == 1) {
                str.append(String.format(BATCH_NOTIFY_TEMPLATE, weworkUserName, "\u5bf9\u597d\u53cb", contactName, action));
                continue;
            }
            if (checkLog.getTargetType() != 2) continue;
            str.append(String.format(BATCH_NOTIFY_TEMPLATE, weworkUserName, "\u5728\u7fa4\u91cc", chatRoomName, action));
        }
        if (count > 5) {
            str.append("..... \n");
        }
        str.append(String.format(BATCH_NOTIFY_DETAILS, count, this.scrmManagerHost, corpId, batchNotifyNo));
        return str.toString();
    }

    @Override
    public void save(QualityCheckLogEs checkLog) {
        this.save(Collections.singletonList(checkLog));
    }

    @Override
    public void save(List<QualityCheckLogEs> list) {
        BulkRequest triggerBulkRequest = new BulkRequest();
        for (QualityCheckLogEs qualityCheckLogEs : list) {
            if (CollectionUtils.isEmpty((Collection)qualityCheckLogEs.getWords())) continue;
            for (QualityCheckWordEs wordEs : qualityCheckLogEs.getWords()) {
                QualityCheckTriggerLogEs triggerGroupEs = this.getQualityCheckTriggerGroupEs(qualityCheckLogEs, wordEs);
                IndexRequest indexRequest = new IndexRequest(this.triggerIndex, "doc", triggerGroupEs.getId());
                indexRequest.source(JSON.toJSONString((Object)triggerGroupEs), XContentType.JSON);
                triggerBulkRequest.add(indexRequest);
            }
        }
        if (!triggerBulkRequest.requests().isEmpty()) {
            try {
                BulkResponse bulkResponse = this.restHighLevelClient.bulk(triggerBulkRequest, new Header[0]);
                log.info("bulk response:{}", (Object)bulkResponse.status());
            }
            catch (Exception e) {
                log.error("bulk save quality_check_log_trigger failed, bulkRequest:{}", (Object)triggerBulkRequest, (Object)e);
            }
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (QualityCheckLogEs qualityCheckLogEs : list) {
            IndexRequest indexRequest = new IndexRequest(this.index, "doc", qualityCheckLogEs.getId());
            indexRequest.source(JSON.toJSONString((Object)qualityCheckLogEs), XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        try {
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
            log.info("bulk response:{}", (Object)bulkResponse.status());
        }
        catch (Exception exception) {
            log.error("bulk save quality_check_log failed, bulkRequest:{}", (Object)bulkRequest, (Object)exception);
        }
    }

    private QualityCheckTriggerLogEs getQualityCheckTriggerGroupEs(QualityCheckLogEs qualityCheckLogEs, QualityCheckWordEs wordEs) {
        String id = qualityCheckLogEs.getId() + "_" + wordEs.getTriggerGroupId() + "_" + wordEs.getTriggerWord().hashCode();
        QualityCheckTriggerLogEs triggerGroupEs = new QualityCheckTriggerLogEs();
        triggerGroupEs.setId(id);
        triggerGroupEs.setMsgId(qualityCheckLogEs.getMsgId());
        triggerGroupEs.setBizId(qualityCheckLogEs.getBizId());
        triggerGroupEs.setCorpId(qualityCheckLogEs.getCorpId());
        triggerGroupEs.setTriggerGroupId(wordEs.getTriggerGroupId());
        triggerGroupEs.setTriggerWord(wordEs.getTriggerWord());
        triggerGroupEs.setCreateTime(qualityCheckLogEs.getCreateTime());
        triggerGroupEs.setSendWeworkUserId(qualityCheckLogEs.getSendWeworkUserId());
        triggerGroupEs.setIsRevoke(qualityCheckLogEs.getIsRevoke());
        return triggerGroupEs;
    }

    @Override
    public QualityCheckLogEs getByMsgId(String msgId) {
        GetResponse response;
        GetRequest request = new GetRequest(this.index, "doc", msgId);
        try {
            response = this.restHighLevelClient.get(request, new Header[0]);
            log.info("get checkLog, result:{}", (Object)response);
        }
        catch (IOException e) {
            log.error("get elasticsearch failed, request={}", (Object)request, (Object)e);
            return null;
        }
        QualityCheckLogEs result = null;
        if (response.isExists()) {
            try {
                result = (QualityCheckLogEs)JacksonUtil.str2Obj((String)response.getSourceAsString(), QualityCheckLogEs.class);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            }
        } else {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
        }
        return result;
    }

    @Override
    public void updateRevoke(QualityCheckLogEs checkLog, Long msgTime) {
        log.info("update revoke checkLog:{}, msgTime:{}", (Object)checkLog, (Object)msgTime);
        long revokeTime = msgTime != null ? msgTime : System.currentTimeMillis();
        HashMap<String, Number> jsonMap = new HashMap<String, Number>();
        jsonMap.put("isRevoke", 1);
        jsonMap.put("revokeTime", revokeTime);
        jsonMap.put("updateTime", System.currentTimeMillis());
        UpdateRequest updateRequest = new UpdateRequest(this.index, "doc", checkLog.getId());
        try {
            updateRequest.doc(jsonMap);
            updateRequest.retryOnConflict(3);
            UpdateResponse response = this.restHighLevelClient.update(updateRequest, new Header[0]);
            if (response.getResult() == DocWriteResponse.Result.UPDATED) {
                log.info("doc updated successfully.");
            } else if (response.getResult() == DocWriteResponse.Result.NOOP) {
                log.info("No changes to the document.");
            }
        }
        catch (IOException e) {
            log.error("update failed:{}", (Object)updateRequest, (Object)e);
        }
        this.updateBehaviorRevoke(checkLog.getMsgId());
    }

    public void updateBehaviorRevoke(String msgId) {
        SearchResponse searchResponse;
        log.info("updateBehaviorRevoke msgId: {}", (Object)msgId);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"msgId.keyword", (String)msgId));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.triggerIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(9999);
        searchSourceBuilder.from(0);
        searchRequest.source(searchSourceBuilder);
        log.info("updateBehaviorRevoke searchRequest: {}", (Object)searchRequest.source().toString());
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("updateBehaviorRevoke Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            return;
        }
        log.info("updateBehaviorRevoke searchResponse: {}", (Object)searchResponse);
        SearchHits hits = searchResponse.getHits();
        if (hits.getTotalHits() == 0L) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
            return;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)((int)hits.getTotalHits()));
        for (SearchHit searchHit : hits.getHits()) {
            String sourceAsString = searchHit.getSourceAsString();
            QualityCheckTriggerLogEs chatMsg = (QualityCheckTriggerLogEs)JSON.parseObject((String)sourceAsString, QualityCheckTriggerLogEs.class);
            result.add(chatMsg);
        }
        log.info("updateBehaviorRevoke get result size: {}, msgId: {}", (Object)result.size(), (Object)msgId);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        for (QualityCheckTriggerLogEs logEs : result) {
            log.info("updateBehaviorRevoke update id: {}", (Object)logEs.getId());
            UpdateRequest updateRequest = new UpdateRequest(this.triggerIndex, "doc", logEs.getId());
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("isRevoke", 1).endObject();
                updateRequest.doc(builder);
                UpdateResponse response = this.restHighLevelClient.update(updateRequest, new Header[0]);
                if (response.getResult() == DocWriteResponse.Result.UPDATED) {
                    log.info("updateBehaviorRevoke successfully.");
                    continue;
                }
                if (response.getResult() != DocWriteResponse.Result.NOOP) continue;
                log.info("updateBehaviorRevoke No changes to the document.");
            }
            catch (IOException e) {
                log.error("update failed:{}", (Object)updateRequest, (Object)e);
            }
        }
    }

    private void updateNotificationId(QualityCheckLogEs checkLog) {
        log.info("update notification, id:{}", (Object)checkLog.getId());
        HashMap<String, Number> jsonMap = new HashMap<String, Number>();
        jsonMap.put("batchNotify", checkLog.getBatchNotify());
        jsonMap.put("notificationId", checkLog.getNotificationId());
        jsonMap.put("updateTime", System.currentTimeMillis());
        UpdateRequest updateRequest = new UpdateRequest(this.index, "doc", checkLog.getId()).doc(jsonMap);
        updateRequest.retryOnConflict(3);
        try {
            UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, new Header[0]);
            if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.info("update notification success id:{}", (Object)checkLog.getId());
            }
        }
        catch (IOException e) {
            log.error("update notification failed, id:{}", (Object)checkLog.getId(), (Object)e);
        }
    }

    private List<QualityCheckLogEs> queryBatchNotify() {
        SearchResponse searchResponse;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"batchNotify", (int)1));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("createTime", SortOrder.ASC);
        searchSourceBuilder.size(9999);
        searchSourceBuilder.from(0);
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        if (hits.getTotalHits() == 0L) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)((int)hits.getTotalHits()));
        for (SearchHit searchHit : hits.getHits()) {
            String sourceAsString = searchHit.getSourceAsString();
            QualityCheckLogEs chatMsg = (QualityCheckLogEs)JSON.parseObject((String)sourceAsString, QualityCheckLogEs.class);
            result.add(chatMsg);
        }
        return result;
    }

    private void updateBatchNotifyNo(Set<String> ids, String batchNotifyNo) {
        log.info("update batchNotifyNo:{}, ids:{}", (Object)batchNotifyNo, ids);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("batchNotify", 0);
        jsonMap.put("batchNotifyNo", batchNotifyNo);
        jsonMap.put("updateTime", System.currentTimeMillis());
        BulkRequest bulkRequest = new BulkRequest();
        for (String id : ids) {
            UpdateRequest updateRequest = new UpdateRequest(this.index, "doc", id).doc(jsonMap);
            updateRequest.retryOnConflict(3);
            bulkRequest.add(updateRequest);
        }
        try {
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
            log.info("bulk response:{}", (Object)bulkResponse.status());
        }
        catch (IOException e) {
            log.error("bulk update batchNotifyNo failed, bulkRequest:{}", (Object)bulkRequest, (Object)e);
        }
    }
}

