/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.chat.dto.TransferUserDto;
import com.kuaike.scrm.chat.service.DimissionChatService;
import com.kuaike.scrm.common.dto.ContactIdDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkContactIdMapper;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkUserIdMapper;
import com.kuaike.scrm.dal.chat.entity.WeworkConversation;
import com.kuaike.scrm.dal.chat.mapper.WeworkConversationMapper;
import com.kuaike.scrm.dal.transfer.entity.DimissionAllocateRecord;
import com.kuaike.scrm.dal.transfer.mapper.DimissionAllocateRecordMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DimissionChatServiceImpl
implements DimissionChatService {
    private static final Logger log = LoggerFactory.getLogger(DimissionChatServiceImpl.class);
    @Resource
    private DimissionAllocateRecordMapper dimissionAllocateRecordMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Resource
    private WeworkConversationMapper weworkConversationMapper;
    @Resource
    private AgentDecryptWeworkUserIdMapper agentDecryptWeworkUserIdMapper;
    @Resource
    private AgentDecryptWeworkContactIdMapper agentDecryptWeworkContactIdMapper;
    @Resource
    private WeworkCorpService weworkCorpService;

    @Override
    public List<TransferUserDto> getTransferUserList(ContactIdDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getContactId()), (Object)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String weworkUserNum = userInfo.getWeworkUserNum();
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return Lists.newArrayList();
        }
        DimissionAllocateRecord allocateRecord = this.dimissionAllocateRecordMapper.queryAllocateRecord(userInfo.getBizId(), params.getContactId(), weworkUserNum);
        if (allocateRecord == null || allocateRecord.getStatus() != 1) {
            return Lists.newArrayList();
        }
        WeworkContactRelation contactRelation = this.weworkContactRelationMapper.get(userInfo.getCorpId(), userInfo.getWeworkUserId(), params.getContactId());
        if (contactRelation == null || contactRelation.getIsDeleted() == 1) {
            return Lists.newArrayList();
        }
        List dimissionUserNums = this.dimissionAllocateRecordMapper.queryDimissionUserIds(userInfo.getBizId(), params.getContactId());
        if (CollectionUtils.isEmpty((Collection)dimissionUserNums)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        List weworkUserList = this.weworkUserMapper.queryInfoListByNums((Collection)dimissionUserNums);
        Integer userAgent = this.queryNewDKF(userInfo.getBizId());
        Map weworkUserIdMap = Maps.newHashMap();
        String agentContactId = null;
        Map<Object, Object> conversationMap = Maps.newHashMap();
        if (userAgent == 1) {
            List weworkUserIds = weworkUserList.stream().map(it -> it.getWeworkUserId()).collect(Collectors.toList());
            weworkUserIdMap = this.agentDecryptWeworkUserIdMapper.queryMapByEncryptUserIds(userInfo.getBizId(), weworkUserIds);
            agentContactId = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactId(userInfo.getBizId(), params.getContactId());
            String decryptCorpId = this.weworkCorpService.getDecryptCorpId(userInfo.getCorpId(), YnEnum.YES.getValue(), userInfo.getBizId());
            if (MapUtils.isNotEmpty((Map)weworkUserIdMap)) {
                List weworkConversations = this.weworkConversationMapper.queryConversionList(decryptCorpId, weworkUserIdMap.values());
                conversationMap = weworkConversations.stream().collect(Collectors.groupingBy(WeworkConversation::getWeworkUserId));
            }
        }
        for (WeworkUser weworkUser : weworkUserList) {
            TransferUserDto userDto = new TransferUserDto();
            userDto.setWeworkUserId(weworkUser.getNum());
            userDto.setAvatar(weworkUser.getAvatar());
            userDto.setName(weworkUser.getName());
            userDto.setIsDimission(1);
            String weworkUserId = null;
            String contactId = null;
            if (userAgent == 1) {
                weworkUserId = (String)weworkUserIdMap.get(weworkUser.getWeworkUserId());
                contactId = agentContactId;
            } else {
                weworkUserId = weworkUser.getWeworkUserId();
                contactId = params.getContactId();
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{weworkUserId, contactId})) continue;
            String conversationId = Lists.newArrayList((Object[])new String[]{weworkUserId, contactId}).stream().sorted().collect(Collectors.joining("$$"));
            userDto.setConversationId(conversationId);
            if (!MapUtils.isNotEmpty((Map)conversationMap) || !CollectionUtils.isNotEmpty((Collection)((Collection)conversationMap.get(weworkUserId)))) continue;
            result.add(userDto);
        }
        return result;
    }

    private Integer queryNewDKF(Long bizId) {
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        return Objects.equals(weworkCorp.getIsNewDkf(), 1) ? 1 : 0;
    }
}

