/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.chat.check.MatchedResult;
import com.kuaike.scrm.chat.check.MatchedWord;
import com.kuaike.scrm.chat.check.WordTree;
import com.kuaike.scrm.common.dto.CorpSensitiveWordBehaviorDto;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckBehaviorSetting;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckWordGroupMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckWordGroupNodeMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckWordsMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class CorpWordTree {
    private static final Logger log = LoggerFactory.getLogger(CorpWordTree.class);
    private static final Map<Long, WordTree> corpId2WordTree = Maps.newConcurrentMap();
    private static final Map<Long, CorpSensitiveWordBehaviorDto> corp2Dto = Maps.newConcurrentMap();
    @Autowired
    private QualityCheckWordsMapper wordsMapper;
    @Autowired
    private QualityCheckWordGroupMapper groupMapper;
    @Autowired
    private QualityCheckWordGroupNodeMapper nodeMapper;
    @Autowired
    private QualityCheckBehaviorSettingMapper behaviorSettingMapper;

    @PostConstruct
    public void init() {
        List words = this.wordsMapper.queryAll();
        List groups = this.groupMapper.queryAll();
        List nodes = this.nodeMapper.queryAll();
        List behaviorSettings = this.behaviorSettingMapper.queryAll();
        Map corpId2groupId2NodeIds = nodes.stream().collect(Collectors.groupingBy(a -> a.getBizId(), Collectors.groupingBy(a -> a.getGroupId(), Collectors.mapping(a -> a.getNodeId().intValue(), Collectors.toSet()))));
        Map<Long, Map<Long, String>> corpId2groupId2GroupName = groups.stream().collect(Collectors.groupingBy(a -> a.getBizId(), Collectors.toMap(a -> a.getId(), a -> a.getGroupName())));
        Map corpId2groupId2Words = words.stream().collect(Collectors.groupingBy(a -> a.getBizId(), Collectors.groupingBy(a -> a.getGroupId(), Collectors.mapping(a -> a.getWord(), Collectors.toSet()))));
        Map<Long, Map<Integer, Integer>> corpId2behaviorMap = behaviorSettings.stream().collect(Collectors.groupingBy(a -> a.getBizId(), Collectors.toMap(QualityCheckBehaviorSetting::getCheckValue, QualityCheckBehaviorSetting::getCheckStatus)));
        Collection bizIds = CollectionUtils.union(corpId2groupId2Words.keySet(), corpId2behaviorMap.keySet());
        bizIds = CollectionUtils.union(corpId2groupId2NodeIds.keySet(), (Iterable)bizIds);
        for (Long bizId : bizIds) {
            CorpSensitiveWordBehaviorDto dto = new CorpSensitiveWordBehaviorDto();
            Map groupId2NodeIds = corpId2groupId2NodeIds.getOrDefault(bizId, Maps.newHashMap());
            Map groupId2Words = corpId2groupId2Words.getOrDefault(bizId, Maps.newHashMap());
            Map<Integer, Integer> behaviorMap = corpId2behaviorMap.getOrDefault(bizId, Maps.newHashMap());
            Map<Long, String> groupId2name = corpId2groupId2GroupName.getOrDefault(bizId, Maps.newHashMap());
            groupId2name.forEach((groupId, groupName) -> {
                Set groupWords = groupId2Words.getOrDefault(groupId, Sets.newHashSet());
                groupWords.add(groupName);
                groupId2Words.put(groupId, groupWords);
            });
            dto.setBizId(bizId);
            dto.setGroupId2Words(groupId2Words);
            dto.setGroupId2NodeIds(groupId2NodeIds);
            dto.setDelByContactCheck(behaviorMap.getOrDefault(QualityBehaviorType.DEL_BY_CONTACT.getType(), 0).equals(1));
            dto.setSendCardCheck(behaviorMap.getOrDefault(QualityBehaviorType.CARD.getType(), 0).equals(1));
            dto.setDelContactCheck(behaviorMap.getOrDefault(QualityBehaviorType.DEL_CONTACT.getType(), 0).equals(1));
            dto.setSendHongbaoCheck(behaviorMap.getOrDefault(QualityBehaviorType.RED_PACKAGE.getType(), 0).equals(1));
            this.setCorpSensitiveDto(dto);
            this.initCorpWords(bizId, groupId2Words);
        }
        log.info("wordTree init load");
    }

    public synchronized void initCorpWords(Long bizId, Map<Long, Set<String>> groupId2SensitiveWord) {
        long startTime = System.currentTimeMillis();
        WordTree wordTree = new WordTree();
        groupId2SensitiveWord.forEach((groupId, words) -> wordTree.addWords((Collection<String>)words, (long)groupId));
        long wasteTime = System.currentTimeMillis() - startTime;
        corpId2WordTree.put(bizId, wordTree);
        log.debug("init wordTree bizId={},wasteTime {} ms", (Object)bizId, (Object)wasteTime);
    }

    public synchronized void setCorpSensitiveDto(CorpSensitiveWordBehaviorDto dto) {
        corp2Dto.put(dto.getBizId(), dto);
    }

    public Set<Integer> getNodeIdsByGroupId(Long bizId, Long groupId) {
        CorpSensitiveWordBehaviorDto dto = corp2Dto.get(bizId);
        if (dto != null) {
            return dto.getGroupId2NodeIds().getOrDefault(groupId, Sets.newHashSet());
        }
        return Sets.newHashSet();
    }

    public synchronized void setSensitiveBehavior(CorpSensitiveWordBehaviorDto dto) {
        CorpSensitiveWordBehaviorDto previous = corp2Dto.get(dto.getBizId());
        if (previous != null) {
            previous.setDelContactCheck(dto.isDelContactCheck());
            previous.setDelByContactCheck(dto.isDelByContactCheck());
            previous.setSendCardCheck(dto.isSendCardCheck());
            previous.setSendHongbaoCheck(dto.isSendHongbaoCheck());
            return;
        }
        corp2Dto.put(dto.getBizId(), dto);
    }

    public MatchedResult matchSensitiveWord(Long bizId, String str) {
        if (bizId == null) {
            return null;
        }
        WordTree wordTree = corpId2WordTree.get(bizId);
        if (Objects.isNull(wordTree) || wordTree.isEmpty()) {
            return null;
        }
        List<MatchedWord> sensitiveWords = wordTree.getMatchedWords(str);
        if (CollectionUtils.isEmpty(sensitiveWords)) {
            return null;
        }
        return new MatchedResult(bizId, sensitiveWords);
    }

    public CorpSensitiveWordBehaviorDto getBehaviorDto(Long bizId) {
        return corp2Dto.get(bizId);
    }

    @PreDestroy
    public synchronized void destroy() {
        corpId2WordTree.clear();
        corp2Dto.clear();
    }
}

