/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.chatgpt.service.impl;

import cn.kinyun.scrm.chatgpt.dto.req.ChatGptTextReq;
import cn.kinyun.scrm.chatgpt.dto.resp.ChatGptTextResp;
import cn.kinyun.scrm.chatgpt.dto.resp.RespDto;
import cn.kinyun.scrm.chatgpt.service.ChatGptService;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ChatGptServiceImpl
implements ChatGptService {
    private static final Logger log = LoggerFactory.getLogger(ChatGptServiceImpl.class);
    @Value(value="${chatgpt.url.domain:http://chat.ai.baijiayun.com}")
    private String domain;
    @Value(value="${chatgpt.url.chat.text:/chat/text}")
    private String chatUrl;
    @Value(value="${chatgpt.maxTokens:1024}")
    private Integer maxTokens;
    @Value(value="${chatgpt.model:text-davinci-003}")
    private String defaultModel;
    @Value(value="${chatgpt.temperature:0.7}")
    private Double temperature;
    @Value(value="${chatgpt.frequencyPenalty:0}")
    private Integer frequencyPenalty;
    @Value(value="${chatgpt.presencePenalty:0}")
    private Integer presencePenalty;
    @Value(value="${chatgpt.stream: false}")
    private Boolean stream;
    @Value(value="${chatgpt.topP: 0.95}")
    private Double topP;
    @Value(value="${chatgpt.role:user}")
    private String role;
    @Value(value="${chatgpt.errorMsg:\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002}")
    private String errorMsg;
    private static final int TIMEOUT = 120000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ChatGptTextResp text(ChatGptTextReq params) {
        RespDto resp;
        block8: {
            log.info("ask ChatGPT, params={}", (Object)params);
            JSONObject message = new JSONObject();
            message.put("content", (Object)params.getText());
            message.put("role", (Object)this.role);
            ArrayList messages = Lists.newArrayList();
            messages.add(message);
            JSONObject pairs = new JSONObject();
            pairs.put("maxTokens", (Object)this.maxTokens);
            pairs.put("messages", (Object)messages);
            pairs.put("temperature", (Object)this.temperature);
            pairs.put("frequencyPenalty", (Object)this.frequencyPenalty);
            pairs.put("presencePenalty", (Object)this.presencePenalty);
            pairs.put("stream", (Object)this.stream);
            pairs.put("topP", (Object)this.topP);
            pairs.put("stop", (Object)"");
            resp = new RespDto();
            CloseableHttpClient httpClient = null;
            try {
                HttpPost httpPost = new HttpPost(this.domain + this.chatUrl);
                StringEntity requestEntity = new StringEntity(JSON.toJSONString((Object)pairs), StandardCharsets.UTF_8);
                httpPost.setEntity((HttpEntity)requestEntity);
                RequestConfig config = RequestConfig.custom().setConnectTimeout(120000).setConnectionRequestTimeout(120000).setSocketTimeout(120000).build();
                httpPost.setConfig(config);
                httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
                httpClient = HttpClientBuilder.create().build();
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                String result = null;
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    httpPost.abort();
                    log.info("HttpClient, error status code:{}", (Object)statusCode);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, this.errorMsg);
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                }
                EntityUtils.consume((HttpEntity)entity);
                response.close();
                String fixDataPattern = "^data:";
                result = result.replaceAll(fixDataPattern, "");
                log.info("ChatGPT result:{}", (Object)result);
                resp.setCode(200);
                resp.setData(result);
                if (httpClient == null) break block8;
            }
            catch (Exception e) {
                try {
                    log.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, this.errorMsg);
                }
                catch (Throwable throwable) {
                    if (httpClient == null) throw throwable;
                    HttpClientUtils.closeQuietly(httpClient);
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        if (!resp.success()) throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, resp.getMessage());
        try {
            ChatGptTextResp textResult = (ChatGptTextResp)JacksonUtil.str2Obj((String)resp.getData(), ChatGptTextResp.class);
            if (!CollectionUtils.isNotEmpty(textResult.getChoices())) return textResult;
            textResult.getChoices().forEach(choice -> {
                if (StringUtils.isBlank((CharSequence)choice.getText())) {
                    choice.setText(choice.getMessage().getContent());
                }
            });
            return textResult;
        }
        catch (IOException e) {
            log.error("\u6d88\u606f\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, this.errorMsg);
        }
    }
}

