/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.CallConfig;
import com.kuaike.scrm.call.dto.CallExtenInfo;
import com.kuaike.scrm.call.enums.ApiTypeEnum;
import com.kuaike.scrm.common.service.AppInstallService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.call.entity.CallAccount;
import com.kuaike.scrm.dal.call.entity.CallAccountSeat;
import com.kuaike.scrm.dal.call.entity.CallAccountSeatCriteria;
import com.kuaike.scrm.dal.call.entity.CallAccountUsing;
import com.kuaike.scrm.dal.call.entity.CallMember;
import com.kuaike.scrm.dal.call.entity.CallMemberCriteria;
import com.kuaike.scrm.dal.call.mapper.CallAccountMapper;
import com.kuaike.scrm.dal.call.mapper.CallAccountSeatMapper;
import com.kuaike.scrm.dal.call.mapper.CallAccountUsingMapper;
import com.kuaike.scrm.dal.call.mapper.CallMemberMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CallConfigServiceImpl
implements AppInstallService {
    private static final Logger log = LoggerFactory.getLogger(CallConfigServiceImpl.class);
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Value(value="${app.call.openUrl}")
    private String openUrl;
    @Value(value="${app.call.closeUrl}")
    private String closeUrl;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Resource
    private AppBindingsMapper bindingsMapper;
    @Resource
    private CallAccountUsingMapper callAccountUsingMapper;
    @Resource
    private CallAccountMapper callAccountMapper;
    @Resource
    private CallAccountSeatMapper callAccountSeatMapper;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CallMemberMapper callMemberMapper;

    public String getAppCode() {
        return this.appCode;
    }

    @Transactional
    public void install(AppBindings bindings) {
        log.info("install call bindings:{}", (Object)bindings);
        CallConfig callConfig = null;
        try {
            if (0 == bindings.getIsOpen()) {
                return;
            }
            log.info("CallConfig getConfigJson: {}", (Object)bindings.getConfigJson());
            callConfig = (CallConfig)JacksonUtil.str2Obj((String)bindings.getConfigJson(), CallConfig.class);
        }
        catch (IOException e) {
            log.error("configJson  str2Obj error", (Throwable)e);
        }
        if (ObjectUtils.isEmpty(callConfig)) {
            callConfig = new CallConfig();
        }
        log.info("install call callConfig:{}", (Object)callConfig);
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bindings.getBizId());
        Preconditions.checkArgument((businessCustomer != null ? 1 : 0) != 0, (Object)"\u5546\u6237\u4e0d\u5b58\u5728");
        String wayType = callConfig.getWayType();
        Integer openSeatCount = callConfig.getCallFeeInfo() == null || callConfig.getCallFeeInfo().getCallExtenInfo() == null ? 0 : callConfig.getCallFeeInfo().getCallExtenInfo().getExtenCount();
        Integer doubleOpenSeatCount = callConfig.getDoubleCallFeeInfo() == null || callConfig.getDoubleCallFeeInfo().getCallExtenInfo() == null ? 0 : callConfig.getDoubleCallFeeInfo().getCallExtenInfo().getExtenCount();
        if (StringUtils.isNotBlank((CharSequence)callConfig.getCallAccountNum()) && wayType.contains(ApiTypeEnum.SIP.getName()) && StringUtils.isNotBlank((CharSequence)callConfig.getDoubleCallAccountNum()) && wayType.contains(ApiTypeEnum.LOCAL.getName())) {
            Preconditions.checkArgument((openSeatCount.intValue() == doubleOpenSeatCount.intValue() ? 1 : 0) != 0, (Object)"\u7f51\u7edc\u7535\u8bdd\u5750\u5e2d\u6570\u91cf\u4e0e\u53cc\u547c\u56de\u663e\u5750\u5e2d\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        this.insertUsing(businessCustomer, callConfig.getCallAccountNum(), ApiTypeEnum.SIP.getValue(), callConfig.getCallFeeInfo() == null ? null : callConfig.getCallFeeInfo().getCallExtenInfo(), wayType);
        this.insertUsing(businessCustomer, callConfig.getDoubleCallAccountNum(), ApiTypeEnum.LOCAL.getValue(), callConfig.getDoubleCallFeeInfo() == null ? null : callConfig.getDoubleCallFeeInfo().getCallExtenInfo(), wayType);
        this.insertUsing(businessCustomer, callConfig.getWebCallAccountNum(), ApiTypeEnum.VOICE.getValue(), null, wayType);
        bindings.setUpdateBy(Long.valueOf(-1L));
        bindings.setUpdateTime(new Date());
        bindings.setConfigJson(bindings.getConfigJson());
        Map<String, String> params = this.getConfigParams(callConfig);
        try {
            this.bjyPartnerService.bjyPost(bindings.getBizId(), this.openUrl, params);
            this.bindingsMapper.updateByPrimaryKeySelective((Object)bindings);
        }
        catch (BusinessException e) {
            log.error("change call config error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("open call error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5916\u547c\u5f00\u901a\u5f02\u5e38");
        }
    }

    public void insertUsing(BusinessCustomer businessCustomer, String num, Integer wayType, CallExtenInfo callExtenInfo, String openWayType) {
        Long bizId = businessCustomer.getId();
        String name = businessCustomer.getName();
        log.info("insertUsing callExtenInfo: {}, num: {}", (Object)JSON.toJSONString((Object)callExtenInfo), (Object)num);
        if (StringUtils.isNotBlank((CharSequence)num) && openWayType.contains(ApiTypeEnum.get(wayType).getName())) {
            List usingExtens;
            List callMembers;
            CallMemberCriteria userCriteria;
            Integer openSeatCount = callExtenInfo == null ? 0 : callExtenInfo.getExtenCount();
            ArrayList seats = callExtenInfo == null ? Collections.emptyList() : Lists.newArrayList(callExtenInfo.getExtens());
            CallAccount callAccount = (CallAccount)this.callAccountMapper.selectOne((Object)CallAccount.builder().num(num).build());
            Preconditions.checkArgument((callAccount != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u4e0d\u5b58\u5728");
            CallAccountUsing existUsing = (CallAccountUsing)this.callAccountUsingMapper.selectOne((Object)CallAccountUsing.builder().bizId(bizId).wayType(wayType).build());
            if (existUsing == null || !existUsing.getCallAccountId().equals(callAccount.getId())) {
                this.callAccountUsingMapper.delete((Object)CallAccountUsing.builder().bizId(bizId).wayType(wayType).build());
                CallAccountUsing callAccountUsing = CallAccountUsing.builder().bizId(bizId).num(this.idGen.getNum()).bizName(name).callAccountId(callAccount.getId()).wayType(wayType).openSeatCount(openSeatCount).createBy("-1").updateBy("-1").createTime(new Date()).updateTime(new Date()).build();
                this.callAccountUsingMapper.insertSelective((Object)callAccountUsing);
            } else {
                existUsing.setUpdateTime(new Date());
                existUsing.setOpenSeatCount(openSeatCount);
                this.callAccountUsingMapper.updateByPrimaryKeySelective((Object)existUsing);
            }
            if (wayType.intValue() == ApiTypeEnum.SIP.getValue()) {
                userCriteria = new CallMemberCriteria();
                userCriteria.createCriteria().andBizIdEqualTo(bizId).andExtenNotEqualTo("");
                callMembers = this.callMemberMapper.selectByExample((Object)userCriteria);
                usingExtens = callMembers.stream().filter(callMember -> StringUtils.isNotBlank((CharSequence)callMember.getExten())).map(CallMember::getExten).collect(Collectors.toList());
            } else if (wayType.intValue() == ApiTypeEnum.LOCAL.getValue()) {
                userCriteria = new CallMemberCriteria();
                userCriteria.createCriteria().andBizIdEqualTo(bizId).andDoubleCallExtenNotEqualTo("");
                callMembers = this.callMemberMapper.selectByExample((Object)userCriteria);
                usingExtens = callMembers.stream().filter(callMember -> StringUtils.isNotBlank((CharSequence)callMember.getDoubleCallExten())).map(CallMember::getDoubleCallExten).collect(Collectors.toList());
            } else {
                return;
            }
            if (!(CollectionUtils.isEmpty((Collection)seats) || CollectionUtils.isEmpty(usingExtens) || seats.containsAll(usingExtens))) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, usingExtens + "\u5916\u547c\u5750\u5e2d\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u53d6\u6d88");
            }
            List occupy = this.callAccountSeatMapper.select((Object)CallAccountSeat.builder().callAccountId(callAccount.getId()).occupyBizId(bizId).build());
            List occupySeats = occupy.stream().map(CallAccountSeat::getSeat).collect(Collectors.toList());
            ArrayList addList = Lists.newArrayList((Iterable)seats);
            addList.removeAll(occupySeats);
            if (!CollectionUtils.isEmpty((Collection)addList)) {
                CallAccountSeat callAccountSeat = new CallAccountSeat();
                callAccountSeat.setUpdateBy("-1");
                callAccountSeat.setUpdateTime(new Date());
                callAccountSeat.setOccupyBizId(bizId);
                callAccountSeat.setOccupyBizName(name);
                CallAccountSeatCriteria criteria = new CallAccountSeatCriteria();
                criteria.createCriteria().andCallAccountIdEqualTo(callAccount.getId()).andSeatIn((List)addList);
                this.callAccountSeatMapper.updateByExampleSelective((Object)callAccountSeat, (Object)criteria);
            }
            ArrayList removeList = Lists.newArrayList(occupySeats);
            log.info("insertUsing removeList:{}", (Object)removeList);
            removeList.removeAll(seats);
            log.info("insertUsing removeList:{}", (Object)removeList);
            if (!CollectionUtils.isEmpty((Collection)removeList)) {
                CallAccountSeat callAccountSeat = new CallAccountSeat();
                callAccountSeat.setUpdateBy("-1");
                callAccountSeat.setUpdateTime(new Date());
                callAccountSeat.setCallAccountId(callAccount.getId());
                callAccountSeat.setOccupyBizName("");
                callAccountSeat.setSeats((List)removeList);
                this.callAccountSeatMapper.updateOccupy(callAccountSeat);
            }
        } else {
            this.callAccountUsingMapper.delete((Object)CallAccountUsing.builder().bizId(bizId).wayType(wayType).build());
            CallAccountSeat callAccountSeat = new CallAccountSeat();
            callAccountSeat.setUpdateBy("-1");
            callAccountSeat.setUpdateTime(new Date());
            callAccountSeat.setOccupyBizId(bizId);
            callAccountSeat.setOccupyBizName("");
            callAccountSeat.setWayType(wayType);
            this.callAccountSeatMapper.updateSeat(callAccountSeat);
        }
    }

    @Transactional
    public void update(AppBindings bindings) {
        log.info("update call config bindings:{}", (Object)bindings);
        CallConfig callConfig = null;
        if (0 == bindings.getIsOpen()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)bindings.getConfigJson())) {
            return;
        }
        try {
            callConfig = (CallConfig)JacksonUtil.str2Obj((String)bindings.getConfigJson(), CallConfig.class);
        }
        catch (IOException e) {
            log.error("configJson str2Obj error", (Throwable)e);
        }
        if (ObjectUtils.isEmpty((Object)callConfig)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5916\u547c\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)callConfig.getSupplierType())) {
            callConfig.setSupplierType(0);
        }
        if (ObjectUtils.isEmpty((Object)callConfig.getCallbackHost())) {
            callConfig.setCallbackHost("");
        }
        if (ObjectUtils.isEmpty((Object)callConfig.getCallLine())) {
            callConfig.setCallLine("");
        }
        if (ObjectUtils.isEmpty((Object)callConfig.getWayType())) {
            callConfig.setWayType("");
        }
        log.info("update call config callConfig:{}", (Object)callConfig);
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bindings.getBizId());
        Preconditions.checkArgument((businessCustomer != null ? 1 : 0) != 0, (Object)"\u5546\u6237\u4e0d\u5b58\u5728");
        String wayType = callConfig.getWayType();
        Integer doubleOpenSeatCount = callConfig.getDoubleCallFeeInfo() == null || callConfig.getDoubleCallFeeInfo().getCallExtenInfo() == null ? 0 : callConfig.getDoubleCallFeeInfo().getCallExtenInfo().getExtenCount();
        Integer openSeatCount = callConfig.getCallFeeInfo() == null || callConfig.getCallFeeInfo().getCallExtenInfo() == null ? 0 : callConfig.getCallFeeInfo().getCallExtenInfo().getExtenCount();
        if (StringUtils.isNotBlank((CharSequence)callConfig.getCallAccountNum()) && wayType.contains(ApiTypeEnum.SIP.getName()) && StringUtils.isNotBlank((CharSequence)callConfig.getDoubleCallAccountNum()) && wayType.contains(ApiTypeEnum.LOCAL.getName())) {
            Preconditions.checkArgument((openSeatCount.intValue() == doubleOpenSeatCount.intValue() ? 1 : 0) != 0, (Object)"\u7f51\u7edc\u7535\u8bdd\u5750\u5e2d\u6570\u91cf\u4e0e\u53cc\u547c\u56de\u663e\u5750\u5e2d\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        this.insertUsing(businessCustomer, callConfig.getCallAccountNum(), ApiTypeEnum.SIP.getValue(), callConfig.getCallFeeInfo() == null ? null : callConfig.getCallFeeInfo().getCallExtenInfo(), wayType);
        this.insertUsing(businessCustomer, callConfig.getDoubleCallAccountNum(), ApiTypeEnum.LOCAL.getValue(), callConfig.getDoubleCallFeeInfo() == null ? null : callConfig.getDoubleCallFeeInfo().getCallExtenInfo(), wayType);
        this.insertUsing(businessCustomer, callConfig.getWebCallAccountNum(), ApiTypeEnum.VOICE.getValue(), null, wayType);
        bindings.setUpdateBy(Long.valueOf(-1L));
        bindings.setUpdateTime(new Date());
        bindings.setConfigJson(bindings.getConfigJson());
        this.bindingsMapper.updateByPrimaryKeySelective((Object)bindings);
        Map<String, String> params = this.getConfigParams(callConfig);
        try {
            this.bjyPartnerService.bjyPost(bindings.getBizId(), this.openUrl, params);
        }
        catch (BusinessException e) {
            log.error("change call config error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("change call config error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5916\u547c\u4fee\u6539\u4ef7\u683c\u5f02\u5e38");
        }
    }

    public void uninstall(AppBindings bindings) {
        try {
            BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bindings.getBizId());
            Preconditions.checkArgument((businessCustomer != null ? 1 : 0) != 0, (Object)"\u5546\u6237\u4e0d\u5b58\u5728");
            this.insertUsing(businessCustomer, "", ApiTypeEnum.SIP.getValue(), null, "");
            this.insertUsing(businessCustomer, "", ApiTypeEnum.LOCAL.getValue(), null, "");
            this.insertUsing(businessCustomer, "", ApiTypeEnum.VOICE.getValue(), null, "");
            this.bjyPartnerService.bjyPost(bindings.getBizId(), this.closeUrl, new HashMap());
        }
        catch (Exception e) {
            log.error("close call error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5916\u547c\u5173\u95ed\u5f02\u5e38");
        }
    }

    private Map<String, String> getConfigParams(CallConfig callConfig) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("supplier_type", String.valueOf(callConfig.getSupplierType()));
        result.put("callback_host", callConfig.getCallbackHost());
        result.put("call_line", callConfig.getCallLine());
        if (!ObjectUtils.isEmpty((Object)callConfig.getAccountInfo())) {
            result.put("account_info", JacksonUtil.obj2Str((Object)callConfig.getAccountInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getWebCallAccountInfo())) {
            result.put("account_webcall_info", JacksonUtil.obj2Str((Object)callConfig.getWebCallAccountInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getDoubleCallAccountInfo())) {
            result.put("account_double_call_info", JacksonUtil.obj2Str((Object)callConfig.getDoubleCallAccountInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getWebCallFeeInfo())) {
            result.put("webcall_fee_info", JacksonUtil.obj2Str((Object)callConfig.getWebCallFeeInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getCallFeeInfo())) {
            result.put("call_fee_info", JacksonUtil.obj2Str((Object)callConfig.getCallFeeInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getDoubleCallFeeInfo())) {
            result.put("double_call_fee_info", JacksonUtil.obj2Str((Object)callConfig.getDoubleCallFeeInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getValidDate())) {
            result.put("exten_fee_valid_date", callConfig.getValidDate());
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getCallFeeInfoZtth())) {
            result.put("call_fee_info_ztth", JacksonUtil.obj2Str((Object)callConfig.getCallFeeInfoZtth()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getAccountInfoZtth())) {
            result.put("account_info_ztth", JacksonUtil.obj2Str((Object)callConfig.getAccountInfoZtth()));
        }
        result.put("way_type", callConfig.getWayType());
        return result;
    }
}

