/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public abstract class CallCommonService {
    public UserRoleCommonService userRoleCommonService;
    public ScrmUserService scrmUserService;
    public NodeService nodeService;

    public Collection<Long> getManageUserIds(Long bizId, String nodeId, String userId) {
        Set<Long> userIds = Sets.newHashSet();
        if (StringUtils.isEmpty((CharSequence)nodeId) && StringUtils.isEmpty((CharSequence)userId)) {
            userIds = this.userRoleCommonService.getManageUserIds();
            userIds.add(-1L);
        }
        if (!StringUtils.isEmpty((CharSequence)nodeId)) {
            Long nodeIdDb = this.nodeService.getIdByNum(bizId, nodeId);
            Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
            if (!manageNodeIds.contains(nodeIdDb)) {
                return Collections.emptyList();
            }
            manageNodeIds = this.nodeService.getPosterityIds(nodeIdDb, bizId);
            userIds = this.scrmUserService.queryIdsByNodeIds((Collection)manageNodeIds);
        }
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            Long userIdDb = this.scrmUserService.getIdByNum(userId);
            Set manageUserIds = this.userRoleCommonService.getManageUserIds();
            if (!manageUserIds.contains(userIdDb)) {
                return Collections.emptyList();
            }
            userIds.add(userIdDb);
        }
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Collections.emptyList();
        }
        return userIds;
    }

    public Map<Long, String> nodePName(Long bizId, List<Long> nodeIds) {
        HashMap nodeNameMap = Maps.newHashMap();
        Map nodeMap = this.nodeService.getNodeMap(bizId);
        for (Long nodeId : nodeIds) {
            if (nodeNameMap.containsKey(nodeId) || !nodeMap.containsKey(nodeId)) continue;
            ArrayList nodeName = Lists.newArrayList();
            Long curId = nodeId;
            Node node = (Node)nodeMap.get(curId);
            nodeName.add(node.getName());
            while (node.getPid() != null && node.getPid() != 0L) {
                curId = node.getPid();
                nodeName.add((node = (Node)nodeMap.get(curId)) == null ? "" : node.getName());
                if (nodeName.size() < 3) continue;
            }
            Collections.reverse(nodeName);
            String orgName = StringUtils.join((Object[])nodeName.toArray(), (String)"/");
            nodeNameMap.put(nodeId, orgName);
        }
        return nodeNameMap;
    }
}

