/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.dto.resp;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.kuaike.scrm.call.enums.StatusEnum;
import com.kuaike.scrm.call.enums.VoiceCallStatusEnum;
import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.enums.EnumDto;
import com.kuaike.scrm.common.enums.EnumService;
import com.kuaike.scrm.common.service.dto.ScrmLeadsDto;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.call.entity.CallTask;
import com.kuaike.scrm.dal.call.entity.CallTaskDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CallTaskRespDto
extends ScrmLeadsDto
implements Serializable {
    private Long callTaskId;
    private Long callTaskDetailId;
    private String customerName;
    private String customerPhone;
    private Integer callCount;
    private String userName;
    private String createName;
    private Date createTime;
    private Date planCompleteTime;
    private Double progress;
    private String taskName;
    private Integer customerCount;
    private Integer callSuccessCount;
    private Integer callDuration;
    private Integer type;
    private EnumDto voiceTaskStatus;
    private String voiceTaskStatusStr;
    private String voiceContent;
    private Integer calledCount;
    private EnumDto lastCallStatus;
    private Date lastCallTime;
    private String source;
    private Long userId;
    private Integer calledSuccessCount;
    private Integer isLimit;
    private List<String> userNums;
    private Integer allocMode;
    private List<Integer> allocRatio;

    public static CallTaskRespDto from(CallTaskDetail taskDetail, boolean mobileEncrypt, Integer type) {
        String customerPhone = taskDetail.getPhone();
        VoiceCallStatusEnum voiceCallStatusEnum = VoiceCallStatusEnum.get(taskDetail.getVoiceTaskStatus());
        StatusEnum statusEnum = StatusEnum.get(taskDetail.getLastCallStatus());
        CallTaskRespDto build = CallTaskRespDto.builder().callTaskDetailId(taskDetail.getId()).customerName(taskDetail.getName()).customerPhone(mobileEncrypt ? MobileUtils.encryptMobile((String)customerPhone) : customerPhone).userName(taskDetail.getUserName()).callCount(taskDetail.getCallCount()).customerCount(taskDetail.getCustomerCount()).callSuccessCount(taskDetail.getCallSuccessCount()).calledCount(taskDetail.getCalledCount()).calledSuccessCount(taskDetail.getCalledSuccessCount()).lastCallStatus(EnumDto.from((EnumService)statusEnum)).voiceTaskStatus(EnumDto.from((EnumService)voiceCallStatusEnum)).voiceTaskStatusStr(Objects.isNull((Object)statusEnum) ? null : statusEnum.getDesc()).lastCallTime(taskDetail.getLastCallTime()).createTime(taskDetail.getCreateTime()).userId(taskDetail.getUserId()).type(type).callDuration(taskDetail.getCallDuration()).build();
        if (StringUtils.isBlank((CharSequence)taskDetail.getApiCallId()) && type != null && type.intValue() == CallTypeEnum.VOICE.getValue()) {
            build.setLastCallStatus(null);
            build.setLastCallTime(null);
            build.setCallDuration(null);
        }
        return build;
    }

    public static CallTaskRespDto from(CallTask task) {
        ArrayList allocRatio = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)task.getAllocRatio())) {
            List tmps = Splitter.on((String)",").splitToList((CharSequence)task.getAllocRatio());
            for (String tmp : tmps) {
                allocRatio.add(Integer.valueOf(tmp));
            }
        }
        CallTaskRespDto callTaskRespDto = CallTaskRespDto.builder().callTaskId(task.getId()).taskName(task.getName()).progress(task.getProgress()).userName(task.getUser()).createTime(task.getCreateTime()).planCompleteTime(task.getPlanCompleteTime()).source(task.getSource()).type(task.getType()).voiceContent(task.getVoiceContent()).allocMode(task.getAllocMode()).userNums(null).allocRatio(allocRatio).build();
        if (task.getCreateBy() > -1L) {
            callTaskRespDto.setCreateName(task.getCreateName());
        }
        return callTaskRespDto;
    }

    public CallTaskRespDto() {
    }

    CallTaskRespDto(Long callTaskId, Long callTaskDetailId, String customerName, String customerPhone, Integer callCount, String userName, String createName, Date createTime, Date planCompleteTime, Double progress, String taskName, Integer customerCount, Integer callSuccessCount, Integer callDuration, Integer type, EnumDto voiceTaskStatus, String voiceTaskStatusStr, String voiceContent, Integer calledCount, EnumDto lastCallStatus, Date lastCallTime, String source, Long userId, Integer calledSuccessCount, Integer isLimit, List<String> userNums, Integer allocMode, List<Integer> allocRatio) {
        this.callTaskId = callTaskId;
        this.callTaskDetailId = callTaskDetailId;
        this.customerName = customerName;
        this.customerPhone = customerPhone;
        this.callCount = callCount;
        this.userName = userName;
        this.createName = createName;
        this.createTime = createTime;
        this.planCompleteTime = planCompleteTime;
        this.progress = progress;
        this.taskName = taskName;
        this.customerCount = customerCount;
        this.callSuccessCount = callSuccessCount;
        this.callDuration = callDuration;
        this.type = type;
        this.voiceTaskStatus = voiceTaskStatus;
        this.voiceTaskStatusStr = voiceTaskStatusStr;
        this.voiceContent = voiceContent;
        this.calledCount = calledCount;
        this.lastCallStatus = lastCallStatus;
        this.lastCallTime = lastCallTime;
        this.source = source;
        this.userId = userId;
        this.calledSuccessCount = calledSuccessCount;
        this.isLimit = isLimit;
        this.userNums = userNums;
        this.allocMode = allocMode;
        this.allocRatio = allocRatio;
    }

    public static CallTaskRespDtoBuilder builder() {
        return new CallTaskRespDtoBuilder();
    }

    public Long getCallTaskId() {
        return this.callTaskId;
    }

    public Long getCallTaskDetailId() {
        return this.callTaskDetailId;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getCustomerPhone() {
        return this.customerPhone;
    }

    public Integer getCallCount() {
        return this.callCount;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getCreateName() {
        return this.createName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getPlanCompleteTime() {
        return this.planCompleteTime;
    }

    public Double getProgress() {
        return this.progress;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Integer getCustomerCount() {
        return this.customerCount;
    }

    public Integer getCallSuccessCount() {
        return this.callSuccessCount;
    }

    public Integer getCallDuration() {
        return this.callDuration;
    }

    public Integer getType() {
        return this.type;
    }

    public EnumDto getVoiceTaskStatus() {
        return this.voiceTaskStatus;
    }

    public String getVoiceTaskStatusStr() {
        return this.voiceTaskStatusStr;
    }

    public String getVoiceContent() {
        return this.voiceContent;
    }

    public Integer getCalledCount() {
        return this.calledCount;
    }

    public EnumDto getLastCallStatus() {
        return this.lastCallStatus;
    }

    public Date getLastCallTime() {
        return this.lastCallTime;
    }

    public String getSource() {
        return this.source;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Integer getCalledSuccessCount() {
        return this.calledSuccessCount;
    }

    public Integer getIsLimit() {
        return this.isLimit;
    }

    public List<String> getUserNums() {
        return this.userNums;
    }

    public Integer getAllocMode() {
        return this.allocMode;
    }

    public List<Integer> getAllocRatio() {
        return this.allocRatio;
    }

    public void setCallTaskId(Long callTaskId) {
        this.callTaskId = callTaskId;
    }

    public void setCallTaskDetailId(Long callTaskDetailId) {
        this.callTaskDetailId = callTaskDetailId;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public void setCallCount(Integer callCount) {
        this.callCount = callCount;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setPlanCompleteTime(Date planCompleteTime) {
        this.planCompleteTime = planCompleteTime;
    }

    public void setProgress(Double progress) {
        this.progress = progress;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setCustomerCount(Integer customerCount) {
        this.customerCount = customerCount;
    }

    public void setCallSuccessCount(Integer callSuccessCount) {
        this.callSuccessCount = callSuccessCount;
    }

    public void setCallDuration(Integer callDuration) {
        this.callDuration = callDuration;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setVoiceTaskStatus(EnumDto voiceTaskStatus) {
        this.voiceTaskStatus = voiceTaskStatus;
    }

    public void setVoiceTaskStatusStr(String voiceTaskStatusStr) {
        this.voiceTaskStatusStr = voiceTaskStatusStr;
    }

    public void setVoiceContent(String voiceContent) {
        this.voiceContent = voiceContent;
    }

    public void setCalledCount(Integer calledCount) {
        this.calledCount = calledCount;
    }

    public void setLastCallStatus(EnumDto lastCallStatus) {
        this.lastCallStatus = lastCallStatus;
    }

    public void setLastCallTime(Date lastCallTime) {
        this.lastCallTime = lastCallTime;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setCalledSuccessCount(Integer calledSuccessCount) {
        this.calledSuccessCount = calledSuccessCount;
    }

    public void setIsLimit(Integer isLimit) {
        this.isLimit = isLimit;
    }

    public void setUserNums(List<String> userNums) {
        this.userNums = userNums;
    }

    public void setAllocMode(Integer allocMode) {
        this.allocMode = allocMode;
    }

    public void setAllocRatio(List<Integer> allocRatio) {
        this.allocRatio = allocRatio;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallTaskRespDto)) {
            return false;
        }
        CallTaskRespDto other = (CallTaskRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$callTaskId = this.getCallTaskId();
        Long other$callTaskId = other.getCallTaskId();
        if (this$callTaskId == null ? other$callTaskId != null : !((Object)this$callTaskId).equals(other$callTaskId)) {
            return false;
        }
        Long this$callTaskDetailId = this.getCallTaskDetailId();
        Long other$callTaskDetailId = other.getCallTaskDetailId();
        if (this$callTaskDetailId == null ? other$callTaskDetailId != null : !((Object)this$callTaskDetailId).equals(other$callTaskDetailId)) {
            return false;
        }
        Integer this$callCount = this.getCallCount();
        Integer other$callCount = other.getCallCount();
        if (this$callCount == null ? other$callCount != null : !((Object)this$callCount).equals(other$callCount)) {
            return false;
        }
        Double this$progress = this.getProgress();
        Double other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        Integer this$customerCount = this.getCustomerCount();
        Integer other$customerCount = other.getCustomerCount();
        if (this$customerCount == null ? other$customerCount != null : !((Object)this$customerCount).equals(other$customerCount)) {
            return false;
        }
        Integer this$callSuccessCount = this.getCallSuccessCount();
        Integer other$callSuccessCount = other.getCallSuccessCount();
        if (this$callSuccessCount == null ? other$callSuccessCount != null : !((Object)this$callSuccessCount).equals(other$callSuccessCount)) {
            return false;
        }
        Integer this$callDuration = this.getCallDuration();
        Integer other$callDuration = other.getCallDuration();
        if (this$callDuration == null ? other$callDuration != null : !((Object)this$callDuration).equals(other$callDuration)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$calledCount = this.getCalledCount();
        Integer other$calledCount = other.getCalledCount();
        if (this$calledCount == null ? other$calledCount != null : !((Object)this$calledCount).equals(other$calledCount)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$calledSuccessCount = this.getCalledSuccessCount();
        Integer other$calledSuccessCount = other.getCalledSuccessCount();
        if (this$calledSuccessCount == null ? other$calledSuccessCount != null : !((Object)this$calledSuccessCount).equals(other$calledSuccessCount)) {
            return false;
        }
        Integer this$isLimit = this.getIsLimit();
        Integer other$isLimit = other.getIsLimit();
        if (this$isLimit == null ? other$isLimit != null : !((Object)this$isLimit).equals(other$isLimit)) {
            return false;
        }
        Integer this$allocMode = this.getAllocMode();
        Integer other$allocMode = other.getAllocMode();
        if (this$allocMode == null ? other$allocMode != null : !((Object)this$allocMode).equals(other$allocMode)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        String this$customerPhone = this.getCustomerPhone();
        String other$customerPhone = other.getCustomerPhone();
        if (this$customerPhone == null ? other$customerPhone != null : !this$customerPhone.equals(other$customerPhone)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$createName = this.getCreateName();
        String other$createName = other.getCreateName();
        if (this$createName == null ? other$createName != null : !this$createName.equals(other$createName)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$planCompleteTime = this.getPlanCompleteTime();
        Date other$planCompleteTime = other.getPlanCompleteTime();
        if (this$planCompleteTime == null ? other$planCompleteTime != null : !((Object)this$planCompleteTime).equals(other$planCompleteTime)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        EnumDto this$voiceTaskStatus = this.getVoiceTaskStatus();
        EnumDto other$voiceTaskStatus = other.getVoiceTaskStatus();
        if (this$voiceTaskStatus == null ? other$voiceTaskStatus != null : !this$voiceTaskStatus.equals(other$voiceTaskStatus)) {
            return false;
        }
        String this$voiceTaskStatusStr = this.getVoiceTaskStatusStr();
        String other$voiceTaskStatusStr = other.getVoiceTaskStatusStr();
        if (this$voiceTaskStatusStr == null ? other$voiceTaskStatusStr != null : !this$voiceTaskStatusStr.equals(other$voiceTaskStatusStr)) {
            return false;
        }
        String this$voiceContent = this.getVoiceContent();
        String other$voiceContent = other.getVoiceContent();
        if (this$voiceContent == null ? other$voiceContent != null : !this$voiceContent.equals(other$voiceContent)) {
            return false;
        }
        EnumDto this$lastCallStatus = this.getLastCallStatus();
        EnumDto other$lastCallStatus = other.getLastCallStatus();
        if (this$lastCallStatus == null ? other$lastCallStatus != null : !this$lastCallStatus.equals(other$lastCallStatus)) {
            return false;
        }
        Date this$lastCallTime = this.getLastCallTime();
        Date other$lastCallTime = other.getLastCallTime();
        if (this$lastCallTime == null ? other$lastCallTime != null : !((Object)this$lastCallTime).equals(other$lastCallTime)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<String> this$userNums = this.getUserNums();
        List<String> other$userNums = other.getUserNums();
        if (this$userNums == null ? other$userNums != null : !((Object)this$userNums).equals(other$userNums)) {
            return false;
        }
        List<Integer> this$allocRatio = this.getAllocRatio();
        List<Integer> other$allocRatio = other.getAllocRatio();
        return !(this$allocRatio == null ? other$allocRatio != null : !((Object)this$allocRatio).equals(other$allocRatio));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallTaskRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $callTaskId = this.getCallTaskId();
        result = result * 59 + ($callTaskId == null ? 43 : ((Object)$callTaskId).hashCode());
        Long $callTaskDetailId = this.getCallTaskDetailId();
        result = result * 59 + ($callTaskDetailId == null ? 43 : ((Object)$callTaskDetailId).hashCode());
        Integer $callCount = this.getCallCount();
        result = result * 59 + ($callCount == null ? 43 : ((Object)$callCount).hashCode());
        Double $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        Integer $customerCount = this.getCustomerCount();
        result = result * 59 + ($customerCount == null ? 43 : ((Object)$customerCount).hashCode());
        Integer $callSuccessCount = this.getCallSuccessCount();
        result = result * 59 + ($callSuccessCount == null ? 43 : ((Object)$callSuccessCount).hashCode());
        Integer $callDuration = this.getCallDuration();
        result = result * 59 + ($callDuration == null ? 43 : ((Object)$callDuration).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $calledCount = this.getCalledCount();
        result = result * 59 + ($calledCount == null ? 43 : ((Object)$calledCount).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $calledSuccessCount = this.getCalledSuccessCount();
        result = result * 59 + ($calledSuccessCount == null ? 43 : ((Object)$calledSuccessCount).hashCode());
        Integer $isLimit = this.getIsLimit();
        result = result * 59 + ($isLimit == null ? 43 : ((Object)$isLimit).hashCode());
        Integer $allocMode = this.getAllocMode();
        result = result * 59 + ($allocMode == null ? 43 : ((Object)$allocMode).hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        String $customerPhone = this.getCustomerPhone();
        result = result * 59 + ($customerPhone == null ? 43 : $customerPhone.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $createName = this.getCreateName();
        result = result * 59 + ($createName == null ? 43 : $createName.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $planCompleteTime = this.getPlanCompleteTime();
        result = result * 59 + ($planCompleteTime == null ? 43 : ((Object)$planCompleteTime).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        EnumDto $voiceTaskStatus = this.getVoiceTaskStatus();
        result = result * 59 + ($voiceTaskStatus == null ? 43 : $voiceTaskStatus.hashCode());
        String $voiceTaskStatusStr = this.getVoiceTaskStatusStr();
        result = result * 59 + ($voiceTaskStatusStr == null ? 43 : $voiceTaskStatusStr.hashCode());
        String $voiceContent = this.getVoiceContent();
        result = result * 59 + ($voiceContent == null ? 43 : $voiceContent.hashCode());
        EnumDto $lastCallStatus = this.getLastCallStatus();
        result = result * 59 + ($lastCallStatus == null ? 43 : $lastCallStatus.hashCode());
        Date $lastCallTime = this.getLastCallTime();
        result = result * 59 + ($lastCallTime == null ? 43 : ((Object)$lastCallTime).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<String> $userNums = this.getUserNums();
        result = result * 59 + ($userNums == null ? 43 : ((Object)$userNums).hashCode());
        List<Integer> $allocRatio = this.getAllocRatio();
        result = result * 59 + ($allocRatio == null ? 43 : ((Object)$allocRatio).hashCode());
        return result;
    }

    public String toString() {
        return "CallTaskRespDto(callTaskId=" + this.getCallTaskId() + ", callTaskDetailId=" + this.getCallTaskDetailId() + ", customerName=" + this.getCustomerName() + ", customerPhone=" + this.getCustomerPhone() + ", callCount=" + this.getCallCount() + ", userName=" + this.getUserName() + ", createName=" + this.getCreateName() + ", createTime=" + this.getCreateTime() + ", planCompleteTime=" + this.getPlanCompleteTime() + ", progress=" + this.getProgress() + ", taskName=" + this.getTaskName() + ", customerCount=" + this.getCustomerCount() + ", callSuccessCount=" + this.getCallSuccessCount() + ", callDuration=" + this.getCallDuration() + ", type=" + this.getType() + ", voiceTaskStatus=" + this.getVoiceTaskStatus() + ", voiceTaskStatusStr=" + this.getVoiceTaskStatusStr() + ", voiceContent=" + this.getVoiceContent() + ", calledCount=" + this.getCalledCount() + ", lastCallStatus=" + this.getLastCallStatus() + ", lastCallTime=" + this.getLastCallTime() + ", source=" + this.getSource() + ", userId=" + this.getUserId() + ", calledSuccessCount=" + this.getCalledSuccessCount() + ", isLimit=" + this.getIsLimit() + ", userNums=" + this.getUserNums() + ", allocMode=" + this.getAllocMode() + ", allocRatio=" + this.getAllocRatio() + ")";
    }

    public static class CallTaskRespDtoBuilder {
        private Long callTaskId;
        private Long callTaskDetailId;
        private String customerName;
        private String customerPhone;
        private Integer callCount;
        private String userName;
        private String createName;
        private Date createTime;
        private Date planCompleteTime;
        private Double progress;
        private String taskName;
        private Integer customerCount;
        private Integer callSuccessCount;
        private Integer callDuration;
        private Integer type;
        private EnumDto voiceTaskStatus;
        private String voiceTaskStatusStr;
        private String voiceContent;
        private Integer calledCount;
        private EnumDto lastCallStatus;
        private Date lastCallTime;
        private String source;
        private Long userId;
        private Integer calledSuccessCount;
        private Integer isLimit;
        private List<String> userNums;
        private Integer allocMode;
        private List<Integer> allocRatio;

        CallTaskRespDtoBuilder() {
        }

        public CallTaskRespDtoBuilder callTaskId(Long callTaskId) {
            this.callTaskId = callTaskId;
            return this;
        }

        public CallTaskRespDtoBuilder callTaskDetailId(Long callTaskDetailId) {
            this.callTaskDetailId = callTaskDetailId;
            return this;
        }

        public CallTaskRespDtoBuilder customerName(String customerName) {
            this.customerName = customerName;
            return this;
        }

        public CallTaskRespDtoBuilder customerPhone(String customerPhone) {
            this.customerPhone = customerPhone;
            return this;
        }

        public CallTaskRespDtoBuilder callCount(Integer callCount) {
            this.callCount = callCount;
            return this;
        }

        public CallTaskRespDtoBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public CallTaskRespDtoBuilder createName(String createName) {
            this.createName = createName;
            return this;
        }

        public CallTaskRespDtoBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public CallTaskRespDtoBuilder planCompleteTime(Date planCompleteTime) {
            this.planCompleteTime = planCompleteTime;
            return this;
        }

        public CallTaskRespDtoBuilder progress(Double progress) {
            this.progress = progress;
            return this;
        }

        public CallTaskRespDtoBuilder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public CallTaskRespDtoBuilder customerCount(Integer customerCount) {
            this.customerCount = customerCount;
            return this;
        }

        public CallTaskRespDtoBuilder callSuccessCount(Integer callSuccessCount) {
            this.callSuccessCount = callSuccessCount;
            return this;
        }

        public CallTaskRespDtoBuilder callDuration(Integer callDuration) {
            this.callDuration = callDuration;
            return this;
        }

        public CallTaskRespDtoBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public CallTaskRespDtoBuilder voiceTaskStatus(EnumDto voiceTaskStatus) {
            this.voiceTaskStatus = voiceTaskStatus;
            return this;
        }

        public CallTaskRespDtoBuilder voiceTaskStatusStr(String voiceTaskStatusStr) {
            this.voiceTaskStatusStr = voiceTaskStatusStr;
            return this;
        }

        public CallTaskRespDtoBuilder voiceContent(String voiceContent) {
            this.voiceContent = voiceContent;
            return this;
        }

        public CallTaskRespDtoBuilder calledCount(Integer calledCount) {
            this.calledCount = calledCount;
            return this;
        }

        public CallTaskRespDtoBuilder lastCallStatus(EnumDto lastCallStatus) {
            this.lastCallStatus = lastCallStatus;
            return this;
        }

        public CallTaskRespDtoBuilder lastCallTime(Date lastCallTime) {
            this.lastCallTime = lastCallTime;
            return this;
        }

        public CallTaskRespDtoBuilder source(String source) {
            this.source = source;
            return this;
        }

        public CallTaskRespDtoBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public CallTaskRespDtoBuilder calledSuccessCount(Integer calledSuccessCount) {
            this.calledSuccessCount = calledSuccessCount;
            return this;
        }

        public CallTaskRespDtoBuilder isLimit(Integer isLimit) {
            this.isLimit = isLimit;
            return this;
        }

        public CallTaskRespDtoBuilder userNums(List<String> userNums) {
            this.userNums = userNums;
            return this;
        }

        public CallTaskRespDtoBuilder allocMode(Integer allocMode) {
            this.allocMode = allocMode;
            return this;
        }

        public CallTaskRespDtoBuilder allocRatio(List<Integer> allocRatio) {
            this.allocRatio = allocRatio;
            return this;
        }

        public CallTaskRespDto build() {
            return new CallTaskRespDto(this.callTaskId, this.callTaskDetailId, this.customerName, this.customerPhone, this.callCount, this.userName, this.createName, this.createTime, this.planCompleteTime, this.progress, this.taskName, this.customerCount, this.callSuccessCount, this.callDuration, this.type, this.voiceTaskStatus, this.voiceTaskStatusStr, this.voiceContent, this.calledCount, this.lastCallStatus, this.lastCallTime, this.source, this.userId, this.calledSuccessCount, this.isLimit, this.userNums, this.allocMode, this.allocRatio);
        }

        public String toString() {
            return "CallTaskRespDto.CallTaskRespDtoBuilder(callTaskId=" + this.callTaskId + ", callTaskDetailId=" + this.callTaskDetailId + ", customerName=" + this.customerName + ", customerPhone=" + this.customerPhone + ", callCount=" + this.callCount + ", userName=" + this.userName + ", createName=" + this.createName + ", createTime=" + this.createTime + ", planCompleteTime=" + this.planCompleteTime + ", progress=" + this.progress + ", taskName=" + this.taskName + ", customerCount=" + this.customerCount + ", callSuccessCount=" + this.callSuccessCount + ", callDuration=" + this.callDuration + ", type=" + this.type + ", voiceTaskStatus=" + this.voiceTaskStatus + ", voiceTaskStatusStr=" + this.voiceTaskStatusStr + ", voiceContent=" + this.voiceContent + ", calledCount=" + this.calledCount + ", lastCallStatus=" + this.lastCallStatus + ", lastCallTime=" + this.lastCallTime + ", source=" + this.source + ", userId=" + this.userId + ", calledSuccessCount=" + this.calledSuccessCount + ", isLimit=" + this.isLimit + ", userNums=" + this.userNums + ", allocMode=" + this.allocMode + ", allocRatio=" + this.allocRatio + ")";
        }
    }
}

