/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.factory;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.call.dto.CallConfig;
import com.kuaike.scrm.call.dto.CallOutDto;
import com.kuaike.scrm.call.dto.req.CallBackReqDto;
import com.kuaike.scrm.call.enums.CallOutTypeEnum;
import com.kuaike.scrm.call.factory.CallOutService;
import com.kuaike.scrm.call.factory.RongLianCallOutServiceImpl;
import com.kuaike.scrm.call.factory.ZhongTongCallOutServiceImpl;
import com.kuaike.scrm.call.factory.ZhuQueCallOutServiceImpl;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CallOutFacade
implements CallOutService {
    private static final Logger log = LoggerFactory.getLogger(CallOutFacade.class);
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private ZhuQueCallOutServiceImpl zhuque;
    @Autowired
    private RongLianCallOutServiceImpl ronglian;
    @Autowired
    private ZhongTongCallOutServiceImpl zhongtong;

    private CallConfig callConfig(Long bizId) {
        CallConfig callConfig;
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        Preconditions.checkArgument((bindings != null && bindings.getIsOpen() == 1 ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u5c1a\u672a\u5f00\u901a\u5916\u547c\u529f\u80fd");
        String configJson = bindings.getConfigJson();
        try {
            callConfig = (CallConfig)JacksonUtil.str2Obj((String)configJson, CallConfig.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u89e3\u6790\u5916\u547c\u914d\u7f6e\u5f02\u5e38");
        }
        return callConfig;
    }

    public CallOutService getInstance(Long bizId) {
        CallConfig config = this.callConfig(bizId);
        return this.getInstance(config.getSupplierType());
    }

    public CallOutService getInstance() {
        Long bizId = LoginUtils.getCurrentUserBizId();
        return this.getInstance(bizId);
    }

    public CallOutService getInstance(Integer supplierType) {
        Preconditions.checkArgument((supplierType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u4f9b\u5e94\u5546");
        CallOutTypeEnum type = CallOutTypeEnum.get(supplierType);
        switch (type) {
            case ZHU_QUE: {
                return this.zhuque;
            }
            case ZHONG_TONG: {
                return this.zhongtong;
            }
            case RONG_LIAN: 
            case RONG_YING: {
                return this.ronglian;
            }
        }
        log.warn("\u4e0d\u652f\u6301\u7684\u5916\u547c\u7ebf\u8def");
        return null;
    }

    @Override
    public Integer getCallOutType() {
        return null;
    }

    @Override
    public String call(CallOutDto reqDto) {
        return this.getInstance().call(reqDto);
    }

    @Override
    public CallRecord callback(CallBackReqDto reqDto) {
        return this.getInstance(reqDto.getSupplierType()).callback(reqDto);
    }

    @Override
    public void cancel(CurrentUserInfo currentUserInfo) {
        this.getInstance().cancel(currentUserInfo);
    }
}

