/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.call.dto.MemberDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.dal.call.dto.CallMemberQueryParams;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class CallMemberReqDto {
    private List<MemberDto> users;
    private String userId;
    private List<String> nodeIds;
    private String nodeId;
    private String phone;
    private Long id;
    private String code;
    private Date startTime;
    private Date endTime;
    private Integer enable;
    private Integer validate;
    private PageDto pageDto;

    private void validateBaseParams(CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateListParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateAddParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.users) ? 1 : 0) != 0, (Object)"\u6267\u884c\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        for (MemberDto user : this.users) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getId()), (Object)"\u6267\u884c\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getPhone()), (Object)"\u6267\u884c\u6210\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void validateModParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.phone), (Object)"\u6267\u884c\u6210\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateIdParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.id) ? 1 : 0) != 0, (Object)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateCodeParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.id) ? 1 : 0) != 0, (Object)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.code) ? 1 : 0) != 0, (Object)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
    }

    public CallMemberQueryParams to(Long bizId, Long userId) {
        CallMemberQueryParams queryParams = new CallMemberQueryParams();
        queryParams.setBizId(bizId);
        queryParams.setCurrentUserId(userId);
        queryParams.setStartDate(this.startTime);
        queryParams.setEndDate(this.endTime);
        queryParams.setEnable(this.enable);
        queryParams.setValidate(this.validate);
        queryParams.setPageDto(this.pageDto);
        return queryParams;
    }

    public List<MemberDto> getUsers() {
        return this.users;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getPhone() {
        return this.phone;
    }

    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getEnable() {
        return this.enable;
    }

    public Integer getValidate() {
        return this.validate;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setUsers(List<MemberDto> users) {
        this.users = users;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setNodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }

    public void setValidate(Integer validate) {
        this.validate = validate;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallMemberReqDto)) {
            return false;
        }
        CallMemberReqDto other = (CallMemberReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$enable = this.getEnable();
        Integer other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        Integer this$validate = this.getValidate();
        Integer other$validate = other.getValidate();
        if (this$validate == null ? other$validate != null : !((Object)this$validate).equals(other$validate)) {
            return false;
        }
        List<MemberDto> this$users = this.getUsers();
        List<MemberDto> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        List<String> this$nodeIds = this.getNodeIds();
        List<String> other$nodeIds = other.getNodeIds();
        if (this$nodeIds == null ? other$nodeIds != null : !((Object)this$nodeIds).equals(other$nodeIds)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallMemberReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        Integer $validate = this.getValidate();
        result = result * 59 + ($validate == null ? 43 : ((Object)$validate).hashCode());
        List<MemberDto> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        List<String> $nodeIds = this.getNodeIds();
        result = result * 59 + ($nodeIds == null ? 43 : ((Object)$nodeIds).hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "CallMemberReqDto(users=" + this.getUsers() + ", userId=" + this.getUserId() + ", nodeIds=" + this.getNodeIds() + ", nodeId=" + this.getNodeId() + ", phone=" + this.getPhone() + ", id=" + this.getId() + ", code=" + this.getCode() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", enable=" + this.getEnable() + ", validate=" + this.getValidate() + ", pageDto=" + this.getPageDto() + ")";
    }
}

