/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.approval.serivce.impl;

import cn.kinyun.wework.sdk.api.OaApi;
import cn.kinyun.wework.sdk.api.req.ApplyData;
import cn.kinyun.wework.sdk.api.req.ApplyEventReq;
import cn.kinyun.wework.sdk.api.req.Content;
import cn.kinyun.wework.sdk.api.req.NodeApprover;
import cn.kinyun.wework.sdk.entity.oa.ApplyEventResp;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.approval.dto.StartApprovalReqWrapper;
import com.kuaike.scrm.approval.serivce.ApproveService;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.approval.entity.FlowInstDetail;
import com.kuaike.scrm.dal.approval.entity.FlowTemplateDetail;
import com.kuaike.scrm.dal.approval.mapper.FlowInstDetailMapper;
import com.kuaike.scrm.dal.approval.mapper.FlowTemplateDetailMapper;
import com.kuaike.scrm.token.service.ApproveTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Service
public class ApproveServiceImpl
implements ApproveService {
    private static final Logger log = LoggerFactory.getLogger(ApproveServiceImpl.class);
    @Resource
    private FlowTemplateDetailMapper flowTemplateDetailMapper;
    @Resource
    private FlowInstDetailMapper flowInstDetailMapper;
    @Resource
    private ApproveTokenService approveTokenService;
    @Resource
    private OaApi oaApi;

    @Override
    public String startApproval(StartApprovalReqWrapper req) {
        FlowTemplateDetail flowTemplateDetail = this.flowTemplateDetailMapper.selectByTmeplateId(req.getBizId(), req.getTemplateId());
        if (Objects.isNull(flowTemplateDetail)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d41\u7a0b\u6a21\u677f\u672a\u914d\u7f6e");
        }
        req.setFormTemplate(flowTemplateDetail.getTemplateInfo());
        req.setAndValidate();
        ApplyEventReq applyEventReq = this.buildApplyEventReq(req);
        ApplyEventResp resp = this.apply(req.getBizId(), applyEventReq);
        this.saveInstDetail(req.getBizId(), applyEventReq, resp);
        return resp.getSpNo();
    }

    @Override
    public String startApproval(Long bizId, ApplyEventReq applyEventReq) {
        log.info("\u53d1\u8d77\u6d41\u7a0b\u5ba1\u6279 bizId:{}param:{}", (Object)bizId, (Object)JSON.toJSONString((Object)applyEventReq));
        FlowTemplateDetail flowTemplateDetail = this.flowTemplateDetailMapper.selectByTmeplateId(bizId, applyEventReq.getTemplateId());
        if (Objects.isNull(flowTemplateDetail)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d41\u7a0b\u6a21\u677f\u672a\u914d\u7f6e");
        }
        this.startFlowCheck(bizId, applyEventReq);
        ApplyEventResp resp = this.apply(bizId, applyEventReq);
        this.saveInstDetail(bizId, applyEventReq, resp);
        return resp.getSpNo();
    }

    private ApplyEventResp apply(Long bizId, ApplyEventReq applyEventReq) {
        String accessToken = this.approveTokenService.getAccessToken(bizId);
        ApplyEventResp applyEventResp = null;
        try {
            applyEventResp = this.oaApi.applyEvent(accessToken, applyEventReq);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5ba1\u6279\u6d41\u5f02\u5e38,param:{}", (Object)JSON.toJSONString((Object)applyEventReq));
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
        }
        return applyEventResp;
    }

    private void saveInstDetail(Long bizId, ApplyEventReq applyEventReq, ApplyEventResp resp) {
        FlowInstDetail flowInstDetail = new FlowInstDetail();
        flowInstDetail.setBizId(bizId);
        flowInstDetail.setSpNo(Objects.nonNull(resp) ? resp.getSpNo() : null);
        Long userId = LoginUtils.getCurrentUserId();
        flowInstDetail.setCreateBy(userId);
        flowInstDetail.setCreateTime(new Date());
        flowInstDetail.setUpdateBy(userId);
        flowInstDetail.setUpdateTime(new Date());
        flowInstDetail.setParam(JSON.toJSONString((Object)applyEventReq));
        flowInstDetail.setResp(JSON.toJSONString((Object)resp));
        flowInstDetail.setTemplateId(applyEventReq.getTemplateId());
        this.flowInstDetailMapper.insert((Object)flowInstDetail);
    }

    private void startFlowCheck(Long bizId, ApplyEventReq req) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getTemplateId()), (Object)"\u6d41\u7a0b\u6a21\u677fid \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getCreatorUserId()), (Object)"\u6d41\u7a0b\u521b\u5efa\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        List nodeApprover = req.getNodeApprover();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)nodeApprover), (Object)"\u6d41\u7a0b\u5ba1\u6279\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        for (NodeApprover approver : nodeApprover) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)approver.getUserId()), (Object)"\u6d41\u7a0b\u5ba1\u6279\u4ebaID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ApplyData applyData = req.getApplyData();
        Preconditions.checkArgument((Objects.nonNull(applyData) && CollectionUtils.isNotEmpty((Collection)applyData.getContents()) ? 1 : 0) != 0, (Object)"\u53d1\u8d77\u6d41\u7a0b \u7533\u8bf7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List contents = applyData.getContents();
        for (Content content : contents) {
            content.validate();
        }
        FlowTemplateDetail flowTemplateDetail = this.flowTemplateDetailMapper.selectByTmeplateId(bizId, req.getTemplateId());
        Preconditions.checkArgument((boolean)Objects.nonNull(flowTemplateDetail), (Object)"\u6d41\u7a0b\u6a21\u677f\u4e0d\u5b58\u5728");
    }

    private ApplyEventReq buildApplyEventReq(StartApprovalReqWrapper wrapper) {
        ApplyEventReq applyEventReq = new ApplyEventReq();
        applyEventReq.setTemplateId(wrapper.getTemplateId());
        applyEventReq.setCreatorUserId(wrapper.getCreatorUserId());
        applyEventReq.setUseTemplateApprover(YnEnum.NO.getValue());
        applyEventReq.setNotifyType(Integer.valueOf(2));
        NodeApprover nodeApprover = new NodeApprover();
        ArrayList nodeApprovers = Lists.newArrayList();
        nodeApprover.setAttr(Integer.valueOf(1));
        nodeApprover.setUserId(wrapper.getNodeApprover());
        nodeApprovers.add(nodeApprover);
        applyEventReq.setNodeApprover((List)nodeApprovers);
        applyEventReq.setNotifyer(wrapper.getNotifyer());
        ApplyData applyData = new ApplyData();
        applyData.setContents(wrapper.getContents());
        applyEventReq.setApplyData(applyData);
        return applyEventReq;
    }
}

