/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum StaffTypeEnum {
    EMPLOYEE(1, "\u6b63\u5f0f"),
    PART_TIME(2, "\u517c\u804c");

    private final int status;
    private final String desc;
    public static final Map<Integer, StaffTypeEnum> cache;

    private StaffTypeEnum(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static StaffTypeEnum get(int status) {
        return cache.get(status);
    }

    public int getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        cache = ImmutableMap.copyOf(Arrays.stream(StaffTypeEnum.values()).collect(Collectors.toMap(StaffTypeEnum::getStatus, Function.identity())));
    }
}

