/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.shopdatasync;

import com.kuaike.scrm.applet.dto.PullResult;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.utils.DateUtil;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPullService {
    private static final Logger log = LoggerFactory.getLogger(AbstractPullService.class);
    @Autowired
    private DistributedLock lock;
    protected Map<String, Object> paramMap;

    public abstract String getKey();

    public void setExtParamMap(Map<String, Object> map) {
        this.paramMap = map;
    }

    public abstract String getStartTime(String var1);

    public abstract int getTotalNum(String var1);

    public abstract void saveTotalNum(String var1, int var2);

    public void saveUpdateTime(String appId, String updateTime) {
    }

    public abstract int getPageSize();

    private PullResult pullData(String appId, String startTime, String endTime, int page, int pageSize) {
        log.info("{} appId={} doPull, startTime={},endTime={},page={},pageSize={}", new Object[]{this.getKey(), appId, startTime, endTime, page, pageSize});
        return this.doPull(appId, startTime, endTime, page, pageSize);
    }

    public abstract PullResult doPull(String var1, String var2, String var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void running(String appId) {
        log.info("pull data,key={}, appId={}", (Object)this.getKey(), (Object)appId);
        String lockKey = this.getKey() + "$$" + appId;
        try {
            this.lock.lock(lockKey, 20L, 60L, TimeUnit.SECONDS);
            this.doBusiness(appId);
        }
        catch (InterruptedException e) {
            log.error("lock with error", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("doBusiness with error", (Throwable)e);
        }
        finally {
            this.lock.unlock(lockKey);
        }
    }

    private void doBusiness(String appId) {
        StopWatchDto timer = new StopWatchDto(this.getKey(), true, log);
        String endTime = DateUtil.dateToDateString((Date)new Date());
        int curPage = this.getTotalNum(appId) / this.getPageSize() + 1;
        String startTime = this.getStartTime(appId);
        timer.start("pullData");
        PullResult result = this.pullData(appId, startTime, endTime, curPage, this.getPageSize());
        timer.stop();
        if (Objects.isNull(result)) {
            log.warn("result is null");
            timer.print();
            return;
        }
        int counter = 0;
        boolean doWhile = true;
        timer.start("getTotalNum");
        int currrentTotalNum = this.getTotalNum(appId);
        timer.stop();
        timer.start("loop");
        do {
            if (result.getTotalNum() > currrentTotalNum) {
                log.info("pull {},contains {} new data", (Object)result.getTotalNum(), (Object)(result.getTotalNum() - currrentTotalNum));
                this.save(appId, result);
                if (result.getResultList().size() == this.getPageSize()) {
                    result = this.pullData(appId, startTime, endTime, ++curPage, this.getPageSize());
                    doWhile = true;
                    log.info("continue pull {} data, startTime={},endTime={},curPage={},pageSize={}", new Object[]{this.getKey(), startTime, endTime, curPage, this.getPageSize()});
                } else {
                    doWhile = false;
                }
            } else {
                doWhile = false;
                log.info("pull {} data empty, pullTotalNum={},totalNum={}", new Object[]{this.getKey(), result.getTotalNum(), this.getTotalNum(appId)});
            }
            ++counter;
        } while (doWhile);
        timer.stop();
        if (result.getTotalNum() > currrentTotalNum) {
            timer.start("save");
            this.saveTotalNum(appId, result.getTotalNum());
            this.saveUpdateTime(appId, endTime);
            timer.stop();
        }
        timer.print();
        log.info("pull {} data with {} times", (Object)this.getKey(), (Object)counter);
    }

    protected void save(String appId, PullResult result) {
        log.info("save {} with appId={},pullSize={}", new Object[]{this.getKey(), appId, result.getResultList().size()});
    }
}

