/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.AppletSessionResp;
import com.google.common.collect.Lists;
import com.kuaike.scrm.applet.dto.req.AuthPhoneReportReq;
import com.kuaike.scrm.applet.dto.req.OpenAppletReportReq;
import com.kuaike.scrm.applet.dto.resp.AppletUserResp;
import com.kuaike.scrm.applet.service.MaterialAppletService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.applet.entity.AppletContactInfo;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialUserInfo;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannel;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannelStaff;
import com.kuaike.scrm.dal.applet.mapper.AppletContactInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialUserInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelStaffMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.enums.StaffTypeEnum;
import com.kuaike.scrm.material.service.MarketingMaterialService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MaterialAppletServiceImpl
implements MaterialAppletService {
    private static final Logger log = LoggerFactory.getLogger(MaterialAppletServiceImpl.class);
    @Resource
    private IdGen idGen;
    @Resource
    private AppletSpreadChannelMapper appletSpreadChannelMapper;
    @Resource
    private AppletSpreadChannelStaffMapper channelStaffMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private AppletMarketingMaterialUserInfoMapper materialUserInfoMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private AppletContactInfoMapper contactInfoMapper;
    @Resource
    private MarketingMaterialService marketingMaterialService;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService materialAppletServiceThreadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(10), (ThreadFactory)new NamedThreadFactory("materialAppletService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public AppletUserResp doBusinessWhenOpenAppletReport(Long bizId, AppletSessionResp session, OpenAppletReportReq req) {
        AppletSpreadChannel appletSpreadChannel;
        log.info("doBusinessWhenOpenAppletReport,bizId:{},session:{},req:{}", new Object[]{bizId, session, req});
        AppletUserResp resp = new AppletUserResp();
        AppletMarketingMaterialUserInfo materialUserInfo = new AppletMarketingMaterialUserInfo();
        materialUserInfo.setNum(this.idGen.getNum());
        materialUserInfo.setBizId(bizId);
        if (req.getScanTime() != null) {
            materialUserInfo.setIsScan(Integer.valueOf(1));
            materialUserInfo.setScanTime(req.getScanTime());
        }
        materialUserInfo.setMaterialNum(req.getMaterialId());
        if (StringUtils.isBlank((CharSequence)req.getSpreadChannelStaffId()) && StringUtils.isNotBlank((CharSequence)req.getSpreadChannelId()) && (appletSpreadChannel = this.appletSpreadChannelMapper.queryByNum(req.getSpreadChannelId())) != null) {
            materialUserInfo.setChannelId(appletSpreadChannel.getChannelId());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getSpreadChannelStaffId())) {
            AppletSpreadChannelStaff channelStaff = this.channelStaffMapper.selectByNum(req.getSpreadChannelStaffId());
            AppletSpreadChannel appletSpreadChannel2 = (AppletSpreadChannel)this.appletSpreadChannelMapper.selectByPrimaryKey((Object)channelStaff.getSpreadChannelId());
            if (appletSpreadChannel2 != null) {
                materialUserInfo.setChannelId(appletSpreadChannel2.getChannelId());
            }
            materialUserInfo.setSpreadChannelStaffNum(channelStaff.getNum());
            materialUserInfo.setSpreadChannelStaffUserId(channelStaff.getUserId());
            ArrayList nums = Lists.newArrayList((Object[])new String[]{channelStaff.getBelongDeptId()});
            Map departmentMap = this.organizationMapper.getOrgNameByIds(bizId, (Collection)nums);
            if (departmentMap != null) {
                String depName = (String)departmentMap.get(channelStaff.getBelongDeptId());
                materialUserInfo.setSpreadChannelStaffUserDeptName(depName);
            }
            if (channelStaff.getStaffType().intValue() == StaffTypeEnum.PART_TIME.getStatus()) {
                materialUserInfo.setSpreadChannelStaffUserName(channelStaff.getUserId());
            } else {
                User user = this.userMapper.selectUserbyNum(channelStaff.getUserId());
                if (user != null) {
                    materialUserInfo.setSpreadChannelStaffUserName(user.getName());
                }
            }
        }
        materialUserInfo.setCreateTime(new Date());
        materialUserInfo.setUpdateTime(new Date());
        materialUserInfo.setIsDeleted(Integer.valueOf(0));
        materialUserInfo.setOpenId(session.getOpenId());
        materialUserInfo.setUnionId(session.getUnionId());
        this.materialUserInfoMapper.insertSelective((Object)materialUserInfo);
        AppletContactInfo appletContactInfo = this.contactInfoMapper.checkPhoneByOpenId(materialUserInfo.getBizId(), materialUserInfo.getOpenId());
        resp.setIsAuth(0);
        if (appletContactInfo != null) {
            resp.setIsAuth(1);
            resp.setPhone(appletContactInfo.getPhone());
        }
        this.materialAppletServiceThreadPool.submit(() -> {
            if (StringUtils.isNotBlank((CharSequence)req.getMaterialId()) && StringUtils.isNotBlank((CharSequence)materialUserInfo.getOpenId()) && appletContactInfo != null) {
                log.info("openAppletReport checkPhoneByOpenId:{}", (Object)appletContactInfo.getId());
                this.materialUserInfoMapper.updateLatestAuthStatusByMaterialNum(materialUserInfo.getBizId(), req.getMaterialId(), appletContactInfo.getOpenId());
            }
        });
        return resp;
    }

    @Override
    public void doBusinessWhenAuthPhoneReport(Long bizId, String corpId, AuthPhoneReportReq req, AppletContactInfo contactInfo) {
        log.info("doBusinessWhenAuthPhoneReport,bizId:{},corpId:{},req:{},contactInfo:{}", new Object[]{bizId, corpId, req, contactInfo});
        AppletSpreadChannel appletSpreadChannel = this.marketingMaterialService.getAppletSpreadChannel(req.getSpreadChannelId(), req.getSpreadChannelStaffId(), bizId);
        this.marketingMaterialService.addLeadsToCrm(bizId, corpId, contactInfo.getOpenId(), contactInfo.getUnionId(), null, req.getMaterialId(), appletSpreadChannel, null);
    }
}

