/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.applet.AppletTemplateAPI;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.DraftDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.TemplateItemDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.Add2TemplateReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.TemplateListResp;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.applet.dto.req.audit.AuditAndReleaseReq;
import com.kuaike.scrm.applet.dto.req.roc.RocAuditAndReleaseReq;
import com.kuaike.scrm.applet.dto.req.template.AddDraftToTemplateReq;
import com.kuaike.scrm.applet.dto.req.template.TemplateIdReq;
import com.kuaike.scrm.applet.dto.resp.roc.ShopListResp;
import com.kuaike.scrm.applet.dto.resp.template.TemplateDraftListResp;
import com.kuaike.scrm.applet.service.AppletAuditService;
import com.kuaike.scrm.applet.service.AppletRocService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.applet.entity.AppletAuditRelease;
import com.kuaike.scrm.dal.applet.mapper.AppletAuditReleaseMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppletRocServiceImpl
implements AppletRocService {
    private static final Logger log = LoggerFactory.getLogger(AppletRocServiceImpl.class);
    @Resource
    private ComponentTokenService componentTokenService;
    @Resource
    private AppletTemplateAPI appletTemplateAPI;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private AppletAuditReleaseMapper appletAuditReleaseMapper;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private AppletAuditService appletAuditService;

    @Override
    public List<TemplateDraftListResp> getTemplateDraftList() {
        ArrayList<TemplateDraftListResp> resp = new ArrayList<TemplateDraftListResp>();
        String accessToken = this.componentTokenService.getComponentAccessToken();
        cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.TemplateDraftListResp draftList = null;
        try {
            draftList = this.appletTemplateAPI.getDraftList(accessToken);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1 \u83b7\u53d6\u4ee3\u7801\u8349\u7a3f\u5217\u8868 \u5f02\u5e38", (Throwable)e);
            return resp;
        }
        List draftDtos = draftList.getDraftList();
        if (CollectionUtils.isEmpty((Collection)draftDtos)) {
            return resp;
        }
        for (DraftDto dto : draftDtos) {
            TemplateDraftListResp draftListResp = new TemplateDraftListResp();
            Date date = new Date(dto.getCreateTime() * 1000L);
            draftListResp.setCreateTime(DateUtil.dateToDateString((Date)date));
            draftListResp.setVersion(dto.getUserVersion());
            draftListResp.setDesc(dto.getUserDesc());
            draftListResp.setDraftId(dto.getDraftId());
            resp.add(draftListResp);
        }
        Collections.reverse(resp);
        return resp;
    }

    @Override
    public void addDraftToTemplate(AddDraftToTemplateReq dto) {
        log.info("addDraftToTemplate dto:{}", (Object)dto);
        dto.validate();
        String accessToken = this.componentTokenService.getComponentAccessToken();
        Add2TemplateReq req = new Add2TemplateReq();
        req.setDraftId(dto.getDraftId());
        req.setTemplateType(dto.getTemplateType());
        try {
            this.appletTemplateAPI.add2Template(accessToken, req);
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }

    @Override
    public void delTemplate(TemplateIdReq req) {
        log.info("delTemplate dto:{}", (Object)req);
        req.validate();
        String accessToken = this.componentTokenService.getComponentAccessToken();
        try {
            this.appletTemplateAPI.delTemplate(accessToken, req.getTemplateId());
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }

    @Override
    public List<com.kuaike.scrm.applet.dto.resp.template.TemplateListResp> getTemplateList() {
        ArrayList<com.kuaike.scrm.applet.dto.resp.template.TemplateListResp> resp = new ArrayList<com.kuaike.scrm.applet.dto.resp.template.TemplateListResp>();
        String accessToken = this.componentTokenService.getComponentAccessToken();
        TemplateListResp template = null;
        try {
            template = this.appletTemplateAPI.getTemplate(accessToken, null);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1 \u83b7\u53d6\u6a21\u677f\u5217\u8868 \u5f02\u5e38", (Throwable)e);
            return resp;
        }
        List templateList = template.getTemplateList();
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            return resp;
        }
        for (TemplateItemDto templateItemDto : templateList) {
            com.kuaike.scrm.applet.dto.resp.template.TemplateListResp templateListResp = new com.kuaike.scrm.applet.dto.resp.template.TemplateListResp();
            Date date = new Date(templateItemDto.getCreateTime() * 1000L);
            templateListResp.setCreateTime(DateUtil.dateToDateString((Date)date));
            templateListResp.setVersion(templateItemDto.getUserVersion());
            templateListResp.setDesc(templateItemDto.getUserDesc());
            templateListResp.setTemplateId(templateItemDto.getTemplateId());
            templateListResp.setTemplateType(templateItemDto.getTemplateType());
            templateListResp.setSourceMiniprogramAppid(templateItemDto.getSourceMiniprogramAppid());
            templateListResp.setSourceMiniprogram(templateItemDto.getSourceMiniprogram());
            templateListResp.setCategoryList(templateItemDto.getCategoryList());
            templateListResp.setAuditScene(templateItemDto.getAuditScene());
            resp.add(templateListResp);
        }
        Collections.reverse(resp);
        return resp;
    }

    @Override
    public List<ShopListResp> shopList(PageDto pageDto) {
        log.info("shopList pageDto:{}", (Object)pageDto);
        List appletInfos = this.appletInfoMapper.queryList(pageDto);
        if (CollectionUtils.isEmpty((Collection)appletInfos)) {
            return Collections.emptyList();
        }
        ArrayList<ShopListResp> respList = new ArrayList<ShopListResp>();
        for (AppletInfo appletInfo : appletInfos) {
            ShopListResp resp = new ShopListResp();
            resp.setCorpId(appletInfo.getCorpId());
            resp.setAppId(appletInfo.getAppId());
            BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)appletInfo.getBizId());
            if (businessCustomer != null) {
                resp.setCorpName(businessCustomer.getName());
            }
            resp.setShopName(appletInfo.getStoreName());
            AppletAuditRelease appletAuditRelease = this.appletAuditReleaseMapper.selectLastByAppId(appletInfo.getAppId());
            if (appletAuditRelease == null) {
                respList.add(resp);
                continue;
            }
            resp.setAuditReason(appletAuditRelease.getAuditReason());
            resp.setReleaseStatus(appletAuditRelease.getReleaseStatus());
            resp.setTemplateId(appletAuditRelease.getTemplateId());
            resp.setAuditStatus(appletAuditRelease.getAuditStatus());
            resp.setAuditReason(appletAuditRelease.getAuditReason());
            resp.setAuditFailTime(appletAuditRelease.getAuditFailTime());
            resp.setAuditDelayTime(appletAuditRelease.getAuditDelayTime());
            resp.setReleaseTime(appletAuditRelease.getReleaseTime());
            respList.add(resp);
        }
        return respList;
    }

    @Override
    public String auditAndRelease(RocAuditAndReleaseReq req) {
        log.info("roc auditAndRelease {}", (Object)req);
        req.validate();
        List list = this.appletInfoMapper.queryAppletInfoListByAppIds(req.getAppIds());
        CurrentUserInfo userInfo = new CurrentUserInfo();
        AuditAndReleaseReq auditAndReleaseReq = new AuditAndReleaseReq();
        ArrayList<String> errorNames = new ArrayList<String>();
        userInfo.setId(Long.valueOf(-1L));
        for (AppletInfo appletInfo : list) {
            userInfo.setCorpId(appletInfo.getCorpId());
            userInfo.setBizId(appletInfo.getBizId());
            auditAndReleaseReq.setFeedbackInfo(req.getFeedbackInfo());
            auditAndReleaseReq.setFeedbackStuff(req.getFeedbackStuff());
            auditAndReleaseReq.setTemplateId(req.getTemplateId());
            auditAndReleaseReq.setUserInfo(userInfo);
            auditAndReleaseReq.setAppId(appletInfo.getAppId());
            try {
                this.appletAuditService.auditAndRelease(auditAndReleaseReq);
            }
            catch (Exception e) {
                errorNames.add(appletInfo.getStoreName());
            }
        }
        return String.join((CharSequence)"-", errorNames);
    }
}

