/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.AppletCommonService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppletCommonServiceImpl
implements AppletCommonService {
    private static final Logger log = LoggerFactory.getLogger(AppletCommonServiceImpl.class);
    @Autowired
    private AppletAccessTokenService appletAccessTokenService;
    @Autowired
    private AppletInfoMapper appletInfoMapper;

    @Override
    public String getCurrentAppId() {
        String corpId = LoginUtils.getCurrentUserCorpId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u5f53\u524dcorpId\u4e0d\u80fd\u4e3a\u7a7a");
        AppletInfo appletInfo = this.appletInfoMapper.getByCorpId(corpId, AppletUseBusinessType.WX_SHOP.getType());
        Preconditions.checkArgument((Objects.nonNull(appletInfo) && appletInfo.getAuthStatus() == 1 ? 1 : 0) != 0, (Object)"\u5f53\u524d\u5546\u6237\u672a\u5173\u8054\u5c0f\u7a0b\u5e8f");
        return appletInfo.getAppId();
    }

    @Override
    public String getCurrentAccessToken() {
        String appId = this.getCurrentAppId();
        return this.appletAccessTokenService.getAccessToken(appId);
    }
}

