/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.applet.AppletAccountAPI;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletCodeManageAPI;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletPluginAPI;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopUtilAPI;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.ApplyPluginReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.CommitCodeReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.SubmitAuditReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.ChangeWxaSearchStatusReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.ModifyDomainReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.account.SetWebViewDomainReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.AppletPluginListResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.GetCodePrivacyInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.SubmitAuditResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account.ModifyDomainResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PicFile;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.UploadImgResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.req.audit.AuditAndReleaseReq;
import com.kuaike.scrm.applet.dto.resp.EditResp;
import com.kuaike.scrm.applet.dto.resp.audit.AuditAndReleaseStatusResp;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.AppletAuditService;
import com.kuaike.scrm.applet.service.AppletDraftTemplateService;
import com.kuaike.scrm.applet.service.AppletService;
import com.kuaike.scrm.applet.service.shopdatasync.PullDispatchService;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.applet.AppletAuthStatus;
import com.kuaike.scrm.common.enums.applet.ShopAvailableStatus;
import com.kuaike.scrm.common.enums.applet.WxAppletAuditStatus;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.applet.entity.AppletAuditRelease;
import com.kuaike.scrm.dal.applet.entity.AppletVersion;
import com.kuaike.scrm.dal.applet.entity.FastRegisterDraft;
import com.kuaike.scrm.dal.applet.mapper.AppletAuditReleaseMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletVersionMapper;
import com.kuaike.scrm.dal.applet.mapper.FastRegisterDraftMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.enums.AppletCommitCodeStatus;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.enums.AuditStatus;
import com.kuaike.scrm.enums.ReleaseStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppletAuditServiceImpl
implements AppletAuditService {
    private static final Logger log = LoggerFactory.getLogger(AppletAuditServiceImpl.class);
    @Resource
    private AppletVersionMapper appletVersionMapper;
    @Resource
    private AppletAuditReleaseMapper appletAuditReleaseMapper;
    @Resource
    private AppletCodeManageAPI appletCodeManageAPI;
    @Resource
    private AppletService appletService;
    @Resource
    private ComponentTokenService componentTokenService;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Resource
    private WxShopUtilAPI wxShopUtilAPI;
    @Autowired
    private DistributedLock lock;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Autowired
    private FastRegisterDraftMapper registerDraftMapper;
    @Autowired
    private AppletDraftTemplateService draftTemplateService;
    @Autowired
    private AppletPluginAPI appletPluginAPI;
    @Autowired
    private AppletAccountAPI appletAccountAPI;
    @Resource
    private PullDispatchService pullDispatchService;
    @Value(value="https://${scrm.domain.scrm-manager}")
    private String domain;
    @Value(value="${scrm.applet.appletDownloadDomain}")
    private String appletDownloadDomain;
    @Value(value="${scrm.applet.webViewDomain:}")
    private String webViewDomain;
    @Value(value="${shopPluginAppId:wx34345ae5855f892d}")
    private String shopPluginAppId;

    @Override
    public void auditAndRelease(AuditAndReleaseReq req) {
        SubmitAuditResp submitAuditResp;
        CurrentUserInfo userInfo;
        log.info("auditAndRelease req:{}", (Object)req);
        String templateId = req.getTemplateId();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{templateId})) {
            userInfo = req.getUserInfo();
        } else {
            userInfo = LoginUtils.getCurrentUser();
            Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        }
        req.validate();
        AppletInfo appletInfo = this.appletService.selectAuthorizedByAppId(userInfo.getBizId(), req.getAppId());
        Preconditions.checkArgument((appletInfo != null ? 1 : 0) != 0, (Object)"\u5c0f\u7a0b\u5e8f\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\u6388\u6743");
        String accessToken = this.appletAccessTokenService.getAccessToken(appletInfo.getAppId());
        int commitCodeStatus = AppletCommitCodeStatus.COMMIT_SUCCESS.getStatus();
        String commitCodeFailReason = "";
        if (AppletUseBusinessType.MARKETING_MATERIAL.getType().equals(appletInfo.getBusinessType())) {
            templateId = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{templateId}) ? req.getTemplateId() : this.draftTemplateService.getMarketingMaterialValidTemplateId();
            try {
                this.commitCode(userInfo, appletInfo.getAppId(), accessToken, AppletCommitCodeStatus.NONE.getStatus(), templateId);
            }
            catch (Exception e) {
                log.error("auditAndRelease \u4e0a\u4f20\u4ee3\u7801\u5f02\u5e38", (Throwable)e);
                String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
                msg = msg + ",\u8bf7\u8054\u7cfb\u5ba2\u670d";
                commitCodeStatus = AppletCommitCodeStatus.COMMIT_FAIL.getStatus();
                commitCodeFailReason = msg;
            }
        } else {
            templateId = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{templateId}) ? req.getTemplateId() : this.draftTemplateService.getCurrentValidTemplateId();
            CompletableFuture.runAsync(() -> this.pullDispatchService.runAppSync(appletInfo.getAppId()));
            this.preSet(userInfo, appletInfo, accessToken, templateId);
        }
        boolean codePrivacyApprove = false;
        int retryTimes = 3;
        do {
            GetCodePrivacyInfoResp codePrivacyInfo;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error("Interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            try {
                codePrivacyInfo = this.appletCodeManageAPI.getCodePrivacyInfo(accessToken);
                log.info("applet auditAndRelease, getCodePrivacyInfo, codePrivacyInfo:{}, retryTimes:{}", (Object)codePrivacyInfo, (Object)retryTimes);
            }
            catch (Exception e) {
                log.error("applet auditAndRelease, getCodePrivacyInfo error, retryTimes:{}", (Object)(--retryTimes), (Object)e);
                continue;
            }
            if (codePrivacyInfo != null && CollectionUtils.isEmpty((Collection)codePrivacyInfo.getWithoutAuthList()) && CollectionUtils.isEmpty((Collection)codePrivacyInfo.getWithoutConfList())) {
                codePrivacyApprove = true;
                retryTimes = 0;
                continue;
            }
            --retryTimes;
        } while (!codePrivacyApprove && retryTimes > 0);
        SubmitAuditReq submitAuditReq = new SubmitAuditReq();
        if (StringUtils.isNotBlank((CharSequence)req.getFeedbackInfo())) {
            submitAuditReq.setFeedbackInfo(req.getFeedbackInfo());
        }
        this.exchangeImg2MediaId(req, accessToken, submitAuditReq);
        log.info("\u8bf7\u6c42\u5fae\u4fe1 \u63d0\u4ea4\u5c0f\u7a0b\u5e8f\u5ba1\u6838 req:{}", (Object)submitAuditReq);
        try {
            submitAuditResp = this.appletCodeManageAPI.submitAudit(accessToken, submitAuditReq);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        log.info("\u8bf7\u6c42\u5fae\u4fe1 \u63d0\u4ea4\u5c0f\u7a0b\u5e8f\u5ba1\u6838  resp:{}", (Object)submitAuditResp);
        this.insertAudit(req, userInfo, appletInfo, templateId, commitCodeStatus, commitCodeFailReason);
    }

    private void exchangeImg2MediaId(AuditAndReleaseReq req, String accessToken, SubmitAuditReq submitAuditReq) {
        if (CollectionUtils.isNotEmpty(req.getFeedbackStuff())) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String url : req.getFeedbackStuff()) {
                UploadImgResp uploadImg = null;
                try {
                    uploadImg = this.wxShopUtilAPI.uploadImg(accessToken, Integer.valueOf(1), Integer.valueOf(1), url, null);
                }
                catch (WeixinException e) {
                    log.error("\u63d0\u4ea4\u5ba1\u6838 \u4e0a\u4f20\u56fe\u7247\u83b7\u53d6\u4e34\u65f6mediaId\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                PicFile picFile = uploadImg.getPicFile();
                stringBuilder.append(picFile.getMediaId()).append('|');
            }
            submitAuditReq.setFeedbackStuff(stringBuilder.toString());
        }
    }

    private void insertAudit(AuditAndReleaseReq req, CurrentUserInfo userInfo, AppletInfo appletInfo, String templateId, Integer commitCodeStatus, String commitCodeFailReason) {
        Date now = new Date();
        AppletAuditRelease appletAuditRelease = new AppletAuditRelease();
        appletAuditRelease.setAppId(appletInfo.getAppId());
        appletAuditRelease.setBizId(appletInfo.getBizId());
        appletAuditRelease.setCorpId(appletInfo.getCorpId());
        appletAuditRelease.setFeedbackInfo(req.getFeedbackInfo());
        appletAuditRelease.setFeedbackStuff(JSON.toJSONString(req.getFeedbackStuff()));
        appletAuditRelease.setAuditStatus(AuditStatus.AUDIT_IN_PROGRESS.getStatus());
        appletAuditRelease.setCreateTime(now);
        appletAuditRelease.setCreateBy(userInfo.getId());
        appletAuditRelease.setTemplateId(templateId);
        appletAuditRelease.setIsDeleted(Integer.valueOf(0));
        appletAuditRelease.setCommitCodeStatus(commitCodeStatus);
        appletAuditRelease.setCommitCodeReason(commitCodeFailReason);
        this.appletAuditReleaseMapper.insertSelective((Object)appletAuditRelease);
    }

    private void preSet(CurrentUserInfo userInfo, AppletInfo appletInfo, String accessToken, String templateId) {
        FastRegisterDraft oldFastRegisterDraft = this.registerDraftMapper.queryByAppId(appletInfo.getAppId());
        if (Objects.isNull(oldFastRegisterDraft)) {
            oldFastRegisterDraft = this.buildRegisterDraft(userInfo, appletInfo.getAppId());
        }
        this.resetStatus(oldFastRegisterDraft);
        this.setDomain(accessToken, oldFastRegisterDraft, null);
        this.setSearchStatus(accessToken, oldFastRegisterDraft, null);
        this.bindShopPlugin(accessToken, null);
        try {
            this.commitCode(userInfo, appletInfo.getAppId(), accessToken, oldFastRegisterDraft.getCommitCodeStatus(), templateId);
            oldFastRegisterDraft.setCommitCodeStatus(Integer.valueOf(1));
            oldFastRegisterDraft.setCommitCodeReason("");
        }
        catch (Exception e) {
            log.error("commit code with error", (Throwable)e);
            String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
            msg = msg + ",\u8bf7\u8054\u7cfb\u5ba2\u670d";
            oldFastRegisterDraft.setCommitCodeStatus(Integer.valueOf(2));
            oldFastRegisterDraft.setCommitCodeReason(msg);
        }
        this.registerDraftMapper.updateByPrimaryKeySelective((Object)oldFastRegisterDraft);
    }

    private void resetStatus(FastRegisterDraft oldFastRegisterDraft) {
        oldFastRegisterDraft.setDomainStatus(Integer.valueOf(0));
        oldFastRegisterDraft.setDomainReason("");
        oldFastRegisterDraft.setSearchStatus(Integer.valueOf(0));
        oldFastRegisterDraft.setSearchReason("");
        oldFastRegisterDraft.setCommitCodeStatus(Integer.valueOf(0));
        oldFastRegisterDraft.setCommitCodeReason("");
        this.registerDraftMapper.updateByPrimaryKeySelective((Object)oldFastRegisterDraft);
    }

    private FastRegisterDraft buildRegisterDraft(CurrentUserInfo currentUserInfo, String appId) {
        AppletInfo appletInfo = this.appletInfoMapper.queryByAppId(appId);
        FastRegisterDraft draft = new FastRegisterDraft();
        draft.setPrincipalName(appletInfo.getPrincipalName());
        draft.setPrincipalCode(appletInfo.getPrincipalCode());
        draft.setCorpId(currentUserInfo.getCorpId());
        draft.setBizId(currentUserInfo.getBizId());
        draft.setAppId(appId);
        draft.setRegisterStatus(Integer.valueOf(2));
        draft.setCreateBy(Long.valueOf(-1L));
        draft.setCreateTime(new Date());
        this.registerDraftMapper.insertSelective((Object)draft);
        FastRegisterDraft oldFastRegisterDraft = draft;
        return oldFastRegisterDraft;
    }

    private void bindShopPlugin(String accessToken, EditResp resp) {
        block8: {
            Set bindAppIds;
            AppletPluginListResp pluginListResp = this.appletPluginAPI.getPluginList(accessToken);
            HashSet pluginInfos = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty((Collection)pluginListResp.getPluginList())) {
                pluginInfos.addAll(pluginListResp.getPluginList());
            }
            if (CollectionUtils.isNotEmpty((Collection)pluginListResp.getApplyList())) {
                pluginInfos.addAll(pluginListResp.getApplyList());
            }
            if ((bindAppIds = pluginInfos.stream().filter(a -> Objects.equals(a.getStatus(), 1) || Objects.equals(a.getStatus(), 2)).map(a -> a.getAppId()).collect(Collectors.toSet())).contains(this.shopPluginAppId)) {
                if (Objects.nonNull(resp)) {
                    resp.setBindShopPluginStatus(1);
                }
            } else {
                ApplyPluginReq applyPluginReq = new ApplyPluginReq();
                applyPluginReq.setPluginAppId(this.shopPluginAppId);
                applyPluginReq.setReason("");
                try {
                    this.appletPluginAPI.applyPlugin(accessToken, applyPluginReq);
                    if (Objects.nonNull(resp)) {
                        resp.setBindShopPluginStatus(1);
                    }
                }
                catch (Exception e) {
                    log.error("applyPlugin with error", (Throwable)e);
                    String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
                    msg = msg + ",\u8bf7\u8054\u7cfb\u5ba2\u670d";
                    if (!Objects.nonNull(resp)) break block8;
                    resp.setBindShopPluginStatus(2);
                    resp.setBindShopPluginReason(msg);
                }
            }
        }
    }

    private void commitCode(CurrentUserInfo currentUserInfo, String appId, String accessToken, Integer commitCodeStatus, String templateId) {
        if (Objects.equals(commitCodeStatus, AppletCommitCodeStatus.COMMIT_SUCCESS.getStatus())) {
            return;
        }
        String extJson = "{\"extAppid\":\"\",\"ext\":{},\"window\":{},\"networkTimeout\":{},\"tabBar\":{},\"plugin\":{}}";
        JSONObject jsonObject = JSONObject.parseObject((String)extJson);
        jsonObject.put("extAppid", (Object)appId);
        CommitCodeReq commitCodeReq = new CommitCodeReq();
        commitCodeReq.setTemplateId(templateId);
        commitCodeReq.setExtJson(jsonObject.toJSONString());
        commitCodeReq.setUserDesc(templateId);
        commitCodeReq.setUserVersion(templateId);
        this.appletCodeManageAPI.commitCode(accessToken, commitCodeReq);
        AppletVersion appletVersion = this.buildAppletVersion(currentUserInfo, appId, templateId, jsonObject);
        this.appletVersionMapper.insertSelective((Object)appletVersion);
    }

    private AppletVersion buildAppletVersion(CurrentUserInfo currentUserInfo, String appId, String templateId, JSONObject jsonObject) {
        AppletVersion appletVersion = new AppletVersion();
        appletVersion.setDesc(templateId);
        appletVersion.setAppId(appId);
        appletVersion.setBizId(currentUserInfo.getBizId());
        appletVersion.setCorpId(currentUserInfo.getCorpId());
        appletVersion.setVersion(templateId);
        appletVersion.setCreateBy(currentUserInfo.getId());
        appletVersion.setCreateTime(new Date());
        appletVersion.setExtJson(jsonObject.toJSONString());
        appletVersion.setTemplateId(templateId);
        return appletVersion;
    }

    private void setSearchStatus(String accessToken, FastRegisterDraft oldFastRegisterDraft, EditResp resp) {
        if (!Objects.equals(oldFastRegisterDraft.getSearchStatus(), 1)) {
            block4: {
                try {
                    ChangeWxaSearchStatusReq changeWxaSearchStatusReq = new ChangeWxaSearchStatusReq();
                    changeWxaSearchStatusReq.setStatus(Integer.valueOf(0));
                    this.appletAccountAPI.changeWxaSearchStatus(accessToken, changeWxaSearchStatusReq);
                    oldFastRegisterDraft.setSearchStatus(Integer.valueOf(1));
                    oldFastRegisterDraft.setSearchReason("");
                    if (Objects.nonNull(resp)) {
                        resp.setSearchStatus(1);
                    }
                }
                catch (Exception e) {
                    log.error("changeSearchStatus with error", (Throwable)e);
                    String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
                    msg = msg + ",\u8bf7\u8054\u7cfb\u5ba2\u670d";
                    oldFastRegisterDraft.setSearchStatus(Integer.valueOf(2));
                    oldFastRegisterDraft.setSearchReason(msg);
                    if (!Objects.nonNull(resp)) break block4;
                    resp.setSearchStatus(2);
                    resp.setSearchReason(msg);
                }
            }
            this.registerDraftMapper.updateByPrimaryKeySelective((Object)oldFastRegisterDraft);
        }
    }

    private void setDomain(String accessToken, FastRegisterDraft oldFastRegisterDraft, EditResp resp) {
        if (!Objects.equals(oldFastRegisterDraft.getDomainStatus(), 1)) {
            block4: {
                try {
                    this.reqSetDomain(accessToken);
                    oldFastRegisterDraft.setDomainStatus(Integer.valueOf(1));
                    oldFastRegisterDraft.setDomainReason("");
                    if (Objects.nonNull(resp)) {
                        resp.setDomainStatus(1);
                    }
                }
                catch (Exception e) {
                    log.error("modify domain with error", (Throwable)e);
                    String msg = StringUtils.abbreviate((String)e.getMessage(), (int)240);
                    msg = msg + ",\u8bf7\u8054\u7cfb\u5ba2\u670d";
                    oldFastRegisterDraft.setDomainStatus(Integer.valueOf(2));
                    oldFastRegisterDraft.setDomainReason(msg);
                    if (!Objects.nonNull(resp)) break block4;
                    resp.setDomainStatus(2);
                    resp.setDomainReason(msg);
                }
            }
            this.registerDraftMapper.updateByPrimaryKeySelective((Object)oldFastRegisterDraft);
        }
    }

    @Override
    public void reqSetDomain(String accessToken) {
        ModifyDomainReq domainReq = new ModifyDomainReq();
        domainReq.setAction("get");
        ModifyDomainResp domainResp = this.appletAccountAPI.modifyDomain(accessToken, domainReq);
        ArrayList requestDomains = Lists.newArrayList((Iterable)domainResp.getRequestDomain());
        requestDomains.add(this.domain);
        requestDomains.removeAll(domainResp.getInvalidRequestDomain());
        domainResp.setRequestDomain((List)requestDomains);
        domainResp.getWsRequestDomain().removeAll(domainResp.getInvalidWsRequestDomain());
        domainResp.getUploadDomain().removeAll(domainResp.getInvalidUploadDomain());
        ArrayList downloadDomains = Lists.newArrayList((Iterable)domainResp.getDownloadDomain());
        String[] split = this.appletDownloadDomain.split(",");
        downloadDomains.addAll(Arrays.asList(split));
        downloadDomains.removeAll(domainResp.getInvalidDownloadDomain());
        domainResp.setDownloadDomain((List)downloadDomains);
        domainResp.getUdpDomain().removeAll(domainResp.getInvalidUdpDomain());
        domainResp.getTcpDomain().removeAll(domainResp.getInvalidTcpDomain());
        domainReq.setAction("set");
        BeanUtils.copyProperties((Object)domainResp, (Object)domainReq);
        this.appletAccountAPI.modifyDomain(accessToken, domainReq);
        SetWebViewDomainReq req = new SetWebViewDomainReq();
        req.setAction("set");
        ArrayList webViewDomains = Lists.newArrayList((Object[])new String[]{this.domain});
        String[] splitWebViewDomain = this.webViewDomain.split(",");
        webViewDomains.addAll(Arrays.asList(splitWebViewDomain));
        req.setWebViewDomain((List)webViewDomains);
        this.appletAccountAPI.setWebViewDomain(req, accessToken);
    }

    @Override
    public AuditAndReleaseStatusResp auditAndReleaseStatus() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        AppletInfo appletInfo = this.appletService.selectAuthorizedByBizId(userInfo.getBizId());
        Preconditions.checkArgument((appletInfo != null ? 1 : 0) != 0, (Object)"\u5c0f\u7a0b\u5e8f\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\u6388\u6743");
        AuditAndReleaseStatusResp resp = new AuditAndReleaseStatusResp();
        AppletAuditRelease appletAuditRelease = this.appletAuditReleaseMapper.selectLastByAppId(appletInfo.getAppId());
        resp.setAuditStatus(AuditStatus.NONE.getStatus());
        resp.setReleaseStatus(ReleaseStatus.NOT_RELEASED.getStatus());
        if (appletAuditRelease != null) {
            resp.setAuditStatus(appletAuditRelease.getAuditStatus());
            resp.setAuditReason(appletAuditRelease.getAuditReason());
            resp.setAuditFailTime(appletAuditRelease.getAuditFailTime() != null ? DateUtil.dateToDateString((Date)appletAuditRelease.getAuditFailTime()) : "");
            resp.setAuditDelayTime(appletAuditRelease.getAuditDelayTime() != null ? DateUtil.dateToDateString((Date)appletAuditRelease.getAuditDelayTime()) : "");
            resp.setReleaseStatus(appletAuditRelease.getReleaseStatus());
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAuditCallback(String userName, String event, Long failTime, String reason, Long delayTime) {
        log.info("handleAuditCallback userName:{},event:{},failTime:{},reason:{},delayTime:{}", new Object[]{userName, event, failTime, reason, delayTime});
        String key = userName + "$$" + event;
        try {
            this.lock.lock(key);
            String appId = this.appletInfoMapper.queryAppIdByUserName(userName);
            if (StringUtils.isBlank((CharSequence)appId)) {
                log.warn("userName={} not found appId", (Object)userName);
                return;
            }
            AppletAuditRelease appletAuditRelease = this.appletAuditReleaseMapper.selectLastByAppId(appId);
            if (appletAuditRelease == null) {
                log.warn("appId={} not found appletAuditRelease", (Object)appId);
                return;
            }
            if (WxAppletAuditStatus.WEAPP_AUDIT_SUCCESS.getDesc().equals(event)) {
                appletAuditRelease.setAuditStatus(AuditStatus.AUDIT_PASSED.getStatus());
                AppletInfo selectAppletInfo = new AppletInfo();
                selectAppletInfo.setAppId(appId);
                selectAppletInfo.setIsDeleted(Integer.valueOf(0));
                selectAppletInfo.setAuthStatus(AppletAuthStatus.AUTHORIZED.getStatus());
                AppletInfo appletInfo = (AppletInfo)this.appletInfoMapper.selectOne((Object)selectAppletInfo);
                if (appletInfo == null) {
                    log.error("\u5ba1\u6838\u6210\u529f\u53d1\u5e03\u5c0f\u7a0b\u5e8f\uff0c\u901a\u8fc7appId\u67e5\u8be2\u6388\u6743\u7684\u5c0f\u7a0b\u5e8f\u4e3a\u7a7a");
                    return;
                }
                String accessToken = this.appletAccessTokenService.getAccessToken(appletInfo.getAppId());
                appletAuditRelease.setReleaseStatus(ReleaseStatus.SUCCESSFUL.getStatus());
                appletAuditRelease.setReleaseTime(new Date());
                try {
                    this.appletCodeManageAPI.release(accessToken);
                }
                catch (Exception e) {
                    log.error("\u53d1\u5e03\u5c0f\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
                    appletAuditRelease.setReleaseStatus(ReleaseStatus.FAILED.getStatus());
                }
                appletInfo.setShopAvailable(ShopAvailableStatus.AVAILABLE.getStatus());
                this.appletInfoMapper.updateByPrimaryKeySelective((Object)appletInfo);
            } else if (WxAppletAuditStatus.WEAPP_AUDIT_FAIL.getDesc().equals(event)) {
                appletAuditRelease.setAuditStatus(AuditStatus.AUDIT_NOT_PASSED.getStatus());
                appletAuditRelease.setAuditFailTime(new Date(failTime * 1000L));
                appletAuditRelease.setAuditReason(reason);
            } else if (WxAppletAuditStatus.WEAPP_AUDIT_DELAY.getDesc().equals(event)) {
                appletAuditRelease.setAuditReason(reason);
                appletAuditRelease.setAuditDelayTime(new Date(delayTime * 1000L));
            } else {
                log.warn("handleAuditCallback \u672a\u77e5\u7684event {}", (Object)event);
                return;
            }
            this.appletAuditReleaseMapper.updateByPrimaryKeySelective((Object)appletAuditRelease);
        }
        catch (Exception e) {
            log.error("handleAuditCallback with error", (Throwable)e);
        }
        finally {
            this.lock.unlock(key);
        }
    }
}

