/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.dto.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.applet.dto.StaffStaticQuery;
import java.util.Date;
import org.apache.commons.lang.math.NumberUtils;

public class AppletStaffListReq {
    private String materialId;
    private String deptId;
    private Integer staffType;
    @JsonProperty(value="pStaffName")
    private String pStaffName;
    private Date startTime;
    private Date endTime;
    private PageDto pageDto;
    private boolean isPage = true;

    public void validate() {
        Preconditions.checkArgument((this.materialId != null ? 1 : 0) != 0, (Object)"\u8d44\u6599Id\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.isPage) {
            Preconditions.checkArgument((this.pageDto != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.pageDto.getPageSize() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.pageDto.getPageNum() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public StaffStaticQuery toQuery(Long bizId) {
        StaffStaticQuery query = new StaffStaticQuery();
        query.setBizId(bizId);
        query.setMaterialId(this.materialId);
        query.setStartTime(this.startTime);
        query.setEndTime(this.endTime);
        query.setPStaffQuery(this.pStaffName);
        query.setStaffType(this.staffType);
        query.setPageDto(this.pageDto);
        query.setJoinChannelStaff(this.staffType != null);
        query.setIsScan(NumberUtils.INTEGER_ONE);
        return query;
    }

    public String getMaterialId() {
        return this.materialId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public Integer getStaffType() {
        return this.staffType;
    }

    public String getPStaffName() {
        return this.pStaffName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public boolean isPage() {
        return this.isPage;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public void setStaffType(Integer staffType) {
        this.staffType = staffType;
    }

    @JsonProperty(value="pStaffName")
    public void setPStaffName(String pStaffName) {
        this.pStaffName = pStaffName;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setPage(boolean isPage) {
        this.isPage = isPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppletStaffListReq)) {
            return false;
        }
        AppletStaffListReq other = (AppletStaffListReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPage() != other.isPage()) {
            return false;
        }
        Integer this$staffType = this.getStaffType();
        Integer other$staffType = other.getStaffType();
        if (this$staffType == null ? other$staffType != null : !((Object)this$staffType).equals(other$staffType)) {
            return false;
        }
        String this$materialId = this.getMaterialId();
        String other$materialId = other.getMaterialId();
        if (this$materialId == null ? other$materialId != null : !this$materialId.equals(other$materialId)) {
            return false;
        }
        String this$deptId = this.getDeptId();
        String other$deptId = other.getDeptId();
        if (this$deptId == null ? other$deptId != null : !this$deptId.equals(other$deptId)) {
            return false;
        }
        String this$pStaffName = this.getPStaffName();
        String other$pStaffName = other.getPStaffName();
        if (this$pStaffName == null ? other$pStaffName != null : !this$pStaffName.equals(other$pStaffName)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppletStaffListReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPage() ? 79 : 97);
        Integer $staffType = this.getStaffType();
        result = result * 59 + ($staffType == null ? 43 : ((Object)$staffType).hashCode());
        String $materialId = this.getMaterialId();
        result = result * 59 + ($materialId == null ? 43 : $materialId.hashCode());
        String $deptId = this.getDeptId();
        result = result * 59 + ($deptId == null ? 43 : $deptId.hashCode());
        String $pStaffName = this.getPStaffName();
        result = result * 59 + ($pStaffName == null ? 43 : $pStaffName.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "AppletStaffListReq(materialId=" + this.getMaterialId() + ", deptId=" + this.getDeptId() + ", staffType=" + this.getStaffType() + ", pStaffName=" + this.getPStaffName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", pageDto=" + this.getPageDto() + ", isPage=" + this.isPage() + ")";
    }
}

