/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.applet.dto.ChannelStaticQuery;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;

public class AppletChannelListReq {
    private String materialId;
    private List<String> channelIdList;
    private Date startTime;
    private Date endTime;
    private PageDto pageDto;
    private boolean isPage = true;

    public void validate() {
        Preconditions.checkArgument((this.materialId != null ? 1 : 0) != 0, (Object)"\u8d44\u6599Id\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.isPage) {
            Preconditions.checkArgument((this.pageDto != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.pageDto.getPageSize() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.pageDto.getPageNum() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public ChannelStaticQuery toQuery(Long bizId) {
        ChannelStaticQuery query = new ChannelStaticQuery();
        query.setBizId(bizId);
        query.setMaterialId(this.materialId);
        query.setChannelIdList(this.channelIdList);
        query.setStartTime(this.startTime);
        query.setEndTime(this.endTime);
        query.setPageDto(this.pageDto);
        query.setIsScan(NumberUtils.INTEGER_ONE);
        return query;
    }

    public String getMaterialId() {
        return this.materialId;
    }

    public List<String> getChannelIdList() {
        return this.channelIdList;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public boolean isPage() {
        return this.isPage;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public void setChannelIdList(List<String> channelIdList) {
        this.channelIdList = channelIdList;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setPage(boolean isPage) {
        this.isPage = isPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppletChannelListReq)) {
            return false;
        }
        AppletChannelListReq other = (AppletChannelListReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPage() != other.isPage()) {
            return false;
        }
        String this$materialId = this.getMaterialId();
        String other$materialId = other.getMaterialId();
        if (this$materialId == null ? other$materialId != null : !this$materialId.equals(other$materialId)) {
            return false;
        }
        List<String> this$channelIdList = this.getChannelIdList();
        List<String> other$channelIdList = other.getChannelIdList();
        if (this$channelIdList == null ? other$channelIdList != null : !((Object)this$channelIdList).equals(other$channelIdList)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppletChannelListReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPage() ? 79 : 97);
        String $materialId = this.getMaterialId();
        result = result * 59 + ($materialId == null ? 43 : $materialId.hashCode());
        List<String> $channelIdList = this.getChannelIdList();
        result = result * 59 + ($channelIdList == null ? 43 : ((Object)$channelIdList).hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "AppletChannelListReq(materialId=" + this.getMaterialId() + ", channelIdList=" + this.getChannelIdList() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", pageDto=" + this.getPageDto() + ", isPage=" + this.isPage() + ")";
    }
}

