/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.dto.dto;

import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.category.CerticateItem;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.utils.HttpHeadUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class CategoryDto {
    private Long first;
    private Long second;
    private List<CerticateItem> certicates;
    private String firstName;
    private String secondName;

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.first), (Object)"first\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.second), (Object)"second\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty(this.certicates)) {
            for (CerticateItem certicate : this.certicates) {
                certicate.validate();
                HttpHeadUtils.checkImgAndSize((String)certicate.getValue(), (String)(certicate.getKey() + "\u8d44\u8d28\u7684\u683c\u5f0f\u5fc5\u987b\u662fpng,jpg,jpeg,gif"), (int)10, (String)(certicate.getKey() + "\u8d44\u8d28\u7684\u56fe\u7247\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc710MB"));
            }
        }
    }

    public Long getFirst() {
        return this.first;
    }

    public Long getSecond() {
        return this.second;
    }

    public List<CerticateItem> getCerticates() {
        return this.certicates;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getSecondName() {
        return this.secondName;
    }

    public void setFirst(Long first) {
        this.first = first;
    }

    public void setSecond(Long second) {
        this.second = second;
    }

    public void setCerticates(List<CerticateItem> certicates) {
        this.certicates = certicates;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setSecondName(String secondName) {
        this.secondName = secondName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryDto)) {
            return false;
        }
        CategoryDto other = (CategoryDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$first = this.getFirst();
        Long other$first = other.getFirst();
        if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
            return false;
        }
        Long this$second = this.getSecond();
        Long other$second = other.getSecond();
        if (this$second == null ? other$second != null : !((Object)this$second).equals(other$second)) {
            return false;
        }
        List<CerticateItem> this$certicates = this.getCerticates();
        List<CerticateItem> other$certicates = other.getCerticates();
        if (this$certicates == null ? other$certicates != null : !((Object)this$certicates).equals(other$certicates)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$secondName = this.getSecondName();
        String other$secondName = other.getSecondName();
        return !(this$secondName == null ? other$secondName != null : !this$secondName.equals(other$secondName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoryDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
        Long $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
        List<CerticateItem> $certicates = this.getCerticates();
        result = result * 59 + ($certicates == null ? 43 : ((Object)$certicates).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $secondName = this.getSecondName();
        result = result * 59 + ($secondName == null ? 43 : $secondName.hashCode());
        return result;
    }

    public String toString() {
        return "CategoryDto(first=" + this.getFirst() + ", second=" + this.getSecond() + ", certicates=" + this.getCerticates() + ", firstName=" + this.getFirstName() + ", secondName=" + this.getSecondName() + ")";
    }
}

