/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.enums.GroupConfigEnum;
import com.kuaike.scrm.material.dto.req.GroupFileDto;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MaterialGroupDto {
    private Long id;
    private String groupName;
    private Integer sort;
    private List<GroupFileDto> groupFiles;

    public void validateParams(Integer groupConfig) {
        if (GroupConfigEnum.GROUP.getValue() == groupConfig.intValue()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.groupName), (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.sort != null ? 1 : 0) != 0, (Object)"\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.groupFiles), (Object)"\u6587\u4ef6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupFiles.forEach(GroupFileDto::validateParams);
    }

    public Long getId() {
        return this.id;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getSort() {
        return this.sort;
    }

    public List<GroupFileDto> getGroupFiles() {
        return this.groupFiles;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setGroupFiles(List<GroupFileDto> groupFiles) {
        this.groupFiles = groupFiles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialGroupDto)) {
            return false;
        }
        MaterialGroupDto other = (MaterialGroupDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$sort = this.getSort();
        Integer other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        List<GroupFileDto> this$groupFiles = this.getGroupFiles();
        List<GroupFileDto> other$groupFiles = other.getGroupFiles();
        return !(this$groupFiles == null ? other$groupFiles != null : !((Object)this$groupFiles).equals(other$groupFiles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialGroupDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        List<GroupFileDto> $groupFiles = this.getGroupFiles();
        result = result * 59 + ($groupFiles == null ? 43 : ((Object)$groupFiles).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialGroupDto(id=" + this.getId() + ", groupName=" + this.getGroupName() + ", sort=" + this.getSort() + ", groupFiles=" + this.getGroupFiles() + ")";
    }
}

