/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.req.AppletChannelListReq;
import com.kuaike.scrm.applet.dto.req.AppletCountReq;
import com.kuaike.scrm.applet.dto.req.AppletStaffListReq;
import com.kuaike.scrm.applet.dto.req.AppletUserListReq;
import com.kuaike.scrm.applet.dto.req.UserInGroupReq;
import com.kuaike.scrm.applet.dto.resp.AppletChannelListResp;
import com.kuaike.scrm.applet.dto.resp.AppletCountResp;
import com.kuaike.scrm.applet.dto.resp.AppletStaffListResp;
import com.kuaike.scrm.applet.dto.resp.AppletUserListResp;
import com.kuaike.scrm.applet.dto.resp.UserInGroupResp;
import com.kuaike.scrm.applet.service.AppletStaticService;
import com.kuaike.scrm.common.component.PojoExportExcel;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.AddWeworkStatusEnum;
import com.kuaike.scrm.common.enums.YesOrNoEnum;
import com.kuaike.scrm.common.service.CustomerDetailSupportService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmWeworkUserService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.ScrmLeadsDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.applet.dto.AppletStaticQuery;
import com.kuaike.scrm.dal.applet.dto.ChannelStaticQuery;
import com.kuaike.scrm.dal.applet.dto.StaffStaticQuery;
import com.kuaike.scrm.dal.applet.entity.AppletContactInfo;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialUserInfo;
import com.kuaike.scrm.dal.applet.entity.AppletSpreadChannelStaff;
import com.kuaike.scrm.dal.applet.mapper.AppletContactInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialUserInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletSpreadChannelStaffMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoomRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.enums.IntoGroupStatusEnum;
import com.kuaike.scrm.enums.StaffTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppletStaticServiceImpl
implements AppletStaticService {
    private static final Logger log = LoggerFactory.getLogger(AppletStaticServiceImpl.class);
    @Autowired
    private AppletMarketingMaterialUserInfoMapper appletMarketingMaterialUserInfoMapper;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private AppletSpreadChannelStaffMapper appletSpreadChannelStaffMapper;
    @Autowired
    private AppletContactInfoMapper appletContactInfoMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private CustomerDetailSupportService customerDetailSupportService;
    @Resource
    private ScrmWeworkUserService scrmWeworkUserService;

    @Override
    public List<AppletUserListResp> userList(AppletUserListReq req) {
        log.info("userList: req:{}", (Object)req);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        Long userId = currentUserInfo.getId();
        log.info("userList: bizId:{}, corpId:{}, userId:{}", new Object[]{bizId, corpId, userId});
        req.validate();
        AppletStaticQuery query = req.toQuery(bizId);
        List userInfoList = this.appletMarketingMaterialUserInfoMapper.queryUserListByCondition(query);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            log.info("userList: \u65e0\u6cd5\u67e5\u8be2\u5230\u5ba2\u6237\u5217\u8868\uff0cbizId:{}, reqDto:{}", (Object)bizId, (Object)req);
            return Collections.emptyList();
        }
        if (req.getPageDto() != null) {
            int count = this.appletMarketingMaterialUserInfoMapper.countUserListByCondition(query);
            req.getPageDto().setCount(Integer.valueOf(count));
            req.getPageDto().setCurPageCount(Integer.valueOf(userInfoList.size()));
        }
        return this.buildUserList(bizId, corpId, userInfoList);
    }

    private List<AppletUserListResp> buildUserList(Long bizId, String corpId, List<AppletMarketingMaterialUserInfo> userInfoList) {
        Set openIds = userInfoList.stream().map(AppletMarketingMaterialUserInfo::getOpenId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        List contactInfoList = this.appletContactInfoMapper.queryByOpenIds(bizId, openIds);
        Map<String, AppletContactInfo> contactInfoMap = contactInfoList.stream().collect(Collectors.toMap(AppletContactInfo::getOpenId, a -> a, (k, v) -> v));
        Set channelNums = userInfoList.stream().map(AppletMarketingMaterialUserInfo::getChannelId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map channelIdAndNameMap = this.channelMapper.selectNameByNums(bizId, channelNums);
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        Set userNums = userInfoList.stream().map(AppletMarketingMaterialUserInfo::getWeworkUserId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(userNums);
        Set<String> contactIds = contactInfoList.stream().map(AppletContactInfo::getContactId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Map<String, WeworkContactRelation> contactId2RelationMap = this.getWeworkContactRelation(corpId, contactIds, weworkUserNum2IdMap);
        List mobiles = contactInfoList.stream().map(AppletContactInfo::getPhone).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List leadsDtoList = this.customerDetailSupportService.leadsDtoList(bizId, mobiles);
        log.info("buildUserList: leads pool list, bizId:{}, leadsDtoList:{}", (Object)bizId, (Object)leadsDtoList);
        Map mobileLeadsMap = leadsDtoList.stream().collect(Collectors.toMap(ScrmLeadsDto::getPhone, Function.identity(), (k, v) -> k));
        ArrayList respList = Lists.newArrayList();
        userInfoList.forEach(e -> {
            AppletUserListResp resp = new AppletUserListResp();
            resp.setNum(e.getNum());
            resp.setAddWeworkUserName(e.getWeworkUserName());
            resp.setSpreadStaffName(e.getSpreadChannelStaffUserName());
            resp.setAddWeworkStatus(e.getIsAddFriend());
            AddWeworkStatusEnum addWeworkStatusEnum = AddWeworkStatusEnum.get((int)e.getIsAddFriend());
            if (addWeworkStatusEnum != null) {
                resp.setAddWeworkStatusDesc(addWeworkStatusEnum.getDesc());
            }
            int isJoinRoom = YesOrNoEnum.NO.getValue();
            AppletContactInfo contactInfo = (AppletContactInfo)contactInfoMap.get(e.getOpenId());
            if (contactInfo != null) {
                ScrmLeadsDto scrmLeadsDto;
                String key;
                WeworkContactRelation relation;
                String weworkUserId;
                resp.setUserName(contactInfo.getNickName());
                String phone = contactInfo.getPhone();
                resp.setPhone(mobileEncrypt ? MobileUtils.encryptMobile((String)phone) : phone);
                resp.setAvatar(contactInfo.getAvatar());
                Integer intoGroupStatus = contactInfo.getIntoGroupStatus();
                if (IntoGroupStatusEnum.JOIN_GROUP.getValue() == intoGroupStatus.intValue() || IntoGroupStatusEnum.QUIT_GROUP.getValue() == intoGroupStatus.intValue()) {
                    isJoinRoom = YesOrNoEnum.YES.getValue();
                }
                String userNum = e.getWeworkUserId();
                String contactId = contactInfo.getContactId();
                if (StringUtils.isNotBlank((CharSequence)userNum) && StringUtils.isNotBlank((CharSequence)contactId) && StringUtils.isNotBlank((CharSequence)(weworkUserId = (String)weworkUserNum2IdMap.get(userNum))) && (relation = (WeworkContactRelation)contactId2RelationMap.get(key = this.buildKey(weworkUserId, contactId))) != null && StringUtils.isNotBlank((CharSequence)relation.getRemark())) {
                    resp.setRemarkName(relation.getRemark());
                }
                if ((scrmLeadsDto = (ScrmLeadsDto)mobileLeadsMap.get(phone)) != null) {
                    resp.setCustomerNum(scrmLeadsDto.getCustomerNum());
                    resp.setLeadsNum(scrmLeadsDto.getLeadsNum());
                    resp.setProductLineNum(scrmLeadsDto.getProductLineNum());
                    resp.setCrmCustomerName(scrmLeadsDto.getCrmCustomerName());
                }
            }
            resp.setIntoGroupStatus(isJoinRoom);
            YesOrNoEnum yesOrNoEnum = YesOrNoEnum.get((int)isJoinRoom);
            if (yesOrNoEnum != null) {
                resp.setIntoGroupStatusDesc(yesOrNoEnum.getDesc());
            }
            resp.setDeptName(e.getSpreadChannelStaffUserDeptName());
            String channelName = (String)channelIdAndNameMap.get(e.getChannelId());
            if (StringUtils.isNotBlank((CharSequence)channelName)) {
                resp.setChannelName(channelName);
            }
            respList.add(resp);
        });
        return respList;
    }

    @Override
    public List<AppletStaffListResp> staffList(AppletStaffListReq req) {
        List staffUserIdList;
        Long nodeId;
        Set posterityIds;
        log.info("staffList: req:{}", (Object)req);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        Long userId = currentUserInfo.getId();
        log.info("staffList: bizId:{},corpId:{},userId:{}", new Object[]{bizId, corpId, userId});
        req.validate();
        StaffStaticQuery query = req.toQuery(bizId);
        String deptId = req.getDeptId();
        if (StringUtils.isNotBlank((CharSequence)deptId) && CollectionUtils.isNotEmpty((Collection)(posterityIds = this.nodeService.getPosterityIds(nodeId = this.organizationMapper.getIdByNum(bizId, deptId), bizId)))) {
            List deptNameList = this.organizationMapper.queryNameByIds(bizId, (Collection)posterityIds);
            query.setDeptNameList((Collection)deptNameList);
        }
        if (CollectionUtils.isEmpty((Collection)(staffUserIdList = this.appletMarketingMaterialUserInfoMapper.queryStaffListByCondition(query)))) {
            log.info("staffList: \u65e0\u6cd5\u67e5\u8be2\u5230\u5458\u5de5\u5217\u8868\uff0cbizId:{}, reqDto:{}", (Object)bizId, (Object)req);
            return Collections.emptyList();
        }
        if (req.getPageDto() != null) {
            int count = this.appletMarketingMaterialUserInfoMapper.countStaffListByCondition(query);
            req.getPageDto().setCount(Integer.valueOf(count));
            req.getPageDto().setCurPageCount(Integer.valueOf(staffUserIdList.size()));
        }
        return this.buildStaffList(bizId, staffUserIdList, query);
    }

    private List<AppletStaffListResp> buildStaffList(Long bizId, List<String> staffUserIdList, StaffStaticQuery query) {
        query.setSpreadStaffUserIds(staffUserIdList);
        query.setIsScan(null);
        query.setIsBrowse(NumberUtils.INTEGER_ONE);
        Map browsePeopleCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByStaff(query);
        query.setIsBrowse(null);
        query.setIsScan(NumberUtils.INTEGER_ONE);
        Map userSpreadCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByStaff(query);
        query.setIsAddFriend(NumberUtils.INTEGER_ONE);
        Map addWeworkCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByStaff(query);
        query.setIsAddFriend(null);
        query.setIsIntoGroup(NumberUtils.INTEGER_ONE);
        query.setJoinContactInfo(true);
        Map inRoomCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByStaff(query);
        List staffList = this.appletSpreadChannelStaffMapper.queryByUserIds(bizId, staffUserIdList);
        Map<String, AppletSpreadChannelStaff> staffMap = staffList.stream().collect(Collectors.toMap(AppletSpreadChannelStaff::getUserId, a -> a, (k, v) -> v));
        Set deptNums = staffList.stream().map(AppletSpreadChannelStaff::getBelongDeptId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map deptNumAndNameMap = this.organizationMapper.getOrgNameByIds(bizId, deptNums);
        List users = this.userMapper.getUserInfoByNums(staffUserIdList);
        Map<String, String> userNameMap = users.stream().collect(Collectors.toMap(User::getNum, User::getName));
        ArrayList respList = Lists.newArrayList();
        staffUserIdList.forEach(e -> {
            AppletStaffListResp resp = new AppletStaffListResp();
            AppletSpreadChannelStaff staff = (AppletSpreadChannelStaff)staffMap.get(e);
            if (staff != null) {
                int staffType = staff.getStaffType();
                String staffName = "";
                if (StaffTypeEnum.EMPLOYEE.getStatus() == staffType) {
                    staffName = (String)userNameMap.get(staff.getUserId());
                } else if (StaffTypeEnum.PART_TIME.getStatus() == staffType) {
                    staffName = staff.getUserId();
                }
                String deptName = (String)deptNumAndNameMap.get(staff.getBelongDeptId());
                if (StringUtils.isNotBlank((CharSequence)staffName)) {
                    resp.setSpreadStaffName(staffName);
                }
                if (StringUtils.isNotBlank((CharSequence)deptName)) {
                    resp.setDeptName(deptName);
                }
                resp.setStaffType(staffType);
                StaffTypeEnum staffTypeEnum = StaffTypeEnum.get(staffType);
                if (staffTypeEnum != null) {
                    resp.setStaffTypeDesc(staffTypeEnum.getDesc());
                }
                resp.setUserId(staff.getUserId());
            }
            resp.setScanCount(userSpreadCountMap.getOrDefault(e, 0));
            resp.setAddWeworkCount(addWeworkCountMap.getOrDefault(e, 0));
            resp.setIntoGroupCount(inRoomCountMap.getOrDefault(e, 0));
            resp.setBrowsePeopleCount(browsePeopleCountMap.getOrDefault(e, 0));
            respList.add(resp);
        });
        return respList;
    }

    @Override
    public List<AppletChannelListResp> channelList(AppletChannelListReq req) {
        log.info("channelList: req:{}", (Object)req);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        Long userId = currentUserInfo.getId();
        log.info("channelList: bizId:{},userId:{}", (Object)bizId, (Object)userId);
        req.validate();
        ChannelStaticQuery query = req.toQuery(bizId);
        List channelIdList = this.appletMarketingMaterialUserInfoMapper.queryChannelListByCondition(query);
        if (CollectionUtils.isEmpty((Collection)channelIdList)) {
            log.info("channelList: \u65e0\u6cd5\u67e5\u8be2\u5230\u6e20\u9053\u5217\u8868\uff0cbizId:{}, reqDto:{}", (Object)bizId, (Object)req);
            return Collections.emptyList();
        }
        if (req.getPageDto() != null) {
            int count = this.appletMarketingMaterialUserInfoMapper.countChannelListByCondition(query);
            req.getPageDto().setCount(Integer.valueOf(count));
            req.getPageDto().setCurPageCount(Integer.valueOf(channelIdList.size()));
        }
        return this.buildChannelList(bizId, channelIdList, query);
    }

    private List<AppletChannelListResp> buildChannelList(Long bizId, List<String> channelIdList, ChannelStaticQuery query) {
        query.setChannelIdList(channelIdList);
        query.setIsScan(null);
        query.setIsBrowse(NumberUtils.INTEGER_ONE);
        Map browsePeopleCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByChannel(query);
        query.setIsBrowse(null);
        query.setIsScan(NumberUtils.INTEGER_ONE);
        Map userSpreadCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByChannel(query);
        query.setIsAddFriend(NumberUtils.INTEGER_ONE);
        Map addWeworkCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByChannel(query);
        query.setIsAddFriend(null);
        query.setIsIntoGroup(NumberUtils.INTEGER_ONE);
        query.setJoinContactInfo(true);
        Map inRoomCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByChannel(query);
        Map channelIdAndNameMap = this.channelMapper.selectNameByNums(bizId, channelIdList);
        ArrayList respList = Lists.newArrayList();
        channelIdList.forEach(e -> {
            AppletChannelListResp resp = new AppletChannelListResp();
            String channelName = (String)channelIdAndNameMap.get(e);
            if (StringUtils.isNotBlank((CharSequence)channelName)) {
                resp.setChannelName(channelName);
            }
            resp.setScanCount(userSpreadCountMap.getOrDefault(e, 0));
            resp.setAddWeworkCount(addWeworkCountMap.getOrDefault(e, 0));
            resp.setIntoGroupCount(inRoomCountMap.getOrDefault(e, 0));
            resp.setBrowsePeopleCount(browsePeopleCountMap.getOrDefault(e, 0));
            respList.add(resp);
        });
        return respList;
    }

    @Override
    public void exportUserList(HttpServletResponse response, AppletUserListReq req) {
        req.setPage(false);
        List<AppletUserListResp> result = this.userList(req);
        String dateStr = DateUtil.getCurDate((String)"yyyyMMddHHmmss");
        String fileName = "\u5ba2\u6237\u6570\u636e_" + dateStr + ".xlsx";
        String sheetName = "\u5ba2\u6237\u6570\u636e";
        try {
            PojoExportExcel.doPrint(result, AppletUserListResp.class, (String)sheetName, (HttpServletResponse)response, (String)fileName);
        }
        catch (Exception e) {
            log.error("exportUserList: export error: ", (Throwable)e);
        }
    }

    @Override
    public void exportStaffList(HttpServletResponse response, AppletStaffListReq req) {
        req.setPage(false);
        List<AppletStaffListResp> result = this.staffList(req);
        String dateStr = DateUtil.getCurDate((String)"yyyyMMddHHmmss");
        String fileName = "\u5458\u5de5\u6570\u636e_" + dateStr + ".xlsx";
        String sheetName = "\u5458\u5de5\u6570\u636e";
        try {
            PojoExportExcel.doPrint(result, AppletStaffListResp.class, (String)sheetName, (HttpServletResponse)response, (String)fileName);
        }
        catch (Exception e) {
            log.error("exportStaffList: export error: ", (Throwable)e);
        }
    }

    @Override
    public void exportChannelList(HttpServletResponse response, AppletChannelListReq req) {
        req.setPage(false);
        List<AppletChannelListResp> result = this.channelList(req);
        String dateStr = DateUtil.getCurDate((String)"yyyyMMddHHmmss");
        String fileName = "\u6e20\u9053\u6570\u636e_" + dateStr + ".xlsx";
        String sheetName = "\u6e20\u9053\u6570\u636e";
        try {
            PojoExportExcel.doPrint(result, AppletChannelListResp.class, (String)sheetName, (HttpServletResponse)response, (String)fileName);
        }
        catch (Exception e) {
            log.error("exportChannelList: export error: ", (Throwable)e);
        }
    }

    @Override
    public List<UserInGroupResp> userInGroupDetail(UserInGroupReq req) {
        log.info("userInGroupDetail: req:{}", (Object)req);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        Long userId = currentUserInfo.getId();
        log.info("userInGroupDetail: bizId:{}, corpId:{}, userId:{}", new Object[]{bizId, corpId, userId});
        req.validate();
        String num = req.getNum();
        AppletMarketingMaterialUserInfo materialUserInfo = this.appletMarketingMaterialUserInfoMapper.queryByNum(bizId, num);
        if (materialUserInfo == null) {
            log.info("userInGroupDetail: \u65e0\u6cd5\u67e5\u8be2\u5230\u7528\u6237\u8bb0\u5f55, bizId:{}, num:{}", (Object)bizId, (Object)num);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        String openId = materialUserInfo.getOpenId();
        if (StringUtils.isBlank((CharSequence)openId)) {
            log.info("userInGroupDetail: \u7528\u6237openId\u4e0d\u80fd\u4e3a\u7a7a, bizId:{}, openId:{}", (Object)bizId, (Object)openId);
            return Collections.emptyList();
        }
        AppletContactInfo contactInfo = this.appletContactInfoMapper.queryContactInfo(bizId, openId);
        if (contactInfo == null) {
            log.info("userInGroupDetail: \u65e0\u6cd5\u67e5\u8be2\u5230\u7528\u6237, bizId:{}, openId:{}", (Object)bizId, (Object)openId);
            return Collections.emptyList();
        }
        String contactId = contactInfo.getContactId();
        if (StringUtils.isBlank((CharSequence)contactId)) {
            log.info("userInGroupDetail: \u8054\u7cfb\u4eba\u672a\u52a0\u597d\u53cb, bizId:{}, openId:{}", (Object)bizId, (Object)openId);
            return Collections.emptyList();
        }
        List relationList = this.weworkChatRoomRelationMapper.queryListByContactId(corpId, contactId);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            log.info("userInGroupDetail: \u65e0\u5165\u7fa4\u8bb0\u5f55, bizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return Collections.emptyList();
        }
        Set roomIdSet = relationList.stream().map(WeworkChatRoomRelation::getWeworkRoomId).collect(Collectors.toSet());
        List weworkRoomList = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, roomIdSet);
        if (CollectionUtils.isEmpty((Collection)weworkRoomList)) {
            log.info("userInGroupDetail: \u65e0\u7fa4\u8bb0\u5f55, bizId:{}, corpId:{}, roomIdSet:{}", new Object[]{bizId, corpId, roomIdSet});
            return Collections.emptyList();
        }
        Map<String, Integer> quitRoomMap = relationList.stream().collect(Collectors.toMap(WeworkChatRoomRelation::getWeworkRoomId, WeworkChatRoomRelation::getIsDeleted, (u, v) -> v));
        Set ownerSet = weworkRoomList.stream().map(WeworkChatRoom::getOwner).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Map ownerUserNameMap = this.weworkUserMapper.queryWeworkUserNameMap(corpId, ownerSet);
        ArrayList userChatRoomList = Lists.newArrayList();
        weworkRoomList.forEach(e -> {
            if (ownerUserNameMap.containsKey(e.getOwner()) && e.getIsDismiss() == 0) {
                userChatRoomList.add(e);
            }
        });
        if (CollectionUtils.isEmpty((Collection)userChatRoomList)) {
            log.info("userInGroupDetail: \u65e0\u6210\u5458\u4e3a\u7fa4\u4e3b\u7684\u7fa4\uff0c bizId:{}, corpId:{}, roomIdSet:{}", new Object[]{bizId, corpId, roomIdSet});
            return Collections.emptyList();
        }
        Map<String, WeworkChatRoom> weworkRoomMap = userChatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, it -> it));
        ArrayList respList = Lists.newArrayList();
        userChatRoomList.forEach(e -> {
            UserInGroupResp resp = new UserInGroupResp();
            WeworkChatRoom weworkChatRoom = (WeworkChatRoom)weworkRoomMap.get(e.getWeworkRoomId());
            if (weworkChatRoom != null) {
                resp.setRoomName(weworkChatRoom.getName());
                resp.setRoomOwner((String)ownerUserNameMap.get(weworkChatRoom.getOwner()));
            }
            int status = IntoGroupStatusEnum.JOIN_GROUP.getValue();
            Integer isDeleted = (Integer)quitRoomMap.get(e.getWeworkRoomId());
            if (isDeleted != null && isDeleted == 1) {
                status = IntoGroupStatusEnum.QUIT_GROUP.getValue();
            }
            resp.setStatus(status);
            IntoGroupStatusEnum intoGroupStatusEnum = IntoGroupStatusEnum.get(status);
            if (intoGroupStatusEnum != null) {
                resp.setStatusDesc(intoGroupStatusEnum.getDesc());
            }
            respList.add(resp);
        });
        return respList;
    }

    @Override
    public AppletCountResp spreadStatistic(AppletCountReq req) {
        log.info("userInGroupDetail: req:{}", (Object)req);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        Long userId = currentUserInfo.getId();
        log.info("userInGroupDetail: bizId:{}, userId:{}", (Object)bizId, (Object)userId);
        req.validate();
        String materialId = req.getMaterialId();
        AppletStaticQuery query = new AppletStaticQuery();
        query.setBizId(bizId);
        query.setMaterialIds((Set)Sets.newHashSet((Object[])new String[]{materialId}));
        Integer browseCount = (Integer)this.appletMarketingMaterialUserInfoMapper.countBrowseCountMaterialIds(query).get(materialId);
        query.setIsBrowse(NumberUtils.INTEGER_ONE);
        Integer browsePeopleCount = (Integer)this.appletMarketingMaterialUserInfoMapper.countUserByMaterialIds(query).get(materialId);
        query.setIsBrowse(null);
        query.setIsScan(NumberUtils.INTEGER_ONE);
        Integer userSpreadCount = (Integer)this.appletMarketingMaterialUserInfoMapper.countUserByMaterialIds(query).get(materialId);
        query.setIsAddFriend(NumberUtils.INTEGER_ONE);
        Integer addWeworkCount = (Integer)this.appletMarketingMaterialUserInfoMapper.countUserByMaterialIds(query).get(materialId);
        query.setIsAddFriend(null);
        query.setIsIntoGroup(NumberUtils.INTEGER_ONE);
        query.setJoinContactInfo(true);
        Integer inRoomCount = (Integer)this.appletMarketingMaterialUserInfoMapper.countUserByMaterialIds(query).get(materialId);
        AppletCountResp resp = new AppletCountResp();
        resp.setScanCount(userSpreadCount);
        resp.setAddWeworkCount(addWeworkCount);
        resp.setIntoGroupCount(inRoomCount);
        resp.setBrowsePeopleCount(browsePeopleCount);
        resp.setBrowseCount(browseCount);
        return resp;
    }

    @Override
    public Map<String, AppletCountResp> spreadStatisticByMaterialIds(Set<String> materialIds) {
        log.info("spreadStatisticByMaterialIds: req:{}", materialIds);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        AppletStaticQuery query = new AppletStaticQuery();
        query.setBizId(bizId);
        query.setMaterialIds((Set)Sets.newHashSet(materialIds));
        Map materialId2BrowseCountMap = this.appletMarketingMaterialUserInfoMapper.countBrowseCountMaterialIds(query);
        query.setIsBrowse(NumberUtils.INTEGER_ONE);
        Map materialId2BrowsePeopleCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByMaterialIds(query);
        query.setIsBrowse(null);
        query.setIsScan(NumberUtils.INTEGER_ONE);
        Map materialId2UserSpreadCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByMaterialIds(query);
        query.setIsAddFriend(NumberUtils.INTEGER_ONE);
        Map materialId2AddWeworkCountMap = this.appletMarketingMaterialUserInfoMapper.countUserByMaterialIds(query);
        query.setIsAddFriend(null);
        query.setIsIntoGroup(NumberUtils.INTEGER_ONE);
        query.setJoinContactInfo(true);
        Map materialId2InRoomCount = this.appletMarketingMaterialUserInfoMapper.countUserByMaterialIds(query);
        HashMap result = Maps.newHashMap();
        materialIds.forEach(materialId -> {
            AppletCountResp resp = new AppletCountResp();
            resp.setBrowseCount(materialId2BrowseCountMap.getOrDefault(materialId, NumberUtils.INTEGER_ZERO));
            resp.setAddWeworkCount(materialId2AddWeworkCountMap.getOrDefault(materialId, NumberUtils.INTEGER_ZERO));
            resp.setBrowsePeopleCount(materialId2BrowsePeopleCountMap.getOrDefault(materialId, NumberUtils.INTEGER_ZERO));
            resp.setIntoGroupCount(materialId2InRoomCount.getOrDefault(materialId, NumberUtils.INTEGER_ZERO));
            resp.setScanCount(materialId2UserSpreadCountMap.getOrDefault(materialId, NumberUtils.INTEGER_ZERO));
            result.put(materialId, resp);
        });
        return result;
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((currentUserInfo.getBizId() != null ? 1 : 0) != 0, (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private Map<String, WeworkContactRelation> getWeworkContactRelation(String corpId, Set<String> contactIds, Map<String, String> weworkUserNum2IdMap) {
        if (CollectionUtils.isEmpty(contactIds) || Objects.isNull(weworkUserNum2IdMap)) {
            return Maps.newHashMap();
        }
        Collection<String> weworkUserIds = weworkUserNum2IdMap.values();
        List contactRelations = this.weworkContactRelationMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, contactIds, weworkUserIds);
        Map<Object, Object> contactId2RelationMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)contactRelations)) {
            contactId2RelationMap = contactRelations.stream().filter(a -> Objects.nonNull(a.getIsDeleted()) && a.getIsDeleted() == 0).collect(Collectors.toMap(it -> this.buildKey(it.getWeworkUserId(), it.getContactId()), a -> a, (k, v) -> v));
        }
        return contactId2RelationMap;
    }

    private String buildKey(String key, String value) {
        return key + "_" + value;
    }
}

