/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerToken;
import cn.kinyun.scrm.weixin.sdk.entity.component.PreAuthCode;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.resp.auth.GetAuthUrlResp;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppletAccessTokenServiceImpl
implements AppletAccessTokenService {
    private static final Logger log = LoggerFactory.getLogger(AppletAccessTokenServiceImpl.class);
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-mp}")
    private String hostName;
    @Resource
    private IdGen idGen;

    @Override
    public String getAccessToken(String appId) {
        log.info("get access token, appId={}", (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null!");
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        if (appletInfo == null) {
            log.error("\u5c0f\u5546\u5e97\u672a\u6388\u6743\uff0cappId={}", (Object)appId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u5546\u5e97\u672a\u6388\u6743");
        }
        if (appletInfo.getAuthStatus() == 0) {
            log.error("\u5c0f\u5546\u5e97\u5df2\u7ecf\u53d6\u6d88\u6388\u6743\uff0cappId={}", (Object)appId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u5546\u5e97\u5df2\u7ecf\u53d6\u6d88\u6388\u6743");
        }
        Date expireTime = DateUtils.addMinutes((Date)new Date(), (int)15);
        if (StringUtils.isNotBlank((CharSequence)appletInfo.getAccessToken()) && expireTime.before(appletInfo.getTokenExpireTime())) {
            return appletInfo.getAccessToken();
        }
        return this.refreshAccessToken(appletInfo);
    }

    private String refreshAccessToken(AppletInfo appletInfo) {
        log.info("refresh access_token with params={}", (Object)appletInfo);
        String appId = appletInfo.getAppId();
        String refreshToken = appletInfo.getRefreshToken();
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        AuthorizerToken authInfo = this.componentAuthAPI.refreshAuthorizerToken(componentAccessToken, this.componentAppId, appId, refreshToken);
        Date now = new Date();
        appletInfo.setAccessToken(authInfo.getAuthorizerAccessToken());
        appletInfo.setRefreshToken(authInfo.getAuthorizerRefreshToken());
        appletInfo.setTokenExpireTime(DateUtils.addSeconds((Date)now, (int)authInfo.getExpires()));
        appletInfo.setUpdateTime(now);
        this.appletInfoMapper.updateByPrimaryKeySelective((Object)appletInfo);
        return appletInfo.getAccessToken();
    }

    @Override
    public String getShopAuthUrl() {
        String authCode;
        log.info("getShopAuthUrl");
        try {
            String accessToken = this.componentTokenService.getComponentAccessToken();
            PreAuthCode preAuthCode = this.componentAuthAPI.preAuthCode(accessToken, this.componentAppId);
            authCode = preAuthCode.getPreAuthCode();
            log.info("get component pre auth code={}", (Object)authCode);
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
        String redirectUri = this.hostName + "/shop/" + LoginUtils.getCurrentUserBizId() + "/auth.json";
        log.info("redirectUri={}", (Object)redirectUri);
        return this.componentAuthAPI.bindcomponent(this.componentAppId, authCode, redirectUri, 2);
    }

    private String buildAuthUrl(String appletId) {
        String authCode;
        try {
            String accessToken = this.componentTokenService.getComponentAccessToken();
            PreAuthCode preAuthCode = this.componentAuthAPI.preAuthCode(accessToken, this.componentAppId);
            authCode = preAuthCode.getPreAuthCode();
            log.info("get component pre auth code={}", (Object)authCode);
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
        String redirectUri = this.hostName + "/applet/" + LoginUtils.getCurrentUserBizId() + "/" + appletId + "/authCallback.json";
        log.info("redirectUri={}", (Object)redirectUri);
        return this.componentAuthAPI.bindcomponent(this.componentAppId, authCode, redirectUri, 2);
    }

    @Override
    public GetAuthUrlResp getAuthUrl() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        int businessType = AppletUseBusinessType.MARKETING_MATERIAL.getType();
        GetAuthUrlResp resp = new GetAuthUrlResp();
        AppletInfo select = new AppletInfo();
        select.setBizId(currentUser.getBizId());
        select.setAppId("-1");
        AppletInfo appletInfo = (AppletInfo)this.appletInfoMapper.selectOne((Object)select);
        String appletId = appletInfo != null ? appletInfo.getNum() : this.insertAppletInfo(businessType, currentUser);
        String authUrl = this.buildAuthUrl(appletId);
        resp.setAppletId(appletId);
        resp.setAuthUrl(authUrl);
        return resp;
    }

    private String insertAppletInfo(Integer businessType, CurrentUserInfo currentUser) {
        AppletInfo appletInfo = new AppletInfo();
        appletInfo.setNum(this.idGen.getNum());
        appletInfo.setBizId(currentUser.getBizId());
        appletInfo.setCorpId(currentUser.getCorpId());
        appletInfo.setAppId("-1");
        appletInfo.setBusinessType(businessType);
        appletInfo.setCreateTime(new Date());
        appletInfo.setCreateBy(currentUser.getId());
        this.appletInfoMapper.insertSelective((Object)appletInfo);
        return appletInfo.getNum();
    }
}

