/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.app.center.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.kuaike.scrm.common.dto.AreaDto;
import com.kuaike.scrm.common.enums.applet.AppletLevelConfigTypeEnum;
import com.kuaike.scrm.common.service.AppInstallService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.applet.entity.AppletLevelConfig;
import com.kuaike.scrm.dal.applet.mapper.AppletLevelConfigMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppletShopInstallServiceImpl
implements AppInstallService {
    private static final Logger log = LoggerFactory.getLogger(AppletShopInstallServiceImpl.class);
    @Value(value="${app.appletShop.appCode}")
    private String appCode;
    @Value(value="${scrm.applet.categorySetting.default}")
    private String categorySettingDefault;
    @Value(value="${scrm.applet.areaSetting.default}")
    private String areaSettingDefault;
    @Resource
    private IdGen idGen;
    @Resource
    private AppletLevelConfigMapper appletLevelConfigMapper;

    public String getAppCode() {
        return this.appCode;
    }

    public void install(AppBindings binding) {
        log.info("AppletShopInstallService, install, binding:{}", (Object)binding);
        Date now = new Date();
        Long bizId = binding.getBizId();
        if (!binding.getCreateTime().equals(binding.getUpdateTime())) {
            return;
        }
        String[] split = this.categorySettingDefault.split(",");
        ArrayList<AppletLevelConfig> addList = new ArrayList<AppletLevelConfig>();
        for (int i = 0; i < split.length; ++i) {
            String name = split[i];
            AppletLevelConfig config = this.buildAppletLevelConfig(this.idGen.getNum(), "0", now, bizId, name, "", "1", AppletLevelConfigTypeEnum.CATEGORY, i + 1);
            addList.add(config);
        }
        List areaDtos = JSONObject.parseArray((String)this.areaSettingDefault, AreaDto.class);
        for (int i = 0; i < areaDtos.size(); ++i) {
            AreaDto areaDto = (AreaDto)areaDtos.get(i);
            String pNum = this.idGen.getNum();
            AppletLevelConfig config = this.buildAppletLevelConfig(pNum, "0", now, bizId, areaDto.getLabel(), areaDto.getValue(), areaDto.getLevel(), AppletLevelConfigTypeEnum.AREA, i + 1);
            addList.add(config);
            List children = areaDto.getChildren();
            for (int i1 = 0; i1 < children.size(); ++i1) {
                AreaDto child = (AreaDto)children.get(i1);
                AppletLevelConfig childConfig = this.buildAppletLevelConfig(this.idGen.getNum(), pNum, now, bizId, child.getLabel(), child.getValue(), child.getLevel(), AppletLevelConfigTypeEnum.AREA, i1 + 1);
                addList.add(childConfig);
            }
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            this.appletLevelConfigMapper.batchInsert(addList);
        }
    }

    private AppletLevelConfig buildAppletLevelConfig(String num, String pNum, Date now, Long bizId, String name, String value, String level, AppletLevelConfigTypeEnum typeEnum, Integer sort) {
        AppletLevelConfig config = new AppletLevelConfig();
        config.setpNum(pNum);
        config.setNum(num);
        config.setBizId(bizId);
        config.setType(Integer.valueOf(typeEnum.getType()));
        config.setName(name);
        config.setValue(value);
        config.setCreateTime(now);
        config.setCreateBy(Long.valueOf(-1L));
        config.setSort(sort);
        config.setLevel(level);
        return config;
    }

    public void update(AppBindings binding) {
        log.info("binding:{}", (Object)binding);
    }

    public void uninstall(AppBindings binding) {
        log.info("binding:{}", (Object)binding);
    }
}

