/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.acquisition.service.impl;

import cn.kinyun.wework.sdk.api.external.CustomerAcquisitionClient;
import cn.kinyun.wework.sdk.callback.corp.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelFollowUser;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionContact;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionContactList;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionLink;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionLinkReq;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionLinkResp;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionQuota;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionRange;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.acquisition.dto.AcquisitionDto;
import com.kuaike.scrm.acquisition.dto.CreateLinkReq;
import com.kuaike.scrm.acquisition.dto.LinkDto;
import com.kuaike.scrm.acquisition.dto.LinkFriendDetailReq;
import com.kuaike.scrm.acquisition.dto.LinkFriendDetailResp;
import com.kuaike.scrm.acquisition.dto.LinkLevelReq;
import com.kuaike.scrm.acquisition.dto.LinkListReq;
import com.kuaike.scrm.acquisition.dto.LinkQuotaDto;
import com.kuaike.scrm.acquisition.service.WeworkAcquisitionService;
import com.kuaike.scrm.addfriend.dto.WelcomeDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdName;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.dto.WeworkCustomerAcquisitionEvent;
import com.kuaike.scrm.common.enums.AddWeworkStatusEnum;
import com.kuaike.scrm.common.enums.LinkTypeEnum;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.customeracquisition.dto.QueryFriendDetail;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisition;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionClickRecord;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionDept;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionJoinRecord;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionLink;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionMember;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionShareRecord;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionClickRecordMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionDeptMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionJoinRecordMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionLinkMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionMemberMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionShareRecordMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.sms.entity.SmsTaskDetail;
import com.kuaike.scrm.dal.sms.mapper.SmsTaskDetailMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkPair;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WeworkAcquisitionServiceImpl
implements WeworkAcquisitionService {
    private static final Logger log = LoggerFactory.getLogger(WeworkAcquisitionServiceImpl.class);
    @Autowired
    private WeworkCustomerAcquisitionMapper weworkCustomerAcquisitionMapper;
    @Autowired
    private WeworkCustomerAcquisitionLinkMapper weworkCustomerAcquisitionLinkMapper;
    @Autowired
    private WeworkCustomerAcquisitionDeptMapper weworkCustomerAcquisitionDeptMapper;
    @Autowired
    private WeworkCustomerAcquisitionMemberMapper weworkCustomerAcquisitionMemberMapper;
    @Autowired
    private WeworkCustomerAcquisitionJoinRecordMapper weworkCustomerAcquisitionJoinRecordMapper;
    @Autowired
    private CustomerAcquisitionClient customerAcquisitionClient;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private IdGen idGen;
    @Resource
    private WeworkCustomerAcquisitionShareRecordMapper weworkCustomerAcquisitionShareRecordMapper;
    @Resource
    private WeworkCustomerAcquisitionClickRecordMapper weworkCustomerAcquisitionClickRecordMapper;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private SmsTaskDetailMapper smsTaskDetailMapper;
    @Autowired
    private SettingService settingService;
    @Resource
    private KafkaClientUtils kafkaClientUtils;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService threadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(2048), (ThreadFactory)new NamedThreadFactory("weworkAcquisitionService"), new ThreadPoolExecutor.CallerRunsPolicy());
    @Value(value="${kafka.topic.wework_customer_acquisition_event}")
    private String customerAcquisitionTopic;
    private static final String CUSTOMER_STATE = "?customer_channel=";

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.threadPool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createLink(CreateLinkReq req) {
        log.info("create link req: {}", (Object)req);
        req.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        WeworkCustomerAcquisition acquisition = this.createAcquisition(req);
        ArrayList weworkUserIds = Lists.newArrayList();
        ArrayList deptIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(req.getMemberList())) {
            Map weworkUserIdMap = this.weworkUserMapper.queryWeworkUserIdMapByNums(req.getMemberList());
            weworkUserIds.addAll(weworkUserIdMap.values());
        }
        if (CollectionUtils.isNotEmpty(req.getDeptList())) {
            Set deptIdSet = this.organizationMapper.queryDepartmentIdsByNum(bizId, req.getDeptList());
            deptIds.addAll(deptIdSet);
        }
        if (req.getLinkType().intValue() == LinkTypeEnum.MANY_TO_LINK.getValue()) {
            WeworkCustomerAcquisitionLink acquisitionLink = this.buildAcquisitionLink(acquisition);
            this.createAcquisitionLink(acquisitionLink, weworkUserIds, deptIds);
            this.weworkCustomerAcquisitionLinkMapper.insert((Object)acquisitionLink);
            this.saveWeworkAcquisitionLinkDept(acquisitionLink, deptIds);
            this.saveWeworkAcquisitionLinkMem(acquisitionLink, weworkUserIds);
        } else if (req.getLinkType().intValue() == LinkTypeEnum.ONE_TO_LINK.getValue()) {
            HashSet allWeworkUserIds = new HashSet();
            if (CollectionUtils.isNotEmpty((Collection)weworkUserIds)) {
                allWeworkUserIds.addAll(weworkUserIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)deptIds)) {
                Set deptOfUserIds = this.weworkDepartmentUserMapper.selectWeworkUserId(corpId, (Collection)deptIds);
                allWeworkUserIds.addAll(deptOfUserIds);
            }
            if (CollectionUtils.isEmpty(allWeworkUserIds)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u627e\u4e0d\u5230\u8981\u521b\u5efa\u6210\u5458");
            }
            for (String weworkUserId : allWeworkUserIds) {
                WeworkCustomerAcquisitionLink acquisitionLink = this.buildAcquisitionLink(acquisition);
                this.createAcquisitionLink(acquisitionLink, Lists.newArrayList((Object[])new String[]{weworkUserId}), Lists.newArrayList());
                this.weworkCustomerAcquisitionLinkMapper.insert((Object)acquisitionLink);
                this.saveWeworkAcquisitionLinkMem(acquisitionLink, Lists.newArrayList((Object[])new String[]{weworkUserId}));
            }
        }
        return acquisition.getNum();
    }

    private WeworkCustomerAcquisition createAcquisition(CreateLinkReq req) {
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long opUserId = LoginUtils.getCurrentUserId();
        Date currTime = new Date();
        WeworkCustomerAcquisition weworkCustomerAcquisition = new WeworkCustomerAcquisition();
        weworkCustomerAcquisition.setBizId(bizId);
        weworkCustomerAcquisition.setNum(this.idGen.getNum());
        weworkCustomerAcquisition.setLinkType(req.getLinkType());
        weworkCustomerAcquisition.setLinkName(req.getName());
        weworkCustomerAcquisition.setSkipVerify(req.getSkipVerify());
        weworkCustomerAcquisition.setCreateBy(opUserId);
        weworkCustomerAcquisition.setUpdateBy(opUserId);
        weworkCustomerAcquisition.setCreateTime(currTime);
        weworkCustomerAcquisition.setUpdateTime(currTime);
        weworkCustomerAcquisition.setIsDeleted(Integer.valueOf(0));
        weworkCustomerAcquisition.setAddFriendRemark(req.getAddFriendRemark());
        weworkCustomerAcquisition.setWelcomeContent(JSONObject.toJSONString((Object)req.getAddFriendWelcome()));
        if (req.getTags() != null) {
            String tagIds = req.getTags().stream().map(StrIdAndNameDto::getId).collect(Collectors.joining(","));
            weworkCustomerAcquisition.setTagIds(tagIds);
        }
        this.weworkCustomerAcquisitionMapper.insert((Object)weworkCustomerAcquisition);
        return weworkCustomerAcquisition;
    }

    private WeworkCustomerAcquisitionLink buildAcquisitionLink(WeworkCustomerAcquisition acquisition) {
        Long opUserId = LoginUtils.getCurrentUserId();
        Date currTime = new Date();
        WeworkCustomerAcquisitionLink weworkCustomerAcquisitionLink = new WeworkCustomerAcquisitionLink();
        weworkCustomerAcquisitionLink.setBizId(acquisition.getBizId());
        weworkCustomerAcquisitionLink.setNum(this.idGen.getNum());
        weworkCustomerAcquisitionLink.setCustomerAcquisitionId(acquisition.getId());
        weworkCustomerAcquisitionLink.setLinkName(acquisition.getLinkName());
        weworkCustomerAcquisitionLink.setSkipVerify(acquisition.getSkipVerify());
        weworkCustomerAcquisitionLink.setStatus(Integer.valueOf(0));
        weworkCustomerAcquisitionLink.setClickCount(Long.valueOf(0L));
        weworkCustomerAcquisitionLink.setIsDeleted(Integer.valueOf(0));
        weworkCustomerAcquisitionLink.setCreateBy(opUserId);
        weworkCustomerAcquisitionLink.setUpdateBy(opUserId);
        weworkCustomerAcquisitionLink.setCreateTime(currTime);
        weworkCustomerAcquisitionLink.setUpdateTime(currTime);
        return weworkCustomerAcquisitionLink;
    }

    private void saveWeworkAcquisitionLinkDept(WeworkCustomerAcquisitionLink acquisitionLink, List<Integer> deptIds) {
        ArrayList inserts = Lists.newArrayList();
        List existList = this.weworkCustomerAcquisitionDeptMapper.queryLinkRelDeptList(acquisitionLink.getBizId(), acquisitionLink.getCustomerAcquisitionId(), acquisitionLink.getId());
        HashMap map = Maps.newHashMap();
        for (Object acquisitionDept : existList) {
            map.put(acquisitionDept.getWeworkDepartmentId(), acquisitionDept);
        }
        ArrayList insertDeptIds = Lists.newArrayList();
        for (Integer deptId : deptIds) {
            if (!map.containsKey(deptId)) {
                insertDeptIds.add(deptId);
                continue;
            }
            map.remove(deptId);
        }
        for (Integer insertDeptId : insertDeptIds) {
            WeworkCustomerAcquisitionDept acquisitionDept = new WeworkCustomerAcquisitionDept();
            acquisitionDept.setBizId(acquisitionLink.getBizId());
            acquisitionDept.setNum(this.idGen.getNum());
            acquisitionDept.setCustomerAcquisitionId(acquisitionLink.getCustomerAcquisitionId());
            acquisitionDept.setCustomerAcquisitionLinkId(acquisitionLink.getId());
            acquisitionDept.setWeworkDepartmentId(insertDeptId);
            acquisitionDept.setCreateBy(acquisitionLink.getCreateBy());
            acquisitionDept.setUpdateBy(acquisitionLink.getUpdateBy());
            acquisitionDept.setCreateTime(acquisitionLink.getCreateTime());
            acquisitionDept.setUpdateTime(acquisitionLink.getUpdateTime());
            acquisitionDept.setIsDeleted(Integer.valueOf(0));
            inserts.add(acquisitionDept);
        }
        if (CollectionUtils.isNotEmpty((Collection)inserts)) {
            this.weworkCustomerAcquisitionDeptMapper.batchInsert((List)inserts);
        }
        if (MapUtils.isNotEmpty((Map)map)) {
            List delIds = map.values().stream().map(it -> it.getId()).collect(Collectors.toList());
            this.weworkCustomerAcquisitionDeptMapper.batchDel(delIds);
        }
    }

    private void saveWeworkAcquisitionLinkMem(WeworkCustomerAcquisitionLink acquisitionLink, List<String> weworkUserIds) {
        ArrayList inserts = Lists.newArrayList();
        List existList = this.weworkCustomerAcquisitionMemberMapper.queryLinkRelMemList(acquisitionLink.getBizId(), acquisitionLink.getCustomerAcquisitionId(), acquisitionLink.getId());
        HashMap map = Maps.newHashMap();
        for (Object acquisitionMember : existList) {
            map.put(acquisitionMember.getWeworkUserId(), acquisitionMember);
        }
        ArrayList insertWeworkUserIds = Lists.newArrayList();
        for (String weworkUserId : weworkUserIds) {
            if (!map.containsKey(weworkUserId)) {
                insertWeworkUserIds.add(weworkUserId);
                continue;
            }
            map.remove(weworkUserId);
        }
        for (String insertWeworkUserId : insertWeworkUserIds) {
            WeworkCustomerAcquisitionMember acquisitionMember = new WeworkCustomerAcquisitionMember();
            acquisitionMember.setBizId(acquisitionLink.getBizId());
            acquisitionMember.setNum(this.idGen.getNum());
            acquisitionMember.setCustomerAcquisitionId(acquisitionLink.getCustomerAcquisitionId());
            acquisitionMember.setCustomerAcquisitionLinkId(acquisitionLink.getId());
            acquisitionMember.setWeworkUserId(insertWeworkUserId);
            acquisitionMember.setCreateBy(acquisitionLink.getCreateBy());
            acquisitionMember.setUpdateBy(acquisitionLink.getUpdateBy());
            acquisitionMember.setCreateTime(acquisitionLink.getCreateTime());
            acquisitionMember.setUpdateTime(acquisitionLink.getUpdateTime());
            acquisitionMember.setIsDeleted(Integer.valueOf(0));
            inserts.add(acquisitionMember);
        }
        if (CollectionUtils.isNotEmpty((Collection)inserts)) {
            this.weworkCustomerAcquisitionMemberMapper.batchInsert((List)inserts);
        }
        if (MapUtils.isNotEmpty((Map)map)) {
            List delIds = map.values().stream().map(it -> it.getId()).collect(Collectors.toList());
            this.weworkCustomerAcquisitionMemberMapper.batchDel(delIds);
        }
    }

    private void createAcquisitionLink(WeworkCustomerAcquisitionLink acquisitionLink, List<String> weworkUserIds, List<Integer> deptIds) {
        Long timestamp = System.currentTimeMillis();
        String corpId = LoginUtils.getCurrentUserCorpId();
        CustomerAcquisitionLinkReq req = new CustomerAcquisitionLinkReq();
        req.setLinkName(acquisitionLink.getLinkName());
        req.setSkipVerify(Boolean.valueOf(acquisitionLink.getSkipVerify() == 1));
        CustomerAcquisitionRange range = new CustomerAcquisitionRange();
        range.setUserList(weworkUserIds);
        range.setDepartmentList(deptIds);
        req.setRange(range);
        try {
            CustomerAcquisitionLinkResp linkResp = this.customerAcquisitionClient.createLink(corpId, req);
            Long endTimestamp = System.currentTimeMillis();
            log.info("request qiwei api cost: {} ms", (Object)(endTimestamp - timestamp));
            if (linkResp != null && linkResp.getErrCode() == 0) {
                CustomerAcquisitionLink link = linkResp.getLink();
                acquisitionLink.setLinkId(link.getLinkId());
                acquisitionLink.setLinkUrl(link.getUrl());
                acquisitionLink.setStatus(Integer.valueOf(1));
            }
        }
        catch (WeworkException e) {
            log.error("error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u68c0\u67e5\u4f01\u5fae\u63a5\u53e3\u6743\u9650");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteLink(String linkId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)linkId), (Object)"\u83b7\u5ba2\u94fe\u63a5id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Date curTime = new Date();
        WeworkCustomerAcquisitionLink acquisitionLink = new WeworkCustomerAcquisitionLink();
        acquisitionLink.setNum(linkId);
        acquisitionLink = (WeworkCustomerAcquisitionLink)this.weworkCustomerAcquisitionLinkMapper.selectOne((Object)acquisitionLink);
        Preconditions.checkArgument((acquisitionLink != null ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u83b7\u5ba2\u94fe\u63a5");
        acquisitionLink.setIsDeleted(Integer.valueOf(1));
        acquisitionLink.setUpdateBy(userInfo.getId());
        acquisitionLink.setUpdateTime(curTime);
        this.weworkCustomerAcquisitionLinkMapper.updateByPrimaryKeySelective((Object)acquisitionLink);
        List linkList = this.weworkCustomerAcquisitionLinkMapper.queryByAcquisitionIds(acquisitionLink.getBizId(), (Collection)Lists.newArrayList((Object[])new Long[]{acquisitionLink.getCustomerAcquisitionId()}));
        if (CollectionUtils.isEmpty((Collection)linkList)) {
            WeworkCustomerAcquisition acquisition = new WeworkCustomerAcquisition();
            acquisition.setId(acquisitionLink.getCustomerAcquisitionId());
            acquisition.setIsDeleted(Integer.valueOf(1));
            acquisition.setUpdateBy(userInfo.getId());
            acquisition.setUpdateTime(curTime);
            this.weworkCustomerAcquisitionMapper.updateByPrimaryKeySelective((Object)acquisition);
        }
        try {
            this.customerAcquisitionClient.deleteLink(userInfo.getCorpId(), acquisitionLink.getLinkId());
        }
        catch (WeworkException e) {
            log.error("error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u68c0\u67e5\u63a5\u53e3\u6743\u9650");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editLink(CreateLinkReq req) {
        String tagIds;
        log.info("edit link req: {}", (Object)req);
        req.validateEdit();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        WeworkCustomerAcquisitionLink acquisitionLink = new WeworkCustomerAcquisitionLink();
        acquisitionLink.setNum(req.getId());
        acquisitionLink = (WeworkCustomerAcquisitionLink)this.weworkCustomerAcquisitionLinkMapper.selectOne((Object)acquisitionLink);
        Preconditions.checkArgument((acquisitionLink != null ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u83b7\u5ba2\u94fe\u63a5");
        WeworkCustomerAcquisition acquisition = (WeworkCustomerAcquisition)this.weworkCustomerAcquisitionMapper.selectByPrimaryKey((Object)acquisitionLink.getCustomerAcquisitionId());
        if (acquisition.getLinkType().intValue() == LinkTypeEnum.ONE_TO_LINK.getValue()) {
            Preconditions.checkArgument((CollectionUtils.isNotEmpty(req.getMemberList()) && req.getMemberList().size() == 1 ? 1 : 0) != 0, (Object)"\u4e00\u94fe\u4e00\u4eba\u65f6\u5019\u7f16\u8f91\u9009\u4eba\u662f\u5355\u4e2a\u6210\u5458");
            Preconditions.checkArgument((boolean)CollectionUtils.isEmpty(req.getDeptList()), (Object)"\u4e00\u94fe\u4e00\u4eba\u7684\u65f6\u5019\u7f16\u8f91\u4e0d\u80fd\u9009\u90e8\u95e8");
        }
        boolean update = false;
        if (!Objects.equals(req.getName(), acquisitionLink.getLinkName())) {
            update = true;
        }
        if (!Objects.equals(req.getSkipVerify(), acquisitionLink.getSkipVerify())) {
            update = true;
        }
        if (!Objects.equals(req.getAddFriendRemark(), acquisition.getAddFriendRemark())) {
            update = true;
        }
        if (req.getAddFriendWelcome() != null && !Objects.equals(JSONObject.toJSONString((Object)req.getAddFriendWelcome()), acquisition.getWelcomeContent())) {
            update = true;
        }
        if ((CollectionUtils.isNotEmpty(req.getTags()) || StringUtils.isNotBlank((CharSequence)acquisition.getTagIds())) && !Objects.equals(tagIds = req.getTags().stream().map(StrIdAndNameDto::getId).collect(Collectors.joining(",")), acquisition.getTagIds())) {
            update = true;
        }
        ArrayList weworkUserIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(req.getMemberList())) {
            Map weworkUserIdMap = this.weworkUserMapper.queryWeworkUserIdMapByNums(req.getMemberList());
            weworkUserIds.addAll(weworkUserIdMap.values());
        }
        ArrayList<Integer> deptIds = new ArrayList<Integer>();
        if (CollectionUtils.isNotEmpty(req.getDeptList())) {
            Set deptIdSet = this.organizationMapper.queryDepartmentIdsByNum(userInfo.getBizId(), req.getDeptList());
            deptIds.addAll(deptIdSet);
        }
        if (update) {
            acquisition.setLinkName(req.getName());
            acquisition.setSkipVerify(req.getSkipVerify());
            acquisition.setUpdateTime(new Date());
            acquisition.setUpdateBy(userInfo.getId());
            acquisition.setAddFriendRemark(req.getAddFriendRemark());
            acquisition.setWelcomeContent(JSONObject.toJSONString((Object)req.getAddFriendWelcome()));
            if (CollectionUtils.isNotEmpty(req.getTags())) {
                String tagIds2 = req.getTags().stream().map(StrIdAndNameDto::getId).collect(Collectors.joining(","));
                acquisition.setTagIds(tagIds2);
            } else if (CollectionUtils.isEmpty(req.getTags()) && StringUtils.isNotBlank((CharSequence)acquisition.getTagIds())) {
                acquisition.setTagIds("");
            }
            this.weworkCustomerAcquisitionMapper.updateByPrimaryKeySelective((Object)acquisition);
        }
        boolean bl = update = update || this.diff(acquisitionLink, weworkUserIds, deptIds);
        if (update) {
            acquisitionLink.setLinkName(req.getName());
            acquisitionLink.setSkipVerify(req.getSkipVerify());
            acquisitionLink.setUpdateTime(new Date());
            acquisitionLink.setUpdateBy(userInfo.getId());
            this.weworkCustomerAcquisitionLinkMapper.updateByPrimaryKeySelective((Object)acquisitionLink);
            CustomerAcquisitionLinkReq linkReq = new CustomerAcquisitionLinkReq();
            linkReq.setLinkId(acquisitionLink.getLinkId());
            linkReq.setLinkName(req.getName());
            linkReq.setSkipVerify(Boolean.valueOf(req.getSkipVerify() == 1));
            CustomerAcquisitionRange range = new CustomerAcquisitionRange();
            range.setUserList((List)weworkUserIds);
            range.setDepartmentList(deptIds);
            linkReq.setRange(range);
            try {
                this.customerAcquisitionClient.updateLink(userInfo.getCorpId(), linkReq);
            }
            catch (WeworkException e) {
                log.error("error: ", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u68c0\u67e5\u63a5\u53e3\u6743\u9650");
            }
            this.saveWeworkAcquisitionLinkMem(acquisitionLink, weworkUserIds);
            this.saveWeworkAcquisitionLinkDept(acquisitionLink, deptIds);
        }
    }

    private boolean diff(WeworkCustomerAcquisitionLink acquisitionLink, List<String> weworkUserIds, List<Integer> deptIds) {
        List deptExistsList = this.weworkCustomerAcquisitionDeptMapper.queryLinkRelDeptList(acquisitionLink.getBizId(), acquisitionLink.getCustomerAcquisitionId(), acquisitionLink.getId());
        List memExistList = this.weworkCustomerAcquisitionMemberMapper.queryLinkRelMemList(acquisitionLink.getBizId(), acquisitionLink.getCustomerAcquisitionId(), acquisitionLink.getId());
        Set<Object> existWeworkUserIds = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)memExistList)) {
            existWeworkUserIds = memExistList.stream().map(WeworkCustomerAcquisitionMember::getWeworkUserId).collect(Collectors.toSet());
        }
        Set<Object> existDeptIds = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)deptExistsList)) {
            existDeptIds = deptExistsList.stream().map(WeworkCustomerAcquisitionDept::getWeworkDepartmentId).collect(Collectors.toSet());
        }
        return !CollectionUtils.isEqualCollection(weworkUserIds, existWeworkUserIds) || !CollectionUtils.isEqualCollection(deptIds, existDeptIds);
    }

    @Override
    public List<LinkDto> linkList(LinkListReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        List list = new ArrayList();
        if (req.getPageDto() != null) {
            PageDto pageDto = req.getPageDto();
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.weworkCustomerAcquisitionLinkMapper.queryLinkList(bizId, req.getName()));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            list = page.getResult();
        }
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        Set acquisitionIds = list.stream().map(it -> it.getCustomerAcquisitionId()).collect(Collectors.toSet());
        Set<Long> acquisitionLinkIds = list.stream().map(it -> it.getId()).collect(Collectors.toSet());
        List acquisitionList = this.weworkCustomerAcquisitionMapper.queryIds(acquisitionIds);
        HashMap acquisitionMap = Maps.newHashMap();
        HashSet<String> tagIdsSet = new HashSet<String>();
        for (WeworkCustomerAcquisition acquisition : acquisitionList) {
            String[] split;
            acquisitionMap.put(acquisition.getId(), acquisition);
            String tagIds = acquisition.getTagIds();
            if (StringUtils.isBlank((CharSequence)tagIds)) continue;
            for (String s : split = tagIds.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                tagIdsSet.add(s);
            }
        }
        Map<Long, List<IdName<String>>> deptMap = this.getAcquisitionLinkDeptInfo(bizId, acquisitionLinkIds);
        Map<Long, List<IdName<String>>> userMap = this.getAcquisitionLinkMemInfo(bizId, corpId, acquisitionLinkIds);
        Map linkAddFriendMap = this.weworkCustomerAcquisitionJoinRecordMapper.queryAcquisitionLinkAddFriendCount(bizId, acquisitionLinkIds);
        Set userIds = list.stream().map(it -> it.getCreateBy()).collect(Collectors.toSet());
        Map userNameMap = this.userMapper.queryUserNameByIds(userIds);
        Map tagNameMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(tagIdsSet)) {
            tagNameMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(LoginUtils.getCurrentUserCorpId(), tagIdsSet);
        }
        ArrayList result = Lists.newArrayList();
        for (WeworkCustomerAcquisitionLink link : list) {
            LinkDto linkDto = new LinkDto();
            linkDto.setId(link.getNum());
            linkDto.setName(link.getLinkName());
            WeworkCustomerAcquisition acquisition = (WeworkCustomerAcquisition)acquisitionMap.get(link.getCustomerAcquisitionId());
            linkDto.setLinkType(acquisition.getLinkType());
            linkDto.setLinkUrl(link.getLinkUrl());
            linkDto.setClickCount(link.getClickCount());
            linkDto.setAddFriendCount((Integer)linkAddFriendMap.get(link.getId()));
            linkDto.setUpdateTime(link.getUpdateTime());
            linkDto.setSkipVerify(link.getSkipVerify());
            linkDto.setDeptList(deptMap.get(link.getId()));
            linkDto.setMemberList(userMap.get(link.getId()));
            linkDto.setCreateBy((String)userNameMap.get(link.getCreateBy()));
            linkDto.setAddFriendRemark(acquisition.getAddFriendRemark());
            linkDto.setAddFriendWelcome((WelcomeDto)JSONObject.parseObject((String)acquisition.getWelcomeContent(), WelcomeDto.class));
            ArrayList<StrIdAndNameDto> tagList = new ArrayList<StrIdAndNameDto>();
            String tagIds = acquisition.getTagIds();
            if (StringUtils.isNotBlank((CharSequence)tagIds)) {
                String[] split;
                for (String s : split = tagIds.split(",")) {
                    String tagName;
                    if (StringUtils.isBlank((CharSequence)s) || StringUtils.isBlank((CharSequence)(tagName = (String)tagNameMap.get(s)))) continue;
                    StrIdAndNameDto dto = new StrIdAndNameDto(s, tagName);
                    tagList.add(dto);
                }
            }
            linkDto.setTags(tagList);
            result.add(linkDto);
        }
        return result;
    }

    private Map<Long, List<IdName<String>>> getAcquisitionLinkDeptInfo(Long bizId, Set<Long> acquisitionLinkIds) {
        Map linkDeptIdMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(acquisitionLinkIds)) {
            linkDeptIdMap = this.weworkCustomerAcquisitionDeptMapper.queryLinkRelDeptByAcquisitionIds(bizId, acquisitionLinkIds);
        }
        HashSet deptIds = Sets.newHashSet();
        for (Map.Entry entry : linkDeptIdMap.entrySet()) {
            deptIds.addAll((Collection)entry.getValue());
        }
        List orgList = this.organizationMapper.queryOrgByDepartmentIds(bizId, (Collection)deptIds);
        HashMap deptMap = Maps.newHashMap();
        for (Organization org : orgList) {
            deptMap.put(org.getWeworkDepartmentId(), org);
        }
        HashMap resultMap = Maps.newHashMap();
        for (Map.Entry entry : linkDeptIdMap.entrySet()) {
            Long acquisitionLinkId = (Long)entry.getKey();
            List linkDeptIds = (List)entry.getValue();
            ArrayList deptNames = Lists.newArrayList();
            resultMap.put(acquisitionLinkId, deptNames);
            if (CollectionUtils.isEmpty((Collection)linkDeptIds)) continue;
            for (Integer deptId : linkDeptIds) {
                Organization org = (Organization)deptMap.get(deptId);
                if (org == null) continue;
                IdName idName = new IdName();
                idName.setId((Object)org.getNum());
                idName.setName(org.getName());
                deptNames.add(idName);
            }
        }
        return resultMap;
    }

    private Map<Long, List<IdName<String>>> getAcquisitionLinkMemInfo(Long bizId, String corpId, Set<Long> acquisitionLinkIds) {
        Map linkUserIdMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(acquisitionLinkIds)) {
            linkUserIdMap = this.weworkCustomerAcquisitionMemberMapper.queryLinkRelMemByAcquisitionIds(bizId, acquisitionLinkIds);
        }
        HashSet weworkUserIds = Sets.newHashSet();
        for (Map.Entry entry : linkUserIdMap.entrySet()) {
            weworkUserIds.addAll((Collection)entry.getValue());
        }
        Map weworkUserMap = Maps.newHashMap();
        Map weworkUserNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)weworkUserIds)) {
            weworkUserMap = this.weworkUserMapper.queryUserNumIdMap(corpId, (Collection)weworkUserIds);
            weworkUserNameMap = this.weworkUserMapper.queryWeworkUserNameMap(corpId, (Collection)weworkUserIds);
        }
        HashMap resultMap = Maps.newHashMap();
        for (Map.Entry entry : linkUserIdMap.entrySet()) {
            Long acquisitionLinkId = (Long)entry.getKey();
            List linkUserIds = (List)entry.getValue();
            ArrayList userNames = Lists.newArrayList();
            resultMap.put(acquisitionLinkId, userNames);
            if (CollectionUtils.isEmpty((Collection)linkUserIds)) continue;
            for (String weworkUserId : linkUserIds) {
                IdName idName = new IdName();
                idName.setId(weworkUserMap.get(weworkUserId));
                idName.setName((String)weworkUserNameMap.get(weworkUserId));
                userNames.add(idName);
            }
        }
        return resultMap;
    }

    @Override
    public List<AcquisitionDto> linkListByLevel(LinkLevelReq req) {
        String corpId;
        Long bizId = LoginUtils.getCurrentUserBizId();
        List list = this.weworkCustomerAcquisitionMapper.queryList(bizId, corpId = LoginUtils.getCurrentUserCorpId(), req.getLinkType(), req.getQuery());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.EMPTY_LIST;
        }
        Set acquisitionIds = list.stream().map(it -> it.getId()).collect(Collectors.toSet());
        List acquisitionLinks = this.weworkCustomerAcquisitionLinkMapper.queryByAcquisitionLinks(bizId, corpId, acquisitionIds, req.getQuery());
        HashMap acquisitionLinkMap = Maps.newHashMap();
        HashSet acquisitionLinkIds = Sets.newHashSet();
        for (WeworkCustomerAcquisitionLink acquisitionLink : acquisitionLinks) {
            if (acquisitionLinkMap.containsKey(acquisitionLink.getCustomerAcquisitionId())) {
                ((List)acquisitionLinkMap.get(acquisitionLink.getCustomerAcquisitionId())).add(acquisitionLink);
            } else {
                acquisitionLinkMap.put(acquisitionLink.getCustomerAcquisitionId(), Lists.newArrayList((Object[])new WeworkCustomerAcquisitionLink[]{acquisitionLink}));
            }
            acquisitionLinkIds.add(acquisitionLink.getId());
        }
        Map<Long, List<IdName<String>>> acquisitionLinkMemMap = this.getAcquisitionLinkMemInfo(bizId, corpId, acquisitionLinkIds);
        ArrayList result = Lists.newArrayList();
        for (WeworkCustomerAcquisition acquisition : list) {
            AcquisitionDto dto = new AcquisitionDto();
            dto.setId(acquisition.getNum());
            dto.setName(acquisition.getLinkName());
            ArrayList children = Lists.newArrayList();
            List links = (List)acquisitionLinkMap.get(acquisition.getId());
            if (CollectionUtils.isNotEmpty((Collection)links)) {
                for (WeworkCustomerAcquisitionLink link : links) {
                    LinkDto linkDto = new LinkDto();
                    linkDto.setId(link.getNum());
                    linkDto.setName(link.getLinkName());
                    linkDto.setLinkType(acquisition.getLinkType());
                    linkDto.setLinkUrl(link.getLinkUrl());
                    List<IdName<String>> mems = acquisitionLinkMemMap.get(link.getId());
                    if (CollectionUtils.isNotEmpty(mems)) {
                        linkDto.setWeworkUsers(mems);
                        IdName<String> mem = mems.get(0);
                        linkDto.setWeworkUserId((String)mem.getId());
                        linkDto.setWeworkUserName(mem.getName());
                    }
                    children.add(linkDto);
                }
            }
            dto.setChildren(children);
            result.add(dto);
        }
        return result;
    }

    @Override
    public LinkQuotaDto linkQuota() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        LinkQuotaDto result = new LinkQuotaDto();
        try {
            CustomerAcquisitionQuota quota = this.customerAcquisitionClient.getQuota(corpId);
            if (quota != null && quota.getErrCode() == 0) {
                result.setTotal(quota.getTotal());
                result.setBalance(quota.getBalance());
            }
        }
        catch (WeworkException e) {
            log.error("error: ", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<LinkFriendDetailResp> linkAddFriendDetail(LinkFriendDetailReq req) {
        req.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        WeworkCustomerAcquisitionLink acquisitionLink = new WeworkCustomerAcquisitionLink();
        acquisitionLink.setNum(req.getId());
        acquisitionLink = (WeworkCustomerAcquisitionLink)this.weworkCustomerAcquisitionLinkMapper.selectOne((Object)acquisitionLink);
        Preconditions.checkArgument((acquisitionLink != null ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u83b7\u5ba2\u94fe\u63a5");
        QueryFriendDetail query = new QueryFriendDetail();
        query.setBizId(bizId);
        query.setCorpId(corpId);
        query.setAcquisitionLinkId(acquisitionLink.getId());
        if (StringUtils.isNotEmpty((CharSequence)req.getWeworkUserId())) {
            query.setWeworkUserId(this.weworkUserMapper.queryWeworkUserIdByNum(req.getWeworkUserId()));
            if (StringUtils.isEmpty((CharSequence)query.getWeworkUserId())) {
                query.setWeworkUserId("");
            }
        }
        query.setName(req.getName());
        query.setChatStatus(req.getChatStatus());
        query.setAddWeworkStatus(req.getAddWeworkStatus());
        query.setMobile(req.getMobile());
        PageDto pageDto = req.getPageDto();
        List joinRecords = null;
        if (pageDto != null) {
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.weworkCustomerAcquisitionJoinRecordMapper.queryAddFriendByLinkId(query));
            joinRecords = page.getResult();
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
        } else {
            joinRecords = this.weworkCustomerAcquisitionJoinRecordMapper.queryAddFriendByLinkId(query);
        }
        if (CollectionUtils.isEmpty((Collection)joinRecords)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = Lists.newArrayList();
        Set contactIds = joinRecords.stream().map(it -> it.getExternalUserid()).collect(Collectors.toSet());
        List weworkContacts = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        HashMap contactMap = Maps.newHashMap();
        for (WeworkContact contact : weworkContacts) {
            contactMap.put(contact.getContactId(), contact);
        }
        Set weworkUserIds = joinRecords.stream().map(it -> it.getWeworkUserId()).collect(Collectors.toSet());
        List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, weworkUserIds);
        HashMap weworkUserMap = Maps.newHashMap();
        for (Object weworkUser : weworkUsers) {
            weworkUserMap.put(weworkUser.getWeworkUserId(), weworkUser);
        }
        ArrayList weworkPairs = Lists.newArrayList();
        for (WeworkCustomerAcquisitionJoinRecord joinRecord : joinRecords) {
            ContactWeworkPair pair = new ContactWeworkPair(joinRecord.getWeworkUserId(), joinRecord.getExternalUserid());
            weworkPairs.add(pair);
        }
        List existRels = this.weworkContactRelationMapper.queryRemainRelation(corpId, (List)weworkPairs, null);
        List userContactInfos = this.weworkContactRelationMapper.queryContactInfoByWeworkUserIdAndNameQuery(corpId, null, (Collection)weworkPairs);
        HashMap remarkNameMap = Maps.newHashMap();
        for (Object contactInfo : userContactInfos) {
            remarkNameMap.put(contactInfo.getWeworkUserId() + "-" + contactInfo.getContactId(), contactInfo.getRemark());
        }
        HashMap relMap = Maps.newHashMap();
        for (ContactWeworkPair pair : existRels) {
            relMap.put(pair.getWeworkUserId() + "-" + pair.getContactId(), pair);
        }
        boolean encryptMobile = this.settingService.getMobileEncrypt(bizId);
        for (WeworkCustomerAcquisitionJoinRecord joinRecord : joinRecords) {
            String key;
            ContactWeworkPair pair;
            LinkFriendDetailResp dto = new LinkFriendDetailResp();
            dto.setId(joinRecord.getNum());
            WeworkContact contact = (WeworkContact)contactMap.get(joinRecord.getExternalUserid());
            if (contact != null) {
                dto.setAvatar(contact.getAvatar());
                dto.setNickname(contact.getName());
                dto.setCustomerNum(contact.getCustomerNum());
            }
            if (encryptMobile) {
                dto.setMobile(MobileUtils.encryptMobile((String)joinRecord.getMobile()));
            } else {
                dto.setMobile(joinRecord.getMobile());
            }
            dto.setAddFriendTime(joinRecord.getCreateTime());
            WeworkUser weworkUser = (WeworkUser)weworkUserMap.get(joinRecord.getWeworkUserId());
            if (weworkUser != null) {
                dto.setAcquisitionName(weworkUser.getName());
            }
            if ((pair = (ContactWeworkPair)relMap.get(key = joinRecord.getWeworkUserId() + "-" + joinRecord.getExternalUserid())) != null) {
                dto.setAddWeworkStatus(1);
            } else {
                dto.setAddWeworkStatus(0);
            }
            dto.setRemarkName((String)remarkNameMap.get(key));
            dto.setChatStatus(joinRecord.getChatStatus());
            result.add(dto);
        }
        return result;
    }

    @Override
    public void redirect(HttpServletResponse response, String shareRecordNum) {
        Long shareRecordId;
        String linkUrl;
        Long bizId;
        Long linkId;
        log.info("redirect,shareRecordNum:{}", (Object)shareRecordNum);
        String key = "CA_redirect_" + shareRecordNum;
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)value)) {
            WeworkCustomerAcquisitionShareRecord select = new WeworkCustomerAcquisitionShareRecord();
            select.setNum(shareRecordNum);
            WeworkCustomerAcquisitionShareRecord shareRecord = (WeworkCustomerAcquisitionShareRecord)this.weworkCustomerAcquisitionShareRecordMapper.selectOne((Object)select);
            Preconditions.checkArgument((shareRecord != null ? 1 : 0) != 0, (Object)"\u83b7\u5ba2\u94fe\u63a5\u4e0d\u5b58\u5728");
            WeworkCustomerAcquisitionLink acquisitionLink = (WeworkCustomerAcquisitionLink)this.weworkCustomerAcquisitionLinkMapper.selectByPrimaryKey((Object)shareRecord.getCustomerAcquisitionLinkId());
            Preconditions.checkArgument((acquisitionLink != null ? 1 : 0) != 0, (Object)"\u83b7\u5ba2\u94fe\u63a5\u4e0d\u5b58\u5728");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)acquisitionLink.getLinkUrl()), (Object)"\u83b7\u5ba2\u94fe\u63a5\u6682\u672a\u751f\u6210");
            linkId = acquisitionLink.getId();
            bizId = acquisitionLink.getBizId();
            linkUrl = acquisitionLink.getLinkUrl();
            shareRecordId = shareRecord.getId();
            value = linkId + "_" + bizId + "_" + linkUrl + "_" + shareRecordId;
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, 7L, TimeUnit.DAYS);
            log.info("redirect,shareRecordNum:{},set to redis,key:{},value:{}", new Object[]{shareRecordNum, key, value});
        } else {
            log.info("redirect,shareRecordNum:{},get from redis:{}", (Object)shareRecordNum, (Object)value);
            String[] split = value.split("_");
            linkId = Long.parseLong(split[0]);
            bizId = Long.parseLong(split[1]);
            linkUrl = split[2];
            shareRecordId = Long.parseLong(split[3]);
        }
        String clickNumber = this.idGen.getNum();
        this.threadPool.submit(() -> {
            try {
                this.weworkCustomerAcquisitionLinkMapper.updateCount(linkId);
                Date now = new Date();
                WeworkCustomerAcquisitionClickRecord insert = new WeworkCustomerAcquisitionClickRecord();
                insert.setNum(clickNumber);
                insert.setBizId(bizId);
                insert.setCustomerAcquisitionShareRecordId(shareRecordId);
                insert.setClickTime(now);
                insert.setCreateTime(now);
                insert.setUpdateTime(now);
                this.weworkCustomerAcquisitionClickRecordMapper.insertSelective((Object)insert);
                this.handleSmsTaskDetailOpenWeworkAcquisitionLink(shareRecordId);
            }
            catch (Exception e) {
                log.error("redirect,shareRecordNum:{},clickNumber:{},\u5f02\u6b65\u5904\u7406\u5f02\u5e38", new Object[]{shareRecordNum, clickNumber, e});
            }
        });
        String redirectUrl = linkUrl + CUSTOMER_STATE + "CA_" + clickNumber;
        log.info("redirect,shareRecordNum:{},redirectUrl:{}", (Object)shareRecordNum, (Object)redirectUrl);
        try {
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            log.error("redirect,sendRedirect error", (Throwable)e);
        }
    }

    private void handleSmsTaskDetailOpenWeworkAcquisitionLink(Long shareRecordId) {
        Boolean exist = this.smsTaskDetailMapper.existByCustomerAcquisitionShareRecordId(shareRecordId);
        if (exist == null || !exist.booleanValue()) {
            return;
        }
        log.info("handleSmsTaskDetailOpenWeworkAcquisitionLink,shareRecordId:{}", (Object)shareRecordId);
        this.smsTaskDetailMapper.updateOpenWeworkAcquisitionLink(shareRecordId);
    }

    @Override
    public void addFriendCallback(ReplyContext ctx) {
        log.info("addFriendCallback,ctx:{}", (Object)ctx);
        String state = ctx.getState();
        if (StringUtils.isBlank((CharSequence)state)) {
            return;
        }
        Date addFriendTime = ctx.getTimestamp();
        if (addFriendTime == null) {
            addFriendTime = new Date();
        }
        String clickNum = state.replaceAll("CA_", "");
        WeworkCustomerAcquisitionClickRecord select = new WeworkCustomerAcquisitionClickRecord();
        select.setNum(clickNum);
        WeworkCustomerAcquisitionClickRecord acquisitionClickRecord = (WeworkCustomerAcquisitionClickRecord)this.weworkCustomerAcquisitionClickRecordMapper.selectOne((Object)select);
        if (acquisitionClickRecord == null) {
            log.info("acquisitionClickRecord is null");
            return;
        }
        Long shareRecordId = acquisitionClickRecord.getCustomerAcquisitionShareRecordId();
        WeworkCustomerAcquisitionShareRecord acquisitionShareRecord = (WeworkCustomerAcquisitionShareRecord)this.weworkCustomerAcquisitionShareRecordMapper.selectByPrimaryKey((Object)shareRecordId);
        if (acquisitionShareRecord == null) {
            log.info("addFriendCallback,acquisitionShareRecord is null");
            return;
        }
        WeworkCustomerAcquisitionEvent event = new WeworkCustomerAcquisitionEvent();
        event.setEventType(Integer.valueOf(1));
        event.setShareRecordNum(acquisitionShareRecord.getNum());
        event.setFkType(acquisitionShareRecord.getFkType());
        event.setFkId(acquisitionShareRecord.getFkId());
        event.setAddFriendTime(addFriendTime);
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(ctx.getBizId(), ctx.getCorpId(), ctx.getContactId());
        if (weworkContact != null) {
            event.setGender(weworkContact.getGender());
            event.setNickName(weworkContact.getName());
            event.setAvatar(weworkContact.getAvatar());
            event.setUnionId(weworkContact.getUnionid());
        }
        event.setContactId(ctx.getContactId());
        event.setWeworkUserNum(ctx.getWeworkUserNum());
        event.setWeworkUserName(ctx.getWeworkUserName());
        String data = JSONObject.toJSONString((Object)event);
        log.info("addFriendCallback,sendMessage:{}", (Object)data);
        this.kafkaClientUtils.sendMessage(this.customerAcquisitionTopic, data);
    }

    @Override
    public void saveAcquisitionJoinRecord() {
        WeworkCustomerAcquisitionClickRecord select;
        ReplyContext ctx = ReplyContextUtil.get();
        if (!ctx.isWeworkCustomerAcquisition()) {
            log.info("not wework customer acquisition");
            return;
        }
        log.info("wework customer acquisition state: {}, weworkUserId: {}, contactId: {}", new Object[]{ctx.getState(), ctx.getWeworkUserId(), ctx.getContactId()});
        String state = ctx.getState();
        if (StringUtils.isBlank((CharSequence)state)) {
            return;
        }
        Date addFriendTime = ctx.getTimestamp();
        if (addFriendTime == null) {
            addFriendTime = new Date();
        }
        WeworkCustomerAcquisitionShareRecord shareRecord = null;
        WeworkCustomerAcquisitionClickRecord acquisitionClickRecord = null;
        if (state.startsWith("CA_")) {
            String clickNum = state.replaceAll("CA_", "");
            select = new WeworkCustomerAcquisitionClickRecord();
            select.setNum(clickNum);
            acquisitionClickRecord = (WeworkCustomerAcquisitionClickRecord)this.weworkCustomerAcquisitionClickRecordMapper.selectOne((Object)select);
            if (acquisitionClickRecord == null) {
                log.info("acquisitionClickRecord is null");
                return;
            }
            Long shareRecordId = acquisitionClickRecord.getCustomerAcquisitionShareRecordId();
            shareRecord = (WeworkCustomerAcquisitionShareRecord)this.weworkCustomerAcquisitionShareRecordMapper.selectByPrimaryKey((Object)shareRecordId);
        } else if (state.startsWith("CS_")) {
            String shareNum = state.replaceAll("CS_", "");
            select = new WeworkCustomerAcquisitionShareRecord();
            select.setNum(shareNum);
            shareRecord = (WeworkCustomerAcquisitionShareRecord)this.weworkCustomerAcquisitionShareRecordMapper.selectOne((Object)select);
        }
        if (shareRecord == null) {
            log.warn("acquisition share record is null");
            return;
        }
        WeworkCustomerAcquisitionLink acquisitionLink = (WeworkCustomerAcquisitionLink)this.weworkCustomerAcquisitionLinkMapper.selectByPrimaryKey((Object)shareRecord.getCustomerAcquisitionLinkId());
        if (acquisitionLink == null) {
            log.warn("acquisition link is null");
            return;
        }
        String weworkUserId = ctx.getWeworkUserId();
        String contactId = ctx.getContactId();
        this.weworkCustomerAcquisitionJoinRecordMapper.updateBeforeRecord(ctx.getBizId(), acquisitionLink.getLinkId(), weworkUserId, contactId);
        Date curTime = new Date();
        WeworkCustomerAcquisitionJoinRecord joinRecord = new WeworkCustomerAcquisitionJoinRecord();
        joinRecord.setNum(this.idGen.getNum());
        joinRecord.setBizId(ctx.getBizId());
        if (acquisitionClickRecord != null) {
            joinRecord.setAcquisitionClickRecordId(acquisitionClickRecord.getId());
        } else {
            joinRecord.setAcquisitionClickRecordId(Long.valueOf(-1L));
        }
        joinRecord.setAcquisitionShareRecordId(shareRecord.getId());
        joinRecord.setWeworkUserId(weworkUserId);
        joinRecord.setExternalUserid(contactId);
        joinRecord.setChatStatus(Integer.valueOf(0));
        joinRecord.setState(state);
        joinRecord.setLinkId(acquisitionLink.getLinkId());
        joinRecord.setIsDeleted(Integer.valueOf(0));
        joinRecord.setIsNew(Integer.valueOf(1));
        joinRecord.setMobile(shareRecord.getMobile());
        joinRecord.setCreateTime(curTime);
        joinRecord.setUpdateTime(curTime);
        joinRecord.setAddTime(addFriendTime);
        joinRecord.setAddStatus(Integer.valueOf(1));
        this.weworkCustomerAcquisitionJoinRecordMapper.insert((Object)joinRecord);
        try {
            this.handleSmsTaskDetailAddWeworkFriend(shareRecord.getId(), weworkUserId);
        }
        catch (Exception e) {
            log.error("saveAcquisitionJoinRecord,handleSmsTaskDetailAddWeworkFriend error", (Throwable)e);
        }
    }

    private void handleSmsTaskDetailAddWeworkFriend(Long shareRecordId, String weworkUserId) {
        log.info("handleSmsTaskDetailAddWeworkFriend,shareRecordId:{},weworkUserId:{}", (Object)shareRecordId, (Object)weworkUserId);
        SmsTaskDetail smsTaskDetail = this.smsTaskDetailMapper.selectByCustomerAcquisitionShareRecordIdLimitOne(shareRecordId);
        if (smsTaskDetail == null) {
            return;
        }
        log.info("handleSmsTaskDetailAddWeworkFriend,shareRecordId:{},weworkUserId:{},smsTaskDetail:{}", new Object[]{shareRecordId, weworkUserId, smsTaskDetail});
        SmsTaskDetail update = new SmsTaskDetail();
        update.setCustomerAcquisitionShareRecordId(shareRecordId);
        update.setAddWeworkStatus(AddWeworkStatusEnum.ADD.getValue());
        if (StringUtils.isNotBlank((CharSequence)smsTaskDetail.getAddWeworkUserIds())) {
            update.setAddWeworkUserIds(smsTaskDetail.getAddWeworkUserIds() + "," + weworkUserId);
        } else {
            update.setAddWeworkUserIds("," + weworkUserId);
        }
        this.smsTaskDetailMapper.batchUpdateAddWeworkStatusAndUserIds(Collections.singletonList(update));
    }

    @Override
    public void updateAcquisitionJoinRecordStatus(DelFollowUser event) {
        String corpId = event.getToUserName();
        Long timestamp = event.getCreateTime();
        String weworkUserId = event.getUserId();
        String contactId = event.getExternalUserId();
        Long bizId = this.weworkCorpMapper.getByCorpId(corpId).getBizId();
        try {
            Date delTime = new Date(timestamp * 1000L);
            this.weworkCustomerAcquisitionJoinRecordMapper.updateJoinRecordAddStatus(bizId, weworkUserId, contactId, delTime);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
        try {
            this.handleSmsTaskDetailDelWeworkFriend(bizId, weworkUserId, contactId);
        }
        catch (Exception e) {
            log.error("updateAcquisitionJoinRecordStatus,handleSmsTaskDetailDelWeworkFriend error", (Throwable)e);
        }
    }

    @Override
    public void updateAcquisitionJoinRecordStatus(DelExternalContact event) {
        String corpId = event.getToUserName();
        Long timestamp = event.getCreateTime();
        String weworkUserId = event.getUserId();
        String contactId = event.getExternalUserId();
        Long bizId = this.weworkCorpMapper.getByCorpId(corpId).getBizId();
        try {
            Date delTime = new Date(timestamp * 1000L);
            this.weworkCustomerAcquisitionJoinRecordMapper.updateJoinRecordAddStatus(bizId, weworkUserId, contactId, delTime);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
        try {
            this.handleSmsTaskDetailDelWeworkFriend(bizId, weworkUserId, contactId);
        }
        catch (Exception e) {
            log.error("updateAcquisitionJoinRecordStatus,handleSmsTaskDetailDelWeworkFriend error", (Throwable)e);
        }
    }

    private void handleSmsTaskDetailDelWeworkFriend(Long bizId, String weworkUserId, String contactId) {
        log.info("handleSmsTaskDetailDelWeworkFriend,bizId:{},weworkUserId:{},contactId:{}", new Object[]{bizId, weworkUserId, contactId});
        WeworkCustomerAcquisitionJoinRecord select = new WeworkCustomerAcquisitionJoinRecord();
        select.setBizId(bizId);
        select.setWeworkUserId(weworkUserId);
        select.setExternalUserid(contactId);
        List joinRecords = this.weworkCustomerAcquisitionJoinRecordMapper.select((Object)select);
        if (CollectionUtils.isEmpty((Collection)joinRecords)) {
            log.info("handleSmsTaskDetailDelWeworkFriend,bizId:{},weworkUserId:{},contactId:{},joinRecords is null", new Object[]{bizId, weworkUserId, contactId});
            return;
        }
        Set shareRecordIds = joinRecords.stream().map(WeworkCustomerAcquisitionJoinRecord::getAcquisitionShareRecordId).collect(Collectors.toSet());
        List smsTaskDetails = this.smsTaskDetailMapper.selectRecentByCustomerAcquisitionShareRecordIds(shareRecordIds);
        if (CollectionUtils.isEmpty((Collection)smsTaskDetails)) {
            return;
        }
        ArrayList<SmsTaskDetail> updateList = new ArrayList<SmsTaskDetail>();
        for (SmsTaskDetail smsTaskDetail : smsTaskDetails) {
            String addWeworkUserIds = smsTaskDetail.getAddWeworkUserIds();
            String newWeworkUserIds = addWeworkUserIds.replaceAll("," + weworkUserId, "");
            Integer addWeworkStatus = smsTaskDetail.getAddWeworkStatus();
            if (StringUtils.isBlank((CharSequence)newWeworkUserIds)) {
                addWeworkStatus = AddWeworkStatusEnum.DEL.getValue();
            }
            SmsTaskDetail update = new SmsTaskDetail();
            update.setCustomerAcquisitionShareRecordId(smsTaskDetail.getCustomerAcquisitionShareRecordId());
            update.setAddWeworkStatus(addWeworkStatus);
            update.setAddWeworkUserIds(addWeworkUserIds);
            updateList.add(update);
            log.info("handleSmsTaskDetailDelWeworkFriend,bizId:{},weworkUserId:{},contactId:{},smsTaskDetail:{},newWeworkUserIds:{},update:{}", new Object[]{bizId, weworkUserId, contactId, smsTaskDetail.getId(), newWeworkUserIds, update});
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.smsTaskDetailMapper.batchUpdateAddWeworkStatusAndUserIds(updateList);
        }
    }

    @Override
    public void refreshChatStatus(Long bizId, String corpId) {
        if (bizId == null) {
            log.warn("update chat status params bizId is null");
            return;
        }
        WeworkCustomerAcquisitionLink acquisitionLink = new WeworkCustomerAcquisitionLink();
        acquisitionLink.setBizId(bizId);
        acquisitionLink.setIsDeleted(Integer.valueOf(0));
        acquisitionLink.setStatus(Integer.valueOf(1));
        List linkList = this.weworkCustomerAcquisitionLinkMapper.select((Object)acquisitionLink);
        block0: for (WeworkCustomerAcquisitionLink link : linkList) {
            CustomerAcquisitionContactList linkCustomer;
            if (!StringUtils.isNotBlank((CharSequence)link.getLinkId())) continue;
            String cursor = null;
            while ((linkCustomer = this.customerAcquisitionClient.getLinkCustomer(corpId, link.getLinkId(), Integer.valueOf(1000), cursor)) != null && linkCustomer.getErrCode() == 0) {
                this.updateChatStatus(link, linkCustomer.getCustomerList());
                cursor = linkCustomer.getNextCursor();
                if (StringUtils.isNotBlank((CharSequence)cursor)) continue;
                continue block0;
            }
        }
    }

    @Override
    public String getShareUrl(String linkId) {
        if (StringUtils.isBlank((CharSequence)linkId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u94fe\u63a5id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WeworkCustomerAcquisitionLink link = new WeworkCustomerAcquisitionLink();
        link.setNum(linkId);
        link = (WeworkCustomerAcquisitionLink)this.weworkCustomerAcquisitionLinkMapper.selectOne((Object)link);
        if (link == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u83b7\u5ba2\u94fe\u63a5");
        }
        WeworkCustomerAcquisitionShareRecord select = new WeworkCustomerAcquisitionShareRecord();
        select.setCustomerAcquisitionLinkId(link.getId());
        select.setFkType(Integer.valueOf(0));
        List list = this.weworkCustomerAcquisitionShareRecordMapper.select((Object)select);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            String shareNum = ((WeworkCustomerAcquisitionShareRecord)list.get(0)).getNum();
            return link.getLinkUrl() + CUSTOMER_STATE + "CS_" + shareNum;
        }
        WeworkCustomerAcquisitionShareRecord shareRecord = new WeworkCustomerAcquisitionShareRecord();
        Date curTime = new Date();
        shareRecord.setNum(this.idGen.getNum());
        shareRecord.setBizId(link.getBizId());
        shareRecord.setCustomerAcquisitionLinkId(link.getId());
        shareRecord.setFkType(Integer.valueOf(0));
        shareRecord.setCreateTime(curTime);
        shareRecord.setUpdateTime(curTime);
        shareRecord.setIsDeleted(Integer.valueOf(0));
        this.weworkCustomerAcquisitionShareRecordMapper.insertSelective((Object)shareRecord);
        return link.getLinkUrl() + CUSTOMER_STATE + "CS_" + shareRecord.getNum();
    }

    private void updateChatStatus(WeworkCustomerAcquisitionLink link, List<CustomerAcquisitionContact> customerList) {
        HashSet set = Sets.newHashSet();
        for (CustomerAcquisitionContact contact : customerList) {
            if (contact.getChatStatus() != 1) continue;
            set.add(contact.getUserId() + "&" + contact.getExternalUserId());
        }
        for (String str : set) {
            List list = Splitter.on((String)"&").splitToList((CharSequence)str);
            String weworkUserId = (String)list.get(0);
            String contactId = (String)list.get(1);
            this.weworkCustomerAcquisitionJoinRecordMapper.updateChatStatus(link.getBizId(), link.getLinkId(), weworkUserId, contactId, Integer.valueOf(1));
        }
    }
}

