/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.listener;

import com.alibaba.fastjson.JSON;
import com.kuaike.scrm.common.dto.PublishPayloadDto;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class GlobalListeners {
    private static final Logger log = LoggerFactory.getLogger(GlobalListeners.class);
    @Autowired
    private KafkaClientUtils clientUtils;
    @Value(value="${kafka.topic.event_bus}")
    private String eventBusTopic;

    @EventListener(value={PublishPayloadDto.class})
    public void publishPayload(PublishPayloadDto dto) {
        log.info("publishPayload with dto={}", (Object)JSON.toJSONString((Object)dto));
        if (dto == null) {
            return;
        }
        String uuid = UUID.randomUUID().toString();
        this.clientUtils.sendMessage(this.eventBusTopic, uuid, JSON.toJSONString((Object)dto));
    }
}

