/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.stereotype.Component;

@Component
public final class RedisDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;
    @Value(value="${spring.redis.database}")
    private int redisDBIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key, int retry, long expireSecs, long sleepMills) {
        String lock = this.redisPrefix + key;
        log.debug("RedisDistributedLock.lock.key:{}, retry:{}, expireSecs:{}, sleepMills:{}", new Object[]{lock, retry, expireSecs, sleepMills});
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(this.redisDBIndex);
            int retryCount = 0;
            while (!connection.set(lock.getBytes(), "".getBytes(), Expiration.seconds((long)expireSecs), RedisStringCommands.SetOption.SET_IF_ABSENT).booleanValue()) {
                if (retry > NumberUtils.INTEGER_ZERO) {
                    if (retryCount > retry) {
                        log.error("RedisDistributedLock.lock.key:{}, retry:{}, retryCount:{}", new Object[]{lock, retry, retryCount});
                        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    Thread.sleep(sleepMills);
                    log.debug("RedisDistributedLock.lock.key:{}, retry:{}, sleepCount:{}", new Object[]{lock, retry, ++retryCount});
                    continue;
                }
                log.error("RedisDistributedLock. get lock failed, lock.key:{}, retry:{}, retryCount:{}", new Object[]{lock, retry, retryCount});
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            log.debug("RedisDistributedLock. get lock succss.key:{}, retry:{}, sleepCount:{}", new Object[]{lock, retry, retryCount});
        }
        catch (InterruptedException e) {
            log.error("RedisDistributedLock.lock:{}, e:{}", (Object)lock, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
            connection.del((byte[][])new byte[][]{lock.getBytes()});
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
            log.debug("RedisDistributedLock.lock release connection success");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String key) {
        RedisConnection connection = null;
        String lock = this.redisPrefix + key;
        try {
            connection = this.redisTemplate.getConnectionFactory().getConnection();
            connection.select(this.redisDBIndex);
            connection.del((byte[][])new byte[][]{lock.getBytes()});
            log.debug("unlock.key:{} success", (Object)key);
        }
        catch (Exception e) {
            log.error("RedisDistributedLock.unlock:{}, e:{}", (Object)key, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            if (connection != null) {
                connection.del((byte[][])new byte[][]{lock.getBytes()});
                log.debug("RedisDistributedLock.unlock:success:key:{}", (Object)key);
            }
        }
        finally {
            if (connection != null) {
                RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                log.debug("RedisDistributedLock.unlock release connection success");
            }
        }
    }
}

