/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.OrderNotifyTargetType;
import com.kuaike.scrm.common.enums.OrderNotifyType;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.service.NotificationSettingService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.NotificationConfigDto;
import com.kuaike.scrm.common.service.dto.req.SettingReqDto;
import com.kuaike.scrm.common.service.dto.resp.SettingRespDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.Setting;
import com.kuaike.scrm.dal.system.mapper.SettingMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotificationSettingServiceImpl
implements NotificationSettingService {
    private static final Logger log = LoggerFactory.getLogger(NotificationSettingServiceImpl.class);
    @Autowired
    private SettingService settingService;
    @Autowired
    private SettingMapper settingMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;

    @Override
    @Transactional
    public void setConfig(List<NotificationConfigDto> params) {
        Long bizId = LoginUtils.getCurrentUserBizId();
        for (NotificationConfigDto param : params) {
            param.validate();
            if (param.getBizId() != null) continue;
            param.setBizId(bizId);
        }
        String settingValue = JacksonUtil.obj2Str(params);
        SettingReqDto settingReqDto = new SettingReqDto();
        settingReqDto.setParamName(SettingEnum.ORDER_PAY_NOTIFY.getName());
        settingReqDto.setParamValue(settingValue);
        SettingRespDto respDto = this.settingService.modSetting(settingReqDto);
        if (respDto == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25");
        }
        log.info("save success notify config:{}", (Object)respDto);
    }

    @Override
    public List<NotificationConfigDto> getConfig(Long bizId) {
        ArrayList<NotificationConfigDto> result = new ArrayList<NotificationConfigDto>();
        String params = this.settingService.getSettingDetail(bizId, SettingEnum.ORDER_PAY_NOTIFY.getName());
        Set typeSet = null;
        if (params != null) {
            log.info("get notify config:{}", (Object)params);
            try {
                List list = JacksonUtil.str2List((String)params, NotificationConfigDto.class);
                result.addAll(list);
                typeSet = list.stream().map(NotificationConfigDto::getType).collect(Collectors.toSet());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u914d\u7f6e\u89e3\u6790\u5f02\u5e38");
            }
        }
        for (NotificationConfigDto notificationConfigDto : result) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{notificationConfigDto.getTargets()})) continue;
            List targetNames = Arrays.stream(notificationConfigDto.getTargets().split(",")).collect(Collectors.toList());
            Map numName = this.weworkUserMapper.queryWeworkUserNameMapByNums(LoginUtils.getCurrentUserCorpId(), targetNames);
            StringBuilder builder = new StringBuilder();
            for (String targetName : targetNames) {
                builder.append((String)numName.get(targetName)).append(',');
            }
            notificationConfigDto.setTargetNames(builder.substring(0, builder.length() - 1));
        }
        if (typeSet == null) {
            typeSet = Collections.emptySet();
        }
        if (!typeSet.contains(OrderNotifyType.NO_PAY.getValue())) {
            result.add(new NotificationConfigDto(bizId, 0, OrderNotifyType.NO_PAY.getValue()));
        }
        if (!typeSet.contains(OrderNotifyType.MEETING_FINISH_PAY.getValue())) {
            NotificationConfigDto meetingPay = new NotificationConfigDto(bizId, 1, OrderNotifyType.MEETING_FINISH_PAY.getValue());
            meetingPay.setTargetType(OrderNotifyTargetType.INVITE.getValue());
            result.add(meetingPay);
        }
        if (!typeSet.contains(OrderNotifyType.NET_SCHOOL_FINISH_PAY.getValue())) {
            NotificationConfigDto schoolPay = new NotificationConfigDto(bizId, 1, OrderNotifyType.NET_SCHOOL_FINISH_PAY.getValue());
            schoolPay.setTargetType(OrderNotifyTargetType.BIND.getValue());
            result.add(schoolPay);
        }
        return result;
    }

    @Override
    public List<NotificationConfigDto> notifyConfigList() {
        ArrayList<NotificationConfigDto> list = new ArrayList<NotificationConfigDto>();
        List settings = this.settingMapper.getListByName(SettingEnum.ORDER_PAY_NOTIFY.getName());
        for (Setting setting : settings) {
            try {
                List str2List = JacksonUtil.str2List((String)setting.getParamValue(), NotificationConfigDto.class);
                for (NotificationConfigDto notificationConfigDto : str2List) {
                    if (notificationConfigDto.getOpen() != 1 || notificationConfigDto.getType().intValue() != OrderNotifyType.NO_PAY.getValue()) continue;
                    list.add(notificationConfigDto);
                }
            }
            catch (IOException e) {
                log.info("str2json err {}", (Object)setting);
            }
        }
        return list;
    }
}

