/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.perm.service.impl;

import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.dto.AccessBizInfo;
import com.kuaike.scrm.common.perm.dto.AccessUserInfo;
import com.kuaike.scrm.common.perm.service.AccessPermitService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.PermissionMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class AccessPermitServiceImpl
implements AccessPermitService {
    private static final Logger log = LoggerFactory.getLogger(AccessPermitServiceImpl.class);
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private PermissionMapper permissionMapper;

    public AccessBizInfo getAccessBiz() {
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.debug("get access biz info, bizId={}", (Object)bizId);
        if (bizId == null || bizId <= 0L) {
            log.warn("access business id is invalid, id={}", (Object)bizId);
            return null;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (biz == null || biz.getIsDeleted() != 0) {
            log.warn("access business customer is not exist, id={}", (Object)bizId);
            return null;
        }
        AccessBizInfo info = new AccessBizInfo();
        info.setId(biz.getId());
        info.setNum(biz.getNum());
        info.setName(biz.getName());
        info.setCorpId(biz.getCorpId());
        info.setVersionId(biz.getVersionId());
        info.setExpireDate(biz.getExpireDate());
        info.setStatus(biz.getStatus());
        info.setType(biz.getType());
        info.setIsOpenConversation(biz.getIsOpenConversation());
        info.setConvCount(biz.getConvCount());
        info.setNumCount(biz.getNumCount());
        return info;
    }

    public AccessUserInfo getAccessUser() {
        Long userId = LoginUtils.getCurrentUserId();
        log.debug("get access user info, userId={}", (Object)userId);
        if (userId == null || userId <= 0L) {
            log.warn("access user id is invalid, id={}", (Object)userId);
            return null;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (user == null || user.getIsDeleted() != 0) {
            log.warn("access user is not exist, id={}", (Object)userId);
            return null;
        }
        AccessUserInfo info = new AccessUserInfo();
        info.setId(userId);
        info.setBizId(user.getBizId());
        info.setCorpId(user.getCorpId());
        info.setEnabled(user.getEnabled());
        String corpId = user.getCorpId();
        String weworkUserId = user.getWeworkUserId();
        if (StringUtils.isNotBlank((CharSequence)weworkUserId)) {
            WeworkUser wu = this.weworkUserMapper.selectByWeworkUserIdAndCorpId(weworkUserId, corpId);
            if (wu != null && wu.getIsDeleted() == 0) {
                BusinessCustomer biz;
                info.setWeworkUserId(weworkUserId);
                info.setIsSuiteAuth(wu.getIsAgentAuth());
                info.setIsAgentAuth(wu.getIsAgentAuth());
                if (NumberUtils.INTEGER_ZERO.equals(wu.getIsAgentAuth()) && (biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)user.getBizId())).getApplyWeworkUserId().equals(wu.getOpenUserId())) {
                    info.setIsAgentAuth(Integer.valueOf(1));
                    info.setIsSuiteAuth(Integer.valueOf(1));
                }
            } else {
                log.info("wework user not exist, userId={}, corpId={}, weworkUserId={}", new Object[]{userId, corpId, weworkUserId});
            }
        }
        return info;
    }

    public boolean checkPermission(String requestUri) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        if (user == null) {
            log.warn("current user is null");
            return false;
        }
        if (!this.permissionMapper.checkExistPath(requestUri).booleanValue()) {
            return true;
        }
        Set menuCode = user.getMenuCodes();
        log.debug("check permission, userId={}, uri={}", (Object)user.getId(), (Object)requestUri);
        if (CollectionUtils.isEmpty((Collection)menuCode)) {
            log.info("\u6ca1\u6709\u83dc\u5355\u6743\u9650");
            return false;
        }
        return this.permissionMapper.checkPermission((Collection)menuCode, requestUri);
    }
}

