/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.component.IDelayQueueHandler;
import com.kuaike.scrm.common.dto.DelayItemDto;
import com.kuaike.scrm.common.enums.DelayHandleType;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CommonDelayQueueManager {
    private static final Logger log = LoggerFactory.getLogger(CommonDelayQueueManager.class);
    private final AtomicBoolean consumerThreadRun = new AtomicBoolean(true);
    private RDelayedQueue<DelayItemDto> delayedQueue;
    @Autowired
    private RedissonClient redissonClient;
    private Map<DelayHandleType, IDelayQueueHandler> handleType2Handler = Maps.newHashMap();
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        RBlockingQueue blockingFairQueue = this.redissonClient.getBlockingQueue(DelayItemDto.class.getName());
        this.delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingFairQueue);
        Thread consumerThread = new Thread(() -> {
            while (this.consumerThreadRun.get()) {
                try {
                    DelayItemDto chatMsg = (DelayItemDto)blockingFairQueue.take();
                    this.dealDelayItem(chatMsg);
                }
                catch (InterruptedException e) {
                    log.error("take delayItem failed", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        });
        consumerThread.start();
        Map map = this.applicationContext.getBeansOfType(IDelayQueueHandler.class);
        for (IDelayQueueHandler value : map.values()) {
            this.handleType2Handler.put(value.getType(), value);
        }
        log.info("common delay queue start");
    }

    @PreDestroy
    public void destroy() {
        this.consumerThreadRun.getAndSet(false);
        this.delayedQueue.destroy();
    }

    private void addQueue(DelayItemDto delayItemDto) {
        this.delayedQueue.offer((Object)delayItemDto, delayItemDto.getRetryGapMillis().longValue(), TimeUnit.MILLISECONDS);
    }

    public void addQueue(DelayHandleType type, String content, long firstDelay, TimeUnit firstDelayTimeUnit, Integer maxRetryCount, Long retryGapMillis) {
        Preconditions.checkArgument((boolean)Objects.nonNull(type), (Object)"type is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)content), (Object)"content is null or empty");
        if (Objects.isNull(maxRetryCount) || maxRetryCount < 0) {
            maxRetryCount = 0;
        }
        if (Objects.isNull(retryGapMillis) || retryGapMillis < 5L) {
            retryGapMillis = 5L;
        }
        DelayItemDto dto = new DelayItemDto();
        String uniqueId = UUID.randomUUID().toString().replace("-", "");
        dto.setContent(content);
        dto.setUniqueId(uniqueId);
        dto.setMaxRetryCount(maxRetryCount);
        dto.setType(type.getType());
        dto.setRetryGapMillis(retryGapMillis);
        dto.setRetryCount(Integer.valueOf(0));
        this.delayedQueue.offer((Object)dto, firstDelay, firstDelayTimeUnit);
    }

    private void dealDelayItem(DelayItemDto delayItemDto) {
        log.info("dealDelayItem delayItemDto={}", (Object)delayItemDto);
        boolean doSuccess = false;
        IDelayQueueHandler handler = this.handleType2Handler.get(DelayHandleType.getByType((Integer)delayItemDto.getType()));
        if (Objects.isNull(handler)) {
            log.error("\u8be5\u5ef6\u8fdf\u5904\u7406\u6682\u4e0d\u652f\u6301\uff0ctype={},delayItemDto={}", (Object)delayItemDto.getType(), (Object)delayItemDto);
            throw new UnsupportedOperationException(delayItemDto.getType() + "\u8be5\u5ef6\u8fdf\u5904\u7406\u6682\u4e0d\u652f\u6301");
        }
        doSuccess = handler.handleDelayItemContent(delayItemDto.getContent());
        delayItemDto.setRetryCount(Integer.valueOf(delayItemDto.getRetryCount() + 1));
        if (!doSuccess) {
            if (Objects.equals(delayItemDto.getMaxRetryCount(), NumberUtils.INTEGER_ZERO)) {
                log.info("not need to retry,uniqueId={},exit", (Object)delayItemDto.getUniqueId());
                return;
            }
            if (delayItemDto.getRetryCount() < delayItemDto.getMaxRetryCount()) {
                this.addQueue(delayItemDto);
                log.info("put into delayQueue,uniqueId={},content={},the {} times retry", new Object[]{delayItemDto.getUniqueId(), delayItemDto.getContent(), delayItemDto.getRetryCount()});
            } else {
                log.info("have reach maxRetryCount={},uniqueId={},exit", (Object)delayItemDto.getRetryCount(), (Object)delayItemDto.getUniqueId());
            }
        } else {
            log.info("retry deal success,delayItemDto={}", (Object)delayItemDto);
        }
    }
}

