/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.alarm.dingtalk;

import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.dingtalk.api.response.OapiRobotSendResponse;
import com.kuaike.scrm.alarm.AlarmTypeEnum;
import com.kuaike.scrm.common.config.DingTalkConfig;
import com.taobao.api.TaobaoRequest;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DingTalkSupport {
    private static final Logger log = LoggerFactory.getLogger(DingTalkSupport.class);
    @Autowired
    private DingTalkConfig dingTalkConfig;

    public void send(String msg, AlarmTypeEnum alarmTypeEnum) {
        String host;
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("text");
        request.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
        StringBuilder sb = new StringBuilder();
        if (Objects.nonNull((Object)alarmTypeEnum)) {
            sb.append(alarmTypeEnum.getDesc()).append(":\n");
        }
        if (StringUtils.isNotEmpty((String)(host = NetUtils.getLocalHost()))) {
            sb.append(" (").append(host).append(")\n");
        }
        sb.append(msg);
        text.setContent(sb.toString());
        request.setText(text);
        OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
        at.setIsAtAll(Boolean.valueOf(false));
        request.setAt(at);
        try {
            DingTalkClient dingTalkClient = this.dingTalkConfig.dingTalkClient();
            OapiRobotSendResponse response = (OapiRobotSendResponse)dingTalkClient.execute((TaobaoRequest)request);
            log.info(response.getBody());
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
    }
}

