/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.RestfulResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaijiacloudServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(BaijiacloudServiceUtil.class);
    private static final String SIGN_SPLIT = "&";
    private static final String DEF_CHARSET = "UTF-8";

    public static <T> RestfulResult<T> query(RestMethod restMethod, String url, Map<String, String> params, Map<String, String> headers, TypeReference<RestfulResult<T>> dataType, String partnerKey) {
        params.put("partner_key", partnerKey);
        String signData = BaijiacloudServiceUtil.createSignData(params);
        String sign = BaijiacloudServiceUtil.getSignature(signData);
        params.remove("partner_key");
        params.put("sign", sign);
        log.info("query param : {}, signData: {}", params, (Object)signData);
        String resultJson = null;
        switch (restMethod) {
            case POST: {
                resultJson = HttpClientUtils.doPost((String)url.toString(), params, headers, (String)DEF_CHARSET);
                break;
            }
            case GET: {
                resultJson = HttpClientUtils.doGet((String)url.toString(), params, headers, (String)DEF_CHARSET);
            }
        }
        log.info("resultJson\uff1d{}", resultJson);
        try {
            return (RestfulResult)JacksonUtil.str2Obj((String)resultJson, dataType);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u89e3\u6790json\u5931\u8d25", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadMedia(String url, Map<String, String> params, String fileParamName, File file, String partnerKey) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        if (MapUtils.isEmpty(params)) {
            return;
        }
        if (Objects.isNull(file)) {
            return;
        }
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        HttpPost post = new HttpPost(url);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        params.put("partner_key", partnerKey);
        String signData = BaijiacloudServiceUtil.createSignData(params);
        String sign = BaijiacloudServiceUtil.getSignature(signData);
        params.remove("partner_key");
        params.put("sign", sign);
        multipartEntityBuilder.addBinaryBody(fileParamName, file);
        for (Map.Entry<String, String> param : params.entrySet()) {
            multipartEntityBuilder.addTextBody(param.getKey(), param.getValue());
        }
        HttpEntity entity = multipartEntityBuilder.build();
        post.setEntity(entity);
        BufferedReader reader = null;
        try {
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);
            HttpEntity responseEntity = httpResponse.getEntity();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                reader = new BufferedReader(new InputStreamReader(responseEntity.getContent()));
                StringBuilder buffer = new StringBuilder();
                String str = "";
                while (!StringUtils.isEmpty((CharSequence)(str = reader.readLine()))) {
                    buffer.append(str);
                }
                log.info("request result: {}", (Object)buffer.toString());
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("reader close error", (Throwable)e);
                }
            }
        }
    }

    public static <T> RestfulResult<T> queryWithDefPara(RestMethod restMethod, String url, Map<String, String> params, Map<String, String> headers, TypeReference<RestfulResult<T>> dataType, String partnerId, String partnerKey) throws Exception {
        if (params == null) {
            params = Maps.newHashMapWithExpectedSize((int)3);
        }
        params.put("partner_id", partnerId);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return BaijiacloudServiceUtil.query(restMethod, url, params, headers, dataType, partnerKey);
    }

    public static <T> RestfulResult<T> postWithDefPara(String url, Map<String, String> params, Map<String, String> headers, TypeReference<RestfulResult<T>> dataType, String partnerId, String partnerKey) throws Exception {
        return BaijiacloudServiceUtil.queryWithDefPara(RestMethod.POST, url, params, headers, dataType, partnerId, partnerKey);
    }

    private static String createSignData(Map<String, String> params) {
        StringBuilder signData = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            int size = params.size();
            String[] paraNames = new String[size];
            Arrays.sort(params.keySet().toArray(paraNames), (o1, o2) -> {
                int result = o1.compareTo((String)o2);
                if (result == 0) {
                    return 0;
                }
                if (o1.equals("partner_key")) {
                    result = 1;
                }
                if (o2.equals("partner_key")) {
                    result = -1;
                }
                return result;
            });
            for (int i = 0; i < size; ++i) {
                String paraName = paraNames[i];
                String value = params.get(paraName);
                if (i != 0) {
                    signData.append(SIGN_SPLIT);
                }
                signData.append(paraName).append("=").append(value);
            }
        }
        return signData.toString();
    }

    private static String getSignature(String signData) {
        return DigestUtils.md5Hex((String)signData);
    }

    public static enum RestMethod {
        GET,
        POST;

    }
}

