/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.google.common.collect.Maps;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.PriceUtils;
import com.kuaike.scrm.dal.meeting.dto.MeetingGoodsRelDto;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BaijiacloudParamBuildUtils {
    public static Map<String, String> buildBjyCouponAddParam(ShopCoupon shopCoupon, String callback) {
        HashMap param = Maps.newHashMap();
        String couponType = "";
        if (shopCoupon.getType() == 2 || shopCoupon.getType() == 102) {
            couponType = "0";
        } else if (shopCoupon.getType() == 3 || shopCoupon.getType() == 103) {
            couponType = "2";
        } else if (shopCoupon.getType() == 4 || shopCoupon.getType() == 104) {
            couponType = "1";
        } else if (shopCoupon.getType() == 1 || shopCoupon.getType() == 101) {
            couponType = "2";
        }
        Long discountFee = Objects.isNull(shopCoupon.getDiscountFee()) ? 0L : shopCoupon.getDiscountFee();
        String validStartTime = null;
        String validEndTime = null;
        validStartTime = DateUtil.dateToDateString(shopCoupon.getReceiveStartTime());
        validEndTime = DateUtil.dateToDateString(shopCoupon.getReceiveEndTime());
        param.put("type", couponType);
        param.put("coupon_title", shopCoupon.getName());
        param.put("total", String.valueOf(shopCoupon.getTotalNum()));
        param.put("callback", callback);
        param.put("money", PriceUtils.priceToStr(discountFee, 2));
        param.put("valid_start_time", validStartTime);
        param.put("valid_end_time", validEndTime);
        param.put("mini_charge_money", PriceUtils.priceToStr(shopCoupon.getProductPrice(), 2));
        return param;
    }

    public static Map<String, String> buildBjyCouponEditParam(ShopCoupon shopCoupon, String callback) {
        HashMap param = Maps.newHashMap();
        param.put("type", String.valueOf(shopCoupon.getType()));
        param.put("coupon_title", shopCoupon.getName());
        param.put("total", String.valueOf(shopCoupon.getTotalNum()));
        param.put("callback", callback);
        param.put("coupon_batch_no", shopCoupon.getCouponButchNo());
        return param;
    }

    public static Map<String, String> buildBjyCouponDelParam(ShopCoupon shopCoupon) {
        HashMap param = Maps.newHashMap();
        param.put("coupon_batch_no", shopCoupon.getCouponButchNo());
        return param;
    }

    public static Map<String, String> buildBjyAssociateCouponParam(List<String> butchCouponNos, String roomId) {
        HashMap params = Maps.newHashMap();
        String couponButchNos = String.join((CharSequence)",", butchCouponNos);
        params.put("room_id", roomId);
        params.put("coupon_batch_nos", couponButchNos);
        return params;
    }

    public static Map<String, String> buildCouponUnAssociaRoom(List<String> couponBatchNo, String roomId) {
        HashMap param = Maps.newHashMap();
        String couponButchNos = String.join((CharSequence)",", couponBatchNo);
        param.put("room_id", roomId);
        param.put("coupon_batch_nos", couponButchNos);
        return param;
    }

    public static Map<String, String> buildDelBjyGoodsParam(MeetingGoodsRelDto meetingGoodsRel) {
        HashMap param = Maps.newHashMap();
        param.put("room_id", meetingGoodsRel.getRoomId());
        param.put("goods_id", meetingGoodsRel.getBjyGoodsId());
        param.put("product_type", "1");
        return param;
    }

    public static Map<String, String> buildAddBjyGoodsParam(MeetingGoodsRelDto meetingGoodsRel) {
        HashMap param = Maps.newHashMap();
        param.put("goods_name", meetingGoodsRel.getGoodsName());
        param.put("room_id", meetingGoodsRel.getRoomId());
        param.put("goods_img", meetingGoodsRel.getGoodsUrl());
        param.put("price", PriceUtils.priceToStr(meetingGoodsRel.getGoodsOriginPrice(), 4));
        param.put("discount_price", PriceUtils.priceToStr(meetingGoodsRel.getGoodsDiscountPrice(), 4));
        param.put("url", meetingGoodsRel.getGoodsDetailUrl());
        param.put("desc", meetingGoodsRel.getGoodsDes());
        param.put("media_id", "0");
        param.put("product_type", "1");
        return param;
    }

    public static Map<String, String> buildEditGoods(MeetingGoodsRelDto meetingGoodsRel) {
        HashMap param = Maps.newHashMap();
        param.put("goods_name", meetingGoodsRel.getGoodsName());
        param.put("room_id", meetingGoodsRel.getRoomId());
        param.put("goods_img", meetingGoodsRel.getGoodsUrl());
        param.put("price", PriceUtils.priceToStr(meetingGoodsRel.getGoodsOriginPrice(), 4));
        param.put("discount_price", PriceUtils.priceToStr(meetingGoodsRel.getGoodsDiscountPrice(), 4));
        param.put("url", meetingGoodsRel.getGoodsDetailUrl());
        param.put("desc", meetingGoodsRel.getGoodsDes());
        param.put("media_id", "0");
        param.put("goods_id", meetingGoodsRel.getBjyGoodsId());
        param.put("product_type", "1");
        return param;
    }

    public static Map<String, String> buildConfigParam(String keywordCallBackUrl, String enableLiveChatKeyword, String enabelUserEvent, String userEventCallBackUrl, String enableLiveSellPc, String enableUserLuckyBag) {
        HashMap param = Maps.newHashMap();
        param.put("live_chat_keywork_callback_url", keywordCallBackUrl);
        param.put("enable_live_chat_keyword", enableLiveChatKeyword);
        param.put("enable_user_event_callback", enabelUserEvent);
        param.put("user_event_callback_url", userEventCallBackUrl);
        param.put("enable_live_sell_pc_student", enableLiveSellPc);
        param.put("enable_use_lucky_bag", enableUserLuckyBag);
        return param;
    }
}

