/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.excel.ExcelHeader;
import com.kuaike.scrm.common.utils.DateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackendExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(BackendExcelUtils.class);
    private static final int HEADER_ROWS = 1;
    private static final int MAX_ROWS = 5000;
    private static final Long MAX_EXPORT_SIZE = 500000L;

    public static Workbook createWorkBook(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        return WorkbookFactory.create((InputStream)inp);
    }

    public static <T extends Serializable> List<T> parseExcelStreamToList(InputStream inputStream, Class<T> tClass, List<ExcelHeader> excelHeaderList) throws IllegalAccessException, Exception {
        Workbook workbook = null;
        try {
            workbook = BackendExcelUtils.createWorkBook(inputStream);
        }
        catch (IOException e) {
            log.error("\u521b\u5efaworkbook\u5f02\u5e38:errorMsg:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efaworkbook\u6d88\u606f\u5f02\u5e38");
        }
        return BackendExcelUtils.parseExcelWorkbook(workbook, 0, tClass, excelHeaderList);
    }

    private static void checkImportUrl(Sheet sheet, int maxRow, int headRow) {
        try {
            int checkRow = maxRow + headRow + 1;
            Row row5000 = sheet.getRow(checkRow);
            if (row5000 != null) {
                boolean isEmpty = true;
                for (int cn = 0; cn < row5000.getLastCellNum(); ++cn) {
                    Cell cell = row5000.getCell(cn, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    String cellValue = cell != null ? cell.toString() : "";
                    log.info("checkImportUrl cellValue: {}", (Object)cellValue.trim());
                    if (cellValue.trim().isEmpty()) continue;
                    isEmpty = false;
                    break;
                }
                log.info("checkImportUrl get isEmpty: {}", (Object)isEmpty);
                if (!isEmpty) {
                    String errMsg = "\u5355\u6b21\u6700\u591a\u5bfc\u5165" + maxRow + "\u6761";
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, errMsg);
                }
            }
        }
        catch (Exception e) {
            log.error("checkImportUrl\uff0c e: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }

    public static <T extends Serializable> List<T> parseExcelWorkbook(Workbook workbook, Integer sheetAt, Class<T> clazz, List<ExcelHeader> headers) throws Exception {
        Cell cell;
        int i;
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        if (Objects.isNull(workbook)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "excel workbook \u4e0d\u80fd\u4e3a\u7a7a\uff1a");
        }
        Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
        if (Objects.isNull(sheet)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5728excel\u4e2d\u672a\u627e\u5230\u7b2c" + sheetAt + "\u5217\u7684sheet:");
        }
        int numberOfRows = sheet.getPhysicalNumberOfRows();
        if (numberOfRows - 1 > 5000) {
            log.warn("excel\u6587\u4ef6\u4e2d\u6570\u636e\u603b\u884c\u6570\u4e3a:{}", (Object)(numberOfRows - 1));
        }
        BackendExcelUtils.checkImportUrl(sheet, 5000, 1);
        Row row = sheet.getRow(0);
        if (row == null) {
            return list;
        }
        for (ExcelHeader header : headers) {
            String fieldName = "";
            for (i = 0; i < row.getLastCellNum(); ++i) {
                cell = row.getCell(i);
                if (StringUtils.isBlank((CharSequence)cell.getStringCellValue()) || !cell.getStringCellValue().trim().equals(header.getName())) continue;
                fieldName = header.getFieldName();
                header.setColumnIndex(i);
            }
            if (!StringUtils.isBlank((CharSequence)fieldName) || !header.getName().startsWith("*")) continue;
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5217\u540d\u3010" + header.getFieldName() + "-" + header.getName() + "\u3011");
        }
        for (i = 1; i <= sheet.getLastRowNum(); ++i) {
            Object entity;
            try {
                entity = (Serializable)clazz.newInstance();
            }
            catch (Exception e) {
                return list;
            }
            row = sheet.getRow(i);
            if (Objects.isNull(row)) continue;
            for (ExcelHeader header : headers) {
                if (header.getColumnIndex() < 0) continue;
                cell = row.getCell(header.getColumnIndex());
                Object cellValue = BackendExcelUtils.getCellValue(cell, header);
                try {
                    if (entity instanceof String) {
                        String strCellValue = Objects.toString(cellValue, "");
                        entity = StringUtils.isBlank((CharSequence)strCellValue) ? null : strCellValue;
                        continue;
                    }
                    BackendExcelUtils.setFieldValueByName(header, cellValue, entity);
                }
                catch (Exception e) {
                    log.error(String.format("excel\u7684 %s \u9875\u7b7e\u7b2c %d \u884c\u7b2c %s \u5217\u7684\u5185\u5bb9\u4e0d\u6b63\u786e:%s\uff01", sheet.getSheetName(), i, header.getName(), cellValue), (Object)e.getMessage());
                }
            }
            if (BackendExcelUtils.checkObjAllFieldsIsNull(entity)) continue;
            list.add((Serializable)entity);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable, F extends Serializable> void doButchListToExcel(String filePath, T functionParam, Function<T, List<F>> executionFunction, List<ExcelHeader> excelHeaders, String sheetName, Boolean bigData) throws Exception {
        long partitionSize;
        List<Object> tList = Lists.newArrayList();
        try {
            tList = executionFunction.apply(functionParam);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38\uff1a\uff0cparam:{}; sheetNameL{}; excelHeaders:{}", new Object[]{JSON.toJSONString(functionParam), sheetName, JSON.toJSONString(excelHeaders)});
            throw e;
        }
        long totalExportSize = partitionSize = CollectionUtils.isEmpty((Collection)tList) ? 0L : (long)tList.size();
        ExcelWriter excelWriter = null;
        try {
            excelWriter = EasyExcelFactory.write((String)filePath).build();
            WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
            WriteTable writeTable = new WriteTable();
            Map<String, List<List<String>>> headerLinkDate = BackendExcelUtils.buildHeaderLinkDate(excelHeaders, tList);
            writeTable.setHead(headerLinkDate.get("header"));
            List<List<String>> data = headerLinkDate.get("data");
            excelWriter.write(data, writeSheet, writeTable);
            long lastButchSize = partitionSize;
            while (Objects.nonNull(bigData) && bigData.booleanValue() && partitionSize > 0L && lastButchSize >= partitionSize && totalExportSize <= MAX_EXPORT_SIZE) {
                boolean paramPageUpdate = BackendExcelUtils.updatePageQueryParam(functionParam, 1);
                if (!paramPageUpdate) {
                    lastButchSize = 0L;
                    continue;
                }
                try {
                    List<F> fList = executionFunction.apply(functionParam);
                    lastButchSize = CollectionUtils.isEmpty(fList) ? 0L : (long)fList.size();
                    totalExportSize += lastButchSize;
                    Map<String, List<List<String>>> stringListMap = BackendExcelUtils.buildHeaderLinkDate(excelHeaders, fList);
                    List<List<String>> loopList = stringListMap.get("data");
                    excelWriter.write(loopList, writeSheet, writeTable);
                }
                catch (Exception e) {
                    log.error("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38\uff1a\uff0cparam:{}; sheetNameL{}; excelHeaders:{}", new Object[]{JSON.toJSONString(functionParam), sheetName, JSON.toJSONString(excelHeaders), e});
                    if (excelWriter != null) {
                        excelWriter.finish();
                    }
                    return;
                }
            }
            excelWriter.finish();
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
    }

    public static <T extends Serializable> void doListToExcel(HttpServletResponse response, List<T> tList, List<ExcelHeader> excelHeaders, String fileName, String sheetName) throws IOException {
        String realFileName = fileName + ExcelTypeEnum.XLSX.getValue();
        OutputStream webOutputStream = BackendExcelUtils.getWebOutputStream(response, realFileName);
        Map<String, List<List<String>>> headerLinkDate = BackendExcelUtils.buildHeaderLinkDate(excelHeaders, tList);
        List<List<String>> header = headerLinkDate.get("header");
        List<List<String>> data = headerLinkDate.get("data");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)webOutputStream).head(header)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName).doWrite(data);
    }

    private static OutputStream getWebOutputStream(HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes(), StandardCharsets.ISO_8859_1) + "\"");
        ServletOutputStream fileWriter = response.getOutputStream();
        return fileWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void doListToLocalExcel(String filePath, List<T> tList, List<ExcelHeader> excelHeaders, String sheetName) throws Exception {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u672a\u586b\u5199");
        }
        if (CollectionUtils.isEmpty(excelHeaders)) {
            throw new IllegalArgumentException("\u8868\u5934\u672a\u586b\u5199");
        }
        ExcelWriter excelWriter = null;
        try {
            excelWriter = EasyExcelFactory.write((String)filePath).build();
            WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
            WriteTable writeTable = new WriteTable();
            Map<String, List<List<String>>> headerLinkDate = BackendExcelUtils.buildHeaderLinkDate(excelHeaders, tList);
            writeTable.setHead(headerLinkDate.get("header"));
            List<List<String>> data = headerLinkDate.get("data");
            excelWriter.write(data, writeSheet, writeTable);
            excelWriter.finish();
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
    }

    private static boolean updatePageQueryParam(Object queryParam, Integer updatePageNum) {
        Field[] fields;
        if (Objects.isNull(queryParam) || Objects.isNull(updatePageNum)) {
            return false;
        }
        Boolean updateResult = false;
        for (Field field : fields = queryParam.getClass().getDeclaredFields()) {
            Type type = field.getGenericType();
            if (type != PageDto.class) continue;
            field.setAccessible(true);
            try {
                Object o = field.get(queryParam);
                PageDto realFieldType = (PageDto)o;
                if (Objects.isNull(realFieldType)) continue;
                realFieldType.setPageNum(Integer.valueOf(realFieldType.getPageNum() + updatePageNum));
                field.set(queryParam, realFieldType);
                updateResult = true;
            }
            catch (Exception e) {
                log.error("\u53cd\u5c04\u83b7\u53d6\u6570\u636e\u5931\u8d25,", (Throwable)e);
            }
        }
        return updateResult;
    }

    private static <T extends Serializable> Map<String, List<List<String>>> buildHeaderLinkDate(List<ExcelHeader> excelHeaders, List<T> dataList) {
        ArrayList exportHeaderList = Lists.newArrayList();
        ArrayList excelDateList = Lists.newArrayList();
        excelHeaders.stream().forEach(excelHeader -> exportHeaderList.add(Lists.newArrayList((Object[])new String[]{excelHeader.getName()})));
        HashMap headerAndDataMap = Maps.newHashMap();
        headerAndDataMap.put("header", exportHeaderList);
        headerAndDataMap.put("data", excelDateList);
        if (CollectionUtils.isEmpty(dataList)) {
            return headerAndDataMap;
        }
        dataList.stream().forEach(itemDate -> {
            ArrayList rowData = Lists.newArrayList();
            excelHeaders.stream().forEach(excelHeader -> {
                try {
                    Field field = itemDate.getClass().getDeclaredField(excelHeader.getFieldName());
                    field.setAccessible(true);
                    Object result = field.get(itemDate);
                    if (Objects.isNull(result)) {
                        rowData.add("");
                    } else if (result instanceof Integer) {
                        Map<Integer, String> showNameFromValue = excelHeader.getShowNameFromValue();
                        if (MapUtils.isNotEmpty(showNameFromValue)) {
                            String showName = showNameFromValue.get((Integer)result);
                            if (StringUtils.isNotBlank((CharSequence)showName)) {
                                rowData.add(showName);
                            } else {
                                rowData.add(String.valueOf(result));
                            }
                        } else {
                            rowData.add(String.valueOf(result));
                        }
                    } else if (result instanceof List) {
                        String listStr = JSON.toJSONString((Object)result);
                        listStr = StringUtils.replace((String)listStr, (String)"[", (String)"");
                        listStr = StringUtils.replace((String)listStr, (String)"]", (String)"");
                        listStr = StringUtils.replace((String)listStr, (String)"\"", (String)"");
                        rowData.add(listStr);
                    } else if (result instanceof Date) {
                        Date date = (Date)result;
                        rowData.add(DateUtil.dateToDateString(date));
                    } else if (result instanceof Long) {
                        if (Objects.nonNull(excelHeader.getIsAmount()) && excelHeader.getIsAmount().booleanValue()) {
                            Long amount = (Long)result;
                            rowData.add(String.valueOf((double)amount.longValue() / 10000.0));
                        } else {
                            rowData.add(String.valueOf(result));
                        }
                    } else if (result instanceof String) {
                        rowData.add(String.valueOf(result));
                    } else {
                        rowData.add(JSON.toJSONString((Object)result));
                    }
                }
                catch (NoSuchFieldException e) {
                    log.error("\u901a\u8fc7\u8868\u5934\u83b7\u53d6\u5b9e\u4f8b\u5c5e\u6027\u4e3a\u627e\u5230", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error("\u64cd\u4f5c\u5bf9\u8c61\u5c5e\u6027\u6743\u9650\u5931\u8d25", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u6570\u636e\u5931\u8d25", (Throwable)e);
                }
            });
            excelDateList.add(rowData);
        });
        return headerAndDataMap;
    }

    private static Object getCellValue(Cell cell, ExcelHeader header) {
        Object value = null;
        if (cell == null) {
            return value;
        }
        CellType cellType = BackendExcelUtils.getImportCellType(cell, header);
        switch (cellType) {
            case STRING: {
                cell.setCellType(CellType.STRING);
                value = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                if (org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case ERROR: {
                value = cell.getErrorCellValue();
                break;
            }
        }
        return value;
    }

    private static CellType getImportCellType(Cell cell, ExcelHeader excelHeader) {
        if (Objects.isNull(excelHeader)) {
            return cell.getCellType();
        }
        if (Objects.nonNull(excelHeader.getIsAmount()) && excelHeader.getIsAmount().booleanValue()) {
            return CellType.NUMERIC;
        }
        if (StringUtils.isNotBlank((CharSequence)excelHeader.getFormat()) && excelHeader.getFormat().startsWith("###")) {
            return CellType.STRING;
        }
        return cell.getCellType();
    }

    private static void setFieldValueByName(ExcelHeader excelHeader, Object fieldValue, Object o) throws Exception {
        Field field = BackendExcelUtils.getFieldByName(excelHeader.getFieldName(), o.getClass());
        if (field != null) {
            field.setAccessible(true);
            Class<?> clazz = field.getType();
            String strValue = Objects.toString(fieldValue, "");
            if (fieldValue == null || StringUtils.isBlank((CharSequence)strValue)) {
                field.set(o, null);
                return;
            }
            if (clazz == String.class) {
                if (fieldValue instanceof Number) {
                    if (((Number)fieldValue).doubleValue() == (double)((Number)fieldValue).intValue()) {
                        field.set(o, String.valueOf(((Number)fieldValue).intValue()));
                    } else {
                        field.set(o, String.valueOf(((Number)fieldValue).doubleValue()));
                    }
                } else {
                    field.set(o, strValue);
                }
            } else if (clazz == Integer.class || clazz == Integer.TYPE) {
                field.set(o, fieldValue instanceof Number ? ((Number)fieldValue).intValue() : Integer.parseInt(strValue));
            } else if (clazz == Float.class || clazz == Float.TYPE) {
                field.set(o, Float.valueOf(fieldValue instanceof Number ? ((Number)fieldValue).floatValue() : Float.parseFloat(strValue)));
            } else if (clazz == Double.class || clazz == Double.TYPE) {
                field.set(o, fieldValue instanceof Number ? ((Number)fieldValue).doubleValue() : Double.parseDouble(strValue));
            } else if (clazz == Date.class) {
                if (!StringUtils.isBlank((CharSequence)Objects.toString(fieldValue, ""))) {
                    field.set(o, fieldValue);
                }
            } else if (clazz == Long.class || clazz == Long.TYPE) {
                if (Objects.nonNull(excelHeader.getIsAmount()) && excelHeader.getIsAmount().booleanValue()) {
                    Double doublevalue = fieldValue instanceof Number ? ((Number)fieldValue).doubleValue() * 10000.0 : Double.parseDouble(strValue) * 10000.0;
                    field.set(o, doublevalue.longValue());
                } else {
                    field.set(o, fieldValue instanceof Number ? ((Number)fieldValue).longValue() : Long.parseLong(strValue));
                }
            } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                field.set(o, Boolean.parseBoolean(strValue));
            } else if (clazz == Byte.class || clazz == Byte.TYPE) {
                field.set(o, fieldValue instanceof Number ? ((Number)fieldValue).byteValue() : Byte.parseByte(strValue));
            } else if (clazz == Character.class || clazz == Character.TYPE) {
                field.set(o, strValue);
            } else if (clazz == Short.class || clazz == Short.TYPE) {
                field.set(o, fieldValue instanceof Number ? ((Number)fieldValue).shortValue() : Short.parseShort(strValue));
            } else {
                field.set(o, strValue);
            }
        } else {
            throw new RuntimeException(o.getClass().getSimpleName() + "\u7c7b\u4e0d\u5b58\u5728\u5b57\u6bb5\u540d " + excelHeader.getFieldName());
        }
    }

    private static Field getFieldByName(String fieldName, Class<?> clazz) {
        Field[] selfFields;
        for (Field field : selfFields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && superClazz != Object.class) {
            return BackendExcelUtils.getFieldByName(fieldName, superClazz);
        }
        return null;
    }

    public static boolean checkObjAllFieldsIsNull(Object object) {
        if (Objects.isNull(object)) {
            return true;
        }
        try {
            for (Field f : object.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if ("serialVersionUID".equals(f.getName()) || f.get(object) == null || !StringUtils.isNotBlank((CharSequence)f.get(object).toString())) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

