/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.scrm.common.utils.DateUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public final class AutoCreateIndexUtil {
    private static final Logger log = LoggerFactory.getLogger(AutoCreateIndexUtil.class);
    @Value(value="${scrm.auto.create.index.type:2}")
    private Integer type;
    @Value(value="${scrm.elasticsearch.chatMessageIndex}")
    private String index;
    private static final String DELIMITER = "_";

    private boolean isDay() {
        return this.type == 1;
    }

    public static String getIndexAlias(String index) {
        return index + DELIMITER + "alias";
    }

    public String getIndexName(Date date) {
        String indexName = this.isDay() ? AutoCreateIndexUtil.getIndexNameByDay(this.index, date) : AutoCreateIndexUtil.getIndexNameByMonth(this.index, date);
        log.info("getIndexName indexName:{}", (Object)indexName);
        return indexName;
    }

    public static String getIndexNameByMonth(String template, Date date) {
        String curMonthStr = DateUtil.dateToDateString(date, "yyyy-MM");
        return template + DELIMITER + curMonthStr;
    }

    public static String getIndexNameByDay(String template, Date date) {
        String curDayStr = DateUtil.dateToDateString(date, "yyyy-MM-dd");
        return template + DELIMITER + curDayStr;
    }
}

