/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdName;
import com.kuaike.scrm.common.dto.RefundReasonDto;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.req.RefundReasonReq;
import com.kuaike.scrm.common.service.dto.req.SettingReqDto;
import com.kuaike.scrm.common.service.dto.resp.RefundOrderConfigDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.mapper.SettingMapper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefundReasonSupport {
    @Autowired
    private SettingService settingService;
    @Autowired
    private SettingMapper settingMapper;

    public void addRefundReason(RefundReasonReq req) {
        List<RefundReasonDto> refundReasons = req.getRefundReasons();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        this.saveApprovalConfig(req.getApprovalType());
        if (CollectionUtils.isEmpty(refundReasons)) {
            return;
        }
        for (RefundReasonDto refundReason : refundReasons) {
            refundReason.validate();
        }
        Set toAdd = refundReasons.stream().filter(item -> Objects.isNull(item.getId())).collect(Collectors.toSet());
        Set toUpdate = refundReasons.stream().filter(item -> Objects.nonNull(item.getId()) && Objects.nonNull(item.getStatus()) && item.getStatus() == 1).collect(Collectors.toSet());
        Set toDel = refundReasons.stream().filter(item -> Objects.nonNull(item.getId()) && Objects.nonNull(item.getStatus()) && item.getStatus() == 0).map(RefundReasonDto::getId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(toDel)) {
            this.settingMapper.deleteByIds(toDel, Integer.valueOf(SettingEnum.REFUND_REASON.getId()));
        }
        for (RefundReasonDto rr : toUpdate) {
            this.settingMapper.updateSettingById(rr.getName(), rr.getId(), currentUser.getId());
        }
        for (RefundReasonDto refundReasonDto : toAdd) {
            SettingReqDto settingReqDto = new SettingReqDto();
            settingReqDto.setSettingType(SettingEnum.REFUND_REASON);
            settingReqDto.setParamValue(refundReasonDto.getName());
            settingReqDto.setParamName(SettingEnum.REFUND_REASON.getName());
            this.settingService.modSetting(settingReqDto);
        }
    }

    private void saveApprovalConfig(Integer approvalType) {
        if (approvalType == null) {
            approvalType = 0;
        }
        SettingReqDto req = new SettingReqDto();
        req.setParamName(SettingEnum.APPROVAL_TYPE.getName());
        req.setSettingType(SettingEnum.APPROVAL_TYPE);
        req.setParamValue(String.valueOf(approvalType));
        this.settingService.modSetting(req);
    }

    public RefundOrderConfigDto listRefundReason(RefundReasonDto req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Page listByValue = PageHelper.startPage((int)1, (int)20).doSelectPage(() -> this.settingMapper.getListByValue(currentUser.getBizId(), Integer.valueOf(SettingEnum.REFUND_REASON.getId()), req.getName()));
        RefundOrderConfigDto configDto = new RefundOrderConfigDto();
        if (CollectionUtils.isEmpty((Collection)listByValue)) {
            return configDto;
        }
        List<IdName> list = listByValue.stream().map(item -> {
            IdName idName = new IdName();
            idName.setName(item.getParamValue());
            idName.setId((Object)item.getId());
            return idName;
        }).distinct().collect(Collectors.toList());
        configDto.setReasons(list);
        Integer approvalType = this.settingService.getInteger(currentUser.getBizId(), SettingEnum.APPROVAL_TYPE.getName());
        configDto.setApprovalType(approvalType);
        return configDto;
    }
}

