/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.BDataValueDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.dto.req.OrgListReqDto;
import com.kuaike.scrm.common.service.dto.req.OrgNetSchoolReqDto;
import com.kuaike.scrm.common.service.dto.resp.DeptNameRespDto;
import com.kuaike.scrm.common.service.dto.resp.OrgListItemDto;
import com.kuaike.scrm.common.service.dto.resp.OrgListRespDto;
import com.kuaike.scrm.common.service.dto.resp.OrgNetSchoolRespDto;
import com.kuaike.scrm.common.service.dto.resp.PositionRespDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.dto.OrgQueryParams;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartment;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class OrgServiceImpl
implements OrgService {
    private static final Logger log = LoggerFactory.getLogger(OrgServiceImpl.class);
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkDepartmentMapper weworkDepartmentMapper;

    @Override
    public List<OrgListRespDto> treeList(OrgListReqDto reqDto) {
        List organizations;
        OrgQueryParams queryParams;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("treeList,reqDto:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        HashSet<Long> manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        User user = (User)this.userMapper.selectByPrimaryKey((Object)currentUserInfo.getId());
        if (CollectionUtils.isEmpty((Collection)manageNodeIds)) {
            manageNodeIds = new HashSet<Long>();
        }
        if (CollectionUtils.isNotEmpty((Collection)manageNodeIds)) {
            manageNodeIds = this.nodeService.getPosterityIds(manageNodeIds, bizId);
        }
        if (Objects.nonNull(user.getNodeId())) {
            manageNodeIds.add(user.getNodeId());
        }
        if (reqDto.isNeedPermissionControl()) {
            queryParams = new OrgQueryParams();
            queryParams.setBizId(bizId);
            queryParams.setCorpId(corpId);
            queryParams.setIds(manageNodeIds);
            organizations = this.organizationMapper.selectOrgsByParams(queryParams);
        } else if (reqDto.getOrgId() != null) {
            manageNodeIds = this.nodeService.getPosterityIds((Collection)Lists.newArrayList((Object[])new Long[]{reqDto.getOrgId()}), bizId);
            queryParams = new OrgQueryParams();
            queryParams.setBizId(bizId);
            queryParams.setCorpId(corpId);
            queryParams.setIds(manageNodeIds);
            organizations = this.organizationMapper.selectOrgsByParams(queryParams);
        } else {
            organizations = this.organizationMapper.selectByBizIdAndCorpId(bizId, corpId);
        }
        ArrayList nodeList = Lists.newArrayList();
        for (Organization org : organizations) {
            nodeList.add(this.from(org, manageNodeIds, reqDto.isNotNeedControlDisabled()));
        }
        List<OrgListRespDto> result = reqDto.isNeedPermissionControl() ? OrgServiceImpl.buildPartOrgNodeTrees(nodeList) : OrgServiceImpl.buildNodeTrees(nodeList);
        return result;
    }

    public static List<OrgListRespDto> buildNodeTrees(List<OrgListRespDto> nodes) {
        ArrayList nodeTrees = Lists.newArrayList();
        if (CollectionUtils.isEmpty(nodes)) {
            return nodeTrees;
        }
        Map map = nodes.stream().collect(Collectors.toMap(OrgListRespDto::getId, Function.identity()));
        for (OrgListRespDto node : nodes) {
            if (!map.containsKey(node.getPid())) {
                nodeTrees.add(node);
                continue;
            }
            OrgListRespDto parent = (OrgListRespDto)map.get(node.getPid());
            if (parent.getChildren() == null) {
                parent.setChildren(Lists.newArrayList());
            }
            parent.getChildren().add(node);
        }
        for (OrgListRespDto node : nodes) {
            if (map.containsKey(node.getPid())) continue;
            OrgServiceImpl.buildIdAndNames(node, null, null);
        }
        return nodeTrees;
    }

    public static List<OrgListRespDto> buildPartOrgNodeTrees(List<OrgListRespDto> nodes) {
        ArrayList nodeTrees = Lists.newArrayList();
        if (CollectionUtils.isEmpty(nodes)) {
            return nodeTrees;
        }
        Map map = nodes.stream().collect(Collectors.toMap(OrgListRespDto::getId, Function.identity()));
        for (OrgListRespDto node : nodes) {
            if (!map.containsKey(node.getPid())) {
                nodeTrees.add(node);
                continue;
            }
            OrgListRespDto parent = map.getOrDefault(node.getPid(), null);
            if (parent == null) continue;
            if (parent.getChildren() == null) {
                parent.setChildren(Lists.newArrayList());
            }
            parent.getChildren().add(node);
        }
        for (OrgListRespDto node : nodes) {
            if (map.containsKey(node.getPid())) continue;
            OrgServiceImpl.buildIdAndNames(node, null, null);
        }
        return nodeTrees;
    }

    private static void buildIdAndNames(OrgListRespDto node, List<Long> parentIds, List<String> parentNames) {
        ArrayList ids = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        node.setIds(ids);
        if (parentIds != null) {
            ids.addAll(parentIds);
            names.addAll(parentNames);
        }
        ids.add(node.getId());
        names.add(node.getName());
        if (CollectionUtils.isNotEmpty(node.getChildren())) {
            for (OrgListRespDto child : node.getChildren()) {
                OrgServiceImpl.buildIdAndNames(child, ids, names);
            }
        }
    }

    @Override
    public List<Node> getNodeWithoutChildren(Long bizId, Collection<Long> manageNodeIds) {
        log.info("getNodeWithoutChildren,bizId:{}, manageNodeIds:{}", (Object)bizId, manageNodeIds);
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(manageNodeIds), (Object)"\u7ba1\u7406\u7684\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        Map nodeMap = this.nodeService.getNodeMap(bizId);
        if (MapUtils.isEmpty((Map)nodeMap)) {
            return Collections.emptyList();
        }
        ArrayList nodes = Lists.newArrayListWithCapacity((int)manageNodeIds.size());
        for (Long nodeId : manageNodeIds) {
            nodes.add(Node.getNodeWithoutChildren((Long)nodeId, (Map)nodeMap));
        }
        return nodes;
    }

    @Override
    public Set<Integer> getDepartmentIds(Set<Long> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Sets.newHashSet();
        }
        return this.organizationMapper.queryDepartmentIds(nodeIds);
    }

    @Override
    public PositionRespDto getPositions() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("getPositions, operatorId:{},bizId:{},corpId:{}", new Object[]{currentUserInfo.getId(), bizId, corpId});
        List positions = this.weworkUserMapper.selectPositionsByCorpId(corpId);
        PositionRespDto positionRespDto = new PositionRespDto();
        positionRespDto.setPositions(positions);
        return positionRespDto;
    }

    @Override
    public List<DeptNameRespDto> getDeptNames(List<Integer> deptIds) {
        log.info("getDeptNames: list:{}", (Object)JSONObject.toJSONString(deptIds));
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("getDeptNames: operatorId:{},bizId:{},corpId:{}", new Object[]{currentUserInfo.getId(), bizId, corpId});
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(deptIds), (Object)"\u8f93\u5165\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        List deptNames = this.weworkDepartmentMapper.queryDeptNames(currentUserInfo.getCorpId(), deptIds);
        if (CollectionUtils.isEmpty((Collection)deptNames)) {
            log.info("getDeptNames: no result");
            return Collections.emptyList();
        }
        ArrayList respDtos = Lists.newArrayList();
        for (WeworkDepartment dept : deptNames) {
            DeptNameRespDto dto = new DeptNameRespDto();
            dto.setDeptId(dept.getDepartmentId());
            dto.setDeptName(dept.getName());
            respDtos.add(dto);
        }
        return respDtos;
    }

    private OrgListRespDto from(Organization org, Set<Long> manageNodeIds, boolean isNotNeedControlDisabled) {
        OrgListRespDto orgListRespDto = new OrgListRespDto();
        orgListRespDto.setId(org.getId());
        orgListRespDto.setName(org.getName());
        orgListRespDto.setPid(org.getPid());
        orgListRespDto.setDisabled(true);
        if (isNotNeedControlDisabled || CollectionUtils.isNotEmpty(manageNodeIds) && manageNodeIds.contains(org.getId())) {
            orgListRespDto.setDisabled(false);
        }
        orgListRespDto.setWeworkOrgId(org.getWeworkDepartmentId());
        return orgListRespDto;
    }

    @Override
    public Long getNodeIdByDepartmentId(String corpId, Integer deptId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"corpId\u4e3a\u7a7a");
        Preconditions.checkArgument((deptId != null ? 1 : 0) != 0, (Object)"deptId\u4e3a\u7a7a");
        return this.organizationMapper.selectNodeIdByCorpIdAndWeworkDepartmentId(corpId, deptId);
    }

    @Override
    public List<OrgListItemDto> orgList(OrgListReqDto reqDto) {
        List<OrgListRespDto> list = this.treeList(reqDto);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        HashSet orgIds = Sets.newHashSet();
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        for (OrgListRespDto dto : list) {
            this.getOrgIds(dto, orgIds);
        }
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return Lists.newArrayList();
        }
        Map numByIds = this.organizationMapper.getNumByIds(userInfo.getBizId(), (Collection)orgIds);
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (OrgListRespDto dto : list) {
            OrgListItemDto itemDto = this.buildResult(dto, numByIds);
            result.add(itemDto);
        }
        return result;
    }

    @Override
    public WeworkDepartment getDepById(String corpId, Integer depId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"corp \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(depId), (Object)"depId \u4e0d\u80fd\u4e3a\u7a7a");
        return this.weworkDepartmentMapper.getDepartment(corpId, depId);
    }

    @Override
    public List<BDataValueDto> getBDataOption(String query, PageDto pageDto) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query dept list, bizId={}, userId={}, query={}, pageDto={}", new Object[]{bizId, userId, query, pageDto});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        OrgQueryParams queryParams = new OrgQueryParams();
        queryParams.setIds((Collection)manageNodeIds);
        queryParams.setBizId(bizId);
        queryParams.setQuery(query);
        if (pageDto != null) {
            queryParams.setOffset(Integer.valueOf(pageDto.getOffset()));
            queryParams.setPageSize(pageDto.getPageSize());
        }
        List list = this.organizationMapper.selectOrgsByParams(queryParams);
        if (pageDto != null) {
            int count = this.organizationMapper.countOrgsByParams(queryParams);
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Organization it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(it.getNum());
                dto.setLabel(it.getName());
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public List<BDataValueDto> getBDataValues(String values) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query dept list, bizId={}, userId={}, values={}", new Object[]{bizId, userId, values});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        String[] args = StringUtils.split((String)values, (String)",");
        HashSet nums = Sets.newHashSet();
        for (String it : args) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            nums.add(it.trim());
        }
        List list = this.organizationMapper.selectOrgByNums((Collection)nums);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Organization it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(it.getNum());
                dto.setLabel(it.getName());
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public Set<Long> getDeptChildrenNodeIds(String query) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query dept children, bizId={}, userId={}, query={}", new Object[]{bizId, userId, query});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Set<String> nodeNumSet = this.distinctQueryNum(query);
        if (CollectionUtils.isEmpty(nodeNumSet)) {
            log.info("nodeNumSet is empty");
            return Collections.emptySet();
        }
        return this.getChildrenNodeIds(bizId, nodeNumSet);
    }

    @Override
    public Map<Long, Set<Long>> getDeptChildrenUserIds(String query) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query dept children, bizId={}, userId={}, query={}", new Object[]{bizId, userId, query});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Set<String> nodeNumSet = this.distinctQueryNum(query);
        if (CollectionUtils.isEmpty(nodeNumSet)) {
            log.info("nodeNumSet is empty");
            return Maps.newHashMap();
        }
        Map<Long, Set<Long>> childrenNodeIdsMap = this.getChildrenNodeIdsMap(bizId, nodeNumSet);
        if (MapUtils.isEmpty(childrenNodeIdsMap)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<Long, Set<Long>> entry : childrenNodeIdsMap.entrySet()) {
            Set userIds = this.userMapper.queryUserIdsByNodeIds((Collection)entry.getValue(), Boolean.valueOf(true));
            if (!CollectionUtils.isNotEmpty((Collection)userIds)) continue;
            result.put(entry.getKey(), userIds);
        }
        return result;
    }

    private Set<String> distinctQueryNum(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            log.info("query is empty");
            return Collections.emptySet();
        }
        String[] array = StringUtils.split((String)query, (String)",");
        HashSet<String> set = new HashSet<String>();
        for (String nodeNum : array) {
            if (!StringUtils.isNotBlank((CharSequence)nodeNum)) continue;
            set.add(nodeNum.trim());
        }
        return set;
    }

    private Set<Long> getChildrenNodeIds(Long bizId, Set<String> nodeNumSet) {
        Map nodeIdMap = this.nodeService.getIdByNums(bizId, nodeNumSet);
        if (MapUtils.isEmpty((Map)nodeIdMap)) {
            log.info("nodeIds is empty");
            return Collections.emptySet();
        }
        return this.nodeService.getPosterityIds(nodeIdMap.values(), bizId);
    }

    private Map<Long, Set<Long>> getChildrenNodeIdsMap(Long bizId, Set<String> nodeNumSet) {
        Map nodeIdMap = this.nodeService.getIdByNums(bizId, nodeNumSet);
        if (MapUtils.isEmpty((Map)nodeIdMap)) {
            log.info("nodeIds is empty");
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry entry : nodeIdMap.entrySet()) {
            result.put(entry.getValue(), this.nodeService.getPosterityIds((Long)entry.getValue(), bizId));
        }
        return result;
    }

    @Override
    public List<OrgListRespDto> getWeworkOrgId(List<OrgListRespDto> orgListRespDtos) {
        if (CollectionUtils.isEmpty(orgListRespDtos)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(orgListRespDtos);
        List<OrgListRespDto> collect = orgListRespDtos.stream().map(OrgListRespDto::getChildren).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return result;
        }
        List<OrgListRespDto> weworkOrgId = this.getWeworkOrgId(collect);
        if (CollectionUtils.isEmpty(weworkOrgId)) {
            return result;
        }
        result.addAll(weworkOrgId);
        return result;
    }

    @Override
    public List<Long> getParentNodeIdsByBizIdAndNodeId(Long bizId, Long nodeId) {
        if (Objects.isNull(bizId) || Objects.isNull(nodeId)) {
            log.warn("bizId:{},nodeId:{}\u90fd\u4e0d\u80fd\u4e3a\u7a7a", (Object)bizId, (Object)nodeId);
            return Collections.emptyList();
        }
        ArrayList pidIds = Lists.newArrayList();
        List organizations = this.organizationMapper.selectByBizId(bizId);
        if (CollectionUtils.isEmpty((Collection)organizations)) {
            log.info("\u6839\u636ebizId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)bizId);
            return pidIds;
        }
        Map orgId2OrgMap = organizations.stream().collect(Collectors.toMap(Organization::getId, Functions.identity()));
        Organization organization = (Organization)orgId2OrgMap.get(nodeId);
        while (organization != null) {
            Long pidId = organization.getPid();
            if (pidId > 0L) {
                pidIds.add(pidId);
            }
            organization = (Organization)orgId2OrgMap.get(pidId);
        }
        return pidIds;
    }

    @Override
    public List<OrgListRespDto> selectOrgByNums(List<String> orgNums, Long bizId, String corpId) {
        if (CollectionUtils.isEmpty(orgNums)) {
            return Lists.newArrayList();
        }
        List organizations = this.organizationMapper.selectOrgByNums(orgNums);
        Set manageNodeIds = organizations.stream().map(Organization::getId).collect(Collectors.toSet());
        manageNodeIds = this.nodeService.getPosterityIds(manageNodeIds, bizId);
        OrgQueryParams queryParams = new OrgQueryParams();
        queryParams.setBizId(bizId);
        queryParams.setCorpId(corpId);
        queryParams.setIds((Collection)manageNodeIds);
        organizations = this.organizationMapper.selectOrgsByParams(queryParams);
        ArrayList nodeList = Lists.newArrayList();
        for (Organization org : organizations) {
            nodeList.add(this.from(org, null, false));
        }
        List<OrgListRespDto> result = OrgServiceImpl.buildNodeTrees(nodeList);
        return result;
    }

    private void getOrgIds(OrgListRespDto dto, Set<Long> orgIds) {
        orgIds.add(dto.getId());
        orgIds.add(dto.getPid());
        List<OrgListRespDto> childrenList = dto.getChildren();
        if (CollectionUtils.isNotEmpty(childrenList)) {
            for (OrgListRespDto children : childrenList) {
                this.getOrgIds(children, orgIds);
            }
        }
    }

    private OrgListItemDto buildResult(OrgListRespDto dto, Map<Long, String> numByIds) {
        OrgListItemDto itemDto = new OrgListItemDto();
        itemDto.setId(numByIds.get(dto.getId()));
        ArrayList nums = Lists.newArrayListWithCapacity((int)dto.getIds().size());
        for (Long id : dto.getIds()) {
            nums.add(numByIds.get(id));
        }
        itemDto.setIds(nums);
        itemDto.setName(dto.getName());
        itemDto.setWeworkOrgId(dto.getWeworkOrgId());
        itemDto.setPid(numByIds.get(dto.getPid()));
        itemDto.setDisabled(dto.getDisabled());
        List<OrgListRespDto> childrenList = dto.getChildren();
        if (CollectionUtils.isNotEmpty(childrenList)) {
            ArrayList orgChildrens = Lists.newArrayListWithCapacity((int)childrenList.size());
            for (OrgListRespDto children : childrenList) {
                orgChildrens.add(this.buildResult(children, numByIds));
            }
            itemDto.setChildren(orgChildrens);
        }
        itemDto.setCount(dto.getCount());
        return itemDto;
    }

    @Override
    public Set<Long> toParentOrgIds(Long bizId, Set<Integer> deptIds) {
        if (CollectionUtils.isEmpty(deptIds)) {
            return Sets.newHashSet();
        }
        HashSet resultSet = Sets.newHashSet();
        List orgIds = this.organizationMapper.queryOrgIdByDepartmentIds(bizId, deptIds);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            log.info("toParentOrgIds: orgIds\u4e3a\u7a7a, bizId:{}, deptIds:{}", (Object)bizId, deptIds);
            return Sets.newHashSet();
        }
        for (Long orgId : orgIds) {
            resultSet.add(orgId);
            List<Long> parentOrgIds = this.getParentNodeIdsByBizIdAndNodeId(bizId, orgId);
            if (!CollectionUtils.isNotEmpty(parentOrgIds)) continue;
            resultSet.addAll(orgIds);
        }
        return resultSet;
    }

    @Override
    public List<Long> getNetSchoolIdsByIds(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return this.organizationMapper.getNetSchoolIdsByIds(ids);
    }

    @Override
    public void setNetSchool(OrgNetSchoolReqDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("setNetSchool: params:{}, operatorId:{}", (Object)params, (Object)userInfo.getId());
        params.validate();
        this.organizationMapper.updateNetSchoolId(params.getId(), params.getNetSchoolId(), userInfo.getId());
    }

    @Override
    public OrgNetSchoolRespDto getNetSchool(Long orgId) {
        OrgNetSchoolRespDto orgNetSchoolRespDto = new OrgNetSchoolRespDto();
        orgNetSchoolRespDto.setId(orgId);
        orgNetSchoolRespDto.setBizId(LoginUtils.getCurrentUser().getBizId());
        Organization organization = (Organization)this.organizationMapper.selectByPrimaryKey((Object)orgId);
        if (Objects.isNull(organization) || Objects.isNull(organization.getNetSchoolId())) {
            return orgNetSchoolRespDto;
        }
        orgNetSchoolRespDto.setNetSchoolId(organization.getNetSchoolId());
        return orgNetSchoolRespDto;
    }
}

