/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.NoticeService;
import com.kuaike.scrm.common.service.dto.req.AddNoticeReq;
import com.kuaike.scrm.common.service.dto.req.NoticeQueryReq;
import com.kuaike.scrm.common.service.dto.req.notice.NoticeExtendParam;
import com.kuaike.scrm.common.service.dto.resp.NoticeItemDto;
import com.kuaike.scrm.common.service.dto.resp.notice.FollowAppointmentStatisticItem;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.system.entity.Notice;
import com.kuaike.scrm.dal.system.mapper.NoticeMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoticeServiceImpl
implements NoticeService {
    private static final Logger log = LoggerFactory.getLogger(NoticeServiceImpl.class);
    @Autowired
    private NoticeMapper noticeMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CcCustomerInfoService customerInfoService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;

    public void addNotice(AddNoticeReq req) {
        log.info("addNotice with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Notice notice = new Notice();
        notice.setNum(this.idGen.getNum());
        Date noticeTime = req.getNoticeTime();
        notice.setNoticeTime(req.getNoticeTime());
        notice.setBizId(currentUserInfo.getBizId());
        notice.setHaveDeal(Integer.valueOf(0));
        notice.setMessage(req.getMessage());
        notice.setNodeId(req.getNodeId());
        notice.setReceiveUserId(req.getReceiveUserId());
        notice.setType(req.getType());
        if (req.getNoticeExtendParam() != null) {
            notice.setParam(JacksonUtil.obj2Str((Object)req.getNoticeExtendParam()));
        }
        if (StringUtils.isNotBlank((CharSequence)req.getCustomerNum())) {
            notice.setCustomerNum(req.getCustomerNum());
            CustomerDetailResp customerDetailResp = this.customerInfoService.queryCustomerDetail(currentUserInfo.getBizId(), req.getCustomerNum());
            if (StringUtils.isBlank((CharSequence)req.getMessage())) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(noticeTime);
                int a = calendar.get(11);
                StringBuilder timeBuilder = new StringBuilder();
                timeBuilder.append(DateUtil.dateToDateString(noticeTime, "MM-dd"));
                if (a < 12) {
                    timeBuilder.append("\u4e0a\u5348");
                } else {
                    timeBuilder.append("\u4e0b\u5348");
                }
                timeBuilder.append(DateUtil.dateToDateString(noticeTime, "HH:mm"));
                String msg = String.format("%s (%s) \u9884\u7ea6%s\u8fdb\u884c\u56de\u8bbf, \u8bf7\u53ca\u65f6\u8ddf\u8fdb!", StringUtils.isNotBlank((CharSequence)customerDetailResp.getName()) ? customerDetailResp.getName() : "", StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile1()) ? customerDetailResp.getMobile1() : "", timeBuilder);
                notice.setMessage(msg);
            }
            if (req.getNoticeExtendParam() != null) {
                req.getNoticeExtendParam().setName(customerDetailResp.getName());
                notice.setParam(JacksonUtil.obj2Str((Object)req.getNoticeExtendParam()));
            }
        }
        notice.setCreateTime(new Date());
        notice.setCreateBy(currentUserInfo.getId());
        notice.setIsDeleted(NumberUtils.INTEGER_ZERO);
        this.noticeMapper.insertSelective((Object)notice);
    }

    public void dealNotice(Long userId, String num) {
        log.info("dealNotice with userId={}, num={}", (Object)userId, (Object)num);
        Notice notice = this.noticeMapper.queryByNum(num);
        if (Objects.isNull(notice) || !Objects.equals(notice.getReceiveUserId(), userId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        if (notice.getHaveDeal() == 1) {
            log.info("\u6d88\u606f\u5df2\u70b9\u51fb,num={}", (Object)num);
            return;
        }
        notice.setHaveDeal(Integer.valueOf(1));
        this.noticeMapper.updateByPrimaryKeySelective((Object)notice);
    }

    public void dealAll(Long bizId, Long userId) {
        log.info("dealAll with bizId={},userId={}", (Object)bizId, (Object)userId);
        Date findTime = new Date();
        List noticeList = this.noticeMapper.queryNotice(bizId, userId, null, Integer.valueOf(0), findTime, null);
        if (!CollectionUtils.isNotEmpty((Collection)noticeList)) {
            return;
        }
        List noticeIds = noticeList.stream().map(Notice::getId).collect(Collectors.toList());
        List partitions = Lists.partition(noticeIds, (int)30);
        partitions.forEach(list -> this.noticeMapper.updateDealByIds((Collection)list));
    }

    public List<NoticeItemDto> getNoticeList(NoticeQueryReq req) {
        log.info("getNoticeList with req={}", (Object)req);
        req.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Date findTime = DateUtils.addHours((Date)new Date(), (int)1);
        List noticeList = this.noticeMapper.queryNotice(bizId, req.getUserId(), req.getType(), req.getHaveDeal(), findTime, req.getPageDto());
        if (req.getPageDto() != null) {
            req.getPageDto().setCurPageCount(Integer.valueOf(noticeList.size()));
            req.getPageDto().setCount(Integer.valueOf(this.noticeMapper.countNotice(bizId, req.getUserId(), req.getType(), req.getHaveDeal(), findTime)));
        }
        if (CollectionUtils.isEmpty((Collection)noticeList)) {
            return Lists.newArrayList();
        }
        log.info("getNoticeList noticeList:{}", (Object)noticeList);
        return noticeList.stream().map(a -> {
            NoticeExtendParam noticeExtendParam = null;
            if (StringUtils.isNotBlank((CharSequence)a.getParam())) {
                try {
                    noticeExtendParam = (NoticeExtendParam)JacksonUtil.str2Obj((String)a.getParam(), NoticeExtendParam.class);
                    if (StringUtils.isNotBlank((CharSequence)noticeExtendParam.getLeadsId()) && StringUtils.isBlank((CharSequence)noticeExtendParam.getProductLineNum())) {
                        noticeExtendParam.setProductLineNum(noticeExtendParam.getRecordId());
                    }
                }
                catch (IOException e) {
                    log.error("convert param to noticeExtendParam", (Throwable)e);
                }
            }
            return new NoticeItemDto(a.getNum(), a.getType(), a.getMessage(), a.getNoticeTime(), a.getCreateTime(), a.getHaveDeal(), "", "", noticeExtendParam);
        }).collect(Collectors.toList());
    }

    public List<FollowAppointmentStatisticItem> followAppointmentStatistics(NoticeQueryReq req) {
        log.info("followAppointmentStatistics with req={}", (Object)req);
        Long userId = LoginUtils.getCurrentUserId();
        List statisticList = this.noticeMapper.statistic(userId, req.getStartTime(), req.getEndTime());
        if (CollectionUtils.isEmpty((Collection)statisticList)) {
            return Collections.emptyList();
        }
        return statisticList.stream().map(a -> new FollowAppointmentStatisticItem(a.getDate(), a.getNotFollowCount(), a.getFollowCount())).collect(Collectors.toList());
    }

    public List<NoticeItemDto> followAppointList(NoticeQueryReq req) {
        log.info("followAppointList with req={}", (Object)req);
        Date date = req.getDate();
        if (date == null) {
            date = DateUtil.getTodayStartTime();
        }
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Date startTime = DateUtil.getDateBegin(date);
        Date endTime = DateUtil.getDateEnd(date);
        List followAppointments = this.noticeMapper.queryList(userId, req.getHaveDeal(), startTime, endTime, req.getPageDto());
        if (req.getPageDto() != null) {
            req.getPageDto().setCurPageCount(Integer.valueOf(followAppointments.size()));
            req.getPageDto().setCount(this.noticeMapper.countList(userId, req.getHaveDeal(), startTime, endTime));
        }
        List customerNums = followAppointments.stream().map(Notice::getCustomerNum).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Map mobileMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(customerNums)) {
            mobileMap = this.ccCustomerNumService.getMobileByCustomerNums(bizId, customerNums);
        }
        ArrayList results = Lists.newArrayList();
        for (Notice followAppointment : followAppointments) {
            String param = followAppointment.getParam();
            NoticeExtendParam noticeExtendParam = null;
            if (StringUtils.isNotBlank((CharSequence)param)) {
                try {
                    noticeExtendParam = (NoticeExtendParam)JacksonUtil.str2Obj((String)param, NoticeExtendParam.class);
                    if (StringUtils.isNotBlank((CharSequence)noticeExtendParam.getLeadsId()) && StringUtils.isBlank((CharSequence)noticeExtendParam.getProductLineNum())) {
                        noticeExtendParam.setProductLineNum(noticeExtendParam.getRecordId());
                    }
                }
                catch (IOException e) {
                    log.error("convert param to noticeExtendParam", (Throwable)e);
                }
            }
            NoticeItemDto item = new NoticeItemDto();
            item.setNum(followAppointment.getNum());
            item.setNoticeTime(followAppointment.getNoticeTime());
            item.setCustomerNum(followAppointment.getCustomerNum());
            item.setMobile((String)mobileMap.get(followAppointment.getCustomerNum()));
            item.setParam(noticeExtendParam);
            item.setHaveDeal(followAppointment.getHaveDeal());
            results.add(item);
        }
        return results;
    }

    public void backfill(Long bizId) {
        log.info("backfill bizId:{}", (Object)bizId);
        if (bizId == null) {
            List notices = this.noticeMapper.queryBackFillList(null);
            if (CollectionUtils.isEmpty((Collection)notices)) {
                log.info("notices is empty return");
            }
            for (Notice notice2 : notices) {
                this.backfill(notice2.getBizId());
            }
            return;
        }
        List notices = this.noticeMapper.queryBackFillList(bizId);
        if (CollectionUtils.isEmpty((Collection)notices)) {
            log.info("notices is empty return");
        }
        if (CollectionUtils.isEmpty(notices = notices.stream().filter(notice -> StringUtils.isNotBlank((CharSequence)notice.getMessage()) && notice.getMessage().length() >= 39).collect(Collectors.toList()))) {
            log.info("notices is empty return");
        }
        for (Notice notice3 : notices) {
            String message = notice3.getMessage();
            String mobile = message.substring(message.length() - 39, message.length() - 28);
            if (!MobileUtils.isPhone(mobile)) continue;
            String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
            CustomerDetailResp customerDetailResp = this.customerInfoService.queryCustomerDetail(bizId, customerNum);
            NoticeExtendParam noticeExtendParam = new NoticeExtendParam();
            noticeExtendParam.setName(customerDetailResp.getName());
            notice3.setParam(JacksonUtil.obj2Str((Object)noticeExtendParam));
            notice3.setCustomerNum(customerNum);
            notice3.setUpdateTime(new Date());
            this.noticeMapper.updateByPrimaryKey((Object)notice3);
        }
    }
}

