/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.enums.ChatMsgType;
import cn.kinyun.wework.sdk.enums.TalkerType;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.TalkerMsgCountDto;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.MessageCommonService;
import com.kuaike.scrm.common.service.dto.MessageGapCount;
import com.kuaike.scrm.common.service.dto.req.ChatEsReq;
import com.kuaike.scrm.common.service.dto.resp.AggChatUserFromEsResp;
import com.kuaike.scrm.common.utils.AutoCreateIndexUtil;
import com.kuaike.scrm.dal.chat.entity.WeworkFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.min.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.aggregations.pipeline.bucketsort.BucketSortPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MessageCommonServiceImpl
implements MessageCommonService {
    private static final Logger log = LoggerFactory.getLogger(MessageCommonServiceImpl.class);
    @Value(value="${scrm.elasticsearch.chatMessageIndex}")
    private String index;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private AutoCreateIndexUtil indexUtil;
    @Autowired
    private Client client;
    private static final String TYPE = "doc";
    private static final Integer DEFAULT_CHAT_SIZE = 500;

    @Override
    public Set<ChatMsg> existsChatMsg(List<WeworkFile> files) {
        HashSet result = Sets.newHashSet();
        if (CollectionUtils.isEmpty(files)) {
            return result;
        }
        MultiGetRequestBuilder multiGetRequestBuilder = this.client.prepareMultiGet();
        for (WeworkFile file : files) {
            multiGetRequestBuilder.add(new MultiGetRequest.Item(this.indexUtil.getIndexName(file.getMsgTime()), TYPE, file.getMsgId()));
        }
        try {
            MultiGetResponse multiGetResponse = (MultiGetResponse)multiGetRequestBuilder.get();
            for (MultiGetItemResponse response : multiGetResponse) {
                GetResponse itemResponse = response.getResponse();
                if (!Objects.nonNull(itemResponse) || !itemResponse.isExists()) continue;
                result.add(JSON.parseObject((String)itemResponse.getSourceAsString(), ChatMsg.class));
            }
        }
        catch (Exception e) {
            log.error("existsChatMsg with error", (Throwable)e);
        }
        return result;
    }

    @Override
    public ChatMsg selectByPrimaryKeyFromES(String msgId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)msgId), (Object)"\u6d88\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"msgId.keyword", (String)msgId));
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits.length > 0) {
            SearchHit searchHit = searchHits[0];
            String sourceAsString = searchHit.getSourceAsString();
            return (ChatMsg)JSON.parseObject((String)sourceAsString, ChatMsg.class);
        }
        return null;
    }

    @Override
    public List<ChatMsg> queryListByCreateTimeCount(ChatEsReq chatEsReq) {
        log.info("queryListByCreateTimeCount param:{}", (Object)JSON.toJSONString((Object)chatEsReq));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)chatEsReq.getConversationId()), (Object)"conversationId\u4e0d\u80fd\u4e3a\u7a7a");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"conversationId.keyword", (Object)chatEsReq.getConversationId())).must((QueryBuilder)QueryBuilders.matchQuery((String)"corpId.keyword", (Object)chatEsReq.getCorpId()));
        if (Objects.nonNull(chatEsReq.getBizId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"bizId", (Object)chatEsReq.getBizId()));
        }
        if (Objects.nonNull(chatEsReq.getCreateTime()) && Objects.nonNull(chatEsReq.getDirection())) {
            if (chatEsReq.getDirection().booleanValue()) {
                chatEsReq.setStartChatTime(chatEsReq.getCreateTime());
            } else {
                chatEsReq.setEndChatTime(chatEsReq.getCreateTime());
            }
        }
        RangeQueryBuilder createTimeQueryBuilder = QueryBuilders.rangeQuery((String)"msgTime");
        if (CollectionUtils.isNotEmpty(chatEsReq.getChatMsgTypes())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"msgType.keyword", chatEsReq.getChatMsgTypes()));
        }
        if (Objects.nonNull(chatEsReq.getStartChatTime())) {
            createTimeQueryBuilder.gt((Object)chatEsReq.getStartChatTime().getTime());
        }
        if (Objects.nonNull(chatEsReq.getEndChatTime())) {
            createTimeQueryBuilder.lt((Object)chatEsReq.getEndChatTime().getTime());
        }
        if (Objects.nonNull(chatEsReq.getStartChatTime()) || Objects.nonNull(chatEsReq.getEndChatTime())) {
            queryBuilder.must((QueryBuilder)createTimeQueryBuilder);
        }
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("msgId.keyword");
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        if (chatEsReq.getIsDesc().booleanValue()) {
            searchSourceBuilder.sort("msgTime", SortOrder.DESC);
        } else if (chatEsReq.getDirection().booleanValue()) {
            searchSourceBuilder.sort("msgTime", SortOrder.ASC);
        } else {
            searchSourceBuilder.sort("msgTime", SortOrder.DESC);
        }
        PageDto pageDto = chatEsReq.getPageDto();
        if (Objects.nonNull(pageDto) && Objects.nonNull(pageDto.getPageSize())) {
            searchSourceBuilder.size(pageDto.getPageSize().intValue());
        } else {
            searchSourceBuilder.size(DEFAULT_CHAT_SIZE.intValue());
        }
        searchSourceBuilder.from(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        Pair<List<ChatMsg>, Long> listLongPair = this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
        ArrayList chatResult = Lists.newArrayList();
        Long totalSize = (Long)listLongPair.getRight();
        chatResult.addAll((Collection)listLongPair.getLeft());
        long totalPageSize = totalSize / (long)DEFAULT_CHAT_SIZE.intValue();
        for (long currentPageSize = 0L; (Objects.isNull(pageDto) || Objects.isNull(pageDto.getPageSize())) && currentPageSize < totalPageSize; ++currentPageSize) {
            searchSourceBuilder.from(chatResult.size());
            Pair<List<ChatMsg>, Long> chatRecords = this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
            List chatMsgs = (List)chatRecords.getLeft();
            log.info("\u5206\u9875\u67e5\u8be2\u4e86\u591a\u5c11\u6b21");
            if (!CollectionUtils.isNotEmpty((Collection)chatMsgs)) continue;
            chatResult.addAll((Collection)chatRecords.getLeft());
        }
        return chatResult;
    }

    @Override
    public AggChatUserFromEsResp getConversationFromEsMessage(ChatEsReq req) {
        log.info("getConversationFromEsMessage params:{}", (Object)JSON.toJSONString((Object)req));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getCorpId()), (Object)"corpId\u4e0d\u80fd\u4e3a\u7a7a");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"corpId.keyword", (Object)req.getCorpId())).must((QueryBuilder)QueryBuilders.matchQuery((String)"bizId", (Object)req.getBizId()));
        if (CollectionUtils.isNotEmpty(req.getTalkerTypes())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"talkerType", req.getTalkerTypes()));
        }
        if (CollectionUtils.isNotEmpty(req.getFromIds())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"from.keyword", req.getFromIds()));
        }
        if (CollectionUtils.isNotEmpty(req.getToList())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"tolist.keyword", req.getToList()));
        }
        RangeQueryBuilder createTimeQueryBuilder = null;
        if (Objects.nonNull(req.getCreateTime()) && req.getDirection().booleanValue()) {
            createTimeQueryBuilder = req.getDirection() != false ? QueryBuilders.rangeQuery((String)"msgTime").gt((Object)req.getCreateTime().getTime()) : QueryBuilders.rangeQuery((String)"msgTime").lt((Object)req.getCreateTime().getTime());
            queryBuilder.must((QueryBuilder)createTimeQueryBuilder);
        }
        String aggTerm = "conversationId";
        if (StringUtils.isNotBlank((CharSequence)req.getAggField())) {
            aggTerm = req.getAggField();
        }
        String termKey = aggTerm + ".keyword";
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SortOrder sortOrder = SortOrder.DESC;
        if (Objects.nonNull(req.getDesc())) {
            searchSourceBuilder.sort("msgTime", sortOrder);
        } else if (Objects.nonNull(req.getDirection()) && req.getDirection().booleanValue()) {
            sortOrder = SortOrder.ASC;
            searchSourceBuilder.sort("msgTime", sortOrder);
        } else {
            sortOrder = SortOrder.DESC;
            searchSourceBuilder.sort("msgTime", sortOrder);
        }
        PageDto pageDto = req.getPageDto();
        if (YnEnum.YES.getValue().equals(req.getShowHits())) {
            searchSourceBuilder.size(pageDto.getPageSize().intValue());
            searchSourceBuilder.from(pageDto.getPageNum().intValue());
        } else {
            searchSourceBuilder.size(0);
            searchSourceBuilder.from(0);
        }
        if (YnEnum.YES.getValue().equals(req.getShowAggs())) {
            TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)aggTerm).field(termKey)).size(100);
            BucketOrder bucketOrder = BucketOrder.aggregation((String)"lastMsgSendTime", (boolean)false);
            aggregationBuilder.order(bucketOrder);
            searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
            MaxAggregationBuilder lastMsgSendTimeBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)"lastMsgSendTime").field("msgTime");
            aggregationBuilder.subAggregation((AggregationBuilder)lastMsgSendTimeBuilder);
            int groupPage = pageDto.getPageNum() - 1;
            int from = pageDto.getPageSize() * groupPage;
            aggregationBuilder.subAggregation((PipelineAggregationBuilder)new BucketSortPipelineAggregationBuilder("bucket_field", null).from(from).size(pageDto.getPageSize()));
            CardinalityAggregationBuilder count = (CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)"count").field(termKey);
            searchSourceBuilder.aggregation((AggregationBuilder)count);
        }
        return this.executeQueryAgg(searchRequest, searchSourceBuilder, aggTerm);
    }

    @Override
    public List<TalkerMsgCountDto> queryTalkerCountByWechatIdMessageQuery(String weworkUserId, String messageQuery, Integer querySize) {
        log.info("queryTalkerCountByWechatIdMessageQuery params, weworkUserId:{}, messageQuery:{}, querySize={}", new Object[]{weworkUserId, messageQuery, querySize});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkUserId), (Object)"weworkUserId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)messageQuery), (Object)"messageQuery\u4e0d\u80fd\u4e3a\u7a7a");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"text.content", (Object)messageQuery));
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"fileName", (Object)messageQuery));
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.title", (Object)messageQuery));
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.description", (Object)messageQuery));
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.linkUrl", (Object)messageQuery));
        queryBuilder.minimumShouldMatch(1);
        queryBuilder.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"tolist.keyword", (String)weworkUserId)).should((QueryBuilder)QueryBuilders.termQuery((String)"from.keyword", (String)weworkUserId)));
        if (Objects.isNull(querySize)) {
            querySize = 1000;
        }
        TermsAggregationBuilder groupTalkerIdAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupTalkerId").field("conversationId.keyword")).size(querySize.intValue()).order(BucketOrder.aggregation((String)"lastMsgSendTime", (boolean)false));
        MaxAggregationBuilder lastMsgSendTimeBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)"lastMsgSendTime").field("msgTime");
        groupTalkerIdAggregationBuilder.subAggregation((AggregationBuilder)lastMsgSendTimeBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)groupTalkerIdAggregationBuilder);
        searchRequest.source(searchSourceBuilder);
        log.debug("queryTalkerCountByWechatIdMessageQuery:{}", (Object)searchSourceBuilder.toString());
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("es search error:", (Throwable)e);
        }
        ArrayList talkerMsgCountDtoList = Lists.newArrayList();
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getAggregations())) {
            return talkerMsgCountDtoList;
        }
        Terms terms = (Terms)searchResponse.getAggregations().get("groupTalkerId");
        if (Objects.isNull(terms)) {
            return talkerMsgCountDtoList;
        }
        List buckets = terms.getBuckets();
        if (CollectionUtils.isNotEmpty((Collection)buckets)) {
            for (Terms.Bucket bucket : buckets) {
                TalkerMsgCountDto talkerMsgCountDto = new TalkerMsgCountDto();
                String talkerId = bucket.getKeyAsString();
                long count = bucket.getDocCount();
                ParsedMax parsedMax = (ParsedMax)bucket.getAggregations().get("lastMsgSendTime");
                long lastMsgSendTime = Double.valueOf(parsedMax.getValue()).longValue();
                talkerMsgCountDto.setCount((int)count);
                talkerMsgCountDto.setTalkerId(talkerId);
                talkerMsgCountDto.setLastMsgSendTime(new Date(lastMsgSendTime));
                talkerMsgCountDtoList.add(talkerMsgCountDto);
            }
        }
        return talkerMsgCountDtoList;
    }

    @Override
    public Pair<List<ChatMsg>, Long> queryPageList(String conversationId, String query, Integer type, Integer skipResults, Integer pageSize, String corpId) {
        log.info("queryPageList params, conversationId:{},corpId:{} query:{}, type={}, skipResults:{}, pageSize:{}", new Object[]{conversationId, corpId, query, type, skipResults, pageSize});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)conversationId), (Object)"conversationId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((pageSize != null && pageSize <= 200 ? 1 : 0) != 0, (Object)"\u6bcf\u9875\u6700\u591a200\u6761");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"conversationId.keyword", (Object)conversationId)).must((QueryBuilder)QueryBuilders.matchQuery((String)"corpId.keyword", (Object)corpId));
        switch (type) {
            case 0: {
                if (!StringUtils.isNotBlank((CharSequence)query)) break;
                queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"text.content", (Object)query));
                queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"fileName", (Object)query));
                queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.title", (Object)query));
                queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.description", (Object)query));
                queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.linkUrl", (Object)query));
                queryBuilder.minimumShouldMatch(1);
                break;
            }
            case 1: {
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"msgType.keyword", (Object)ChatMsgType.FILE.getValue()));
                if (!StringUtils.isNotBlank((CharSequence)query)) break;
                queryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"fileName", (Object)query));
                break;
            }
            case 2: {
                queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"msgType.keyword", (Collection)Lists.newArrayList((Object[])new String[]{ChatMsgType.IMAGE.getValue(), ChatMsgType.VIDEO.getValue()})));
                break;
            }
            case 3: {
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"msgType.keyword", (Object)ChatMsgType.LINK.getValue()));
                if (!StringUtils.isNotBlank((CharSequence)query)) break;
                queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.title", (Object)query));
                queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.description", (Object)query));
                queryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"link.linkUrl", (Object)query));
                queryBuilder.minimumShouldMatch(1);
                break;
            }
            default: {
                log.warn("unknow type: {}", (Object)type);
            }
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("msgTime", SortOrder.DESC);
        searchSourceBuilder.sort("msgId.keyword", SortOrder.ASC);
        searchSourceBuilder.size(pageSize.intValue());
        searchSourceBuilder.from(skipResults.intValue());
        log.info("\u67e5\u8be2json={}", (Object)searchSourceBuilder.toString());
        return this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
    }

    @Override
    public Set<Long> updateFile2Es(List<WeworkFile> weworkFileList) {
        if (CollectionUtils.isEmpty(weworkFileList)) {
            return Collections.emptySet();
        }
        HashSet syncIds = Sets.newHashSet();
        BulkRequest bulkRequest = new BulkRequest();
        for (WeworkFile weworkFile : weworkFileList) {
            ConcurrentMap jsonMap = Maps.newConcurrentMap();
            if (Objects.nonNull(weworkFile.getDuration())) {
                jsonMap.put("duration", weworkFile.getDuration());
            }
            if (StringUtils.isNotBlank((CharSequence)weworkFile.getTranscodeFileUrl())) {
                jsonMap.put("transcodeFileUrl", weworkFile.getTranscodeFileUrl());
            }
            jsonMap.put("fileUrl", weworkFile.getFileUrl());
            if (StringUtils.isNotBlank((CharSequence)weworkFile.getFileName())) {
                jsonMap.put("fileName", weworkFile.getFileName());
            }
            if (StringUtils.isNotBlank((CharSequence)weworkFile.getFileExt())) {
                jsonMap.put("fileType", weworkFile.getFileExt());
            }
            log.info("msgId:{}, jsonMap:{}", (Object)weworkFile.getMsgId(), (Object)JSON.toJSONString((Object)jsonMap));
            UpdateRequest updateRequest = new UpdateRequest(this.indexUtil.getIndexName(weworkFile.getCreateTime()), TYPE, weworkFile.getMsgId()).doc((Map)jsonMap);
            bulkRequest.add(updateRequest);
            syncIds.add(weworkFile.getId());
        }
        try {
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
            for (BulkItemResponse itemResponse : bulkResponse) {
                if (itemResponse.isFailed()) {
                    log.error("sync file to es error:{}", (Object)itemResponse.getId(), (Object)itemResponse.getFailure().getCause());
                    continue;
                }
                log.info("sync file to es success:{}", (Object)itemResponse.getId());
            }
        }
        catch (IOException e) {
            log.error("syncFile2Es error: bulk fail,syncIds={}", (Object)syncIds);
            syncIds.clear();
        }
        return syncIds;
    }

    private Pair<List<ChatMsg>, Long> executeQueryAndDealResult(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        ArrayList chatMsgList = Lists.newArrayList();
        if (Objects.isNull(searchResponse)) {
            return new ImmutablePair((Object)chatMsgList, (Object)0L);
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        long totalHits = hits.getTotalHits();
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            ChatMsg chatMsg = (ChatMsg)JSON.parseObject((String)sourceAsString, ChatMsg.class);
            chatMsgList.add(chatMsg);
        });
        return new ImmutablePair((Object)chatMsgList, (Object)totalHits);
    }

    private SearchResponse executeEsSearch(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
        }
        return searchResponse;
    }

    private AggChatUserFromEsResp executeQueryAgg(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder, String aggTerm) {
        List buckets;
        SearchResponse searchResponse = this.executeEsSearch(searchRequest, searchSourceBuilder);
        AggChatUserFromEsResp resp = new AggChatUserFromEsResp();
        PageDto resPage = new PageDto();
        resp.setPageDto(resPage);
        HashSet conversationIds = Sets.newHashSet();
        if (Objects.isNull(searchResponse)) {
            return resp;
        }
        Aggregations aggregations = searchResponse.getAggregations();
        if (Objects.isNull(aggregations)) {
            return resp;
        }
        ParsedStringTerms conversationId = (ParsedStringTerms)aggregations.get(aggTerm);
        if (Objects.isNull(conversationId)) {
            return resp;
        }
        Cardinality count = (Cardinality)aggregations.get("count");
        if (Objects.nonNull(count)) {
            resPage.setCount(Integer.valueOf((int)count.getValue()));
        }
        if (CollectionUtils.isEmpty((Collection)(buckets = conversationId.getBuckets()))) {
            return resp;
        }
        for (Terms.Bucket bucket : buckets) {
            String keyAsString = bucket.getKeyAsString();
            TalkerMsgCountDto talkerMsg = new TalkerMsgCountDto();
            ParsedMax parsedMax = (ParsedMax)bucket.getAggregations().get("lastMsgSendTime");
            Long lastMsgSendTime = Double.valueOf(parsedMax.getValue()).longValue();
            talkerMsg.setLastMsgSendTime(new Date(lastMsgSendTime));
            talkerMsg.setLasMsgTimeStr(parsedMax.getValueAsString());
            talkerMsg.setConversationId(keyAsString);
            conversationIds.add(talkerMsg);
        }
        resp.setTalkerMsgs(conversationIds);
        log.info("executeQueryAgg result:{}", (Object)JSON.toJSONString((Object)resp));
        return resp;
    }

    @Override
    public List<ChatMsg> queryWeworkDayMessageDetail(List<String> conversationIds, Date beginTime, Date endTime, PageDto pageDto) {
        Preconditions.checkArgument((boolean)Objects.nonNull(pageDto), (Object)"\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(beginTime), (Object)"beginTime is null");
        Preconditions.checkArgument((boolean)Objects.nonNull(endTime), (Object)"endTime is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(conversationIds), (Object)"conversationIds not empty");
        BoolQueryBuilder queries = QueryBuilders.boolQuery();
        queries.must((QueryBuilder)QueryBuilders.termsQuery((String)"conversationId.keyword", conversationIds));
        queries.must((QueryBuilder)QueryBuilders.termQuery((String)"talkerType", (int)TalkerType.CONTACT.getValue()));
        queries.must((QueryBuilder)QueryBuilders.rangeQuery((String)"msgTime").gt((Object)beginTime.getTime()).lt((Object)endTime.getTime()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queries);
        searchSourceBuilder.from(pageDto.getOffset());
        searchSourceBuilder.size(pageDto.getPageSize().intValue());
        searchSourceBuilder.sort("msgTime", SortOrder.ASC);
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search query wechat message failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        if (hits.getTotalHits() <= 0L) {
            return new ArrayList<ChatMsg>();
        }
        pageDto.setCount(Integer.valueOf(Long.valueOf(hits.getTotalHits()).intValue()));
        ArrayList list = Lists.newArrayListWithExpectedSize((int)Long.valueOf(hits.getTotalHits()).intValue());
        Stream.of(hits.getHits()).forEach(hit -> {
            String sourceAsString = hit.getSourceAsString();
            ChatMsg wechatMessage = (ChatMsg)JSON.parseObject((String)sourceAsString, ChatMsg.class);
            list.add(wechatMessage);
        });
        return list;
    }

    @Override
    public Boolean updateRevokeMsg(String msgId, Date msgTime) {
        log.info("updateMessage with:{}", (Object)msgId);
        boolean flag = false;
        HashMap<String, Boolean> jsonMap = new HashMap<String, Boolean>();
        jsonMap.put("isRevoked", true);
        if (MapUtils.isEmpty(jsonMap)) {
            return false;
        }
        UpdateRequest updateRequest = new UpdateRequest(this.indexUtil.getIndexName(msgTime), TYPE, msgId).doc(jsonMap);
        updateRequest.retryOnConflict(3);
        try {
            UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, new Header[0]);
            if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                flag = true;
                log.info("updateMsg success msgId:{}", (Object)msgId);
            }
        }
        catch (IOException e) {
            log.error("updateMsg failed, msgId={}", (Object)msgId, (Object)e);
        }
        return flag;
    }

    @Override
    public List<ChatMsg> queryMsgBySender(String conversationId, String from, int count, boolean isDesc, String corpId) {
        log.info("queryMsgBySender params: conversationId:{}, count:{}, isDesc:{} corpId:{}", new Object[]{conversationId, count, isDesc, corpId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)conversationId), (Object)"conversationId\u4e0d\u80fd\u4e3a\u7a7a");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"conversationId.keyword", (Object)conversationId)).must((QueryBuilder)QueryBuilders.matchQuery((String)"from.keyword", (Object)from)).must((QueryBuilder)QueryBuilders.matchQuery((String)"corpId.keyword", (Object)corpId));
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("msgId.keyword");
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        if (isDesc) {
            searchSourceBuilder.sort("msgTime", SortOrder.DESC);
        } else {
            searchSourceBuilder.sort("msgTime", SortOrder.ASC);
        }
        searchSourceBuilder.size(count);
        searchSourceBuilder.from(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        return (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
    }

    @Override
    public Map<String, ChatMsg> queryLastMsgBySender(Collection<String> conversationIds, Collection<String> talkerIds, String corpId) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"conversationId.keyword", conversationIds)).must((QueryBuilder)QueryBuilders.termsQuery((String)"from.keyword", talkerIds)).must((QueryBuilder)QueryBuilders.matchQuery((String)"corpId.keyword", (Object)corpId));
        TermsAggregationBuilder aggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_field").field("conversationId.keyword");
        aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"top_hits").size(1).sort("msgTime", SortOrder.DESC));
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        searchRequest.source(searchSourceBuilder);
        HashMap<String, ChatMsg> result = new HashMap<String, ChatMsg>();
        try {
            SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
            Terms terms = (Terms)searchResponse.getAggregations().get("group_by_field");
            for (Terms.Bucket bucket : terms.getBuckets()) {
                TopHits topHits = (TopHits)bucket.getAggregations().get("top_hits");
                if (topHits.getHits().totalHits <= 0L) continue;
                SearchHit hit = topHits.getHits().getAt(0);
                String sourceAsString = hit.getSourceAsString();
                ChatMsg chatMsg = (ChatMsg)JSON.parseObject((String)sourceAsString, ChatMsg.class);
                String conversationId = ChatMsg.getConversationId((ChatMsg)chatMsg);
                result.put(conversationId, chatMsg);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("queryLastMsgBySender result: {}", (Object)result.size());
        return result;
    }

    @Override
    public List<ChatMsg> queryMsgBySenderBeforeTime(String conversationId, String from, int count, Date msgTime, boolean isTimeBefore, String corpId) {
        log.info("queryMsgBySender params: conversationId:{}, count:{}, isTimeBefore:{}; corpId:{}", new Object[]{conversationId, count, isTimeBefore, corpId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)conversationId), (Object)"conversationId\u4e0d\u80fd\u4e3a\u7a7a");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"conversationId.keyword", (Object)conversationId)).must((QueryBuilder)QueryBuilders.matchQuery((String)"from.keyword", (Object)from));
        RangeQueryBuilder createTimeQueryBuilder = null;
        createTimeQueryBuilder = isTimeBefore ? QueryBuilders.rangeQuery((String)"msgTime").lt((Object)msgTime.getTime()) : QueryBuilders.rangeQuery((String)"msgTime").gt((Object)msgTime.getTime());
        queryBuilder.must((QueryBuilder)createTimeQueryBuilder).must((QueryBuilder)QueryBuilders.matchQuery((String)"corpId.keyword", (Object)corpId));
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("msgId.keyword");
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("msgTime", SortOrder.DESC);
        searchSourceBuilder.size(count);
        searchSourceBuilder.from(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        return (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
    }

    @Override
    public Long latestMsgTime() {
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.max((String)"latestMsgTime").field("msgTime");
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("latestMsgTime failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getAggregations())) {
            return 0L;
        }
        log.info("result={}", (Object)JacksonUtil.obj2Str((Object)searchResponse));
        ParsedMax max = (ParsedMax)searchResponse.getAggregations().get("latestMsgTime");
        return Double.valueOf(max.getValue()).longValue();
    }

    @Override
    public List<MessageGapCount> findGapByTime(Long startTime, Long endTime) {
        log.info("findGapByTime with startTime={}, endTime={}", (Object)startTime, (Object)endTime);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        RangeQueryBuilder createTimeQueryBuilder = QueryBuilders.rangeQuery((String)"msgTime").gte((Object)startTime).lte((Object)endTime);
        queryBuilder.must((QueryBuilder)createTimeQueryBuilder);
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupBy").field("corpId.keyword")).size(100000);
        aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.min((String)"MIN").field("seq"));
        aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"MAX").field("seq"));
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        searchRequest.source(searchSourceBuilder);
        log.info("findGapByTime queryJson={}", (Object)searchSourceBuilder.toString());
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("findGapByTime failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getAggregations())) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        ParsedStringTerms agg = (ParsedStringTerms)searchResponse.getAggregations().get("groupBy");
        for (Terms.Bucket bucket : agg.getBuckets()) {
            MessageGapCount messageGapCount = new MessageGapCount();
            messageGapCount.setCorpId(bucket.getKeyAsString());
            messageGapCount.setTotalCount(bucket.getDocCount());
            messageGapCount.setMinSeq((long)((ParsedMin)bucket.getAggregations().get("MIN")).getValue());
            messageGapCount.setMaxSeq((long)((ParsedMax)bucket.getAggregations().get("MAX")).getValue());
            messageGapCount.setGap(messageGapCount.getMaxSeq() - messageGapCount.getMinSeq() + 1L);
            list.add(messageGapCount);
        }
        return list;
    }

    @Override
    public MessageGapCount findGapBySeq(String corpId, Long startSeq, Long endSeq) {
        log.info("findGapBySeq with corpId={}, startSeq={}, endSeq={}", new Object[]{corpId, startSeq, endSeq});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)corpId));
        RangeQueryBuilder createTimeQueryBuilder = QueryBuilders.rangeQuery((String)"seq").gte((Object)startSeq).lte((Object)endSeq);
        queryBuilder.must((QueryBuilder)createTimeQueryBuilder);
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"groupBy").field("corpId.keyword")).size(100000);
        aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.min((String)"MIN").field("seq"));
        aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"MAX").field("seq"));
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        log.info("findGapBySeq queryJson={}", (Object)searchSourceBuilder.toString());
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("findGapBySeq failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getAggregations())) {
            return null;
        }
        ParsedStringTerms agg = (ParsedStringTerms)searchResponse.getAggregations().get("groupBy");
        Terms.Bucket bucket = (Terms.Bucket)agg.getBuckets().get(0);
        MessageGapCount messageGapCount = new MessageGapCount();
        messageGapCount.setCorpId(bucket.getKeyAsString());
        messageGapCount.setTotalCount(bucket.getDocCount());
        messageGapCount.setMinSeq((long)((ParsedMin)bucket.getAggregations().get("MIN")).getValue());
        messageGapCount.setMaxSeq((long)((ParsedMax)bucket.getAggregations().get("MAX")).getValue());
        messageGapCount.setGap(messageGapCount.getMaxSeq() - messageGapCount.getMinSeq() + 1L);
        return messageGapCount;
    }

    @Override
    public List<Integer> findContinueSeq(String corpId, Long startSeq, Long endSeq, Long limit) {
        log.info("findContinueSeq with corpId={}, startSeq={}, endSeq={}, limit={}", new Object[]{corpId, startSeq, endSeq, limit});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)corpId));
        RangeQueryBuilder createTimeQueryBuilder = QueryBuilders.rangeQuery((String)"seq").gte((Object)startSeq).lte((Object)endSeq);
        queryBuilder.must((QueryBuilder)createTimeQueryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.from(0);
        searchSourceBuilder.size(limit.intValue());
        searchSourceBuilder.sort("seq", SortOrder.ASC);
        searchSourceBuilder.fetchSource("seq", null);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("findContinueSeq failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getHits())) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (SearchHit hit : searchResponse.getHits()) {
            result.add((Integer)hit.getSourceAsMap().get("seq"));
        }
        return result;
    }

    @Override
    public List<ChatMsg> searchChatRoomHistoryRedPacketMsg(Date startTime, Date endTime, Collection<String> roomIds) {
        log.info("searchChatRoomHistoryRedPacketMsg startTime:{}, endTime:{}, roomIds:{}", new Object[]{startTime, endTime, roomIds});
        if (CollectionUtils.isEmpty(roomIds)) {
            log.warn("roomIds is empty");
            return Collections.emptyList();
        }
        String[] msgTypes = new String[]{ChatMsgType.REDPACKET.name(), ChatMsgType.EXTERNAL_REDPACKET.name()};
        String[] fetchSource = new String[]{"roomId", "redPacket.totalAmount"};
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"msgType.keyword", (String[])msgTypes)).must((QueryBuilder)QueryBuilders.termsQuery((String)"roomId.keyword", roomIds)).must((QueryBuilder)QueryBuilders.rangeQuery((String)"msgTime").gte((Object)startTime.getTime()).lte((Object)endTime.getTime()));
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(roomIds.size());
        searchSourceBuilder.fetchSource(fetchSource, new String[0]);
        Pair<List<ChatMsg>, Long> listLongPair = this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
        return (List)listLongPair.getLeft();
    }

    @Override
    public List<ChatMsg> searchContactHistoryRedPacketMsh(Date startTime, Date endTime, Collection<String> weworkUserIds) {
        log.info("searchContactHistoryRedPacketMsh startTime:{}, endTime:{}, weworkUserIds:{}", new Object[]{startTime, endTime, weworkUserIds});
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            log.warn("roomIds is empty");
            return Collections.emptyList();
        }
        String[] msgTypes = new String[]{ChatMsgType.REDPACKET.name(), ChatMsgType.EXTERNAL_REDPACKET.name()};
        String[] fetchSource = new String[]{"from", "redPacket.totalAmount"};
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"msgType.keyword", (String[])msgTypes)).must((QueryBuilder)QueryBuilders.termsQuery((String)"from.keyword", weworkUserIds)).must((QueryBuilder)QueryBuilders.termQuery((String)"roomId.keyword", (String)"")).must((QueryBuilder)QueryBuilders.rangeQuery((String)"msgTime").gte((Object)startTime.getTime()).lte((Object)endTime.getTime()));
        SearchRequest searchRequest = new SearchRequest(new String[]{AutoCreateIndexUtil.getIndexAlias(this.index)});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(weworkUserIds.size());
        searchSourceBuilder.fetchSource(fetchSource, new String[0]);
        log.info("searchContactHistoryRedPacketMsh searchBuilder: {}", (Object)searchSourceBuilder);
        Pair<List<ChatMsg>, Long> listLongPair = this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
        return (List)listLongPair.getLeft();
    }
}

