/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.excel;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.common.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExcelHeader {
    private String fieldName;
    private String name;
    private String format;
    private int columnIndex;
    private CellStyle cellStyle;
    private CellStyle headerCellStyle;
    private Hyperlink hyperlink;
    private Boolean isAmount;
    private Map<Integer, String> showNameFromValue;

    public ExcelHeader(String fieldName) {
        this(fieldName, null);
    }

    public ExcelHeader(String fieldName, String name) {
        this(fieldName, name, null, -1, false, null);
    }

    public ExcelHeader(String fieldName, String name, String format) {
        this(fieldName, name, format, -1, false, null);
    }

    public ExcelHeader(String fieldName, String name, Map<Integer, String> showNameFromValue) {
        this(fieldName, name, null, -1, false, showNameFromValue);
    }

    public ExcelHeader(String fieldName, String name, Boolean isAmount) {
        this(fieldName, name, null, -1, isAmount, null);
    }

    public ExcelHeader(String fieldName, String name, String format, int columnIndex, Boolean isAmount, Map<Integer, String> showNameFromValue) {
        this.fieldName = fieldName;
        this.name = StringUtils.isNotBlank((CharSequence)name) ? name : fieldName;
        this.format = format;
        this.columnIndex = columnIndex;
        this.isAmount = isAmount;
        this.showNameFromValue = showNameFromValue;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public void setHeaderCellStyle(CellStyle headerCellStyle) {
        this.headerCellStyle = headerCellStyle;
    }

    public void setHyperlink(Hyperlink hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void setIsAmount(Boolean isAmount) {
        this.isAmount = isAmount;
    }

    public void setShowNameFromValue(Map<Integer, String> showNameFromValue) {
        this.showNameFromValue = showNameFromValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public CellStyle getHeaderCellStyle() {
        return this.headerCellStyle;
    }

    public Hyperlink getHyperlink() {
        return this.hyperlink;
    }

    public Boolean getIsAmount() {
        return this.isAmount;
    }

    public Map<Integer, String> getShowNameFromValue() {
        return this.showNameFromValue;
    }
}

