/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.config;

import com.google.common.collect.Maps;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
public class KafkaConfig {
    @Value(value="${spring.kafka.bootstrap-servers}")
    String servers;
    @Value(value="${spring.kafka.producer.acks}")
    String acks;
    @Value(value="${spring.kafka.producer.retries}")
    int retries;
    @Value(value="${spring.kafka.producer.batch-size}")
    int batchSize;
    @Value(value="${spring.kafka.producer.key-serializer}")
    String keySerializer;
    @Value(value="${spring.kafka.producer.value-serializer}")
    String valueSerializer;

    private Map<String, Object> getKafkaConf() {
        HashMap map = Maps.newHashMap();
        map.put("bootstrap.servers", this.servers);
        map.put("acks", this.acks);
        map.put("retries", this.retries);
        map.put("batch.size", this.batchSize);
        map.put("key.serializer", this.keySerializer);
        map.put("value.serializer", this.valueSerializer);
        return map;
    }

    @Bean
    public KafkaTemplate<String, String> kafkaTemplate() {
        DefaultKafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory(this.getKafkaConf());
        return new KafkaTemplate((ProducerFactory)producerFactory);
    }

    @Bean(value={"kafkaThreadPool"})
    public ExecutorService kafkaThreadPool() {
        return new ThreadPoolExecutor(1, 40, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(200), new NamedThreadFactory("kafka-monitor"), new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

