/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.trace.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.MDC;

public class ExecutorTraceWrapUtil {
    public static <T> Callable<T> wrap(Callable<T> callable) {
        Map context = MDC.getCopyOfContextMap();
        return () -> {
            if (MapUtils.isEmpty((Map)context)) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        };
    }

    public static Runnable wrap(Runnable runnable) {
        Map context = MDC.getCopyOfContextMap();
        return () -> {
            if (MapUtils.isEmpty((Map)context)) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            try {
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        };
    }

    public static void wrapExecute(Executor executor, Runnable runnable) {
        executor.execute(ExecutorTraceWrapUtil.wrap(runnable));
    }

    public static void wrapSubmit(ExecutorService executorService, Runnable runnable) {
        executorService.submit(ExecutorTraceWrapUtil.wrap(runnable));
    }

    public static <T> Future<T> wrapSubmit(ExecutorService executorService, Callable<T> callable) {
        return executorService.submit(ExecutorTraceWrapUtil.wrap(callable));
    }

    public static <T> List<Future<T>> invokeAll(ExecutorService executorService, Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List wrapTasks = tasks.stream().map(ExecutorTraceWrapUtil::wrap).collect(Collectors.toList());
        return executorService.invokeAll(wrapTasks);
    }

    public static void wrapCompletableFutureRunAsync(Runnable runnable) {
        CompletableFuture.runAsync(ExecutorTraceWrapUtil.wrap(runnable));
    }

    public static void wrapCompletableFutureRunAsync(Runnable runnable, Executor executor) {
        CompletableFuture.runAsync(ExecutorTraceWrapUtil.wrap(runnable), executor);
    }
}

