package com.kuaike.trace.interceptor;

import com.kuaike.trace.utils.TraceIdUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;

import java.util.Map;

/**
 *
 * @author louis
 * @date 2022/7/27
 * kafka 支持traceId 拦截器
 */
@Slf4j
public class KafkaConsumerInterceptor<K,V> implements ConsumerInterceptor<K,V> {
    @Override
    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        String traceId = TraceIdUtils.getTraceId();
        // 上一次执行poll 遗留的traceId 要remove 调
        if (StringUtils.isNotBlank(traceId)) {
            TraceIdUtils.removeTraceId();
        }
        traceId= TraceIdUtils.genAndSetTraceId(TraceIdUtils.TraceType.KAFKA);

        log.debug("=========kafka traceId:{}  =======", traceId);

        return records;
    }

    @Override
    public void close() {
    }

    @Override
    public void onCommit(Map offsets) {

    }

    @Override
    public void configure(Map<String, ?> configs) {

    }
}
