package com.kuaike.trace.config;

import com.kuaike.trace.registrar.TraceIdScanRegistrar;
import com.kuaike.trace.utils.TraceIdUtils;
import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Import(TraceIdScanRegistrar.class)
public @interface EnableTraceId {

    /**
     * web 项目traceId 的前缀
     * @return
     */
    TraceIdUtils.TraceType webPrefix();

    String[] basePackages() default {"com.kuaike.trace"};

}
