/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.common.annotation.LoginNeedless;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class LoginUtils {
    private static final Logger log = LoggerFactory.getLogger(LoginUtils.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    private static RedisTemplate<String, Object> staticRedisTemplate;
    private static String staticRedisKeyPrefix;
    public static final String CURRENT_USER = "currentUser";
    public static final String HTTP_SESSION = "httpSession";
    public static final String SESSION_ID = "sessionId";
    public static final String USER_ID = "userId";
    public static final String LOGIN_MOBILE = "LOGIN_MOBILE";
    public static final String LOGIN_ACCOUNT_ID = "LOGIN_ACCOUNT_ID";
    public static final String EXTERNAL_TOKEN = "EXTERNAL_TOKEN";
    private static final String LOGIN_KEY = "SCRM_LOGIN_KEY_%s";
    private static final String APP_USER_NAME = "APP_USER_NAME:";
    private static final String APP_REQ_TOKEN = "APP_REQ_TOKEN:";
    private static final ThreadLocal<Map<String, Object>> CONTEXT;

    @PostConstruct
    public void init() {
        log.info("Initialize LoginUtils: {}, {}", (Object)this.redisKeyPrefix, this.redisTemplate);
        staticRedisTemplate = this.redisTemplate;
        staticRedisKeyPrefix = this.redisKeyPrefix;
    }

    public static Map<String, Object> getContext() {
        Map<String, Object> map = CONTEXT.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            CONTEXT.set(map);
        }
        return map;
    }

    public static RedisTemplate<String, Object> getRedisTemplate() {
        return staticRedisTemplate;
    }

    public static void setSession(HttpSession httpSession) {
        LoginUtils.getContext().put(HTTP_SESSION, httpSession);
        LoginUtils.getContext().put(SESSION_ID, httpSession.getId());
        LoginUtils.getContext().put(LOGIN_ACCOUNT_ID, httpSession.getAttribute(LOGIN_ACCOUNT_ID));
        LoginUtils.getContext().put(LOGIN_MOBILE, httpSession.getAttribute(LOGIN_MOBILE));
        LoginUtils.getContext().put(EXTERNAL_TOKEN, httpSession.getAttribute(EXTERNAL_TOKEN));
    }

    public static HttpSession getSession() {
        Object val = LoginUtils.getContext().get(HTTP_SESSION);
        return val == null ? null : (HttpSession)val;
    }

    public static void setCurrentUser(CurrentUserInfo user) {
        LoginUtils.getContext().put(CURRENT_USER, user);
    }

    public static CurrentUserInfo getCurrentUser() {
        Object val = LoginUtils.getContext().get(CURRENT_USER);
        return val == null ? null : (CurrentUserInfo)val;
    }

    public static Long getCurrentUserId() {
        CurrentUserInfo loginUser = LoginUtils.getCurrentUser();
        if (loginUser != null) {
            return loginUser.getId();
        }
        return null;
    }

    public static String getCurrentUserCorpId() {
        CurrentUserInfo loginUser = LoginUtils.getCurrentUser();
        if (loginUser != null) {
            return loginUser.getCorpId();
        }
        return null;
    }

    public static Long getCurrentUserBizId() {
        CurrentUserInfo loginUser = LoginUtils.getCurrentUser();
        if (loginUser != null) {
            return loginUser.getBizId();
        }
        return null;
    }

    public static void clear() {
        CONTEXT.remove();
    }

    public static void initCurrentUser(RedisTemplate<String, Object> redisTemplate, String redisKeyPrefix) {
        String key = LoginUtils.getUserInfoKey(redisKeyPrefix, LoginUtils.getLoginAccountId());
        Object cache = redisTemplate.opsForValue().get((Object)key);
        if (cache != null) {
            if (cache instanceof CurrentUserInfo) {
                LoginUtils.setCurrentUser((CurrentUserInfo)cache);
            } else {
                log.error("The user is not front system.");
            }
        }
    }

    public static void initRpcCurrentUser(String sessionId, Long userId) {
        String key = LoginUtils.getUserInfoKey(staticRedisKeyPrefix, sessionId, userId);
        Object cache = staticRedisTemplate.opsForValue().get((Object)key);
        if (cache != null) {
            if (cache instanceof CurrentUserInfo) {
                LoginUtils.setCurrentUser((CurrentUserInfo)cache);
            } else {
                log.error("The user is not front system.");
            }
        }
    }

    public static String getUserInfoKey(String redisKeyPrefix, Long userId) {
        return redisKeyPrefix + LoginUtils.getSessionId() + String.format(LOGIN_KEY, userId);
    }

    private static String getUserInfoKey(String redisKeyPrefix, String sessionId, Long userId) {
        return redisKeyPrefix + sessionId + String.format(LOGIN_KEY, userId);
    }

    public static void deleteCurrentUser(RedisTemplate<String, Object> redisTemplate, String redisKeyPrefix) {
        String key = LoginUtils.getUserInfoKey(redisKeyPrefix, LoginUtils.getLoginAccountId());
        redisTemplate.delete((Object)key);
    }

    public static boolean hasLoginNeedless(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class type = handlerMethod.getBeanType();
        LoginNeedless loginNeedless = type.getAnnotation(LoginNeedless.class);
        if (loginNeedless == null) {
            loginNeedless = type.getSuperclass().getAnnotation(LoginNeedless.class);
        }
        if (loginNeedless == null) {
            loginNeedless = (LoginNeedless)handlerMethod.getMethodAnnotation(LoginNeedless.class);
        }
        return loginNeedless != null;
    }

    public static String getSessionId() {
        Object val = LoginUtils.getContext().get(SESSION_ID);
        return val == null ? null : (String)val;
    }

    public static void setSessionId(String sessionId) {
        LoginUtils.getContext().put(SESSION_ID, sessionId);
    }

    public static Long getLoginAccountId() {
        Object val = LoginUtils.getContext().get(LOGIN_ACCOUNT_ID);
        return val == null ? null : (Long)val;
    }

    public static void setLoginAccountId(Long userId) {
        LoginUtils.getContext().put(LOGIN_ACCOUNT_ID, userId);
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.setAttribute(LOGIN_ACCOUNT_ID, (Object)userId);
        }
    }

    public static String getLoginMobile() {
        Object val = LoginUtils.getContext().get(LOGIN_MOBILE);
        return val == null ? null : (String)val;
    }

    public static void setLoginMobile(String mobile) {
        LoginUtils.getContext().put(LOGIN_MOBILE, mobile);
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.setAttribute(LOGIN_MOBILE, (Object)mobile);
        }
    }

    public static String getExternalToken() {
        Object val = LoginUtils.getContext().get(EXTERNAL_TOKEN);
        return val == null ? null : (String)val;
    }

    public static void setExternalToken(String token) {
        LoginUtils.getContext().put(EXTERNAL_TOKEN, token);
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.setAttribute(EXTERNAL_TOKEN, (Object)token);
        }
    }

    public static void clearExternalToken() {
        LoginUtils.getContext().remove(EXTERNAL_TOKEN);
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.removeAttribute(EXTERNAL_TOKEN);
        }
    }

    public static void logout() {
        LoginUtils.getContext().remove(LOGIN_ACCOUNT_ID);
        LoginUtils.getContext().remove(LOGIN_MOBILE);
        LoginUtils.getContext().remove(EXTERNAL_TOKEN);
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.removeAttribute(LOGIN_ACCOUNT_ID);
            session.removeAttribute(LOGIN_MOBILE);
            session.removeAttribute(EXTERNAL_TOKEN);
        }
    }

    public static String buildAppUserNameKey(String redisKeyPrefix, String username) {
        return redisKeyPrefix + APP_USER_NAME + username;
    }

    public static String buildAppReqTokenKey(String redisKeyPrefix, String reqToken) {
        return redisKeyPrefix + APP_REQ_TOKEN + reqToken;
    }

    static {
        CONTEXT = new InheritableThreadLocal<Map<String, Object>>();
    }
}

