package com.kuaike.trace.interceptor;

import com.kuaike.trace.utils.TraceIdUtils;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

import java.util.Map;

/**
 * 生产者拦截器，用于在消息头中添加requestId，打通链路追踪。
 *
 * @author yanmaoyuan
 * @date 2024/1/27
 */
public class KafkaProducerRequestIdInterceptor implements ProducerInterceptor<String, String> {
    @Override
    public ProducerRecord<String, String> onSend(ProducerRecord<String, String> producerRecord) {
        String traceId = TraceIdUtils.getTraceId();
        if (traceId != null) {
            producerRecord.headers().add(TraceIdUtils.B_REQUEST_ID, traceId.getBytes());
        }
        return producerRecord;
    }

    @Override
    public void onAcknowledgement(RecordMetadata recordMetadata, Exception e) {
        // nothing to do
    }

    @Override
    public void close() {
        // nothing to do
    }

    @Override
    public void configure(Map<String, ?> map) {
        // nothing to do
    }
}