/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.trace.dubbo;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.kuaike.trace.utils.TraceIdUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class ProviderTraceIdFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ProviderTraceIdFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            this.getTraceFromContext();
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (RpcException e) {
            log.error("\u8c03\u7528dubbo \u63a5\u53e3\u5f02\u5e38\uff0cerrorMsg:{}", (Object)e.getMessage());
            throw e;
        }
        finally {
            TraceIdUtils.removeTraceId();
        }
    }

    protected void getTraceFromContext() {
        String traceId = RpcContext.getContext().getAttachment("traceId");
        log.debug("provider receive traceId:{}", (Object)traceId);
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            TraceIdUtils.setTraceId(traceId);
        }
    }
}

