package com.kuaike.trace.dubbo;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;
import com.kuaike.trace.utils.TraceIdUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @author louis
 * @date 2022/8/2
 * dubbo 提供者支持traceId 拦截器
 */
@Slf4j
@Activate(group = {Constants.PROVIDER})
public class ProviderTraceIdFilter implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            getTraceFromContext();
            return invoker.invoke(invocation);
        } catch (RpcException e) {
            log.error("调用dubbo 接口异常，errorMsg:{}", e.getMessage());
            throw e;
        } finally {
            TraceIdUtils.removeTraceId();
        }
    }
    protected void getTraceFromContext() {
        String traceId = RpcContext.getContext().getAttachment(TraceIdUtils.TRACE_ID);
        log.debug("provider receive traceId:{}", traceId);
        if (StringUtils.isNotBlank(traceId)) {
            TraceIdUtils.setTraceId(traceId);
        }

    }
}
